/*
 * Decompiled with CFR 0.152.
 */
package com.sap.b1i.utilitity.dbpurger;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.Properties;
import java.util.Scanner;

public class DBPurger {
    static String[] queryStatements = new String[15];
    static String[] deletionItems = new String[15];
    static String[] deletionStatements = new String[15];
    static String[] userSelections = new String[10];
    static String version = "1.2";

    public static void main(String[] args) {
        System.out.println("===Welcome to B1i Database Growth Purging Utility Version" + version + "===");
        System.out.println("Please make sure Integraion Service is turned off to avoid damaging the data consistency");
        System.out.println("Loading DB connection parameters from cfg file...");
        try {
            Connection dbConn = DBPurger.loadParams();
            DBPurger.operation(dbConn);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public static Connection loadParams() throws Exception {
        Properties props = new Properties();
        FileInputStream is = null;
        File f = new File("xcellerator.cfg");
        is = new FileInputStream(f);
        props.load(is);
        String JDBC_URL = props.getProperty("bpc.jdbc_url");
        String JDBC_user = props.getProperty("bpc.jdbc_user");
        String JDBC_password = "";
        if (JDBC_password.length() <= 0) {
            System.out.println("Verifying B1i DB user access...");
            System.out.print("Please enter the password for SQL Server user " + JDBC_user + ": ");
            Scanner in = new Scanner(System.in);
            JDBC_password = in.nextLine();
            if (JDBC_password == null || JDBC_password.length() == 0) {
                System.out.print("Invalid input provided as the password for SQL Server user " + JDBC_user + ", program terminating...");
            }
        }
        Connection conn = DriverManager.getConnection(JDBC_URL, JDBC_user, JDBC_password);
        return conn;
    }

    static void operation(Connection conn) throws Exception {
        String selection;
        Statement stmt = null;
        DBPurger.userSelections[0] = "Transaction IO Data";
        DBPurger.userSelections[1] = "Message Log";
        DBPurger.userSelections[2] = "Event Log";
        DBPurger.userSelections[3] = "Transaction INQ";
        DBPurger.userSelections[4] = "Transaction LOG";
        DBPurger.userSelections[5] = "Transaction POS";
        DBPurger.userSelections[6] = "Misc INFO";
        DBPurger.userSelections[7] = "New Message Log Index (recommended to delete only after emptying Message Log)";
        DBPurger.userSelections[8] = "Processing Errors LOG";
        DBPurger.userSelections[9] = "All of the listed above";
        DBPurger.queryStatements[0] = "Select count(*) from BZSTDOC where PKEYGUID in (select DOCGUID from BZSTIDXP where FKEYGUID in (select PKEYGUID from BZSTIDXH where DATASET='com.sap.b1i.system.xc.iodata'))";
        DBPurger.queryStatements[1] = "Select count(*) from BZSTIDXP where FKEYGUID in (select PKEYGUID from BZSTIDXH where DATASET='com.sap.b1i.system.xc.iodata')";
        DBPurger.queryStatements[2] = "Select count(*) from BZSTIDXH where DATASET='com.sap.b1i.system.xc.iodata'";
        DBPurger.queryStatements[3] = "Select count(*) from BZSTDOC where PKEYGUID in (select DOCGUID from BZSTIDXP where FKEYGUID in (select PKEYGUID from BZSTIDXH where DATASET='com.sap.b1i.b1imessage.logs'))";
        DBPurger.queryStatements[4] = "Select count(*) from BZSTIDXP where FKEYGUID in (select PKEYGUID from BZSTIDXH where DATASET='com.sap.b1i.b1imessage.logs')";
        DBPurger.queryStatements[5] = "Select count(*) from BZSTIDXH where DATASET='com.sap.b1i.b1imessage.logs'";
        DBPurger.queryStatements[6] = "Select count(*) from BZSTDOC where PKEYGUID in (select DOCGUID from BZSTIDXP where FKEYGUID in (select PKEYGUID from BZSTIDXH where DATASET='com.sap.b1i.system.b1eventlog'))";
        DBPurger.queryStatements[7] = "Select count(*) from BZSTIDXP where FKEYGUID in (select PKEYGUID from BZSTIDXH where DATASET='com.sap.b1i.system.b1eventlog')";
        DBPurger.queryStatements[8] = "Select count(*) from BZSTIDXH where DATASET='com.sap.b1i.system.b1eventlog'";
        DBPurger.queryStatements[9] = "Select count(*) from XCLTRINQ";
        DBPurger.queryStatements[10] = "Select count(*) from XCLTRLOG";
        DBPurger.queryStatements[11] = "Select count(*) from XCLTRPOS";
        DBPurger.queryStatements[12] = "Select count(*) from INFO";
        DBPurger.queryStatements[13] = "Select count(*) from MSGLOG";
        DBPurger.queryStatements[14] = "Select count(*) from PROCERR";
        DBPurger.deletionItems[0] = "Transaction IO Data - Documents";
        DBPurger.deletionItems[1] = "Transaction IO Data - Index";
        DBPurger.deletionItems[2] = "Transaction IO Data - Header";
        DBPurger.deletionItems[3] = "Message Log - Documents";
        DBPurger.deletionItems[4] = "Message Log - Index";
        DBPurger.deletionItems[5] = "Message Log - Header";
        DBPurger.deletionItems[6] = "Event Log - Documents";
        DBPurger.deletionItems[7] = "Event Log - Index";
        DBPurger.deletionItems[8] = "Event Log - Header";
        DBPurger.deletionItems[9] = "Transaction INQ";
        DBPurger.deletionItems[10] = "Transaction LOG";
        DBPurger.deletionItems[11] = "Transaction POS";
        DBPurger.deletionItems[12] = "Misc INFO";
        DBPurger.deletionItems[13] = "New Message Log Index(recommended to delete only after emptying Message Log)";
        DBPurger.deletionItems[14] = "Processing Errors LOG";
        DBPurger.deletionStatements[0] = "Delete from BZSTDOC where PKEYGUID in (select DOCGUID from BZSTIDXP where FKEYGUID in (select PKEYGUID from BZSTIDXH where DATASET='com.sap.b1i.system.xc.iodata'))";
        DBPurger.deletionStatements[1] = "Delete from BZSTIDXP where FKEYGUID in (select PKEYGUID from BZSTIDXH where DATASET='com.sap.b1i.system.xc.iodata')";
        DBPurger.deletionStatements[2] = "Delete from BZSTIDXH where DATASET='com.sap.b1i.system.xc.iodata'";
        DBPurger.deletionStatements[3] = "Delete from BZSTDOC where PKEYGUID in (select DOCGUID from BZSTIDXP where FKEYGUID in (select PKEYGUID from BZSTIDXH where DATASET='com.sap.b1i.b1imessage.logs'))";
        DBPurger.deletionStatements[4] = "Delete from BZSTIDXP where FKEYGUID in (select PKEYGUID from BZSTIDXH where DATASET='com.sap.b1i.b1imessage.logs')";
        DBPurger.deletionStatements[5] = "Delete from BZSTIDXH where DATASET='com.sap.b1i.b1imessage.logs'";
        DBPurger.deletionStatements[6] = "Delete from BZSTDOC where PKEYGUID in (select DOCGUID from BZSTIDXP where FKEYGUID in (select PKEYGUID from BZSTIDXH where DATASET='com.sap.b1i.system.b1eventlog'))";
        DBPurger.deletionStatements[7] = "Delete from BZSTIDXP where FKEYGUID in (select PKEYGUID from BZSTIDXH where DATASET='com.sap.b1i.system.b1eventlog')";
        DBPurger.deletionStatements[8] = "Delete from BZSTIDXH where DATASET='com.sap.b1i.system.b1eventlog'";
        DBPurger.deletionStatements[9] = "TRUNCATE TABLE XCLTRINQ";
        DBPurger.deletionStatements[10] = "TRUNCATE TABLE XCLTRLOG";
        DBPurger.deletionStatements[11] = "TRUNCATE TABLE XCLTRPOS";
        DBPurger.deletionStatements[12] = "TRUNCATE TABLE INFO";
        DBPurger.deletionStatements[13] = "TRUNCATE TABLE MSGLOG";
        DBPurger.deletionStatements[14] = "TRUNCATE TABLE PROCERR";
        int[] rowCounts = new int[15];
        System.out.println("Reading items to be purged from database...");
        try {
            stmt = conn.createStatement();
            int i = 0;
            while (i < rowCounts.length) {
                ResultSet rs = stmt.executeQuery(queryStatements[i]);
                rs.next();
                rowCounts[i] = rs.getInt(1);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Scanner in = new Scanner(System.in);
        System.out.println("1: " + userSelections[0]);
        System.out.println("\t" + deletionItems[0] + " (" + rowCounts[0] + " rows of record" + ")");
        System.out.println("\t" + deletionItems[2] + " (" + rowCounts[2] + " rows of record" + ")");
        System.out.println("2: " + userSelections[1]);
        System.out.println("\t" + deletionItems[3] + " (" + rowCounts[3] + " rows of record" + ")");
        System.out.println("\t" + deletionItems[5] + " (" + rowCounts[5] + " rows of record" + ")");
        System.out.println("3: " + userSelections[2]);
        System.out.println("\t" + deletionItems[6] + " (" + rowCounts[6] + " rows of record" + ")");
        System.out.println("\t" + deletionItems[8] + " (" + rowCounts[8] + " rows of record" + ")");
        System.out.println("4: " + deletionItems[9] + " (" + rowCounts[9] + " rows of record" + ")");
        System.out.println("5: " + deletionItems[10] + " (" + rowCounts[10] + " rows of record" + ")");
        System.out.println("6: " + deletionItems[11] + " (" + rowCounts[11] + " rows of record" + ")");
        System.out.println("7: " + deletionItems[12] + " (" + rowCounts[12] + " rows of record" + ")");
        System.out.println("8: " + deletionItems[13] + " (" + rowCounts[13] + " rows of record" + ")");
        System.out.println("9: " + deletionItems[14] + " (" + rowCounts[14] + " rows of record" + ")");
        System.out.println("10: All of the above");
        System.out.println("DISCLAIMER: If the number of records has grown to a exceedingly high level, you may experience a prolonged process during the deletion. In that case, please try to rebuild database indices by using Management Studio.");
        int number = -1;
        boolean legit = false;
        while (!legit) {
            System.out.print("Please select the item you wish to delete (number 1-10), input 'e' to exit: ");
            selection = in.nextLine();
            if (selection.charAt(0) == 'e') {
                System.exit(0);
            }
            try {
                number = Integer.parseInt(selection) - 1;
                legit = true;
            }
            catch (Exception e) {
                System.out.println("Invalid input. Please input a number from 1 to 10!");
                legit = false;
            }
            if (!legit || number < 10 && number >= 0) continue;
            System.out.println("Invalid input. Please input a number from 1 to 10!");
            legit = false;
        }
        legit = false;
        int numberOfRowsToDelete = 0;
        while (!legit) {
            if (number >= 0 && number <= 2) {
                System.out.println();
                System.out.println("Please indicate the number of rows of DATA you want to delete at this time in " + userSelections[number]);
                System.out.println("(-1 to indicate delete ALL DATA WITH INDICES AND HEADERS, 0 to cancel the deletion): ");
            } else {
                System.out.println();
                System.out.print("Please confirm that you wish to delete " + userSelections[number] + ": (y/n)");
            }
            selection = in.nextLine();
            if (selection.charAt(0) == 'y') {
                selection = "-1";
            }
            if (selection.charAt(0) == 'n') {
                selection = "0";
            }
            try {
                numberOfRowsToDelete = Integer.parseInt(selection);
                legit = true;
            }
            catch (Exception e) {
                if (number < 10 && number >= 3 && !selection.equals("-1") && !selection.equals("0")) {
                    System.out.println("Invalid input, please input 'y' or 'n' to indicate whether you wish to delete the records!");
                    legit = false;
                    continue;
                }
                System.out.println("Invalid input, input only integer number (-1 for deleting all, 0 for cancel deletion)!");
                legit = false;
            }
        }
        if (numberOfRowsToDelete == -1) {
            try {
                conn.setAutoCommit(false);
                if (number != 9) {
                    if (number == 0) {
                        System.out.println();
                        System.out.println("Deleting " + userSelections[0]);
                        System.out.println("Deleting " + rowCounts[0] + " rows of record from " + deletionItems[0]);
                        int numOfRows = stmt.executeUpdate(deletionStatements[0]);
                        if (numOfRows == -1) {
                            numOfRows = 0;
                        }
                        System.out.println("Finished deleting " + numOfRows + " rows of record.");
                        System.out.println();
                        System.out.println("Deleting " + rowCounts[1] + " rows of record from " + deletionItems[1]);
                        int numOfRows1 = stmt.executeUpdate(deletionStatements[1]);
                        if (numOfRows1 == -1) {
                            numOfRows1 = 0;
                        }
                        System.out.println("Finished deleting " + numOfRows1 + " rows of record.");
                        System.out.println();
                        System.out.println("Deleting " + rowCounts[2] + " rows of record from " + deletionItems[2]);
                        int numOfRows2 = stmt.executeUpdate(deletionStatements[2]);
                        if (numOfRows2 == -1) {
                            numOfRows2 = 0;
                        }
                        System.out.println("Finished deleting " + numOfRows2 + " rows of record.");
                        conn.commit();
                        conn.setAutoCommit(true);
                        try {
                            FileWriter fstream = new FileWriter("DBGrowthRecessionRecord.log", true);
                            BufferedWriter out = new BufferedWriter(fstream);
                            out.write(String.valueOf(new Date().toString()) + ": deleted " + numOfRows + " row(s) of record from " + deletionItems[0]);
                            out.newLine();
                            out.write(String.valueOf(new Date().toString()) + ": deleted " + numOfRows1 + " row(s) of record from " + deletionItems[1]);
                            out.newLine();
                            out.write(String.valueOf(new Date().toString()) + ": deleted " + numOfRows2 + " row(s) of record from " + deletionItems[2]);
                            out.newLine();
                            out.flush();
                            out.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (number == 1) {
                        System.out.println();
                        System.out.println("Deleting " + userSelections[1]);
                        System.out.println("Deleting " + rowCounts[3] + " rows of record from " + deletionItems[3]);
                        int numOfRows3 = stmt.executeUpdate(deletionStatements[3]);
                        if (numOfRows3 == -1) {
                            numOfRows3 = 0;
                        }
                        System.out.println("Finished deleting " + numOfRows3 + " rows of record.");
                        System.out.println();
                        System.out.println("Deleting " + rowCounts[4] + " rows of record from " + deletionItems[4]);
                        int numOfRows4 = stmt.executeUpdate(deletionStatements[4]);
                        if (numOfRows4 == -1) {
                            numOfRows4 = 0;
                        }
                        System.out.println("Finished deleting " + numOfRows4 + " rows of record.");
                        System.out.println();
                        System.out.println("Deleting " + rowCounts[5] + " rows of record from " + deletionItems[5]);
                        int numOfRows5 = stmt.executeUpdate(deletionStatements[5]);
                        if (numOfRows5 == -1) {
                            numOfRows5 = 0;
                        }
                        System.out.println("Finished deleting " + numOfRows5 + " rows of record.");
                        conn.commit();
                        conn.setAutoCommit(true);
                        try {
                            FileWriter fstream = new FileWriter("DBGrowthRecessionRecord.log", true);
                            BufferedWriter out = new BufferedWriter(fstream);
                            out.write(String.valueOf(new Date().toString()) + ": deleted " + numOfRows3 + " row(s) of record from " + deletionItems[3]);
                            out.newLine();
                            out.write(String.valueOf(new Date().toString()) + ": deleted " + numOfRows4 + " row(s) of record from " + deletionItems[4]);
                            out.newLine();
                            out.write(String.valueOf(new Date().toString()) + ": deleted " + numOfRows5 + " row(s) of record from " + deletionItems[5]);
                            out.newLine();
                            out.flush();
                            out.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (number == 2) {
                        System.out.println();
                        System.out.println("Deleting " + userSelections[2]);
                        System.out.println("Deleting " + rowCounts[6] + " rows of record from " + deletionItems[6]);
                        int numOfRows6 = stmt.executeUpdate(deletionStatements[6]);
                        if (numOfRows6 == -1) {
                            numOfRows6 = 0;
                        }
                        System.out.println("Finished deleting " + numOfRows6 + " rows of record.");
                        System.out.println();
                        System.out.println("Deleting " + rowCounts[7] + " rows of record from " + deletionItems[7]);
                        int numOfRows7 = stmt.executeUpdate(deletionStatements[7]);
                        if (numOfRows7 == -1) {
                            numOfRows7 = 0;
                        }
                        System.out.println("Finished deleting " + numOfRows7 + " rows of record.");
                        System.out.println();
                        System.out.println("Deleting " + rowCounts[8] + " rows of record from " + deletionItems[8]);
                        int numOfRows8 = stmt.executeUpdate(deletionStatements[8]);
                        if (numOfRows8 == -1) {
                            numOfRows8 = 0;
                        }
                        System.out.println("Finished deleting " + numOfRows8 + " rows of record.");
                        conn.commit();
                        conn.setAutoCommit(true);
                        try {
                            FileWriter fstream = new FileWriter("DBGrowthRecessionRecord.log", true);
                            BufferedWriter out = new BufferedWriter(fstream);
                            out.write(String.valueOf(new Date().toString()) + ": deleted " + numOfRows6 + " row(s) of record from " + deletionItems[6]);
                            out.newLine();
                            out.write(String.valueOf(new Date().toString()) + ": deleted " + numOfRows7 + " row(s) of record from " + deletionItems[7]);
                            out.newLine();
                            out.write(String.valueOf(new Date().toString()) + ": deleted " + numOfRows8 + " row(s) of record from " + deletionItems[8]);
                            out.newLine();
                            out.flush();
                            out.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        System.out.println();
                        System.out.println("Deleting " + userSelections[number]);
                        System.out.println("Deleting " + rowCounts[number + 6] + " rows of record from " + deletionItems[number + 6]);
                        int numOfRowsX = stmt.executeUpdate(deletionStatements[number + 6]);
                        if (numOfRowsX == -1) {
                            numOfRowsX = 0;
                        }
                        System.out.println("Finishing truncating table " + deletionItems[number + 6]);
                        conn.commit();
                        conn.setAutoCommit(true);
                        try {
                            FileWriter fstream = new FileWriter("DBGrowthRecessionRecord.log", true);
                            BufferedWriter out = new BufferedWriter(fstream);
                            out.write(String.valueOf(new Date().toString()) + ": Finishing truncating table " + deletionItems[number + 6]);
                            out.newLine();
                            out.flush();
                            out.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    System.out.println();
                    System.out.println("Deleting all of the list items...");
                    int i = 0;
                    while (i < rowCounts.length) {
                        System.out.println("Deleting " + rowCounts[i] + " row(s) of record from " + deletionItems[i]);
                        int numOfRows = stmt.executeUpdate(deletionStatements[i]);
                        if (numOfRows == -1) {
                            numOfRows = 0;
                        }
                        System.out.println("Finished deleting " + numOfRows + " rows of record.");
                        try {
                            FileWriter fstream = new FileWriter("DBGrowthRecessionRecord.log", true);
                            BufferedWriter out = new BufferedWriter(fstream);
                            out.write(String.valueOf(new Date().toString()) + ": deleted " + numOfRows + " rows of record from " + deletionItems[i]);
                            out.newLine();
                            out.flush();
                            out.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ++i;
                    }
                    conn.commit();
                }
                conn.setAutoCommit(true);
            }
            catch (Exception e) {
                System.out.println();
                System.out.println("Error during deletion: ");
                e.printStackTrace();
                conn.rollback();
                conn.close();
            }
        } else if (numberOfRowsToDelete == 0) {
            System.out.println();
            System.out.println("Deletion cancelled.");
        } else {
            BufferedWriter out;
            FileWriter fstream;
            System.out.println();
            System.out.println("Deleting " + numberOfRowsToDelete + " rows of record from " + userSelections[number]);
            int numOfRowsY = stmt.executeUpdate(DBPurger.generateDeleteStatement(numberOfRowsToDelete, number));
            if (numOfRowsY == -1) {
                numOfRowsY = 0;
            }
            System.out.println("Finished deleting " + numOfRowsY + " rows of record.");
            try {
                fstream = new FileWriter("DBGrowthRecessionRecord.log", true);
                out = new BufferedWriter(fstream);
                out.write(String.valueOf(new Date().toString()) + ": deleted " + numOfRowsY + " row(s) of record from " + userSelections[number]);
                out.newLine();
                out.flush();
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            while ((number == 0 || number == 1 || number == 2) && numOfRowsY != 0) {
                numOfRowsY = stmt.executeUpdate(DBPurger.generateDeleteStatement(numberOfRowsToDelete, number));
                if (numOfRowsY == -1) {
                    numOfRowsY = 0;
                }
                System.out.println("Finished deleting " + numOfRowsY + " rows of record.");
                try {
                    fstream = new FileWriter("DBGrowthRecessionRecord.log", true);
                    out = new BufferedWriter(fstream);
                    out.write(String.valueOf(new Date().toString()) + ": deleted " + numOfRowsY + " row(s) of record from " + userSelections[number]);
                    out.newLine();
                    out.flush();
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((number == 0 || number == 1 || number == 2) && numOfRowsY == 0) {
                String stmt2 = "";
                String stmt3 = "";
                if (number == 0) {
                    stmt2 = deletionStatements[1];
                    stmt3 = deletionStatements[2];
                } else if (number == 1) {
                    stmt2 = deletionStatements[4];
                    stmt3 = deletionStatements[5];
                } else {
                    stmt2 = deletionStatements[7];
                    stmt3 = deletionStatements[8];
                }
                int numOfRows3 = stmt.executeUpdate(stmt3);
                try {
                    FileWriter fstream2 = new FileWriter("DBGrowthRecessionRecord.log", true);
                    BufferedWriter out2 = new BufferedWriter(fstream2);
                    out2.write(String.valueOf(new Date().toString()) + ": deleted " + numOfRows3 + " row(s) of record from " + userSelections[number]);
                    out2.newLine();
                    out2.flush();
                    out2.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        DBPurger.operation(conn);
    }

    public static String generateDeleteStatement(int numOfRows, int input) {
        if (input == 0 || input == 1 || input == 2) {
            String[] deletionStatementsBottom = new String[3];
            String deletionStatementsTop = "Delete from BZSTDOC where PKEYGUID in (select top ";
            deletionStatementsBottom[0] = " PKEYGUID from BZSTDOC where PKEYGUID in (select DOCGUID from BZSTIDXP where FKEYGUID in (select PKEYGUID from BZSTIDXH where DATASET='com.sap.b1i.system.xc.iodata')))";
            deletionStatementsBottom[1] = " PKEYGUID from BZSTDOC where PKEYGUID in (select DOCGUID from BZSTIDXP where FKEYGUID in (select PKEYGUID from BZSTIDXH where DATASET='com.sap.b1i.b1imessage.logs')))";
            deletionStatementsBottom[2] = " PKEYGUID from BZSTDOC where PKEYGUID in (select DOCGUID from BZSTIDXP where FKEYGUID in (select PKEYGUID from BZSTIDXH where DATASET='com.sap.b1i.system.b1eventlog')))";
            return String.valueOf(deletionStatementsTop) + numOfRows + deletionStatementsBottom[input];
        }
        if (input == 3) {
            return "TRUNCATE TABLE XCLTRINQ";
        }
        if (input == 4) {
            return "TRUNCATE TABLE XCLTRLOG";
        }
        return "TRUNCATE TABLE XCLTRPOS";
    }
}

