// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
//***********************************************************************************
// slide content for acqusition & selection
//***********************************************************************************
var TABLE_DIV_PRE = "table_div";
var TABLE_PRE = "table";
var TITLE_PRE = "title";
var CONTENT_DIV_PRE = "contentDiv";
var CONTENT_DIV_PRE_SEL = "contentSelDiv";

var timer;
var INTERVAL_TIME = 10; 		//ms
var SLIDE_TIME = 0.1 * 1000;	//ms
var moving_contentIndex = null;

/**
 * instead of calling hide/display method immediately, hide or show the content slowly
 */
function slideContent(contentIndex){
	var content = document.getElementById(TABLE_DIV_PRE + contentIndex);
	var table = document.getElementById(TABLE_PRE + contentIndex);
	moving_contentIndex = contentIndex;
	if(content.style.display != "none"){		//hide
		content.style.height = content.offsetHeight + "px";		
		timer = setInterval(move, INTERVAL_TIME);
		ac_moving_hide = true;	
	} else {									//hidden --> show
		content.style.display = "";
		content.style.height = "1px";
		ac_moving_hide = false;
		timer = setInterval(move, INTERVAL_TIME);
	}
//	document.getElementById(TITLE_PRE + contentIndex).style.width = table.offsetWidth + "px";				//align the title and table
}
/**
 * move a step
 */
function move(){
        if (moving_contentIndex == null) {
            return;
        }
	var content = document.getElementById(TABLE_DIV_PRE + moving_contentIndex);
	var table = document.getElementById(TABLE_PRE + moving_contentIndex);
	var speed = table.offsetHeight / SLIDE_TIME * INTERVAL_TIME;
	if(speed < 1){
		speed = 1;
	}
	if(ac_moving_hide){
		var tmp = parseFloat(content.style.height.replace("px", "")) - speed;
		if(tmp > 1){
			content.style.height = tmp + "px";
		}
		else {
			hideContent(moving_contentIndex);
			clearInterval(timer);
			moving_contentIndex = null;
		}
	} else {
		var tmp = parseFloat(content.style.height.replace("px", "")) + speed;
		if(tmp < table.offsetHeight)
			content.style.height = tmp + "px";
		else {
			displayContent(moving_contentIndex);
			clearInterval(timer);
			moving_contentIndex = null;
		}
	}
}
/**
 * hide the content after all packages 'Done' or 'Already Downloaded', except the last content
 */
function hideContent(contentIndex){
	document.getElementById(TABLE_DIV_PRE + contentIndex).style.display = "none";
	var img = document.getElementById(TITLE_PRE + contentIndex).childNodes[0];	
	img.src = "images/treeExpand_plus.gif";
	img.title = "display";
}

/**
 * display content table
 */
function displayContent(contentIndex){	
	document.getElementById(TABLE_DIV_PRE + contentIndex).style.height = "";
	document.getElementById(TABLE_DIV_PRE + contentIndex).style.display = "";
	var img = document.getElementById(TITLE_PRE + contentIndex).childNodes[0];	
	img.src = "images/treeExpand_mius.gif";
	img.title = "hide";
}

/**
 * response to click the content bar
 * ref is a reference of title bar
 */
function toggleContent(ref){
	if(moving_contentIndex){					//still moving...
		return;
	}
	var spans = ref.getElementsByTagName("span");
	if(spans[0].innerHTML.length < 1 || spans[0].innerHTML.indexOf("(") == 0){			//no real content in xml yet
		return;
	}
	var contentIndex = ref.id.substring(TITLE_PRE.length);		//remove the prefix - "title"
	slideContent(contentIndex);
}

function createContentSel(xname, mt, os, index){
	var contentDiv = document.createElement("div");
	contentDiv.className = "progressContentDiv";
	contentDiv.id = CONTENT_DIV_PRE_SEL + index;
	_details = document.getElementById("details_selection");
	_details.insertBefore(contentDiv, null);
	createTitle(xname, mt, os, index, contentDiv);
}

/**
 * when here comes a new content, add a content to the div
 */
function createContent(xname, mt, os, index){
	var contentDiv = document.createElement("div");
	contentDiv.className = "progressContentDiv";
	contentDiv.id = CONTENT_DIV_PRE + index;
	_details = document.getElementById("details");
	_details.insertBefore(contentDiv, null);
	createTitle(xname, mt, os, index, contentDiv);
}

/**
 * create a table containing a content of packs
 */
function createTable(index, isAc){
	if(isAc){
		//insert a 'div'
		var tableDiv = document.createElement("div");
		tableDiv.id = TABLE_DIV_PRE + index;
		tableDiv.className = "ContentTableDiv";
		tableDiv.style.display = "none";
		document.getElementById(CONTENT_DIV_PRE + index).insertBefore(tableDiv, null);
		//insert a table
		var table = document.createElement("table");
		table.className = "EntityTable";
		table.cellSpacing = "0";
		table.style.width = "97%";
		table.id = TABLE_PRE + index;
		tableDiv.insertBefore(table, null);

		//create header
		var thr = table.insertRow(-1);
		var th = thr.insertCell(-1);
		th.className = "EntityTableHeader";
		th.style.width = "20%";
		th.innerHTML = header[0];
		
		var th = thr.insertCell(-1);
		th.className = "EntityTableHeader";
		th.innerHTML = header[1];
		th.style.width = "45%";
		
		var th = thr.insertCell(-1);
		th.className = "EntityTableHeader";
		th.innerHTML = header[2];
		th.style.width = "12%";
		
		var th = thr.insertCell(-1);
		th.className = "EntityTableHeader";
		th.innerHTML = header[3];
		th.style.width = "23%";


	}else{
		//insert a 'div'
		var tableDiv = document.createElement("div");
		tableDiv.id = TABLE_DIV_PRE + index;
		tableDiv.className = "ContentTableDiv";
		tableDiv.style.display = "none";
		document.getElementById(CONTENT_DIV_PRE_SEL + index).insertBefore(tableDiv, null);
		//insert a table
		var table = document.createElement("table");
		table.className = "EntityTable";
		table.cellSpacing = "0";
		table.style.width = "97%";
		table.id = TABLE_PRE + index;
		tableDiv.insertBefore(table, null);

		//create header
		var thr = table.insertRow(-1);
		var th = thr.insertCell(-1);
		th.className = "EntityTableHeader";
		th.style.width = "4%";
		th.innerHTML = header[0];
		
		var th = thr.insertCell(-1);
		th.className = "EntityTableHeader";
		th.style.width = "24%";
		th.innerHTML = header[1];

		var th = thr.insertCell(-1);
		th.className = "EntityTableHeader";
		th.innerHTML = header[2];
		th.style.width = "52%";

		var th = thr.insertCell(-1);
		th.className = "EntityTableHeader";
		th.innerHTML = header[3];
		th.style.width = "20%";

	}
	
	return table;
}

/**
 * create a title bar for a content
 */
function createTitle(xname, mt, os, index, contentDiv){
	var titleInnerHTML = new Array();
	titleInnerHTML.push("<div class='ContentTitleDiv' id='" + TITLE_PRE + index + "' onclick='toggleContent(this)'>");
	titleInnerHTML.push("<img style='margin-left:18px;' alt=\"Not Started\" src=\"images/statusStopped_obj16.gif\">&nbsp;");
	titleInnerHTML.push(xname + "(type " + mt + ") - " + os + " - <span></span>");
	titleInnerHTML.push("</div>");
	contentDiv.innerHTML = titleInnerHTML.join("");
}

/**
 * update the status of the whole content.
 * if all packs done/already downloaded, change the title status to "Done";
 * if the previous one is "done/already downloaded", while the current one is "not started", the title status should be "Acquiring"
 * if any pack is Acquiring, the title status should be "Acquiring";
 * if all packs are not started, the title should show "not started".
 */
function updateTitle(index, stt){
	var title = document.getElementById(TITLE_PRE + index);
	var imgs = title.getElementsByTagName("img");
	if(stt == "Acquiring") {		
		imgs[imgs.length - 1].src = "images/progress_anim2_small.gif";
		imgs[imgs.length - 1].alt = "Acquiring...";
	}
	else if(stt == "Not Started") {
		imgs[imgs.length - 1].src = "images/statusStopped_obj16.gif";
		imgs[imgs.length - 1].alt = "Not Started";
	}
	else if(stt == "None") {
		imgs[imgs.length - 1].src = "images/statusInformation_obj16.gif";
		imgs[imgs.length - 1].alt = "No applicable updates";
	}
	else if(stt == "Warning") {
		imgs[imgs.length - 1].src = "images/statusWarning_obj16.gif";
		imgs[imgs.length - 1].alt = "Warning";
	}
	else if(stt == "Error"){
		imgs[imgs.length - 1].src = "images/statusCritical_obj16.gif";
		imgs[imgs.length - 1].alt = "Error";
	}
	else {
		imgs[imgs.length - 1].src = "images/statusSuccess_obj16.gif";
		imgs[imgs.length - 1].alt = "Done";
	}
}

/**
 * conversion from MT (in xml file) to MT (in top.gl_config_list)
 */
function unifyOS(os){
	if(os == null)
		return null;
		
	var o = os.toLowerCase();
	//o = o.replace(" ", "");
	if(o.indexOf("windows") > -1)
		return "windows";
	if(o.indexOf("aix") > -1){
		return "aix";
	}
	if(o.indexOf("vmware") > -1){
		return "vmware";
	}
	return o;
}

/**
 * when there is a non-empty content, insert a 'plus'icon
 */
function showPlusIcon(index){
	var title = document.getElementById(TITLE_PRE + index);
	var imgs = title.getElementsByTagName("img");
	if(imgs.length > 1)
		return;
	imgs[0].style.marginLeft = "0px";
	var plus_img = document.createElement("img");
    plus_img.src = "images/treeExpand_plus.gif";
	plus_img.alt = "display";
	plus_img.height = "18";
	plus_img.width = "18";
	title.insertBefore(plus_img, imgs[0]);
}