// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
// Licensed Materials - Property of IBM
// 5648-F10 (C) Copyright International Business Machines Corp. 2005
// All Rights Reserved
// US Government Users Restricted Rights - Use, duplication or disclosure
// restricted by GSA ADP Schedule Contract with IBM Corp.

// return array of file name in the folder
function get_folder_content(folder) {
	return window.bomc.utils('get_folder_content', folder);
}

function createDirectory(directoryName) {
	return window.bomc.utils('createDirectory', directoryName);
}

// determine if the file or folder exists
// fileName: string - full native file name
// returns:  false if the file does not exist, true otherwise (or if shouldIndicateType is true, 1 if file exists, -1 directory exists, 0 file does not exist)
function fileExists(fileName) {
	return window.bomc.utils('fileExists', fileName);

}

function isDirectory(directoryName) {
	return window.bomc.utils('isDirectory', directoryName);

}

// determine if the file exists
// securityFcn: function = new Function('return window')
// fileName: string - full native file name
// returns: boolean
function secureFileExists(fileName) {
	return fileExists(fileName);
}

// determine if the directory exists
// securityFcn: function = new Function('return window')
// directory: string - full native directory name
// returns: boolean
function secureDirectoryExists(directory) {
	return secureFileExists(directory);
}


// gets the value of an environment variable
// securityFcn: function = new Function('return window')
// anyvar: string - name of variable
// returns: string - value of variable
//          undefined - variable is not defined
function secureGetEnv(anyvar) {
	top.printLog('anyvar : ', anyvar);
	return window.bomc.utils('secureGetEnv', anyvar);
}

// sets the value of an environment variable
// securityFcn: function = new Function('return window')
// anyvar: string - name of variable
// value: string - new value of variable
// returns: boolean - success status
function secureSetEnv(anyvar, value) {
	window.bomc.utils('secureSetEnv', anyvar, value);
}

// executes an arbitrary command
// securityFcn: function = new Function('return window')
// topDir: string - CD mount point
// args: [strings] - command and parameters
// waitBoolean: boolean - foreground or background
// isHidden: boolean - visible window or silent
// element: document element - element to disable while running
// returns integer - exit code if foreground or process status if background

// get a list of child directories
// securityFcn: function = new Function('return window')
// dir: string - parent directory
// returns: [directory name strings]
function secureGetDirectories(dir) {
	return window.bomc.utils('secureGetDirectories', dir);
}

// get a list of child files
// securityFcn: function = new Function('return window')
// dir: string - parent directory
// returns: [file name strings]
// new implementation by nodejs api
function secureGetFiles(dir) {
	return window.bomc.utils('secureGetFiles', dir);
}

function deleteFile(file) {
	return window.bomc.utils('deleteFile', file);
}

// read an external file
// fileName: string - full native file name or URL
// returns: string - contents of file if readable, null otherwise
function readTextFile(fileName) {
	return window.bomc.utils('readTextFile', fileName);
}

function pathJoin(...args) {
    return window.bomc.utils('join', ...args)
}

// read an external file
// securityFcn: function = new Function('return window')
// fileName: string - full native file name
// returns: [line strings]
function secureReadTextFile(fileName) {
	try {
		var fileContents = readTextFile(fileName);
		var fileLines = fileContents.split(/\r*\n/);
		if (fileLines.length > 0)
		//yeah this is smart, this is to remove the empty lines at the end of a file
			if (fileLines[fileLines.length - 1].length == 0)
				fileLines.pop();

		return fileLines;

	} catch (e) {
		//FSO failed, there's nothing we can do to read this files    
		top.logException(e, arguments);
	}
}

// write a text file
// fileName: string - full native file name
// text:  string - content of text file
// append: boolean - true = append text to end of file,  false = overwrite existing file
// returns: true if file was written successfully, false otherwise
function writeTextFile(fileName, fileContent, append) {
	return window.bomc.utils('writeTextFile', fileName, fileContent, append);
}

function winclose() {
	return win.close();
}

function statSync(filepath) {
	return window.bomc.utils('statSync', filepath);
}

function dirname(filepath) {
	return window.bomc.utils('dirname', filepath);
}

// securityFcn: function = new Function('return window')
// returns: void
function secureExit() {
	try {
		window.close();
	} catch (e) {
		top.logException(e, arguments);
	}
	winclose(); //Rarely called when debugging and refresh windows.
}
function loadJsonFile(filePath) {
	return window.bomc.utils('loadJsonFile', filePath);
}

function openExternal(link) {
	return window.bomc.utils('openExternal', link);
}

function showItemInFolder(configFile) {
	return window.bomc.utils('showItemInFolder', configFile);
}

function createReadStream(fileName) {
	return window.bomc.utils('createReadStream', fileName);
}

function getStream() {
	return window.bomc.utils('getStream');
}

function rewrite_compare_result(callback, compare_rewrite_xml, compare_xml, selected_list) {
	console.log("brower rewrite_compare_result");
	return window.bomc.rewrite_compare_result(callback, compare_rewrite_xml, compare_xml, selected_list);
}

function printLog(level, msg) {
    function getCallerFileNameAndLine() {
        function getException() {
            try {
                throw Error('');
            } catch (err) {
                return err;
            }
        }
        const err = getException();
        const stack = err.stack;
        const stackArr = stack.split('\n');
        let callerLogIndex = 0;
        for (let i = 0; i < stackArr.length; i++) {
            if (stackArr[i].indexOf("at printLog") > 0 && i + 1 < stackArr.length) {
                callerLogIndex = i + 1;
                break;
            }
        }
        if (callerLogIndex !== 0) {
            const callerStackLine = stackArr[callerLogIndex];
            return `[${callerStackLine.substring(callerStackLine.lastIndexOf("/") + 1, callerStackLine.lastIndexOf(':'))}]`;
        } else {
            return '[-]';
        }
    }
    return window.bomc.utils('printLog', level, getCallerFileNameAndLine(), msg)
}

// Init log filter now that we have access to env vars
logInitFilter();