// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
var uxspilicense_bootable;

// syncFlag
// false: cmd has not completed
// true: cmd has completed
var syncFlag = false;

function isPurley(mt) {
    mt = mt.toString();
    var isPur = false;
    for (var i = 0; i < mt.length; i++) {
        var tempMt = mt[i].toLowerCase();
        if (tempMt >= "a" && tempMt <= "z") {
            isPur = true;
            break;
        }
    }
    return isPur;
}

function returnMtCategory(mt) {
    if (top.purleyList.indexOf(mt) != -1) {
        return "purley";
    } else if (top.lenovoSystemxList.indexOf(mt) != -1) {
        return "x";
    } else if (top.storageList.indexOf(mt) != -1) {
        return "storage";
    }
}

function killAsync(appName, callback) {
    var args = new Array();
    args.push(getStartingTopDir() + getNativeFileSeparator() + top.guiHelper);
    args.push("--kill");
    args.push(appName);
    args.push("--file");
    args.push(top.bomc_gui);
    secureRunProgram(null, args, BACKGROUND, null, null, function(success) {
        if (success) {
            console.log(appName + " is killed successfully. ");
            if (callback) callback(true);
        } else {
            console.log(appName + " is not killed, please try again. ");
            if (callback) callback(false);
        }
    });
}

function isBomcRunning(callback) {
    // var outputFile = top.gl_ibm_support + "guihelper.dat";
    var outputFile = "guihelper.dat";
    var outputFullFile = top.gl_ibm_support + "guihelper.dat";
    if (top.fileExists(outputFullFile)) {
        top.deleteFile(outputFullFile);
    }
    var bomcProgName = top.mainAppName;
    var args = new Array();
    var guihelpRelPath = "";
    if (top.OSTYPE == "windows") guihelpRelPath = "..\\guihelper.exe";
    else guihelpRelPath = "../guihelper.sh";
    args.push(getStartingTopDir() + getNativeFileSeparator() + guihelpRelPath);
    args.push("--isrunning");
    args.push(bomcProgName);
    args.push("--file");
    args.push(outputFile);
    secureRunProgram(null, args, BACKGROUND, null, null, function(success) {
        if(success && top.fileExists(outputFullFile)) {
            engineTop.secureRead1PropertyFile(outputFullFile, top.propertiesInfo, false);
            if(top.propertiesInfo["IBM_SYSTEM_RUNNING"] != bomcProgName) {
                console.log("bomc is not running.");
                if(callback) {
                    callback(false);
                }
            } else {
                console.log("bomc is running.");
                if(callback) {
                    callback(true);
                }
            }
        } else {
            console.log("Can't get bomc running status.");
            if(callback) {
                callback(true);
            }
        }
    });
}

function syncCheckResultTimeout()
{
    if (syncFlag == false)
    {
        //alert("syncFlag is false");
        setTimeout(syncCheckResultTimeout(), 500);
    }
    //alert("got execfile result!");
}

function togglePrevious(enable) { 
    toggleActionButton("previous", enable); 
}

function toggleNext(enable) { 
    toggleActionButton("next", enable); 
}

function toggleFinish(enable) {
    toggleActionButton("finish",   enable); 
}

function toggleActionButton(buttonId, enable) {
    if (enable)
    {
        // Enable disabled button
        var button = $("#navigationbar-vertical").find('a[href="#' + buttonId + '-disabled"]');
            button.attr("href", '#' + buttonId);
            button.parent().removeClass();
    }
    else
    {
        // Disable enabled button
        var button = $("#navigationbar-vertical").find('a[href="#' + buttonId + '"]');
            button.attr("href", '#' + buttonId + '-disabled');
            button.parent().addClass("disabled");
    }
}

/**
 * catch key down event
 */
function keydownevent(event) {
    //alert(top.root.footer.document.getElementById('nextButton').value);
    event = event || window.event;
    if (!event) {
        top.logMessage("null event!");
        return true;
    }
    top.logMessage("LPV20024W", String.fromCharCode(event.keyCode).toLowerCase());
    if (event.altKey && (String.fromCharCode(event.keyCode).toLowerCase() == 'n')) {
        event.cancelBubble = true;
        event.returnValue = false;
        if (event.stopPropagation) {
            event.stopPropagation();
            event.preventDefault();
        }
        //if (top.root.footer.document.getElementById('nextButton').disabled == false) {
        gl_wizard.steps("next");
        //}
        return false;
    }
    if (event.altKey && (String.fromCharCode(event.keyCode).toLowerCase() == 'p')) {
        event.cancelBubble = true;
        event.returnValue = false;
        if (event.stopPropagation) {
            event.stopPropagation();
            event.preventDefault();
        }
        //if (top.root.footer.document.getElementById('previousButton').disabled == false) {
        gl_wizard.steps("previous");
        //}
        return false;
    }
    if (event.altKey && (String.fromCharCode(event.keyCode).toLowerCase() == 'c')) {
        event.cancelBubble = true;
        event.returnValue = false;
        if (event.stopPropagation) {
            event.stopPropagation();
            event.preventDefault();
        }
        //if (top.root.footer.document.getElementById('cancelButton').disabled == false) {
        top.Exit(true);
        //}
        return false;
    }
    return true;
}
//***********************************************************************************
// Initialization
// Call mini_init first
//***********************************************************************************
function common_init() 
{
    console.log("common_init() ");
    engineTop.setEnv("BOMC_GUI_ENVIRONMENT",1);
    tcInit();      
}

function mini_init() {
    //Initialize parameters
    var prefix = top.gl_ibm_support;
    top.gl_basic_info_file = prefix + "guihelp.dat";
    top.gl_ac_result = prefix + "ac_result.xml";
    top.gl_co_result_onecli = prefix + "Onecli-update-compare.xml";
    top.gl_co_result_uxspi = prefix + "co_result.xml";
    top.gl_up_result_onecli = prefix + "Onecli-update-flash.xml";
    top.gl_up_result_uxspi = prefix + "up_result.xml";
    top.gl_up_status_onecli = prefix + "Onecli-update_flash_status.xml";
    top.gl_command_file = prefix + "command.txt";
    top.gl_common_result = prefix + "common_result.xml";
    top.gl_config_list_file = prefix + "configList.xml";
    top.gl_config_list_file_temp = prefix + "configListTmp.xml";
    top.gl_config_list_bak_file = prefix + "configListbak.xml";
    top.gl_obtainLatestVersion_result = prefix + "obtainLatestVersion_result.txt";
    top.gl_proxy_tmpfile = prefix + "uxspi_proxy_tmp.dat";
    top.gl_common_result_properties_file = prefix + "common_result.properties";
    top.gl_usbkeys_file = prefix + "uxspi_keys.xml";
    top.gl_loghtml_file = prefix + "uxspi_log.html";
    top.gl_proxy_config_file = prefix + "toolscenter_proxy.dat";
    top.gl_UpdateSupportList_Result = prefix + "supportlist_ac_result.xml";
    top.gl_outputDir = top.gl_ibm_support;

    top.gl_guiHelper = getOSCommand("guiHelper");
    //top.gl_parProxy = getOSCommand("parProxy");
    top.gl_saveFilesToKey = getOSCommand("saveFilesToKey");
 
    if (!top.fileExists(top.gl_basic_info_file)) {
        if (top.OSTYPE != "windows") {
            deleteFile("/var/log/Lenovo_Support/uxspi_biosinfo_mt.dat");
        }           
        //Run guiHelper to get basic information, such as machine type and os.
        //In this step, we can't determine the main application's name yet
        var args = [];
        args.push(getStartingTopDir() + getNativeFileSeparator() + top.gl_guiHelper);
        var rc = secureRunProgram(null, args, BACKGROUND, HIDDEN, null, callbackAfterRunGuiHelper);
        
        if (!engineTop.secureFileExists(top.gl_basic_info_file)) {
            alert("Can't get basic info!");
        } 
        // else {
        //     top.gl_gui_help_run = true;
        // }
    }
    engineTop.secureRead1PropertyFile(top.gl_basic_info_file, top.gl_properties_info, false);
    init_os_mt_arch();
    if (top.isMultiNodesMT()) {
        init_multinode();
    } else {
        top.gl_current_mulitnodes_d = "0";
    }

    killApp_ux(top.gl_mainAppName);

    //top.gl_mini_init_run = true;
}



function init_multinode() {

    //var mainAppDir = top.gl_properties_info["IBM_SYSTEM_DIR"];
    // if (mainAppDir.length > 9) {
    //     mainAppDir = mainAppDir.substr(0, mainAppDir.length - 9);
    // }

    var args = new Array();
    //args.push(top.gl_parProxy);
    args.push(top.gl_mainAppName);
    args.push("-V");
    secureRunProgram(null, args, BACKGROUND, HIDDEN);

}

// disable steps tab, make them unclickable;
function disableAllTab() {
    $("[role='tab']").addClass("disabled");
}

function init_os_mt_arch() {
    var os = top.gl_properties_info["IBM_SYSTEM_OS"];
    var arch = top.gl_properties_info["IBM_SYSTEM_ARCH"];
    top.gl_current_mt = top.gl_properties_info["IBM_SYSTEM_MT"];
    top.gl_current_mt_d = top.gl_current_mt;
    var uxlite_version = uxspi_version2;
    if (top.gl_current_mt == "NONE") {
        top.gl_current_mt_d = "NONE";
        top.gl_isAbnormal = true;
    }

    if (arch == "64") {
        top.gl_current_arch_d = "64 bit";
    } else if (arch == "32") {
        top.gl_current_arch_d = "32 bit";
    } else {
        top.gl_current_arch_d = "No Architecture";
        top.gl_isAbnormal = true;
    }

    /*if(os == "101" || os == "102" || os == "103" || os == "104" || os == "105" || os == "106" || os == "107" || os == "108" || os == "109" || os == "110" || os == "111" || os == "112" || os == "113"){
      top.gl_sepAppName = "SepManager.exe";
     }else{
      top.gl_sepAppName = "SepManager.bin"; 
     }*/



    if (os == "101" || os == "102" || os == "103" || os == "104" || os == "105" || os == "106" || os == "107" || os == "108" || os == "109" || os == "110" || os == "111" || os == "112" || os == "113") {
        if (os == "101") {
            top.gl_current_os_d = "Windows NT";
        } else if (os == "102") {
            top.gl_current_os_d = "Windows 2000";
        } else if (os == "103") {
            top.gl_current_os_d = "Windows 2003";
        } else if (os == "104") {
            top.gl_current_os_d = "Windows PE";
        } else if (os == "105") {
            top.gl_current_os_d = "Windows XP";
        } else if (os == "106") {
            top.gl_current_os_d = "Win DC 2000";
        } else if (os == "107") {
            top.gl_current_os_d = "Win DC 2003";
        } else if (os == "108") {
            top.gl_current_os_d = "Win Vista";
        } else if (os == "109") {
            top.gl_current_os_d = "Win Server 2008";
        } else if (os == "110") {
            top.gl_current_os_d = "Windows 7";
        } else if (os == "111") {
            top.gl_current_os_d = "Windows 8";
        } else if (os == "112") {
            top.gl_current_os_d = "Windows 2012";
        } else if (os == "113") {
            top.gl_current_os_d = "Windows 2012 R2";
        }

        if (arch == "64") {
            top.gl_mainAppName = "uxspi" + uxlite_version + "_64_cli.exe";
        } else {
            top.gl_mainAppName = "uxspi" + uxlite_version + "_cli.exe";
        }
        top.gl_bomc_name = "bomc100.exe";
        top.gl_current_os = "windows";

    } else if (os == "201") {
        if (arch == "64") {
            top.gl_mainAppName = "uxspi" + uxlite_version + "_cli.rhel3_64";
            top.gl_bomc_name = "bomc100.rhel3_64";
        } else {
            top.gl_mainAppName = "uxspi" + uxlite_version + "_cli.rhel3";
            top.gl_bomc_name = "bomc100.rhel3";
        }
        top.gl_current_os = "rhel3";
        top.gl_current_os_d = "RHEL 3";
    } else if (os == "202") {
        if (arch == "64") {
            top.gl_mainAppName = "uxspi" + uxlite_version + "_cli.rhel4_64";
            top.gl_bomc_name = "bomc100.rhel4_64";
        } else {
            top.gl_mainAppName = "uxspi" + uxlite_version + "_cli.rhel4";
            top.gl_bomc_name = "bomc100.rhel4";
        }
        top.gl_current_os = "rhel4";
        top.gl_current_os_d = "RHEL 4";
    } else if (os == "203") {
        if (arch == "64") {
            top.gl_mainAppName = "uxspi" + uxlite_version + "_cli.rhel5_64";
            top.gl_bomc_name = "bomc100.rhel5_64";
        } else {
            top.gl_mainAppName = "uxspi" + uxlite_version + "_cli.rhel5";
            top.gl_bomc_name = "bomc100.rhel5";
        }
        top.gl_current_os = "rhel5";
        top.gl_current_os_d = "RHEL 5";
    } else if (os == "208") {
        if (arch == "64") {
            top.gl_mainAppName = "uxspi" + uxlite_version + "_cli.rhel6_64";
            top.gl_bomc_name = "bomc100.rhel6_64";
        } else {
            top.gl_mainAppName = "uxspi" + uxlite_version + "_cli.rhel6";
            top.gl_bomc_name = "bomc100.rhel6";
        }
        top.gl_current_os = "rhel6";
        top.gl_current_os_d = "RHEL 6";
    } else if (os == "209") { //rhel7
        if (arch == "64") {
            top.gl_mainAppName = "uxspi" + uxlite_version + "_cli.rhel7_64";
            top.gl_bomc_name = "bomc100.rhel7_64";
        } else {
            top.gl_mainAppName = "uxspi" + uxlite_version + "_cli.rhel7";
            top.gl_bomc_name = "bomc100.rhel7";
        }
        top.gl_current_os = "rhel7";
        top.gl_current_os_d = "RHEL 7";
    } else if (os == "205") {
        if (arch == "64") {
            top.gl_mainAppName = "uxspi" + uxlite_version + "_cli.sles9_64";
            top.gl_bomc_name = "bomc100.sles9_64";
        } else {
            top.gl_mainAppName = "uxspi" + uxlite_version + "_cli.sles9";
            top.gl_bomc_name = "bomc100.sles9";
        }
        top.gl_current_os = "sles9";
        top.gl_current_os_d = "SLES 9";
    } else if (os == "206") {
        if (arch == "64") {
            top.gl_mainAppName = "uxspi" + uxlite_version + "_cli.sles10_64";
            top.gl_bomc_name = "bomc100.sles10_64";
        } else {
            top.gl_mainAppName = "uxspi" + uxlite_version + "_cli.sles10";
            top.gl_bomc_name = "bomc100.sles10";
        }
        top.gl_current_os = "sles10";
        top.gl_current_os_d = "SLES 10";
    } else if (os == "207") {
        if (arch == "64") {
            top.gl_mainAppName = "uxspi" + uxlite_version + "_cli.sles11_64";
            top.gl_bomc_name = "bomc100.sles11_64";
        } else {
            top.gl_mainAppName = "uxspi" + uxlite_version + "_cli.sles11";
            top.gl_bomc_name = "bomc100.sles11";
        }
        top.gl_current_os = "sles11";
        top.gl_current_os_d = "SLES 11";
    } else if (os == "210") {
        if (arch == "64") {
            top.gl_mainAppName = "uxspi" + uxlite_version + "_cli.sles12_64";
            top.gl_bomc_name = "bomc100.sles12_64";
        } else {
            top.gl_mainAppName = "uxspi" + uxlite_version + "_cli.sles12";
            top.gl_bomc_name = "bomc100.sles12";
        }
        top.gl_current_os = "sles12";
        top.gl_current_os_d = "SLES 12";
    } else if (os == "301" || os == "302" || os == "303") {
        if (os == "301") {
            top.gl_current_os_d = "VMware ESX 2";
        } else if (os == "302") {
            top.gl_current_os_d = "VMware ESX 3";
        } else if (os == "303") {
            top.gl_current_os_d = "VMware ESX 3.5";
        }
        if (arch == "64") {
            top.gl_mainAppName = "uxspi" + uxlite_version + "_cli.rhel3_64";
            top.gl_bomc_name = "bomc100.rhel3_64";
        } else {
            top.gl_mainAppName = "uxspi" + uxlite_version + "_cli.rhel3";
            top.gl_bomc_name = "bomc100.rhel3";
        }
        top.gl_current_os = "vmware";
    } else {
        top.gl_current_os_d = "NONE";
        top.gl_mainAppName = "NONE";
        top.gl_bomc_name = "NONE";
        top.gl_current_os = "NONE";
        top.gl_isAbnormal = true;
    }
    if (isOneCLIReady) {
        top.gl_mainAppName = getOSCommand('onecli_name');
    }
}

function killApp_ux(appName) {
    var args = new Array();
    args.push(getStartingTopDir() + getNativeFileSeparator() + top.guiHelper);
    args.push("--kill");
    args.push(appName);
    return secureRunProgram(null, args, FOREGROUND, HIDDEN);
}

function deleteFile_ux(file) {
    var args = new Array();
    args.push(getStartingTopDir() + getNativeFileSeparator() + top.gl_guiHelper);
    args.push("--delete");
    args.push(file);
    return secureRunProgram(null, args, FOREGROUND, HIDDEN);
}

function isRunning(appName) {
    var args = new Array();
    args.push(getStartingTopDir() + getNativeFileSeparator() + top.gl_guiHelper);
    args.push("--isrunning");
    args.push(appName);
    if (secureRunProgram(null, args, FOREGROUND, HIDDEN)) {
        return false;
    }

    engineTop.secureRead1PropertyFile(top.gl_basic_info_file, top.gl_properties_info, false);
    if (top.gl_properties_info["IBM_SYSTEM_RUNNING"] == appName) {
        return true;
    }

    return false;
}

/*
 * We override the default next() function by adding a declare named nextAction.
 * So we need to implement a customized navigation function which will makes current page jump to next page.
 */
/* Comment this legacy function
function nextDefinedByUX() {
    var navOrder = top.getWizardNavOrder();
    var found = false;
    for (var i = 0; i < navOrder.length; i++) {
        if (navOrder[i] == top.navigationCurrent) {
            found = true;
            if (i < navOrder.length - 1) {
                top.navigateTo(navOrder[i + 1]);
                break;
            } else {
                top.Exit();
            }
        }
    }
    if (!found) {
        // If we get here, we're currently sitting on a deactivated nav item. 
        //  Fallback to complete nav order to navigate to the next item.
        var allNavOrder = getNavOrder();
        found = false;
        for ( i = 0; i < allNavOrder.length; i++) {
            if (allNavOrder[i] == top.navigationCurrent) {
                if (i < allNavOrder.length - 1) {
                    top.navigateTo(allNavOrder[i + 1]);
                    break;
                } else {
                    top.Exit();
                }
            }
        }
    }
}
*/

/*
 * check whether the path name is valid and whether it exists
 */
function validatePath(path) {
    if (top.trim(path) == "")
        return "Please input the absolute directory!";
    //support non-English,
    var regExp = null;
    var regExpNet = null;
    if (top.gl_current_os == "windows" || top.OSTYPE == "windows") //for windows
    {
        //regExp = /^[a-zA-Z]\:(\\[a-zA-Z0-9_ -.]+)*\\{0,1}$/gi;
        regExp = /^[a-zA-Z]\:(\\.+)*\\{0,1}$/gi;
        regExpNet = /^\\\\((2[0-4]\d|25[0-5]|[01]?\d\d?)\.){3}(2[0-4]\d|25[0-5]|[01]?\d\d?)(\\.+)*\\{0,1}$/gi;
    } else //for linux
    //regExp = /^\/|(\/[a-zA-Z0-9_ -.]+)+\/{0,1}$/gi;
        regExp = /^\/|(\/.+)+\/{0,1}$/gi;
    if (!path.match(regExp) && !path.match(regExpNet))
        return "Invalid path!";
    else if (!engineTop.secureDirectoryExists(path))
        return "Unavailable path!";
    else
        return "success";
}

/**
 * filter directory path
 */
function filter(input) {
    input = top.trim(input);
    if (top.OSTYPE == "windows") {
        return "\"" + input + "\"";
    } else {
        //return input.toString().replace(/(\s{1})/g, "\\\ ");
        return input;
    }
}

/*
 * 1234.56 -> 1,234.56
 * input may already have commas, so just return
 */
function formatNumberWithComma(input) {
    var str = "",
        value = input.toString();
    var dotPos = value.indexOf(".");
    var commaPos = value.indexOf(",");
    if (commaPos > -1) {
        return input;
    }
    var integer = dotPos > -1 ? value.substring(0, dotPos) : value;
    var dicemal = dotPos > -1 ? value.substring(dotPos) : "";
    var chars = top.trim(integer).split("");
    for (var i = chars.length - 1; i > -1; i--) {
        str = chars[i] + str;
        if ((chars.length - i) % 3 == 0 && i != 0) {
            str = "," + str;
        }
    }
    return str + dicemal;
}

/*
 * for decimal
 */
function formatData(input) {
    var per = input.toString();
    if (per.indexOf(".") > 0)
        per = per.substring(0, per.indexOf(".") + 3);
    return per;
}
/*
 * for index
 */
function formatNo(input) {
    var result = input.toString();
    switch (input) {
        case 1:
            result += "st";
            break;
        case 2:
            result += "nd";
            break;
        case 3:
            result += "rd";
            break;
        default:
            result += "th";
    }
    return result;
}
/*
 * extract from wizard.js-->previous, default case
 */
/* comment this legacy function 
function commonPre() {
    var navOrder = top.getWizardNavOrder();
    var found = false;
    for (var i = 0; i < navOrder.length; i++) {
        if (navOrder[i] == top.navigationCurrent && i > 0) {
            found = true;
            top.navigateTo(navOrder[i - 1]);
            break;
        }
    }
    if (!found) {
        var allNavOrder = getNavOrder();
        found = false;
        for (i = 0; i < allNavOrder.length; i++) {
            if (allNavOrder[i] == top.navigationCurrent && i > 0) {
                top.navigateTo(allNavOrder[i - 1]);
                break;
            }
        }
    }
}
*/
/*
 * leave current page and change the menu item status
 * isReload -- refresh current page
 * menuStyle -- set the menu's style class according to navigation.css
 * only support 'previous' action now
 */
function leaveCurrentPage(action, isReload, menuStyle) {
    var leavingMenu = top.navigationCurrent;

    //collect mt checkBox status
    if (leavingMenu == 'machineTypes') {
        mt_collectPre(action);
        writeConfigFile();
    }

    //collect os checkBox status
    if (leavingMenu == 'targetOS') {
        os_collectPre();
        writeConfigFile();
    }
    if (isReload) {
        killApp_ux(top.gl_mainAppName);
        window.location.reload();
        toggleNext(true);
    }
    if (action == "previous") {
        commonPre();
    } else if (action == "next") {
        //...
    }
    if (menuStyle)
        top.setNavigationState(leavingMenu, menuStyle);
}

/**
 * right-click may cause refreshing and other problems
 */
// Comment following legacy codes 
// function disableRightClick() {
//     var func = top.rightClick;
//     setNavigationDocClickEvent(func);
//     setContentPageClickEvent(func);
//     setFooterClickEvent(func);
//     setBannerClickEvent(func);
// }

function openWorkingDir(id) {
    var dir = top.browseForFolder("Please Select Path:");
    if (dir != null) {
        document.getElementById(id).value = dir;
    }
}

/**
 * return an array with possible dirs corresponding with input
 */
function dirCompletion(input) {
    var matchedDir = new Array();
    var sprt = (top.gl_current_os == "windows") ? "\\" : "/";
    if (input.match(/^[a-zA-Z]\:$/)) //for complete [driver]:\
        input = input + sprt;
    if (input.indexOf(sprt) < 0) { //no '/; or '\'
        matchedDir.push(input);
        return matchedDir;
    }
    var dir = input.substring(0, input.lastIndexOf(sprt) + 1);
    if (!engineTop.secureDirectoryExists(dir)) { //input is not existing or invalid
        matchedDir.push(input);
        return matchedDir;
    }
    if (top.BROWSER == "IExplore") { //if in IE
        var fileSystemObject = new ActiveXObject("Scripting.FileSystemObject");
        var folder = fileSystemObject.GetFolder(dir);
        var enu = new Enumerator(folder.SubFolders);
        while (!enu.atEnd()) {
            var subf = enu.item();
            if (subf.Path.toUpperCase().indexOf(input.toUpperCase()) == 0)
                matchedDir.push(subf.Path);
            enu.moveNext();
        }
    } else { //try ff
        netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
        var file = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
        file.initWithPath(dir);
        var entries = file.directoryEntries; //each entry is a nsIFilese
        if (entries) {
            while (entries.hasMoreElements()) {
                var entry = entries.getNext();
                entry.QueryInterface(Components.interfaces.nsIFile); //nsISupport -> nsIFile
                if (top.isDirectory(entry) && entry.path.toUpperCase().indexOf(input.toUpperCase()) == 0)
                    matchedDir.push(entry.path);
            }
        }
    }
    return matchedDir;
}

/**
 * Save and clean
 */
function quit() {
    killApp_ux(top.gl_mainAppName);
    //writeConfigFile();
}

/**
 * Catch the even of closing the current window
 */
function closeWindow() {
    killApp_ux(top.gl_mainAppName);
    writeConfigFile();
    if (top.OSTYPE == "windows") {
        if (event.clientY < 0 || event.altKey) {
            //killApp_ux("mshta.exe");
        }
    }
}

//window.onbeforeunload = closeWindow;

/**
 * write user's selections (MT & OS) to hard disk
 */
function writeConfigFile() {
    if (!top.gl_store_os || !top.gl_store_mt)
        return;
    var root = "<?xml version=\"1.0\"?>";
    root += "<root>\n<version>";
    root += top.gl_min_version;
    root += "</version>\n";
    root += "<timestamp>";
    root += top.gl_configlist_time_stamp;
    root += "</timestamp>\n";
    for (var i = 0; i < top.gl_config_list.length; i++) {
        var a = top.gl_config_list[i];
        root += "\t<system>";
        root += "<xname>" + a[0] + "</xname>";
        root += "<machineType>" + a[1] + "</machineType>";
        root += "<selected>" + a[2] + "</selected>";
        root += "<noUXSP>" + a[3] + "</noUXSP>";
        root += "</system>\n";
    }
    for (i = 0; i < top.gl_os_list.length; i++) {
        //for OS agnostic update support
        if (top.gl_os_list[i] != "none" || top.gl_isNoneSelected) {
            root += "<OS>" + top.gl_os_list[i] + "</OS>\n";
        }
    }

    root += "</root>";
    top.writeTextFile(top.gl_config_list_file, root);
}

/**
 * Unique candidate array, means remove duplicate items
 */
Array.prototype.unique = function() {
    var a = {};
    for (var i = 0; i < this.length; i++) {
        if (typeof a[this[i]] == "undefined")
            a[this[i]] = 1;
    }
    this.length = 0;
    for (i in a)
        this[this.length] = i;
    return this;
}

/**
 * trim blank space and eliminate other characters 
 */
function updateDirPath(path) {
    path = top.trim(path);
    if (path.charAt(path.length - 1) == '\\') {
        path = path.substring(0, path.length - 1);
    }
    path = "--local=\"" + path + "\"";
    return path;
}
//for unattend mode
function uxlite_alert(text) {
    if (top.getEnv("BOMC_UNATTENDED_MODE")) {
        top.Exit(false);
    } else {
        alert(text);
    }

}

function os_collectPre() {
    top.gl_store_os = true;
    top.gl_os_list = new Array();
    for (var i = 0; i < targetOS.length; i++) {
        if (document.getElementById("sysOS" + i).checked == true) {
            top.gl_os_list.push(document.getElementById("sysOS" + i).value);
        }
    }
}

function mt_collectPre(action) {
    var mt_list = new Array();
    top.gl_config_list = new Array();
    /**
     * Use two recursion to make that new machine types added by the usr will be in the header of the list 
     */
    for (var i = oriCount; i < sysCount; i++) {
        try {
            var a = new Array();
            a.push(document.getElementById("sysRow" + i).cells[1].innerHTML);
            a.push(document.getElementById("sysRow" + i).cells[2].innerHTML);
            if (document.getElementById("sysMT" + i).checked == true) {
                mt_list.push(document.getElementById("sysMT" + i).value);
                a.push("1");
            } else {
                a.push("0");
            }
            //It's a hidden field used to indicate whether there is UXSP for this machine
            a.push(document.getElementById("sysRow" + i).cells[3].innerHTML);
            top.gl_config_list.push(a);
        } catch (e) {;
        }
    }
    for (var i = 0; i < oriCount; i++) {
        try {
            var a = new Array();
            a.push(document.getElementById("sysRow" + i).cells[1].innerHTML);
            a.push(document.getElementById("sysRow" + i).cells[2].innerHTML);
            if (document.getElementById("sysMT" + i).checked == true) {
                mt_list.push(document.getElementById("sysMT" + i).value);
                a.push("1");
            } else {
                a.push("0");
            }
            //It's a hidden field used to indicate whether there is UXSP for this machine
            a.push(document.getElementById("sysRow" + i).cells[3].innerHTML);
            top.gl_config_list.push(a);
        } catch (e) {;
        }
    }
    top.gl_store_mt = true;
    top.gl_mt_list = new Array();
    for (var i = 0; i < mt_list.length; i++) {
        var flag = false;
        //remove duplicate items
        for (var j = 0; j < top.gl_mt_list.length; j++) {
            if (mt_list[i] == top.gl_mt_list[j]) {
                flag = true;
                break;
            }
        }
        //remove unsupported items in the black list
        for (var k = 0; k < top.gl_bl_mt_list.length; k++) {
            if (mt_list[i] == top.gl_bl_mt_list[k]) {
                flag = true;
                break;
            }
        }
        if (!flag)
            top.gl_mt_list.push(mt_list[i]);
    }
    if (top.gl_mt_list.length < 1) {
        if (action == "next")
            alert("Please select one or more Machine Type(s)!");
    } else {
        top.gl_mt_list.sort(); //sort mt_list
        sortConfigList();
        top.gl_refresh_mt_page = false;
        //  nextDefinedByUX();
    }


}


// top.startInitTimer();
// call common initialization
// common_init();
