// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
var ezJsLib;

(function(){
    if (typeof ezJsLib != "undefined") {
        return;
    }
    else {
        //$ ****** init ******
        ezJsLib = {};
        
        //$ ****** properties zone(start) ******
        ezJsLib.resultDom = null;
        ezJsLib.resultNode = null;
		ezJsLib.contextDom = null;
		ezJsLib.configDom = null;
		ezJsLib.request = new Array();
		ezJsLib.session = new Array();
		
        //$ ****** properties zone(end) ******
        
        //$ ****** public methods(start) ******
        // ****** package for command execution ******
        ezJsLib.Command = {
            invokeSingleCommand: function(diskNum, commandCode, mode, visibility){
				var command = _getCommand(commandCode);
                if (command != null && command.length > 0) 
                    return top.securerunProgram(diskNum, command, mode, visibility);
                else 
                    return 1;// this return value is deprecated in the future, keep it to compatible with old code
            },
			execute: function(diskNum, commandCode, mode, visibility){
                var xmlDom = null;
                var resultcode = 0;
                resultcode = ezJsLib.Command.invokeSingleCommand(diskNum, commandCode, mode, visibility);
                if (resultcode != 0) {
                }else {
					// var filename = _getResultFile(commandCode); 
                    // ezJsLib.Ajax.loadResult(filename);
                }
				return resultcode; // this return value is deprecated in the future, keep it to compatible with old code
            }
        };
		
		// ****** package for context ******
		ezJsLib.navigation = {
			chassisDiscoveryNext: function(){
				//if(top.RefreshChassisInventory){
				var ele;
				if(document.getElementById("oneblade")!=null){
					ele = document.getElementById("weburl").innerHTML;
				}else{
					var radios = document.getElementsByName('chassis');
					for(var i=0;i<radios.length;i++){
						if(radios[i].checked == true){
							ele = radios[i].value;
						}
					}
				}
				ezJsLib.context.setRequestParameter(ezJsLib.Constants.TAG_CHASSISWEBURL(), ele);
				var ip = ele.replace("http://","");
				ip=ip.replace(":80","");
				ezJsLib.context.setRequestParameter('chassisip',ip);
				ezJsLib.context.setRequestParameter('chassisoldip',ip);
				var rc = 0;
				rc = ezJsLib.Command.invokeSingleCommand(ezJsLib.Constants.DISK_ONE(),ezJsLib.Constants.SET_CONTEXT(),FOREGROUND, top.EzVISIBILITY);
				//}
				
				top.navigateTo("chassisInventory");
			},
			firmwareEnter: function(){
				if (top.needRefresh())
				{				
					//var resultcode = 0;
					ezJsLib.Command.execute(ezJsLib.Constants.DISK_ONE(), ezJsLib.Constants.QUERY_FIRMWARE(), FOREGROUND, top.EzVISIBILITY);
					document.getElementById("progress").style.display = "none";
					//alert("load result");
					var loadResult = ezJsLib.Ajax.loadResult(ezJsLib.Constants.PATH_FIRMWARE_FILE());
					if(loadResult==ezJsLib.Constants.RESULT_UNKNOWN()){
			// display message for result load failure
						document.getElementById("content").innerHTML = ezJsLib.Message.InLineErrorMessageById("GUICFFFF");
						top.enableEzNextButton(false);
					}else{
						var executionResult = ezJsLib.XmlDom.getStatusFromResultXml();
						// the execution of this command is failed
						if(executionResult==ezJsLib.Constants.RESULT_FAIL()){
							document.getElementById("content").innerHTML = ezJsLib.Message.InLineErrorMessage(ezJsLib.XmlDom.getErrorCodeFromResultXml(), ezJsLib.XmlDom.getErrorMessageFromResultXml());
							document.getElementById("updateBtn").disabled=true;
						}else {
							document.getElementById("content").innerHTML = ezJsLib.XmlDom.getHtmlContentFromResultXml();
							top.resetted();
							ezJsLib.Ajax.loadContext();
							var enableButton = ezJsLib.context.getRequestParameter("enableUpdateButton");
							if (enableButton == "False"){
								document.getElementById("updateBtnDiv").style.display="none";
								document.getElementById("noNeedUpdateInfo").style.display="block";
								document.getElementById("noNeedUpdateInfo").innerHTML=ezJsLib.Message.InLineSuccessMessage("", "Firmware for your chassis components is up to date.");
							}else{
								document.getElementById("needUpdateInfo").style.display="block";
								document.getElementById("updateBtnDiv").style.display="block";
								document.getElementById("needUpdateInfo").innerHTML=ezJsLib.Message.InLineInfoMessage("", "Firmware for one or more of your chassis components needs updating. See the table below for details.");
							}
						
						}
					
					
					}
					
					
					/*
					if (resultcode != 0) {
						document.getElementById("content").innerHTML = ezJsLib.Message.InLineErrorMessage("", "Exception throwed while executing the command");
					}
					else {
						try {
							if(ezJsLib.XmlDom.getStatusFromResultXml()=="failure"){
								document.getElementById("content").innerHTML = ezJsLib.Message.InLineErrorMessage(ezJsLib.XmlDom.getErrorCodeFromResultXml(), ezJsLib.XmlDom.getErrorMessageFromResultXml());
								document.getElementById("updateBtn").disabled=true;
							}else{
								document.getElementById("content").innerHTML = ezJsLib.XmlDom.getHtmlContentFromResultXml();
								top.resetted();
								ezJsLib.Ajax.loadContext();
								var enableButton = ezJsLib.context.getRequestParameter("enableUpdateButton");
								if (enableButton == "False"){
									document.getElementById("updateBtnDiv").style.display="none";
									document.getElementById("noNeedUpdateInfo").style.display="block";
									document.getElementById("noNeedUpdateInfo").innerHTML=ezJsLib.Message.InLineSuccessMessage("", "Firmware for your chassis components is up to date.");
								}else{
									document.getElementById("needUpdateInfo").style.display="block";
									document.getElementById("updateBtnDiv").style.display="block";
									document.getElementById("needUpdateInfo").innerHTML=ezJsLib.Message.InLineInfoMessage("", "Firmware for one or more of your chassis components needs updating. See the table below for details.");
								}
							}
						} 
						catch (ex) {
							document.getElementById("content").innerHTML = ezJsLib.Message.InLineErrorMessage(ezJsLib.XmlDom.getErrorCodeFromResultXml(), ezJsLib.XmlDom.getErrorMessageFromResultXml());
							document.getElementById("updateBtn").disabled=true;
						}
					}*/
				}				
			},
			chassisInventoryEnter: function(){
				if (top.needRefresh())
				{
					ezJsLib.context.setRequestParameter("inventoryStatus","OK");
					ezJsLib.Command.invokeSingleCommand(ezJsLib.Constants.DISK_ONE(),ezJsLib.Constants.SET_CONTEXT(),FOREGROUND, top.EzVISIBILITY);//top.EzVISIBILITY);
					enter();
				}
			}
		};
		
		// ****** package for context ******
		ezJsLib.context = {
			getRequestParameter: function(_key){
				var root; 
				if(ezJsLib.contextDom!=null){
					root = ezJsLib.contextDom.documentElement;
					var nodes = root.getElementsByTagName("request");
					if(nodes[0]){
						var request = nodes[0];
						var requests = request.childNodes;
						for(var i=0;i<requests.length;i++){
							if (requests[i].nodeName == _key) {
								if(requests[i].childNodes.length>0&&requests[i].childNodes[0].nodeValue!=null){
									return requests[i].childNodes[0].nodeValue;
								}else{
									return "";
								}
							}
						}
					}
				}
				throw new Error(ezJsLib.Constants.ERROR_NO_SUCH_TAG());
			},
			hasKeyInRequest: function(_key){
				var root; 
				if(ezJsLib.contextDom!=null){
					root = ezJsLib.contextDom.documentElement;
					var nodes = root.getElementsByTagName("request");
					if(nodes[0]){
						var request = nodes[0];
						var requests = request.childNodes;
						for(var i=0;i<requests.length;i++){
							if (requests[i].nodeName == _key) {
								return true;
							}
						}
					}
				}
				return false;
			},
			getSessionAttribute: function(_key){
				var root; 
				if(ezJsLib.contextDom!=null){
					root = ezJsLib.contextDom.documentElement;
					var nodes = root.getElementsByTagName("session");
					if(nodes[0]){
						var session = nodes[0];
						var sessions = session.childNodes;
						for(var i=0;i<sessions.length;i++){
							if (sessions[i].nodeName == _key) {
								if(sessions[i].childNodes.length>0&&sessions[i].childNodes[0].nodeValue!=null){
									return sessions[i].childNodes[0].nodeValue;
								}else{
									return "";
								}
							}
						}
					}
				}
				throw new Error(ezJsLib.Constants.ERROR_NO_SUCH_TAG());
			},
			hasKeyInSession: function(_key){
				var root; 
				if(ezJsLib.contextDom!=null){
					root = ezJsLib.contextDom.documentElement;
					var nodes = root.getElementsByTagName("session");
					if(nodes[0]){
						var session = nodes[0];
						var sessions = session.childNodes;
						for(var i=0;i<sessions.length;i++){
							if (sessions[i].nodeName == _key) {
								return true;
							}
						}
					}
				}
				return false;
			},
			setRequestParameter:function(_key,_value){
				var encodedvalue = escape(_value);
				var requeststr = "'"+_key+"'"+ ":" +"'"+encodedvalue+"'";

				var isSet = false;				
				if (ezJsLib.request.length>0)
				{
					for (var i=0; i<ezJsLib.request.length; i++)
					{
						if ((new String(ezJsLib.request[i])).indexOf(_key)!=-1)
						{
							isSet = true;
							ezJsLib.request[i] = requeststr;
							return;
						}						
					}
				}				
				if (!isSet)
				{
					ezJsLib.request.push(requeststr);
				}
			},
			setSessionAttribute:function(_key,_value){
				var encodedvalue = escape(_value);
				var sessionstr = "'"+_key+"'"+ ":" +"'"+encodedvalue+"'";

				var isSet = false;				
				if (ezJsLib.session.length>0)
				{
					for (var i=0; i<ezJsLib.session.length; i++)
					{
						if ((new String(ezJsLib.session[i])).indexOf(_key)!=-1)
						{
							isSet = true;
							ezJsLib.session[i] = sessionstr;
							return;
						}						
					}
				}				
				if (!isSet)
				{
					ezJsLib.session.push(sessionstr);
				}
			},
			toStringFormat:function(){
				var str = "";
				var requeststr = "";
				var sessionstr = "";
				
				if(ezJsLib.request.length>0){
					for(var r=0;r<ezJsLib.request.length;r++){
						requeststr = requeststr + ezJsLib.request[r];
						if(r<ezJsLib.request.length-1){
							requeststr = requeststr + '////';
						}	
					}
					requeststr = "'request':{"+requeststr+"}";
				}
				if(ezJsLib.session.length>0){
					for(var r=0;r<ezJsLib.session.length;r++){
						sessionstr = sessionstr + ezJsLib.session[r];
						if(r<ezJsLib.session.length-1){
							sessionstr = sessionstr + '////';
						}	
					}
					sessionstr = "'session':{"+sessionstr+"}";
				}
				if(requeststr.length>0){
					str = requeststr;
					if(sessionstr.length>0){
						str = str + '////' + sessionstr;
					}
				}else{
					if (sessionstr.length > 0) {
						str = sessionstr;
					}
				}
				if(str.length>0){
					str = '{'+str+'}';	
					//str.replace(/,/g,"////");
				}
				return str;	
			}
		};
        
        // ****** package for Xml Dom ******
        ezJsLib.XmlDom = {
            newDocument: function(rootTagName, namespaceURL){
				if (!rootTagName) rootTagName = "";
    			if (!namespaceURL) namespaceURL = "";

    			if (document.implementation && document.implementation.createDocument) {
        		// This is the W3C standard way to do it
        			return document.implementation.createDocument(namespaceURL,
                                                      rootTagName, null);
    			}else { 
					// This is the IE way to do it
        			// Create an empty document as an ActiveX object
        			// If there is no root element, this is all we have to do
        			var doc = new ActiveXObject("MSXML2.DOMDocument");

		        	// If there is a root tag, initialize the document
		        	if (rootTagName) {
		            	// Look for a namespace prefix
		            	var prefix = "";
		            	var tagname = rootTagName;
		            	var p = rootTagName.indexOf(':');
		            	if (p != -1) {
		                	prefix = rootTagName.substring(0, p);
		                	tagname = rootTagName.substring(p+1);
		           		}
		
		            	// If we have a namespace, we must have a namespace prefix
		            	// If we don't have a namespace, we discard any prefix
		            	if (namespaceURL) {
		                	if (!prefix) prefix = "a0"; // What Firefox uses
		            	}else prefix = "";
		
		            	// Create the root element (with optional namespace) as a
		            	// string of text
		            	var text = "<" + (prefix?(prefix+":"):"") +  tagname +
		                	(namespaceURL
		                 	?(" xmlns:" + prefix + '="' + namespaceURL +'"')
		                 	:"") +
		                	"/>";
		            	// And parse that text into the empty document
		            	doc.loadXML(text);
		        	}
		        	return doc;
    			}
			},
			parse: function(_text){
				if (typeof DOMParser != "undefined") {
        			// Mozilla, Firefox, and related browsers
        			return (new DOMParser( )).parseFromString(_text, "application/xml");
    			}else if (typeof ActiveXObject != "undefined") {
        			// Internet Explorer.
        			var doc = ezJsLib.XmlDom.newDocument( );  // Create an empty document
        			doc.loadXML(_text);            // Parse text into it
        			return doc;                   // Return it
    			}else {
        			// As a last resort, try loading the document from a data: URL
        			// This is supposed to work in Safari. 
        			var url = "data:text/xml;charset=utf-8," + encodeURIComponent(_text);
        			var request = new XMLHttpRequest( );
        			request.open("GET", url, false);
        			request.send(null);
        			return request.responseXML;
    			}
			},
			getValueByTag: function(_tag,_dom){
                if(_dom==null){
					_dom = ezJsLib.resultDom;
				}
				var nodevalue = ezJsLib.Constants.COMMON_UNDEFINED();
				try{
					var root = _dom.documentElement;
	                var nodes = root.getElementsByTagName(_tag);
	                //var nodevalue = "";
	                if (nodes[0]) {
	                    if(nodes[0].childNodes[0]){
							nodevalue = nodes[0].childNodes[0].nodeValue;	
						}
						return nodevalue;
	                }
	                else {
	                    throw new Error(ezJsLib.Constants.ERROR_NO_SUCH_TAG());
	                }
	            }catch(ex){
	            	// to do/ log
	            }
                return nodevalue;
            },
            getValueByTagFromNode: function(_tag,_node){
                if(_node==null){
					_node = ezJsLib.resultNode;
				}
				var nodevalue = ezJsLib.Constants.COMMON_UNDEFINED();
				try{
	                var nodes = _node.getElementsByTagName(_tag);
	                //var nodevalue = "";
	                if (nodes[0]) {
	                    if(nodes[0].childNodes[0]){
							nodevalue = nodes[0].childNodes[0].nodeValue;	
						}
						return nodevalue;
	                }
	                else {
	                    throw new Error(ezJsLib.Constants.ERROR_NO_SUCH_TAG());
	                }
	            }catch(ex){
	            	// to do/ log
	            }
                return nodevalue;
            },
            getValueByTagAndIndex: function(_tag,_dom,_index){
                if(_dom==null){
					_dom = ezJsLib.resultDom;
				}
				var nodevalue = ezJsLib.Constants.COMMON_UNDEFINED();
				try{
					var root = _dom.documentElement;
	                var nodes = root.getElementsByTagName(_tag);
	                //var nodevalue = "";
	                if (nodes[_index]) {
	                    if(nodes[_index].childNodes[0]){
							nodevalue = nodes[_index].childNodes[0].nodeValue;	
						}
	                }
	                else {
	                    throw new Error(ezJsLib.Constants.ERROR_NO_SUCH_TAG());
	                }
	            }catch(ex){
	            	// to do/ log
	            }
                return nodevalue;
            },
            getValueByTagAndIndexFromNode: function(_tag,_node,_index){
                if(_node==null){
					_node = ezJsLib.resultNode;
				}
				var nodevalue = ezJsLib.Constants.COMMON_UNDEFINED();
				try{
	                var nodes = _node.getElementsByTagName(_tag);
	                if (nodes[_index]) {
	                    if(nodes[_index].childNodes[0]){
							nodevalue = nodes[_index].childNodes[0].nodeValue;	
						}
	                }
	                else {
	                    throw new Error(ezJsLib.Constants.ERROR_NO_SUCH_TAG());
	                }
	            }catch(ex){
	            	// to do/ log
	            }
                return nodevalue;
            },
            getNodeByTagAndIndex: function(_tag,_dom,_index){
            	if(_dom==null){
            		_dom = ezJsLib.resultDom;
            	}
            	var node = null;
            	try{
            		var root = _dom.documentElement;
            		var nodes = root.getElementsByTagName(_tag);
            		if(nodes[_index]){
            			node = nodes[_index];
            		}
            		else{
            			throw new Error(ezJsLib.Constants.ERROR_NO_SUCH_TAG());
	                }
	            }catch(ex){
	            	// to do/ log
	            }
	            return node;
            },
            getHtmlContentFromResultXml: function(dom){
                if(dom==null){
					dom = ezJsLib.resultDom; 
				}
				//alert("getHtmlContentFromResultXml");
				//alert(ezJsLib.resultDom.documentElement);
				//alert(dom.documentElement);
				var root = dom.documentElement;
                var htmlContentTag = root.getElementsByTagName(ezJsLib.Constants.TAG_HTMLCONTENT());
                var content = "";
				//alert('htmlcontent');
				//alert(htmlContentTag);
				//alert(htmlContentTag[0]);
				//alert(htmlContentTag[0].childNodes[0]);
                if (htmlContentTag!=null && htmlContentTag[0]!=null) {
                    if(htmlContentTag[0].childNodes[0]!=null){
						content = htmlContentTag[0].childNodes[0].nodeValue;
					}
                    return content;
                }else{
					throw new Error(ezJsLib.Constants.ERROR_NO_SUCH_TAG());
                }
            },
			getStatusFromResultXml: function(_dom){
				if(_dom==null){
					_dom = ezJsLib.resultDom;
				}
				tag = ezJsLib.Constants.TAG_STATUS();
				status = ezJsLib.XmlDom.getValueByTag(tag,_dom);
				return status;
			},
			getProgressFromResultXml: function(_dom){
				if(_dom==null){
					_dom = ezJsLib.resultDom;
				}
				tag = ezJsLib.Constants.TAG_PROGRESS();
				progress = ezJsLib.XmlDom.getValueByTag(tag,_dom);
				return progress;
			},
			getErrorCodeFromResultXml: function(_dom){
				if(_dom==null){
					_dom = ezJsLib.resultDom;
				}
				tag = ezJsLib.Constants.TAG_ERROR_CODE();
				errorcode = ezJsLib.XmlDom.getValueByTag(tag,_dom);
				return errorcode;
			},
			getErrorMessageFromResultXml: function(_dom){
				if(_dom==null){
					_dom = ezJsLib.resultDom;
				}
				tag = ezJsLib.Constants.TAG_ERROR_MESSAGE();
				errormessage = ezJsLib.XmlDom.getValueByTag(tag,_dom);
				return errormessage;
			},
			getDescriptionFromResultXml: function(_dom){
				if(_dom==null){
					_dom = ezJsLib.resultDom;
				}
				tag = ezJsLib.Constants.TAG_DESCRIPTION_MESSAGE();
				description = ezJsLib.XmlDom.getValueByTag(tag,_dom);
				return description;
			},
            loadCommandResultDom: function(result){
                ezJsLib.resultDom = result;
            },
			loadContextDom: function(context){
				ezJsLib.contextDom = context;
			},
			loadConfigDom: function(result){
                ezJsLib.configDom = result;
            },
            getResultDom: function(){
                return ezJsLib.resultDom;
            },
            setResultDom: function(dom){
                ezJsLib.resultDom = dom;
            },
            getConfigDom: function(){
                return ezJsLib.configDom;
            },
            setConfigDom: function(dom){
                ezJsLib.configDom = dom;
            }
        };
        
        // ****** package for Ajax ******
        ezJsLib.Ajax = {
			// A private method used by js lib only
			_readFile: function(filename){
				var content = top.readTextFile(filename);
				var dom = ezJsLib.XmlDom.parse(content)
				return dom; 
			},
			loadResult: function(_file){
				var result = ezJsLib.Constants.RESULT_UNKNOWN();
				
				try{
					ezJsLib.resultDom = ezJsLib.Ajax._readFile(_file);
					result = ezJsLib.Constants.RESULT_LOADED();
				}catch(ex){
					// to do 
				}
				return result;
            },
			loadContext:function(){
				var result = ezJsLib.Constants.RESULT_UNKNOWN();
				
				try{
					ezJsLib.contextDom = ezJsLib.Ajax._readFile(ezJsLib.Constants.PATH_CONTEXT_FILE());
					result = ezJsLib.Constants.RESULT_LOADED();
				}catch(ex){
					// to do
				}
				return result;
				
			},
			getConfigFile: function(filepath){
				var xmlDom = null;
				try{
					xmlDom = ezJsLib.Ajax._readFile(filepath);
				}catch(ex){
					// to do
				}
				return xmlDom;
			}
        };
        
        //$ ****** public methods(end) ******
        
        //$ ****** private methods(start) ******
		
        this._getCommand = function(commandCode){
            var command;
            switch (commandCode) {
                case ezJsLib.Constants.NETLOAD():
                    command = [ezJsLib.Constants.COMMAND_DISPATCHER(), ezJsLib.Constants.NET_LOAD_COMMAND_CLASS()];
                    return command;
                case ezJsLib.Constants.NETSET():
                    command = [ezJsLib.Constants.COMMAND_DISPATCHER(), ezJsLib.Constants.NET_SET_COMMAND_CLASS()];
                    return command;
                case ezJsLib.Constants.NETSAVE():
                    command = [ezJsLib.Constants.COMMAND_DISPATCHER(), ezJsLib.Constants.NET_SAVE_COMMAND_CLASS()];
                    return command;
                case ezJsLib.Constants.NETRESTORE():
                    command = [ezJsLib.Constants.COMMAND_DISPATCHER(), ezJsLib.Constants.NET_RESTORE_COMMAND_CLASS()];
                    return command;
                case ezJsLib.Constants.DISCOVER_CHASSIS():
                    command = [ezJsLib.Constants.COMMAND_DISPATCHER(), ezJsLib.Constants.DISCOVER_CHASSIS_COMMAND_CLASS()];
                    return command;
				case ezJsLib.Constants.SET_CONTEXT():
					command = [ezJsLib.Constants.COMMAND_DISPATCHER(), ezJsLib.Constants.SET_CONTEXT_COMMAND_CLASS(),ezJsLib.context.toStringFormat()];
					return command;
				case ezJsLib.Constants.SHOW_INVENTORY():
					command = [ezJsLib.Constants.COMMAND_DISPATCHER(), ezJsLib.Constants.SHOW_INVENTORY_COMMAND_CLASS()];
					return command;
				case ezJsLib.Constants.QUERY_FIRMWARE():
					command = [ezJsLib.Constants.COMMAND_DISPATCHER(), ezJsLib.Constants.QUERY_FIRMWARE_COMMAND_CLASS()];
					return command;
				case ezJsLib.Constants.UPDATE_FIRMWARE():
					command = [ezJsLib.Constants.COMMAND_DISPATCHER(), ezJsLib.Constants.UPDATE_FIRMWARE_COMMAND_CLASS()];
					return command;
				case ezJsLib.Constants.CHECK_SCM_INSTALL_TASK_LIST():
					command = [ezJsLib.Constants.COMMAND_DISPATCHER(), ezJsLib.Constants.CHECK_SCM_INSTALL_TASK_LIST_COMMAND_CLASS(), ezJsLib.context.toStringFormat()];
					return command;
				case ezJsLib.Constants.CHECK_SCM_IS_INSTALLED():
					command = [ezJsLib.Constants.COMMAND_DISPATCHER(), ezJsLib.Constants.CHECK_SCM_IS_INSTALLED_COMMAND_CLASS()];
					return command;
				case ezJsLib.Constants.STORAGE_ZONE():
					command = [ezJsLib.Constants.COMMAND_DISPATCHER(), ezJsLib.Constants.STORAGE_ZONE_COMMAND_CLASS()];
					return command;
				case ezJsLib.Constants.EXPRESS_CONFIG():
					command = [ezJsLib.Constants.COMMAND_DISPATCHER(), ezJsLib.Constants.EXPRESS_CONFIG_COMMAND_CLASS()];
					return command;
				case ezJsLib.Constants.SAVE_CONFIG():
					command = [ezJsLib.Constants.COMMAND_DISPATCHER(), ezJsLib.Constants.SAVE_CONFIG_COMMAND_CLASS()];
					return command;
				case ezJsLib.Constants.RESTART_AMM():
					command = [ezJsLib.Constants.COMMAND_DISPATCHER(), ezJsLib.Constants.RESTART_AMM_COMMAND_CLASS()];
					return command;
				case ezJsLib.Constants.SET_LOCAL_IP():
					command = [ezJsLib.Constants.COMMAND_DISPATCHER(), ezJsLib.Constants.SET_LOCAL_IP_COMMAND_CLASS()];
					return command;
				case ezJsLib.Constants.GET_LOCAL_IP():
					command = [ezJsLib.Constants.COMMAND_DISPATCHER(), ezJsLib.Constants.GET_LOCAL_IP_COMMAND_CLASS()];
					return command;
				case ezJsLib.Constants.RESTORE_LOCAL_IP():
					command = [ezJsLib.Constants.COMMAND_DISPATCHER(), ezJsLib.Constants.RESTORE_LOCAL_IP_COMMAND_CLASS()];
					return command;
				case ezJsLib.Constants.IP_VALIDATION():
					command = [ezJsLib.Constants.COMMAND_DISPATCHER(), ezJsLib.Constants.IP_VALIDATION_COMMAND_CLASS()];
					return command;	
				case ezJsLib.Constants.IP_APPLY():
					command = [ezJsLib.Constants.COMMAND_DISPATCHER(), ezJsLib.Constants.IP_APPLY_COMMAND_CLASS()];
					return command;	
                default:
                    return '';
            }
        };
		this._getResultFile = function(commandCode){
            var file;
            switch (commandCode) {
                case ezJsLib.Constants.DISCOVER_CHASSIS():
                    file = ezJsLib.Constants.PATH_DISCOVERY_FILE();
                    return file;
				case ezJsLib.Constants.SHOW_INVENTORY():
					file = ezJsLib.Constants.PATH_INVENTORY_FILE();
					return file;
				case ezJsLib.Constants.QUERY_FIRMWARE():
					file = ezJsLib.Constants.PATH_FIRMWARE_FILE();
					return file;
				case ezJsLib.Constants.UPDATE_FIRMWARE():
					file = ezJsLib.Constants.PATH_FIRMWARE_FILE();
					return file;
				case ezJsLib.Constants.STORAGE_ZONE():
					file = ezJsLib.Constants.PATH_STORAGE_FILE();
					return file;
				case ezJsLib.Constants.EXPRESS_CONFIG():
					file = ezJsLib.Constants.EXPRESS_CONFIG_FILE();
					return file;
                default:
                    return '';
            }
        };
        //$ ****** private methods(end) ******
    }
})();
