// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
var UnattdModeType = {
	UNATTENDED_NULL 		: 0,
	UNATTENDED_TFTP		: 1,
	UNATTENDED_FTP			: 2,
	UNATTENDED_NFS			: 3,
	UNATTENDED_SMB			: 4,
	UNATTENDED_USB			: 5,
	UNATTENDED_INVALID		: 6,
	UNATTENDED_SFTP		: 7
};

var UnattdConfig = {
	// value of the IP address or hostname for NFS/SMB/FTP/TFTP server 
	m_strUnattdServer: "" ,

	// value of the directory to upload the log package 
	m_strUnattdDir: "" ,

	// value of the username 
	m_strUnattdUserName: "" ,

	// value of the password 
	m_strUnattdPassword: "" ,

	// value for the log package upload location
	m_enUnattdModeType: UnattdModeType.UNATTENDED_NULL , 


	SetUnattdModeType: function(modetype)
	{
		this.m_enUnattdModeType = modetype;
	},
	GetUnattdModeType: function()
	{
		return this.m_enUnattdModeType;
	},
	

	SetUnattdDir: function(strDir)
	{
		this.m_strUnattdDir = strDir;
	},
	GetUnattdDir: function()
	{
		return this.m_strUnattdDir;
	},

	SetUnattdServer: function(strSvr)
	{
		this.m_strUnattdServer = strSvr;
	},
	GetUnattdServer: function()
	{
		return this.m_strUnattdServer;
	},

	SetUnattdUserName: function(strUserName)
	{
		this.m_strUnattdUserName = strUserName;
	},
	GetUnattdUserName: function()
	{
		return this.m_strUnattdUserName;
	},

	SetUnattdPassword: function(strPassword)
	{
		this.m_strUnattdPassword = strPassword;
	},
	GetUnattdPassword: function()
	{
		return this.m_strUnattdPassword;
	},

	/**
	  * Set the value of the data members for class UnattdConfig,  based on the full string in the config file
	  * @param: fullstr - the value (string) of the "IBM_SYSTEM_UNATTENDED" field in config file
	  * @return: true 	- if it's a valid config string for unattended mode
	  *		     false 	- if it's a invalid config string for unattended mode
	  */
	//UpdateUnattdCfgFromFullStr: function(fullstr)
	UpdateUnattdCfgFromFullStr: function(strUnattdCfgFullStr)
	{
		//TODO
		this.m_strUnattdDir = "";
		this.m_strUnattdServer = "";

		var svrStartPos = 0;
		var svrEndPos = 0;
		var svrMidPos = 0;
		var ret = false;
		
		if ( "NULL" == strUnattdCfgFullStr || "" == strUnattdCfgFullStr)
		{
			this.m_enUnattdModeType = UnattdModeType.UNATTENDED_NULL;
		}
		else if (strUnattdCfgFullStr.indexOf("tftp://") != -1)
		{
			this.m_enUnattdModeType = UnattdModeType.UNATTENDED_TFTP;
		}
		else if (strUnattdCfgFullStr.indexOf("sftp://") != -1)
		{
			this.m_enUnattdModeType = UnattdModeType.UNATTENDED_SFTP;
		}
		else if (strUnattdCfgFullStr.indexOf("ftp://") != -1)
		{
			this.m_enUnattdModeType = UnattdModeType.UNATTENDED_FTP;
		}
		else if (strUnattdCfgFullStr.indexOf("nfs://") != -1)
		{
			this.m_enUnattdModeType = UnattdModeType.UNATTENDED_NFS;
		}
		else if (strUnattdCfgFullStr.indexOf("smb://") != -1)
		{
			this.m_enUnattdModeType = UnattdModeType.UNATTENDED_SMB;
		}
		else if (strUnattdCfgFullStr.indexOf("usb:/") != -1)
		{
			this.m_enUnattdModeType = UnattdModeType.UNATTENDED_USB;
		}
		else
		{
			this.m_enUnattdModeType = UnattdModeType.UNATTENDED_INVALID;
		}

		switch (UnattdConfig.GetUnattdModeType())
		{
			case UnattdModeType.UNATTENDED_NULL:
				break;
			case UnattdModeType.UNATTENDED_INVALID:
				break;
			case UnattdModeType.UNATTENDED_TFTP:
				svrStartPos = 7;
				svrEndPos = svrStartPos + strUnattdCfgFullStr.substring(svrStartPos).indexOf('/');
				break;
			case UnattdModeType.UNATTENDED_FTP:
				svrStartPos = 6;
				svrEndPos = svrStartPos + strUnattdCfgFullStr.substring(svrStartPos).indexOf('/');
				break;
			case UnattdModeType.UNATTENDED_NFS:
				svrStartPos = 6;
				svrEndPos = svrStartPos + strUnattdCfgFullStr.substring(svrStartPos).indexOf('/');
				break;
			case UnattdModeType.UNATTENDED_SMB:
				svrStartPos = 6;
				svrEndPos = svrStartPos + strUnattdCfgFullStr.substring(svrStartPos).indexOf('/');
				break;
			case UnattdModeType.UNATTENDED_USB:
				svrStartPos = 4;
				svrEndPos = svrStartPos;
				break;
			case UnattdModeType.UNATTENDED_SFTP:
				svrStartPos = 7;
				svrEndPos = svrStartPos + strUnattdCfgFullStr.substring(svrStartPos).indexOf('/');
				break;
			default:
				break;
		}

		if (svrStartPos != 0)
		{
			this.m_strUnattdServer = strUnattdCfgFullStr.substring(svrStartPos, svrEndPos);
			this.m_strUnattdDir = strUnattdCfgFullStr.substring(svrEndPos);
			if(top.strUnattdUseUserName)
			{
				svrMidPos = this.m_strUnattdServer.indexOf('@');
				this.m_strUnattdUserName = this.m_strUnattdServer.substring(0, svrMidPos);
				this.m_strUnattdServer = this.m_strUnattdServer.substring(svrMidPos+1);
			}
			ret = true;
		}
		return ret;
	},

	/**
	  * Generate the value (string) for the "IBM_SYSTEM_UNATTENDED" field in config file 
	  *@param: null
	  *@return: the value (string) for the "IBM_SYSTEM_UNATTENDED" field
	  */
	generateFullStrFromUnattdCfg: function()
	{
		var strRet = "";
		var unattdUser = top.strUnattdUseUserName?UnattdConfig.GetUnattdUserName()+"@":"";
		var unattdSvr = UnattdConfig.GetUnattdServer();
		if(top.strUnattdUseUserName&&unattdSvr.indexOf(":") != -1)
		{
			unattdSvr="["+unattdSvr+"]";
		}
		var unattdDir = UnattdConfig.GetUnattdDir();

		switch (UnattdConfig.GetUnattdModeType())
		{
			case UnattdModeType.UNATTENDED_NULL:
				break;
			case UnattdModeType.UNATTENDED_INVALID:
				break;
			case UnattdModeType.UNATTENDED_TFTP:
				if ('/' == unattdDir.charAt(0))
				{
					strRet = "tftp://" + unattdSvr + unattdDir;
				}
				else
				{
					strRet = "tftp://" + unattdSvr + "/" + unattdDir;
				}
				break;
			case UnattdModeType.UNATTENDED_SFTP:
				if ('/' == unattdDir.charAt(0))
				{
					strRet = "sftp://" + unattdUser + unattdSvr + unattdDir;
				}
				else
				{
					strRet = "sftp://" + unattdUser + unattdSvr + "/" + unattdDir;
				}
				break;
			case UnattdModeType.UNATTENDED_FTP:
				if ('/' == unattdDir.charAt(0))
				{
					strRet = "ftp://" + unattdUser + unattdSvr + unattdDir;
				}
				else
				{
					strRet = "ftp://" + unattdUser + unattdSvr + "/" + unattdDir;
				}
				break;
			case UnattdModeType.UNATTENDED_NFS:
				if ('/' == unattdDir.charAt(0))
				{
					strRet = "nfs://" + unattdSvr + unattdDir;
				}
				else
				{
					strRet = "nfs://" + unattdSvr + "/" + unattdDir;
				}
				break;
			case UnattdModeType.UNATTENDED_SMB:
				if ('/' == unattdDir.charAt(0))
				{
					strRet = "smb://" + unattdUser + unattdSvr + unattdDir;
				}
				else
				{
					strRet = "smb://" + unattdUser + unattdSvr + "/" + unattdDir;
				}
				break;
			case UnattdModeType.UNATTENDED_USB:
				if ('/' == unattdDir.charAt(0))
				{
					strRet = "usb:" + unattdDir;
				}
				else
				{
					strRet = "usb:/" + unattdDir;
				}
				break;
			default:
				break;
		}
		return strRet;
	}

}
