// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
var Progress = function() {
	/*
	 * in this file, use a combination of mt & os as talbe/div's 'index' or 'contentIndex'
	 */
	// var ac_progress_timer;
	// var ac_progress_timer2;
	var ac_package_index_last = -1;
	var ac_content_index = 0;
	var ac_table_visibility = false;
	var ac_isNew_content = true;
	var ac_current_content_count = 0;
	var ac_content_count = 0;
	var ac_canceled = false;
	var ac_additional_index_array = new Array();
	//record each content's height for sliding
	var ac_slide_time = 0.1 * 1000; 		//ms
	var ac_interval = 10;				//ms
	var ac_timer;
	var ac_moving_contentIndex;
	var ac_moving_hide = false;
	var ac_beginCount = 0;
	var strDate;
	var last_usbKeyVolume = "";
	var answer = "";

	var strDiv = "";
	var errCode = 0;
	var userSelected = false;
	var overallSteps = 0; // overall steps for media creation

	//record the error occured in one package
	var wrong = 0;
	var isContinue = false;

	var ibmMtArr = new Array();
	var lenovoMtArr = new Array();

	//buffer the html element frequently refered
	var _doc = document;
	var _details = _doc.getElementById("details");		//need the explorer to parse the js file after html file loaded
	header = ["Component", "Update ID", "Size (KB)", "Status"];

	// if any system has been selected
	// var sysSelected = false;

	var in_process_index = "";
	var in_process_rows_index = [];

	Array.prototype.indexOf = function(e) {
		for (var i = 0; i < this.length; i++) {
			if (this[i] == e)
				return i;
		}
		return -1; 
	};
	
	Array.prototype.add = function(val) {
		var index = this.indexOf(val);
		if (index == -1) {
			this.push(val); 
		}
	};

	Array.prototype.remove = function(val) {
		var index = this.indexOf(val);
		if (index > -1) {
			this.splice(index, 1); 
		}
	};

	function gui_log(text) {
	    top.writeTextFile(top.guilogInfo, "\n\t" + text + "\n\t", true);
	}

	// Bug 122980 - Some machines packages can not download when use the latest BoMC download all machines packages
	function mtArrSort() {
		ibmMtArr = [];
		lenovoMtArr = [];
		for (var i = 0; i < top.mtArray.length; i++) {
			lenovoMtArr.push(top.mtArray[i]);
		}
		top.mtArray = ibmMtArr;
		top.mtArray = top.mtArray.concat(lenovoMtArr);
	}

	function checkOverwrite()
	{
		if(top.isForce == true)
		{
			top.configTag["IBM_SYSTEM_FORCE_OVERWRITE"] == "";  
		}

		if(createISOFile == true)
		{
			if(engineTop.secureFileExists(top.isoFile))
			{
				// ISO file already exists in working directory
				if(confirm("Are you sure you want to overwrite " + top.isoFile + "?"))
				{
					top.isForce = true;
					return true;
				}
				else
				{
					alert("Please go back to \"Media Format\" and assign another name for the ISO file");
					return false;
				}
			}
			else
			{
				return true;
			}
		}
		else if(createPXEFile == true)
		{
			var pxeKeyFile = "";
			if (top.OSTYPE == "windows")
			{
				if(top.pxeFile.lastIndexOf("\\") == top.pxeFile.length-1)
				{
					pxeKeyFile = top.pxeFile + "pxelinux.0";
				}
				else
				{
					pxeKeyFile = top.pxeFile + "\\pxelinux.0";
				}                  
			}
			else
			{
				if(top.pxeFile.lastIndexOf("/") == top.pxeFile.length-1)
				{
					pxeKeyFile = top.pxeFile + "pxelinux.0";
				}
				else
				{
					pxeKeyFile = top.pxeFile + "/pxelinux.0";
				}
			}

			var pxeExisted = engineTop.secureFileExists(pxeKeyFile);
			if (pxeExisted)
			{
				if (confirm("Are you sure you want to overwrite " + top.pxeFile + "?"))
				{
					top.isForce = true;
					return true;
				}
				else
				{
					alert("Please go back to \"Media Format\" and assign another direcotry for pxe creation");
					return false;
				}
			}
			else
			{
				return true;
			}
		}
		else
		{
			//create usb or burn to device
			return true;
		}
	}

	function progressInit() {
	    if (!top.isForce) {
			if(!checkOverwrite())
			{
				return;
			}
	    }


		if(top.use_Intel_RSTe_RAID_Configuration)
		{
			top.writeConFiles(
				top.workingdirProgram
				+(top.workingdirProgram.lastIndexOf(FILE_SEPARATOR) == top.workingdirProgram.length-1?"":FILE_SEPARATOR)
				+"configfiles");
		}

		in_process_index = "";
		in_process_rows_index.splice(0,in_process_rows_index.length);

		mtArrSort();

		_doc = document;
		_details = _doc.getElementById("details");
		$("#details").empty().hide();
		$("#acqMsg").hide();
		$("#cplMsg").hide();
		$("#noMsg").hide();
		$("#cancelMsg").hide();
		$("#beginBtn").hide();
		$("#multiflash").hide();
		$("#retryBtn").hide();
		header = ["Component", "Update ID", "Size (KB)", "Status"];
		top.toggleNext(false);
		
		if(top.acquireMode)
		{
			ac_init();
		}
		else
		{
			top.isBomcRunning(killBomcConfirm);
		}
	}

	function killBomcConfirm(success) {
		if (success) {
			var confirmKill = top.confirm("Another running bomc is detected. If you want to continue this program, the running one need to be killed. Are you sure to kill it and continue now? ");
			console.log("check confirmKill result is ", confirmKill);
			if (confirmKill) {
				top.killAsync(top.mainAppName, killBomcCB);
			} else {
				$("#beginBtn").show();
				return false;
			}
		} else {
			ac_init();
		}
	}

	function killBomcCB(success) {
		if (success) {
			ac_init();
		} else {
			$("#beginBtn").show();
			return false;
		}
	}

	function ac_init() {
		ac_reload();
		beginAcq(_doc.getElementById("beginBtn"));
	}

	//refresh Aquire_Updates.html
	function ac_reload() {
	    // window.location.reload();
	    $("#details").empty().hide();
	    $("#acqMsg").hide();
	    $("#acqMsg2").html("Acquiring updates. . .");
	    $("#acqMsg1").html("...").hide();
	    $("#beginBtn").show();
		$("#retryBtn").hide();
	    $("#meterValue").css("margin-right", "100%");
	    $("#contentMeter").css("margin-right", "100%");
	    $("#contentProgress").hide();
	    $("#noMsg").hide();
		ac_package_index_last = -1;
		ac_content_index = 0;
		ac_table_visibility = false;
		ac_isNew_content = true;
		ac_current_content_count = 0;
		ac_content_count = 0;
		// ac_canceled = false;
		ac_additional_index_array = new Array();
		ac_slide_time = 0.1 * 1000; 		//ms
		ac_interval = 10;				//ms
		ac_timer;
		ac_moving_contentIndex;
		ac_moving_hide = false;
		strDate;
		ac_beginCount = 0;

		strDiv = "";
		errCode = 0;
		userSelected = false;
		overallSteps = 0; 

		wrong = 0;
		isContinue = false;

		_doc = document;
		_details = _doc.getElementById("details");
		header = ["Component", "Update ID", "Size (KB)", "Status"];

		if(!top.acquireMode || top.usbReFlash)
		{
			progressMainAppIsRunning = false;
		}

		// sysSelected = false;

	    top.toggleNext(false);
	}

	function initToolArr() {
		ac_additional_index_array = new Array();
		var tempArr = new Array();

		if(top.selectedOSMachineType.indexOf("x") != -1 || top.selectedOSMachineType.indexOf("purley") != -1)
		{
			if (tempArr.indexOf("UPDATE") == -1) {
				tempArr.push("UPDATE");
			}
		}
		if(top.selectedOSMachineType.indexOf("ibm") != -1)
		{
			if (tempArr.indexOf("UXSPI") == -1) {
				tempArr.push("UXSPI");
			}
		}

		for (var i = 0; i < top.selectedOSMachineType.length; i++) {
	    	if (top.program == "UPDATE") {
	    		if (top.selectedOSMachineType[i] == "x") {
	    			if (tempArr.indexOf("Maintenance Mode OS(for Lenovo ThinkSystem and Lenovo System X)") == -1) {
		    			tempArr.push("Maintenance Mode OS(for Lenovo ThinkSystem and Lenovo System X)");
		    		}
	    		}
	    		if (top.selectedOSMachineType[i] == "ibm") {
	    			if (tempArr.indexOf("Maintenance Mode OS(for IBM system X)") == -1) {
		    			tempArr.push("Maintenance Mode OS(for IBM system X)");
		    		}
	    		}
	    		if (top.selectedOSMachineType[i] == "purley") {
	    			if (tempArr.indexOf("Maintenance Mode OS(for Lenovo ThinkSystem and Lenovo System X)") == -1) {
		    			tempArr.push("Maintenance Mode OS(for Lenovo ThinkSystem and Lenovo System X)");
		    		}
	    		}
	    	} else if (top.program == "FULL") {
	    		if (top.selectedOSMachineType[i] == "x") {
		    		if (tempArr.indexOf("DSA") == -1) {
		    			tempArr.push("DSA");
		    		}
		    		if (tempArr.indexOf("Maintenance Mode OS(for Lenovo ThinkSystem and Lenovo System X)") == -1) {
		    			tempArr.push("Maintenance Mode OS(for Lenovo ThinkSystem and Lenovo System X)");
		    		}
		    	}
		    	if (top.selectedOSMachineType[i] == "ibm") {
		    		if (tempArr.indexOf("Maintenance Mode OS(for IBM system X)") == -1) {
		    			tempArr.push("Maintenance Mode OS(for IBM system X)");
		    		}
		    		if (tempArr.indexOf("ASU") == -1) {
		    			tempArr.push("ASU");
		    		}
		    		if (tempArr.indexOf("DSA") == -1) {
		    			tempArr.push("DSA");
		    		}
		    	}
		    	if (top.selectedOSMachineType[i] == "purley") {
		    		if (tempArr.indexOf("Maintenance Mode OS(for Lenovo ThinkSystem and Lenovo System X)") == -1) {
		    			tempArr.push("Maintenance Mode OS(for Lenovo ThinkSystem and Lenovo System X)");
		    		}
		    	}
	    	}
 	    }

 	    var sortArr = new Array();
 	//    for (var i = 0; i < tempArr.length; i++) {
 	    	if (tempArr.indexOf("Maintenance Mode OS(for Lenovo ThinkSystem and Lenovo System X)") != -1) {
 	    		if (sortArr.indexOf("Maintenance Mode OS(for Lenovo ThinkSystem and Lenovo System X)") == -1) {
 	    			sortArr.push("Maintenance Mode OS(for Lenovo ThinkSystem and Lenovo System X)");
 	    		}
 	    	}
 	    	if (tempArr.indexOf("Maintenance Mode OS(for IBM system X)") != -1) {
 	    		if (sortArr.indexOf("Maintenance Mode OS(for IBM system X)") == -1) {
 	    			sortArr.push("Maintenance Mode OS(for IBM system X)");
 	    		}
 	    	}
 	    	if (tempArr.indexOf("ASU") != -1) {
 	    		if (sortArr.indexOf("ASU") == -1) {
 	    			sortArr.push("ASU");
 	    		}
 	    	}
 	    	if (tempArr.indexOf("UPDATE") != -1) {
 	    		if (sortArr.indexOf("UPDATE") == -1) {
 	    			sortArr.push("UPDATE");
 	    		}
			}
 	    	if (tempArr.indexOf("UXSPI") != -1) {
				if (sortArr.indexOf("UXSPI") == -1) {
					sortArr.push("UXSPI");
				}
			}
 	    	if (tempArr.indexOf("DSA") != -1) {
 	    		if (sortArr.indexOf("DSA") == -1) {
 	    			sortArr.push("DSA");
 	    		}
 	    	}
 	//    }
 	    ac_additional_index_array = sortArr;
	}

	function store_bomc_command(args) {
		top.bomcCommandArray.length = 0;
		top.bomcCommandArray = args.slice();

		var patt1 = new RegExp("--password=");
		var patt2 = new RegExp("--proxy-password=");
		var patt3 = new RegExp("bomc.exe|bomc.bin");

		// hidden passowrd.
		// hidden absolute path of BoMC
		for (var i=0; i<args.length; i++) {
			if (patt1.test(args[i])) {
				top.bomcCommandArray[i] = "--password=***";
			} else if (patt2.test(args[i])) {
				top.bomcCommandArray[i] = "--proxy-password=***";
			} else if (patt3.test(args[i])) {
				top.bomcCommandArray[i] = "<LXCE BoMC>";
			}
		}

		// remove proxy script
		top.bomcCommandArray.shift()

		// remove '--xml' parameter, it is only for GUI usage
		var index = top.bomcCommandArray.indexOf("--xml");
		if (index > -1) {
			top.bomcCommandArray.splice(index, 1);
		}
	}

	function makeCliContinue() {
		if(!top.comResultCompleted)
		{
			setTimeout(makeCliContinue,100);
		}
		else
		{
			progressInit();
		}
	}

	function uxsp_acquire() {
		initToolArr();
		if(top.acquireMode && !top.usbReFlash)
		{
			var status = window.bomc.utils('readTextFile', top.CONFIRM_CONTINUE_FILE);
			if(status != "RETRY")
			{
				window.bomc.utils('writeTextFile', top.gl_ac_result, window.bomc.utils('readTextFile', top.gl_ac_result_rewrite));
				window.bomc.utils('writeTextFile', top.CONFIRM_CONTINUE_FILE, "CONTINUE", false);
			}
			
			overallSteps = 6;
			if (top.mediaFormat == 0 && top.cdVolume != "") {
				overallSteps = 8;
			}
			return ;
		}
	    var dir;
	    var args = new Array();
	    if (top.OSTYPE == "windows") {
	        // args.push(getStartingTopDir() + getNativeFileSeparator() + "..\\proxy.bat");
	        args.push(top.workingdir + "\\" + top.mainAppName);
	        dir = "workingdir";
	        strDiv = "\\";
	    } else {
	        args.push(getStartingTopDir() + getNativeFileSeparator() + "../proxy.sh");
	        args.push(top.mainAppName);
	        dir = "workingdir";
	        strDiv = "/";
	    }

	    top.program = top.program.replace("uxspi", "UPDATE");

	    if (top.selectedOSMachineType.indexOf("storage") != -1) {
	    	args.push('--function=jbod');
	    } else {
	    	args.push('--function=' + top.program.toLowerCase());
	    }

		if (top.selectedOSMachineType.indexOf("storage") == -1) {
			if (!top.isRebootBmc)
			{
				args.push('--noreboot');
			}
			if (top.strUnattdCfgFullStr != "" && top.strUnattdCfgFullStr != "NULL" && top.strUnattdCfgFullStr!= undefined) {
				args.push("--unattended=" + top.strUnattdCfgFullStr);
				if (top.after_updating_firmware == "Noaction")
				{
					args.push("--noshutdown");
				}
				else if (top.after_updating_firmware == "Reboot")
				{
					args.push("--rebootos");
				}
				if (top.strUnattdUseUserName)
				{
					if (top.OSTYPE == "windows") {
						args.push("--password=" + "\"\"" + top.strUnattdCfgPassword + "\"\"");
					} else {
						args.push("--password=" + "\"" + top.strUnattdCfgPassword + "\"");
					}
				}
		    }
		}

	    var mt = "";
	    for (var i=0; i<top.mtArray.length; ++i) {
	        if (i==0) {
	            mt = top.mtArray[i];
	        } else {
	            mt = mt + "," + top.mtArray[i];
	        }

	    }

	    if (top.selectedOSMachineType.indexOf("storage") == -1) {
	    	// if(top.acquireMode == true && mt != "" && mt != undefined && mt != null) {
			if (mt != "" && mt != undefined && mt != null) {
				//args.push("-m " + mt);
				args.push("--machine-type=" + mt);
			}
			if (!top.acquireMode && top.acquireToolOnly) {
        		//args.push("--machine-type=all");
				//args.push("--machine-type=none"); //20140616, doesn't acquire any more firmware package for local repository case
				args.push("--no-mt-acquire"); // Using --no-acquire-mt instead of --machine-type=noe to let bomc.exe not filter the packages.
	    	}
	    }
		//	args.push("--bootenv=" + top.bootEnv);
		if (top.selectedOSMachineType.indexOf("storage") == -1) {
			if (top.autorun != "NULL") {
				args.push("--autorun");
			}
		}
	    
	    if (top.mediaFormat == 1) {
	        if (top.usbKeyVolume != "" ) {
	            overallSteps = 6;
	            args.push("--usbkey=" + top.usbKeyVolume);
	        }
	    } else if (top.mediaFormat == 2) {
	        if (top.pxeFile != "") {
	            overallSteps = 6;
	            if (top.OSTYPE == "windows") {
	                var lastChar = top.pxeFile.charAt(top.pxeFile.length - 1);
	                if (lastChar == "\\") {
	                    top.pxeFile = top.pxeFile.substring(0, top.pxeFile.length - 1);
	                }
					args.push("--pxe");
					args.push( top.pxeFile );
	            } else {
	                args.push("--pxe=" + top.pxeFile);
	            }
	            if (top.pxeTFTPAddress != "") {
	                args.push("--tftp-pxe-address=" + top.pxeTFTPAddress);
	            }
	        }
	    } else {
	        if (top.isoFile != "") {
	            overallSteps = 6;
	            if (top.OSTYPE == "windows") {
					
					args.push("--iso");
					args.push( top.isoFile );
	            } else {
	                args.push("--iso=" + top.isoFile);
	            }
	        }
		}
		
		if (top.copy_ram_disk) {
			args.push("--copytoramdisk");
		}
		
	    if (top.isForce) {
	    	args.push("--force");
	    }

		if (top.useAdditionalCaCertFile) {
			args.push("--cacert=" + top.additionalCaCertFile);
		}

		if (top.url_custom) {
			if (top.url_insecure) {
				args.push("--insecure");
			} else if (top.url_custom && top.url_specify_cert) {
				if (top.urlCustomCaCertFile != "" && top.urlCustomCaCertFile != null) {
					args.push("--cacert");
					args.push(top.urlCustomCaCertFile);
				}
			}
		}

	    if (top.useProxy) {
	    	if (top.proxyAdd != "" && top.proxyAdd != null && top.proxyAdd != undefined && top.proxyPort != "" && top.proxyPort != null && top.proxyPort != undefined) {
				if (top.proxyType == "https" ||
					top.proxyType == "socks4" ||
					top.proxyType == "socks4a" ||
					top.proxyType == "socks5" ||
					top.proxyType == "socks5h") {
					args.push("--proxy-address=" + top.proxyType + "://" + top.proxyAdd);
				} else {
					args.push("--proxy-address=" + top.proxyAdd);
				}
	    		args.push("--proxy-port=" + top.proxyPort);
	    	}
	    	if (top.useProxyAuth) {
	    		if (top.proxyUid != "" && top.proxyUid != null && top.proxyUid != undefined) {
	    			args.push("--proxy-user=" + top.proxyUid);
	    		}
	    		if (top.proxyPwd != "" && top.proxyPwd != null && top.proxyPwd != undefined) {
	    			args.push("--proxy-password=" + top.proxyPwd);
	    		}
			}

			if (top.proxy_insecure) {
				args.push("--proxy-insecure");
			} else {
				if (top.proxy_specify_cert) {
					if (top.proxyCaCertFile != "" && top.proxyCaCertFile != null) {
						args.push("--proxy-cacert");
						args.push(top.proxyCaCertFile); 
					}
				}
			}
	    }
	    
	    if (top.OSTYPE == "windows") {
	        var lastChar = top.workingdirProgram.charAt(top.workingdirProgram.length - 1);
	        if (lastChar == "\\") {
	            top.workingdirProgram = top.workingdirProgram.substring(0, top.workingdirProgram.length - 1);
	        }
	        // args.push("\"" + "--local=" + top.workingdirProgram + "\"");
	        args.push("-l");
	        args.push(top.workingdirProgram );
	    } else {
	        // args.push("--local=" + top.workingdirProgram);
	        args.push("-l");
	        args.push(top.workingdirProgram);
	    }
	    args.push("--xml");
	    if (top.selectedOSMachineType.indexOf("storage") != -1) {
	    	if (!top.acquireToolOnly || top.usbReFlash) {
	    		args.push('--no-acquire');
	    	}
	    } else {
	    	if ((!top.acquireMode && !top.acquireToolOnly) || top.usbReFlash) {
		        //acquire from local directory
		        args.push("--no-acquire");
		    } else {
		        //acquire form System X web site
		        if (top.latest) {
		            args.push("--latest");
		        }
		    }
	    }

	    if (top.OSTYPE == "windows") {
	        if (top.mediaLabel == "") {
				args.push("--description=" + "\"" + " " + "\"");
	        } else {
				args.push("--description");
				args.push( top.mediaLabel );
	        }
	    } else {
	        if (top.mediaLabel == "") {
	            args.push("--description=" + " ");
	        } else {
	            args.push("--description=" + top.mediaLabel);
	        }
		}

	    // Add for preview 
            setPreviewParams(args);
            store_bomc_command(args);

	    progressMainAppIsRunning = true;
	    secureRunProgram(null, args, BACKGROUND, HIDDEN, null, progessCallback);
	}

	function progessCallback() {
		progressMainAppIsRunning = false;
	}

	function beginAcq(ref) {
	    _doc.getElementById("cancelMsg").style.display = "none";
	    top.togglePrevious(false);
	    _doc.getElementById("acqMsg").style.display = "block";
	    _details.style.display = "block";
	    ref.style.display = "none";

	    ac_canceled = false;
	    //Preparation
	    deleteFile(top.gl_ac_result);
		deleteFile(top.cliErrorMsg);

		if(!top.acquireMode || top.usbReFlash)
		{
			deleteFile(top.guilogInfo);
			
		}

	    uxsp_acquire();

	    if (top.selectedOSMachineType.indexOf("storage") != -1) {
		    if (top.acquireToolOnly && !top.usbReFlash) {
		    	createJbodContent();
		    	setTimeout(showStatus_ac, 1000);
		    } else {
		    	complete(1, '');
		    }
	    } else {
		    if ((top.acquireMode || top.acquireToolOnly) && !top.usbReFlash) {
		        createAllContents(true);
		        //ac_progress_timer = setInterval(showStatus_ac,1000);
		        setTimeout(showStatus_ac,1000);
		    } else {
		        complete(1, "");
		    }
	    }
	}

	function ac_cancel() {
	    ac_canceled = true;
	    //clearInterval(ac_progress_timer);
		killApp_ux(top.mainAppName);
		progressMainAppIsRunning = false;
	    ac_reload();
		_doc.getElementById("cancelMsg").style.display = "block";
		if(top.acquireMode)
		{
			$("#beginBtn").hide();
			UpdateSelection.ac_cancel();
		}
	    top.togglePrevious(true);
	}


	function killApp_ux(appName) {
	    var args = new Array();
	    args.push(getStartingTopDir() + getNativeFileSeparator() + top.guiHelper);
	    args.push("--kill");
	    args.push(appName);
	    args.push("--file");
	    args.push(top.bomc_gui);
	    return secureRunProgram(null, args, FOREGROUND, HIDDEN);
	}

	function confirmContinue(warningMsg) {
		if (isContinue == false) {
			var msg = warningMsg + "\nAre you sure you want to continue?";
			answer = "STOP";
			if (confirm(msg)) {
				isContinue = true;
				answer = "CONTINUE";
			}
			top.writeTextFile(top.CONFIRM_CONTINUE_FILE, answer, false);
		}
		gui_log("confirm continue");
	    return isContinue;
	}

	function showStatus_ac() {
	    //gui_log("showStatus_ac in");
	    strDate = Date();
	    gui_log(strDate + " showStatus_ac in");
	    if (ac_canceled == true) {
	        return;
	    }
		
		getCLIErrorCode(); 

		if (errCode >= 100 && errCode!= 205) {
	        complete(0, errMsg);
	        return;
	    }

        if (!top.fileExists(top.gl_ac_result) && progressMainAppIsRunning) {
        	_doc.getElementById("acqMsg2").innerHTML = "Connecting...";
        	setTimeout(showStatus_ac,1000);
            return;
        }

    	if (!top.fileExists(top.gl_ac_result) || !progressMainAppIsRunning) {
            if (errCode >= 100 && errCode < 256) {
            	//cli return error
                //clearInterval(ac_progress_timer);
                complete(0, errMsg);
                return;
			} else {
               	errCode = 0;
                errMsg="bomc process error";
               	complete(errCode, errMsg);
               	return;
            }
        }

	    var doc = top.readTextFile(top.gl_ac_result);

        var dom = ezJsLib.XmlDom.parse(doc);
        //doc is not null but dom is null
        if (dom == null) {
            setTimeout(showStatus_ac,1000);
            return;
        }
        var content = ezJsLib.XmlDom.getNodeByTagAndIndex("CONTENT", dom, ac_content_index);
        if (content == null) {
            //refresh the progress bar
            _updateProgress(content);
            if (!progressMainAppIsRunning) {
                //clearInterval(ac_progress_timer); 
                //stop the timer
                complete(0, errMsg);
                return;
            }
            setTimeout(showStatus_ac,1000);
            return;
        }
		
        var mt = ezJsLib.XmlDom.getValueByTagFromNode("MT", content);
        // defect-159191: [bomc01c]If the second MT download failure, bomc would not pop out warning message then the GUI will hang at downloading
        var needErrorConfirm = false;
        if (mt.toLowerCase() != "tool") {
        	needErrorConfirm = true;
        }
        var os = ezJsLib.XmlDom.getValueByTagFromNode("OS", content);
        var total = parseInt(ezJsLib.XmlDom.getValueByTagFromNode("TOTAL", content));
        var currentUpdateId = ezJsLib.XmlDom.getValueByTagFromNode("CURRENTUPDATEID", content);
		var index = "";
		if(os == "RHEL 7 x64"){
			index = (mt + unifyOS("RHEL 7")).toLowerCase();
		} else if (os == "platform"){
			index = (mt + unifyOS("platform")).toLowerCase();
		} else {
			index = (mt + unifyOS(os)).toLowerCase();
		}
		in_process_index = index;
        //update content coming...

        if (mt == "all" || (mt == "undefined" && os == "NONE")) { //get fixIds list or invalid mt and os
            setTimeout(showStatus_ac,1000);
            return;
        }

        _doc.getElementById("acqMsg1").style.display = "block";
        _doc.getElementById("contentProgress").style.display = "block";
        _doc.getElementById('cancelBtn').style.marginLeft = (top.BROWSER == "IExplore") ? "44" : "36" + "px";
        
        
        if (ac_isNew_content) {	

			wrong = 0;
			updateTotal(index, total);
			ac_beginCount = 0;
			ac_current_content_count = total;
            
            if (total > 0) {						
                showPlusIcon(index);
                updateTitle(index, "Acquiring");
                var table = null;
                if(ac_beginCount==0) {
                	table = createTable(index, true);
                } else {
                	table = _doc.getElementById("table" + index);
                }
                
                for (var i = 0; i < total; i++) {
                    //default consider that its a full xml file, including all nodes
                    var component = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("COMPONENT", content, i);
					var updateId = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("UPDATEID", content, i);
					var description = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("DESCRIPTION", content, i);
                    var size = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("SIZE", content, i);
                    var statusValue = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("STATUS", content, i);

                    //add a new row
                    var newRow = table.insertRow(-1);

                    var newCell1 = newRow.insertCell(-1);
                    //The following codes are used to test the match between the content and the title
                    //var machineType = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("MT", content, 0);
                    //var os = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("OS", content, 0);
                    //newCell1.innerHTML = component + machineType + os;
                    if (component == "Undefined" || component == "null")
                        component = "UXSP";
                    newCell1.innerHTML = component;
                    newCell1.title = component;
                    newCell1.className = "EntityTableCell";

                    var newCell4 = newRow.insertCell(-1);
                    newCell4.innerHTML = updateId;
                    newCell4.title = description.replace(/ \(InstallXML\)/g, "");
                    newCell4.className = "EntityTableCell";

                    var newCell6 = newRow.insertCell(-1);
                    newCell6.innerHTML = formatNumberWithComma(size);
                    newCell6.title = formatNumberWithComma(size);
                    newCell6.className = "EntityTableCell";
                    newCell6.align = "right";

                    var newCell7 = newRow.insertCell(-1);
                    newCell7.title = "Not Started";
                    newCell7.innerHTML = "<img src='images/statusStopped_obj16.gif' alt='Not Started'>" + "Not Started";
                    newCell7.className = "EntityTableCell";
                    ac_isNew_content = false;
                }
            } else {
                updateTitle(index, "None");
                ac_isNew_content = true;
                //start parsing new content
                ac_content_index++;
            }
        } else {
            var package_finished_count = ac_beginCount;
            console.log("PACKAGE_FINISHED_COUNT="+package_finished_count);
            //record the number of wrong status of the contents
            table = _doc.getElementById("table" + index);
            for (var i = 0; i < total; i++) {
                var statusValue = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("STATUS", content, i);
                if (statusValue.toLowerCase().indexOf('already download') != -1) {
					table.rows[1 + ac_beginCount + i].cells[3].title = statusValue;
                    table.rows[1 + ac_beginCount + i].cells[3].innerHTML = "<img src='images/statusNormal_obj16.gif' alt='Already Downloaded'>" + statusValue;
					package_finished_count++;
					in_process_rows_index.remove(1 + ac_beginCount + i);
                } else if (statusValue.toLowerCase().indexOf('acquiring') != -1) {
                    // calculate completing percent for current package
                    var downloadedSize = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("DOWNLOADSIZE", content, i);
                    var totalSize = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("SIZE", content, i);
                    var completePercent;
                    if (totalSize == 0) {
                        completePercent = 100;
                    } else {
                        completePercent = (parseFloat(downloadedSize) / parseFloat(totalSize) * 100).toFixed(0);
                    }
                    if (completePercent > 100) {
                        completePercent = 100;
                    } else if (completePercent < 0) {
                        completePercent = 0;
					}
					table.rows[1 + ac_beginCount + i].cells[3].title = statusValue + "(" + completePercent + "%)";
					table.rows[1 + ac_beginCount + i].cells[3].innerHTML = "<img src='images/progress_anim2_small.gif' alt='Acquiring'>" + statusValue + "(" + completePercent + "%)";
					in_process_rows_index.add(1 + ac_beginCount + i);
					/*
                    * If the cli exits abnormally when downloading, the status of the UXSP will be always "acquiring",
                    * and the status on the xml won't be changed.
                    * In this case, what we need to do is to just traverse the xml file.
                    */
                    if (!progressMainAppIsRunning) {
						wrong++;
						table.rows[1 + ac_beginCount + i].cells[3].title = statusValue;
                        table.rows[1 + ac_beginCount + i].cells[3].innerHTML = "<img src='images/statusCritical_obj16.gif' alt='Critical Error'>" + statusValue;
						package_finished_count++;
						in_process_rows_index.remove(1 + ac_beginCount + i);
                    }
                } else if (statusValue.toLowerCase().indexOf('done') != -1) {
					table.rows[1 + ac_beginCount + i].cells[3].title = statusValue;
                    table.rows[1 + ac_beginCount + i].cells[3].innerHTML = "<img src='images/statusSuccess_obj16.gif' alt='Success'>" + statusValue;
					package_finished_count++;
					in_process_rows_index.remove(1 + ac_beginCount + i);
                } else if (statusValue.toLowerCase().indexOf('error') != -1) {
					wrong++;
					table.rows[1 + ac_beginCount + i].cells[3].title = statusValue;
                    table.rows[1 + ac_beginCount + i].cells[3].innerHTML = "<img src='images/statusCritical_obj16.gif' alt='Critical Error'>" + statusValue;
					package_finished_count++;
					in_process_rows_index.remove(1 + ac_beginCount + i);
                    //if updates contents is partly download, should pop up confirm dialog box

                    // why pop up the confirm dialog only when ac_content_index == 0?
                    // if(top.program.indexOf("uxspi") != -1&&ac_content_index==0&&wrong==1){
                    // defect-159191: [bomc01c]If the second MT download failure, bomc would not pop out warning message then the GUI will hang at downloading
                    if(needErrorConfirm && wrong > 0){
                        if(confirmContinue("some update files are missed  ")){

                        } else {
                            ac_cancel();
                        }
                    }
                    // if(top.program.indexOf("uxspi") != -1 && needErrorConfirm && wrong > 0){
                    //     if(confirmContinue("some update files are missed  ")){

                    //     } else {
                    //         ac_cancel();
                    //     }
                    // }
                } else {
                    if (!progressMainAppIsRunning) {
                    	package_finished_count++;
                    }
                }
        	}
        
	        //finished downloading one package
	        if (package_finished_count == ac_current_content_count) {
	            if(wrong==ac_current_content_count){
	                updateTitle(index, "Error");
	                if(top.program.indexOf("UPDATE") != -1&&ac_content_index==1){
	                    complete(0,errMsg);
	                }
	            }
	            else if(wrong==0){
					updateTitle(index, "Done");
					in_process_index = "";
	            }
	            else {
					updateTitle(index, "Warning");
					in_process_index = "";
	            }
	            ac_isNew_content = true;
	            //start parsing new content
	            ac_content_index++;
	        }
	    }
	    _updateProgress(content);

	    //Even when uxspi300_cli.exe has quited, the page will still remain incomplete because of the I/O delay for writing/reading xml file
        if (ac_content_index == ac_content_count) { //all statuses in ac_result.xml are "Done" or "Already Downloaded	
            if(errCode == 205) {
				complete(1, "");
                return;
			}
			//It's a little hard to handle all kinds of errors here.
            if ((errCode >= 100 && errCode < 256) || !progressMainAppIsRunning) {
                //exit abnormally
                //cli errors occurred
                //clearInterval(ac_progress_timer); //stop the timer
                complete(0, errMsg);
                return;
            } else {
                //clearInterval(ac_progress_timer);
                complete(1, "");
                return;
            }
        }
	    
	    setTimeout(showStatus_ac,1000);
	    //} catch (e) {
	        //do nothing...
	    //}
	}


	function _updateProgress(content) {
	    //gui_log("_updateProgress in");
	    if (content == null) {
	        //if content is null, restore the package downloading progress bar to zero
	        _doc.getElementById("meterValue").style.marginRight = "100%";
	        _doc.getElementById("acqMsg2").innerHTML = "Acquiring now, please wait...";
	        return;
	    }

	    var packages = content.getElementsByTagName("PACKAGE");
	    var machineType= ezJsLib.XmlDom.getValueByTagFromNode("MT", content);
	    var total = ezJsLib.XmlDom.getValueByTagFromNode("TOTAL", content);
	    var currentUpdateId = ezJsLib.XmlDom.getValueByTagFromNode("CURRENTUPDATEID", content);
	    var currentUpdateIdIndex = -1;
	    for (var i = 0; i < total; i++) {
	        var updateId = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("UPDATEID", content, i);
	        if (updateId == currentUpdateId)
	            currentUpdateIdIndex = i;
	    }
	    if (currentUpdateIdIndex == -1)
	        return;

	    if (packages.length == 0) {
	        _doc.getElementById("acqMsg2").innerHTML = "Acquiring now, please wait...";
	        _doc.getElementById("acqMsg1").innerHTML = "Acquiring " + ac_content_index + " of " + ac_content_count + " package bundle(s)";
	        _doc.getElementById("contentMeter").style.marginRight = formatData((1 - ac_content_index / ac_content_count) * 100) + "%";
	        if (machineType == "Tool" || machineType== "VMWARE ESXi Updates" || machineType == "Requisite Package") {
	            _doc.getElementById("acqMsg1").innerHTML = "Acquiring " + (ac_content_index + 1)+ " of " + ac_content_count + " package bundle(s)";
	            _doc.getElementById("contentMeter").style.marginRight = formatData((1 - ac_content_index / ac_content_count) * 100) + "%";
	        } else {
	            if (confirmContinue("No applicable updates available") == false) {
	                ac_cancel();
	            } else {
	                _doc.getElementById("acqMsg1").innerHTML = "Acquiring " + (ac_content_index + 1)+ " of " + ac_content_count + " package bundle(s)";
	                _doc.getElementById("contentMeter").style.marginRight = formatData((1 - ac_content_index / ac_content_count) * 100) + "%";
	            }
	        }
	        return;
	    }

	    var downloaded = packages[currentUpdateIdIndex].getElementsByTagName("DOWNLOADSIZE")[0].childNodes[0].nodeValue;//kb
	    var downloadedValue = parseFloat(downloaded);
	    var strDownloaded = formatNumberWithComma(downloaded);

	    var size = packages[currentUpdateIdIndex].getElementsByTagName("SIZE")[0].childNodes[0].nodeValue;
	    var strSize = formatNumberWithComma(size);
	    var sizeValue = parseFloat(size);

	    var speed = packages[currentUpdateIdIndex].getElementsByTagName("DOWNLOADSPEED")[0].childNodes[0].nodeValue;		//KB/Sec
	    if (parseFloat(speed) > downloadedValue) {
	        speed = downloadedValue;
	    }
	    var strSpeed = formatNumberWithComma(speed);

	    //progress of contents...
	    if (ac_content_index < ac_content_count) {
	        _doc.getElementById("acqMsg1").innerHTML = "Acquiring " + (ac_content_index + 1) + " of " + ac_content_count + " package bundle(s)";
	        _doc.getElementById("contentMeter").style.marginRight = formatData((1 - ac_content_index / ac_content_count) * 100) + "%";
	    }
	    //progress of packages
	    if (packages.length != 0) {
	        var data;
	        if (sizeValue == 0) {
	            data = 100;
	        } else {
	            data = (1 - downloadedValue / sizeValue) * 100;
	        }
	        if (data < 0) {
	            data = 0;
	        } else if (data > 100) {
	            data = 100;
	        }
	        _doc.getElementById("meterValue").style.marginRight = formatData(data) + "%";
	        //display message as a description of content
	//        _doc.getElementById("acqMsg2").innerHTML = "Acquiring updates " + (currentUpdateIdIndex + 1) + " of " + packages.length
	//            + "<br/>" + strDownloaded + " of " + strSize + "KB"
	//            + " (" + strSpeed + "KB/Sec)";
	        _doc.getElementById("acqMsg2").innerHTML = "Acquiring updates: " + currentUpdateId
	            + "<br/>" + strDownloaded + " of " + strSize + "KB" + " (" + strSpeed + "KB/Sec)";
	    } else { //empty content
	        _doc.getElementById("meterValue").style.marginRight = "0%";
	        _doc.getElementById("acqMsg2").innerHTML = "Acquiring updates (0 of 0) - 100% complete.";
	    }
	    //gui_log("_updateProgress out");
	}

	function formatData(input) {
	    var per = input.toString();
	    if (parseFloat(input) < 0) {
	        per = 0;
	    } else if (per.indexOf(".") > 0) {
	        per = per.substring(0, per.indexOf(".") + 3);
	    }
	    return per;
	}

	//if downloads finished, execute this
	function complete(c, msg) {
	    switch (c) {
	    case 0:			//error when acquiring
	        _doc.getElementById("acqMsg").style.display = "none";
	        _doc.getElementById("noMsg").style.display = "block";
	        _doc.getElementById("noMsg2").innerHTML = "Error(s) occurs while downloading! <br>Error message: " + msg;
	        //stop the cli process if it's still running
	        // if (progressMainAppIsRunning) {
	        //     killApp_ux(top.mainAppName);
			// }
			// else 
			if(in_process_index != "") {
				updateTitle(in_process_index, "Error");
				var table = _doc.getElementById("table" + in_process_index);
				for(var j = 0,len = in_process_rows_index.length; j < len; ++j){
					table.rows[in_process_rows_index[j]].cells[3].title = "Error";
					table.rows[in_process_rows_index[j]].cells[3].innerHTML = "<img src='images/statusCritical_obj16.gif' alt='Critical Error'>Error";
				}
			}
			top.togglePrevious(true);
			$("#retryBtn").show();
	        break;
	    case 2:		   //error when creating bootable media
	        _doc.getElementById("createMsg").style.display = "none";
	        _doc.getElementById("noMsg").style.display = "block";
	        _doc.getElementById("noMsg2").innerHTML = "Error(s) occurs while creating the bootable media! <br>Error message: " + msg;
	        //stop the cli process if it's still running
	        if (progressMainAppIsRunning) {
	            killApp_ux(top.mainAppName);
	        }
	        top.togglePrevious(true);
	        break;
	    case 1:
	        //finish acquisition
	        _doc.getElementById("acqMsg").style.display = "none";
	        _doc.getElementById("createMsg").style.display = "block";
	        //ac_progress_timer2 = setInterval(showStatus_cr,1000);
			if(wrong > 0)
			{
				if(confirmContinue("some update files are missed  ")){
					gui_log("some update files are missed, and user still choose to continue.");
				} else {
					$("#retryBtn").show();
					return;
				}
			}
	        setTimeout(showStatus_cr,1000);
	        break;
	    case 9:
	        //finish creation
	        _doc.getElementById("createMsg").style.display = "none";
	        _doc.getElementById("cplMsg").style.display = "block";
	        //reporting the success message
	        if (top.usbKeyVolume != "" ) {
	            msg += "Please eject disk " + top.usbKeyVolume;
	        }
	        if (top.isoFile != "" ) {
	            msg += "The image file path is:" + top.isoFile;
	        }
	        if (top.pxeFile != "" ) {
	            msg += "The image file path is:" + top.pxeFile;
	        }
	        //_doc.getElementById("cplMsg2").innerHTML = ("The bootable media has been created successfully!<br>" + msg);

	        var length = 60;
	        var obj = _doc.getElementById("cplMsg2");
	        var strContent = msg;
	        var strTemp = "";

	        while (strContent.length> length) {
	            strTemp += strContent.substr(0,length)+"<br />";
	            strContent=strContent.substr(length, strContent.length);
	        }
	        strTemp	+= strContent;

	        _doc.getElementById("cplMsg2").innerHTML = ("The bootable media has been created successfully!<br>" + strTemp);
	        top.toggleNext(true);		//enable "next" button
			top.togglePrevious(true);
	        if (top.usbKeyVolume != "" ) {
				updateMediaProperty();
				last_usbKeyVolume = top.usbKeyVolume;
				document.getElementById("multiflashLable").innerHTML="If you want to create another bootable media with the same content, you must first eject the current media from drive {"+ last_usbKeyVolume +"}, insert another one then click the button <b>Create Again</b>. If the new media is assigned a different drive letter by Windows, you can choose another drive letter accordingly.";
	            $("#multiflash").show();
	        }
	        // boot_need_acq = false;
	        break;
	    }
	}

	function getCLIErrorCode() {
	    var cliErrorMsgFile;
		var errDom;
		if (!top.fileExists(top.cliErrorMsg)) {
			return;
		}

		cliErrorMsgFile = top.readTextFile(top.cliErrorMsg);

		if (cliErrorMsgFile) {
			errCode = 0;
			errDom = ezJsLib.XmlDom.parse(cliErrorMsgFile);
			errMsg = ezJsLib.XmlDom.getValueByTagFromNode("MESSAGE", errDom.documentElement);
			errCode = ezJsLib.XmlDom.getValueByTagFromNode("CODE", errDom.documentElement);
			stepSN = ezJsLib.XmlDom.getValueByTagFromNode("STEPSERIAL", errDom.documentElement);
		}
	}

	function showStatus_cr() {
	    getCLIErrorCode();
	    strDate = Date();
	    gui_log(strDate + " showStatus_cr in");
		gui_log("error code is ", errCode);
	    if (errCode >= 100 && errCode < 256 ) {
			if(errCode == 205) {
				if(!progressMainAppIsRunning) {
					complete(9, "");
				} else {
					setTimeout(showStatus_cr,1000);
				}
			}
	        //cli errors occurred
	        //clearInterval(ac_progress_timer2);		//stop the timer
	        complete(2, errMsg);
	        return;
	    } else if (errCode >= 10 && errCode < 100 ) {
	        //cli generated warning message
	        //currently we only handle the BOMCWARNING_FORMAT_USBKEY (value is 10) and BOMCWARNING_PROGRESS_INFO (value is 20) warning message
	        if (errCode == 10) {
	            if (userSelected == false) {
	                if (confirm("USB key needs formatting. This will erase all existing data on the key.  Are you sure you want to continue?")) {
	                    //user select to format the usb key
	                    userSelected = true;
	                    tmpFile = top.gl_ibm_support+ getOSCommand("tmpFile");
	                    if (!engineTop.secureFileExists(tmpFile)) {
	                        alert("Can't get temp file!");
	                    }
	                    var args = new Array();
	                    if (top.OSTYPE == "windows") {
	                        args.push(getStartingTopDir() + getNativeFileSeparator() + "..\\guiInput.bat");
	                    } else { //linux ...
	                        args.push(getStartingTopDir() + getNativeFileSeparator() + "../guiInput.sh");
	                    }
	                    args.push("yes");
	                    secureRunProgram(null, args, BACKGROUND, HIDDEN);
	                } else {
	                    userSelected = true;
	                    var args = new Array();
	                    if (top.OSTYPE == "windows") {
	                        args.push(getStartingTopDir() + getNativeFileSeparator() + "..\\guiInput.bat");
	                    } else { //linux ...
	                        args.push(getStartingTopDir() + getNativeFileSeparator() + "../guiInput.sh");
	                    }
	                    args.push("no");
	                    secureRunProgram(null, args, BACKGROUND, HIDDEN);
	                    //clearInterval(ac_progress_timer2);		//stop the timer
	                    complete(2, "Failed to format the USB Key.");
	                    return;
	                }
	            } else {
	                //ignore.
	            }
	        } else if (errCode == 20) {
	            //update the creation progress info
	            if (stepSN > overallSteps) {
	            	stepSN = overallSteps;
	            }
	            _doc.getElementById("createValue").style.marginRight = formatData((100 - (stepSN / overallSteps)*100)) + "%";
	            _doc.getElementById("createMsg3").innerHTML = errMsg + " - " + formatData((stepSN / overallSteps)*100) + "% complete...";
	        }
	    } else {

	        getCLIErrorCode();
	        if ((errCode== 0) && !progressMainAppIsRunning) {
	            //cli finished successfully
	            //clearInterval(ac_progress_timer2);		//stop the timer
	            complete(9, "");
	            return;
	        }
	    }
	    setTimeout(showStatus_cr,1000);
	}

	function open_no_uxsp_url() {
		var  sWidth  = 500;
	    var  sHeight = 200;
	    var  l = ( screen.availWidth - sWidth ) / 2;
	    var  t = ( screen.availHeight- sHeight) / 2;
	    var  style = 'resizable=no,toolbar=no,status=no,menubar=no,personalbar=no,location=no,directories=no,titlebar=no,scrollbars=no,close=yes,show=true';
	    var  loc   = ',left='+l+',top='+t+',width='+sWidth+',height='+sHeight;
	    // window.open(findFile(null, 'noUpdates.html'),  '', style+loc);
	    window.open("../bomc/content/no_uxsp_updates.html",  '', style+loc);
	}

	function open_no_indiv_url() {
		var  sWidth  = 500;
	    var  sHeight = 200;
	    var  l = ( screen.availWidth - sWidth ) / 2;
	    var  t = ( screen.availHeight- sHeight) / 2;
	    var  style = 'resizable=no,toolbar=no,status=no,menubar=no,personalbar=no,location=no,directories=no,titlebar=no,scrollbars=no,close=yes,show=true';
	    var  loc   = ',left='+l+',top='+t+',width='+sWidth+',height='+sHeight;
	    // window.open(findFile(null, 'noUpdates.html'),  '', style+loc);
	    window.open("../bomc/content/no_indiv_updates.html",  '', style+loc);
	}

	// function openNoUpdatesURL() {
	//     var  sWidth  = 500;
	//     var  sHeight = 200;
	//     var  l = ( screen.availWidth - sWidth ) / 2;
	//     var  t = ( screen.availHeight- sHeight) / 2;
	//     var  style = 'resizable=no,toolbar=no,status=no,menubar=no,personalbar=no,location=no,directories=no,titlebar=no,scrollbars=no,close=yes,show=true';
	//     var  loc   = ',left='+l+',top='+t+',width='+sWidth+',height='+sHeight;
	//     // window.open(findFile(null, 'noUpdates.html'),  '', style+loc);
	//     window.open("../bomc/content/noUpdates.html",  '', style+loc);
	// }

	function openNoRequisiteURL() {
	    var  sWidth  = 500;
	    var  sHeight = 200;
	    var  l = ( screen.availWidth - sWidth ) / 2;
	    var  t = ( screen.availHeight- sHeight) / 2;
	    var  style = 'resizable=no,toolbar=no,status=no,menubar=no,personalbar=no,location=no,directories=no,titlebar=no,scrollbars=no,close=yes,show=true';
	    var  loc   = ',left='+l+',top='+t+',width='+sWidth+',height='+sHeight;
	    // window.open(findFile(null, 'noRequisite.html'),  '', style+loc);
	    window.open("../bomc/content/noRequisite.html",  '', style+loc);
	}

	function openNoSEPsURL() {
	    var  sWidth  = 500;
	    var  sHeight = 200;
	    var  l = ( screen.availWidth - sWidth ) / 2;
	    var  t = ( screen.availHeight- sHeight) / 2;
	    var  style = 'resizable=no,toolbar=no,status=no,menubar=no,personalbar=no,location=no,directories=no,titlebar=no,scrollbars=no,close=yes,show=true';
	    var  loc   = ',left='+l+',top='+t+',width='+sWidth+',height='+sHeight;
	    // window.open(findFile(null, 'noSEPpkgAvailable.html'),  '', style+loc);
	    window.open("../bomc/content/noSEPpkgAvailable.html",  '', style+loc);
	}

	function openDownloadErrorURL() {
	    var  sWidth  = 500;
	    var  sHeight = 200;
	    var  l = ( screen.availWidth - sWidth ) / 2;
	    var  t = ( screen.availHeight- sHeight) / 2;
	    var  style = 'resizable=no,toolbar=no,status=no,menubar=no,personalbar=no,location=no,directories=no,titlebar=no,scrollbars=no,close=yes,show=true';
	    var  loc   = ',left='+l+',top='+t+',width='+sWidth+',height='+sHeight;
	    // window.open(findFile(null, 'DownloadError.html'),  '', style+loc);
	    window.open("../bomc/content/DownloadError.html",  '', style+loc);
	}
	/**
	 * update 'total' parameter in content title
	 */
	/*Style: 'resizable,toolbar,status,menubar,personalbar,location,directories,titlebar,close,scrollbars'*/
	function updateTotal(index, total) {
	    var  spans = _doc.getElementById(TITLE_PRE + index).getElementsByTagName("span");

	    if (total == 0) {
	        if ((index.indexOf("vmware esxi updates") != -1)) {
	            spans[0].innerHTML = "(No packages available)";
	        } else if (index.indexOf("tool") != -1) {
	            spans[0].innerHTML = "(No update packages required. <a href=\"javascript:void 0\" onclick=Progress.openNoSEPsURL()> Details...</a>)"
	        } else if (index.indexOf("requisite package") != -1) {
	            spans[0].innerHTML = "(No additional requisite required <a href=\"javascript:void 0\" onclick=Progress.openNoRequisiteURL()> Details...</a>)"
	        } else {
	            if (top.latest) {
	                spans[0].innerHTML = "(No applicable Individual Updates for this system! <a href=\"javascript:void 0\" onclick=Progress.open_no_indiv_url()> Details...</a>)";
	            } else {
	                spans[0].innerHTML = "(No applicable UXSP for this system! <a href=\"javascript:void 0\" onclick=Progress.open_no_uxsp_url()> Details...</a>)";
	            }
	        }
	    } else
	        spans[0].innerHTML = total + " update(s)";
	}

	function createJbodContent() {
		var mt = "Tool";
        var os = "Maintenance Mode OS(for Lenovo ThinkSystem and Lenovo System X)";
        var index = (mt + os).toLowerCase();
        ++ac_content_count;		
        createContent('', mt, os, index);
	}

	/**
	 * before any download begins, show all the waiting contents first.
	 */
	function createAllContents(isAcUXSP) {
		if (!top.acquireMode && top.acquireToolOnly) {
			// No add MT updates downloading or prereq downloading. Add by Wengmh1 2017/3/11
		} else {
			top.gl_selected_list.forEach(function(value, key){
				if(key.indexOf("ibm") == -1 && key.indexOf("lenovo") == -1) {
					var mt = key.substr(0,4);
					var os = key.substr(4);
					var type = "Updates";
					var index = (mt + unifyOS(os)).toLowerCase();
					createContent("", mt, type, index);
					++ac_content_count;
				}
			}) 
			if (top.ibm_requisite) {
				var mt = "IBM Requisite Package";
				var os = "IBM Requisite Package";
				var type = "Updates";
				var index = (mt + unifyOS(os)).toLowerCase();
				createContent("", mt, type, index);
				++ac_content_count;
			}
			if (top.lenovo_requisite) {
				var mt = "Lenovo Requisite Package";
				var os = "Lenovo Requisite Package";
				var type = "Updates";
				var index = (mt + unifyOS(os)).toLowerCase();
				createContent("", mt, type, index);
				++ac_content_count;
			}
		}

		// FilterTool();
	    for (var i = 0; i < ac_additional_index_array.length; i++) {
	        var mt = "Tool";
	        var os = ac_additional_index_array[i];
	        var index = (mt + os).toLowerCase();
	        createContent("", mt, os, index);
	        ++ac_content_count;
	    }
	}

	function isRunningCallback() {
		var propertiesInfo = new Array();
		if (!engineTop.secureFileExists(top.basicInfo)) 
		{
	        alert("Can't get basic info!");
	    }
	    engineTop.secureRead1PropertyFile(top.basicInfo, propertiesInfo, false);
	    if (propertiesInfo["IBM_SYSTEM_RUNNING"] == appName) 
	    {
	        progressMainAppIsRunning = true;
	    }
	    else
	    {
	    	progressMainAppIsRunning = false;
	    }
	}

	function isRunning(appName) 
	{
		var args = new Array();
	    args.push(getStartingTopDir() + getNativeFileSeparator() + top.guiHelper);
	    args.push("--isrunning");
	    args.push(appName);
	    args.push("--file");
	    args.push(top.bomc_gui);
	    secureRunProgram(null, args, BACKGROUND, HIDDEN, null, isRunningCallback);
	}

	/*
	function isRunning(appName) {
	    var args = new Array();
	    args.push(getStartingTopDir() + getNativeFileSeparator() + top.guiHelper);
	    args.push("--isrunning");
	    args.push(appName);
	    args.push("--file");
	    args.push(top.bomc_gui);
	    if (secureRunProgram(null, args, FOREGROUND, HIDDEN)) {
	        return false;
	    }

	    var propertiesInfo = new Array();
	    if (!engineTop.secureFileExists(securityCheck, top.basicInfo)) {
	        alert("Can't get basic info!");
	    }
	    engineTop.secureRead1PropertyFile(securityCheck, top.basicInfo, propertiesInfo, false);

	    if (propertiesInfo["IBM_SYSTEM_RUNNING"] == appName) {
	        return true;
	    }

	    return false;
	}
	*/

	function deleteFile_ux(file) {
	    var args = new Array();
	    args.push(getStartingTopDir() + getNativeFileSeparator() + top.guiHelper);
	    args.push("--delete");
	    args.push(file);
	    args.push("--file");
	    args.push(top.bomc_gui);
	    return secureRunProgram(null, args, FOREGROUND, HIDDEN);
	}

	/*
	 * 1234.56 -> 1,234.56
	 */
	function formatNumberWithComma(input) {
	    var str = "", value = input.toString();
	    var dotPos = value.indexOf(".");
	    var integer = dotPos > -1 ? value.substring(0, dotPos) : value;
	    var dicemal = dotPos > -1 ? value.substring(dotPos) : "";
	    var chars = top.trim(integer).split("");
	    for (var i = chars.length - 1; i > -1; i--) {
	        str = chars[i] + str;
	        if ( (chars.length - i) % 3 == 0 && i != 0) {
	            str = "," + str;
	        }
	    }
	    return str + dicemal;
	}

	/*
	 * extract from wizard.js-->previous, default case
	 */
	function commonPre() {
	    var navOrder = top.getWizardNavOrder();
	    var found = false;
	    for (var i = 0; i < navOrder.length; i++) {
	        if (navOrder[i] == top.navigationCurrent && i > 0) {
	            found = true;
	            top.navigateTo(navOrder[i-1]);
	            break;
	        }
	    }
	    if (!found) {
	        var allNavOrder = getNavOrder();
	        var found = false;
	        for (var i = 0; i < allNavOrder.length; i++) {
	            if (allNavOrder[i] == top.navigationCurrent && i > 0) {
	                top.navigateTo(allNavOrder[i-1]);
	                break;
	            }
	        }
	    }
	}

	/*
	 * leave current page and change the menu item status
	 * isReload -- refresh current page
	 * menuStyle -- set the menu's style class according to navigation.css
	 * only support 'previous' action now
	 */
	function leaveCurrentPage(action, isReload, menuStyle) {
	    var leavingMenu = top.navigationCurrent;
	    if (isReload) {
	        killApp_ux(top.gl_mainAppName);
	        window.location.reload();
	        top.toggleNext(false);
	    }
	    if (action == "previous") {
	        commonPre();
	    } else if (action == "next") {
	        //...
	    }
	    if (menuStyle)
	        top.setNavigationState(leavingMenu, menuStyle);
	}

	function progressPreviousAction() {
		if(top.acquireMode)
		{
			UpdateSelection.ac_cancel();
			top.toggleNext(false);
		}
		else
		{
			top.toggleNext(true);
		}
	}

	function showUSBKey()
	{
		var mtStr = top.usbKey;
		if (mtStr) 
		{
			var usbKeyVolume = document.getElementById("progress_usbKeyVolume");
			var ooption = new Array();
			var beginPos = 0;
			var lastPos = mtStr.indexOf(";");
			
			while(lastPos > 0)
			{
				ooption.push(mtStr.substr(0, lastPos));
				beginPos = lastPos + 1;
				mtStr = mtStr.slice(beginPos);
				lastPos = mtStr.indexOf(";");
			}	
			
			usbKeyVolume.options.length = 0;
			var i;
			for(i=0; i<ooption.length; ++i)
			{
				usbKeyVolume.options[i] = new Option(ooption[i], ooption[i]);
			}
			if (i > 0) {
				// default selected item
				usbKeyVolume.selectedIndex = --i;
			}
		}
	}

	function setWriteName()
	{
		var sel = document.getElementById("progress_usbKeyVolume");
		if ( sel.options.length != 0 )
		{
			top.usbKeyVolume = sel.options[sel.selectedIndex].value;
		}
	}

	function updateMediaProperty()
    {
		var args = new Array();
		args.push(getStartingTopDir() + getNativeFileSeparator() + top.guiHelper);
		args.push("--file");
		args.push(top.bomc_gui);
		if(!secureRunProgram(null, args, BACKGROUND, HIDDEN, null, updateCreateMedia))
		{
			updateCreateMedia();
		}
    }

	function updateCreateMedia()
	{
		var propertiesInfo = new Array();
		if (!engineTop.secureFileExists(top.basicInfo)) {
			alert("Can't get basic info!");
			return false;
		}
		engineTop.secureRead1PropertyFile(top.basicInfo, propertiesInfo, false);
		top.usbKey = propertiesInfo["IBM_SYSTEM_USBDISK"];
		var usbKeyVolume = document.getElementById("progress_usbKeyVolume");
		
		if (top.usbKeyVolume != "")
		{
			showUSBKey();
			for (i = 0; i < usbKeyVolume.options.length; ++i) {
				if (usbKeyVolume.options[i].text == top.usbKeyVolume) {
					usbKeyVolume.selectedIndex = i;
					break;
				}
			}
			if(i == usbKeyVolume.options.length)
			{
				setWriteName();
			}
		}
	}

	function selectUSBKey(theOption)
	{
		if (theOption == "undefined") {
	        alert('No device found');
	        return;
	    }
	    var theValue = theOption.text;
		top.usbKeyVolume = theValue;
		setWriteName();
	}

	function reFlash()
	{
		var args = new Array();
		args.push(getStartingTopDir() + getNativeFileSeparator() + top.guiHelper);
		args.push("--file");
		args.push(top.bomc_gui);
		secureRunProgram(null, args, BACKGROUND, HIDDEN, null, checkCreateMedia);
	}

	function checkCreateMedia()
	{
		var propertiesInfo = new Array();
		if (!engineTop.secureFileExists(top.basicInfo)) {
			alert("Can't get basic info!");
			return false;
		}
		engineTop.secureRead1PropertyFile(top.basicInfo, propertiesInfo, false);
		top.usbKey = propertiesInfo["IBM_SYSTEM_USBDISK"];

		var findDisk = false;
		var mtStr = top.usbKey;
		if (mtStr) 
		{
			var beginPos = 0;
			var lastPos = mtStr.indexOf(";");
			
			while(lastPos > 0)
			{
				if(top.usbKeyVolume == mtStr.substr(0, lastPos))
				{
					findDisk = true;
					break;
				}
				beginPos = lastPos + 1;
				mtStr = mtStr.slice(beginPos);
				lastPos = mtStr.indexOf(";");
			}
		}
		if(findDisk)
		{
			if(last_usbKeyVolume == top.usbKeyVolume
				||confirm("Are you sure to create the bootable media in another drive?"))
			{
				top.usbReFlash = true;
				progressInit();
				top.usbReFlash = false;
			}
		}
		else
		{
			alert("No media found in drive {" + top.usbKeyVolume + "}, insert a media to continue.");
		}
	}

	function waitInit()
	{
		top.acquireMode?makeCliContinue():progressInit();
	}

	function retry()
	{
		gui_log("Press the Retry button...");
		top.writeTextFile(top.CONFIRM_CONTINUE_FILE, "RETRY", false);
		ac_init();
	}

	
	function FilterTool()
	{
		var mediaTools = loadJsonFile("../../../../../media.json").tools;
		var folder_content_arr = top.get_folder_content(top.workingdirProgram);
		for(var pos = 0; pos < ac_additional_index_array.length; ++pos)
		{
			gui_log("ac_additional_index_array="+ac_additional_index_array[pos]);
			for(var i = 0; i < mediaTools.length; ++i)
			{
				// if find salie or elie, no need to download.
				if(mediaTools[i].name=="salie"&&ac_additional_index_array[pos]=="Maintenance Mode OS(for Lenovo ThinkSystem and Lenovo System X)")
				{
					for (var j = 0; j < folder_content_arr.length; ++j)
					{
						if((folder_content_arr[j].indexOf("lnvgy_utl_lxce_bomc") == 0) && (folder_content_arr[j].lastIndexOf(".zip") == folder_content_arr[j].length-4))
						{
							ac_additional_index_array.splice(pos,1);
							pos--;
							break;
						}
					}
				}

				// if find updatexpress, no need to download.
				folder_content_arr = top.get_folder_content(top.workingdirProgram + top.FILE_SEPARATOR +"update");
				if(mediaTools[i].name=="updatexpress"&&ac_additional_index_array[pos]=="UPDATE")
				{
					for (var j = 0; j < folder_content_arr.length; ++j)
					{
						if( (folder_content_arr[j].indexOf("lnvgy_utl_lxce_ux") == 0) && (folder_content_arr[j].lastIndexOf(".tgz") == folder_content_arr[j].length-4) )
						{
							ac_additional_index_array.splice(pos,1);
							pos--;
							break;
						}
					}
				}
			}
		}
	}

	return{
		name: "Progress",
        index: 0,
        header: header,
		openNoRequisiteURL: openNoRequisiteURL,
		ac_cancel: ac_cancel,
		openNoSEPsURL: openNoSEPsURL,
		// openNoUpdatesURL: openNoUpdatesURL,
		open_no_uxsp_url: open_no_uxsp_url,
		open_no_indiv_url: open_no_indiv_url,
		beginAcq: beginAcq,
		init: waitInit, 
		selectUSBKey: selectUSBKey,
		updateMediaProperty : updateMediaProperty,
		reFlash: reFlash,
		retry: retry,
        nextAction: function() { return true; },
        previousAction: progressPreviousAction,
        importId: '#import_progress',
        selectorId: '.progress',
        title: "Progress" 
	}
}();
