// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
var UnattendedConfiguration = function() 
{
	var serverIPValid = false;
	var directoryValid = false;
	var usernameValid = false;
	var passwordValid = false;

	function unattendedConfiguration_init() 
	{
		UpdateUnattendedConfig();
	}

	function unattendedChooseDirectory() 
	{
		$("#unattendedSaveToDirectory").click();
	}

	function unattendedSaveDirectory() 
	{
		var folder = $("#unattendedSaveToDirectory").val();
		$("#DirectoryText").attr("value", folder);
		UnattdConfig.SetUnattdDir(folder);
	}

	function UpdateUnattendedConfig()
	{
		var LocationType = document.getElementById("LocationType");
		var LocationTypeIndex = LocationType.selectedIndex;
		LocationType.options.length = 0;
		LocationType.options[0] = new Option("TFTP Server", "TFTP");
		LocationType.options[1] = new Option("FTP Server", "FTP");
		LocationType.options[2] = new Option("NFS Share", "NFS");
		LocationType.options[3] = new Option("SAMBA Server", "SAMBA");
		LocationType.options[4] = new Option("USB Drive", "USB");
		if(top.selectedOSMachineType.indexOf("ibm") == -1)
		{
			LocationType.options[5] = new Option("SFTP Server", "SFTP");
		}
		if(top.configTag["IBM_SYSTEM_UNATTENDED"] == "1") 
		{
			//get unattended configuration
			//if (false == UnattdConfig.UpdateUnattdCfgFromFullStr(UnattdModeType.UNATTENDED_SMB, "/mytest", "9.125.90.222"))
	        if (false == UnattdConfig.UpdateUnattdCfgFromFullStr(top.strUnattdCfgFullStr))
			{
				//invalid value in the config file
				top.strUnattdCfgFullStr = "NULL";
				configTag["IBM_SYSTEM_UNATTENDED"] = "";
				alert("Invalid configuration specified for unattended mode support in the configuration file!");
				return;
			}
			//alert(UnattdConfig.GetUnattdModeType());
        	if ((UnattdConfig.GetUnattdModeType() == UnattdModeType.UNATTENDED_NULL) && (UnattdConfig.GetUnattdModeType() == UnattdModeType.UNATTENDED_INVALID)) 
        	{
        		//unattended mode disabled
        		EnableContents(false);
        	}
        	else
        	{
        		//unattended mode enabled
        		EnableContents(true);

				document.getElementById("DirectoryText").value = UnattdConfig.GetUnattdDir();
				SetDirectory(UnattdConfig.GetUnattdDir());

				var LocationType=document.getElementById("LocationType");

				var strValue = "";
				switch (UnattdConfig.GetUnattdModeType())
				{
					case UnattdModeType.UNATTENDED_TFTP:
						LocationType.selectedIndex = 0;
						break;
					case UnattdModeType.UNATTENDED_FTP:
						LocationType.selectedIndex = 1;
						break;
					case UnattdModeType.UNATTENDED_NFS:
						LocationType.selectedIndex = 2;
						break;
					case UnattdModeType.UNATTENDED_SMB:
						LocationType.selectedIndex = 3;
						break;
					case UnattdModeType.UNATTENDED_USB:
						LocationType.selectedIndex = 4;
						break;
					case UnattdModeType.UNATTENDED_SFTP:
						LocationType.selectedIndex = 5;
						break;
					default:
						LocationType.selectedIndex = 0;
						break;
				}
				SelectLocation(LocationType.options[LocationType.selectedIndex].value);
				
	    		if (LocationType.options[LocationType.selectedIndex].value != "USB")
	    		{
	    			ShowSeverAdd(true);
	    			var tempServerAddr = UnattdConfig.GetUnattdServer();
	    			tempServerAddr = tempServerAddr.replace("[","");
	    			tempServerAddr = tempServerAddr.replace("]","");	
	    			document.getElementById("SeverAddText").value = tempServerAddr;
					SetServer(tempServerAddr);
					document.getElementById("checkRebootBmc").checked = top.isRebootBmc;
					switch(top.after_updating_firmware) {
						case "Shutdown":
							document.getElementById("afterUpdatingFirmwareSelect").selectedIndex = 0;
							break;
						case "Noaction":
							document.getElementById("afterUpdatingFirmwareSelect").selectedIndex = 1;
							break;
						case "Reboot":
							document.getElementById("afterUpdatingFirmwareSelect").selectedIndex = 2;
							break;
						default:
							document.getElementById("afterUpdatingFirmwareSelect").selectedIndex = 0;
							break;
					}
					document.getElementById("checkUser").checked = top.strUnattdUseUserName;
					showUserName();
					if(document.getElementById("checkUser").checked)
					{
						document.getElementById("UesrNameText").value = UnattdConfig.GetUnattdUserName();
					}
	    		}
	    		else
	    		{
	    			ShowSeverAdd(false);
	    		}
        	}
			top.configTag["IBM_SYSTEM_UNATTENDED"] = "";
		}
		else
		{
			if(LocationTypeIndex < LocationType.options.length)
			{
				LocationType.selectedIndex = LocationTypeIndex;
			}
			SelectLocation(LocationType.options[LocationType.selectedIndex].value);
			//no unattended config info got
			if(document.getElementById("disUnattended").checked)
			{
		   		EnableContents(false);
			}
	  	}
		if(top.selectedOSMachineType.indexOf("ibm") != -1)
		{
			document.getElementById("checkRebootBmc").checked = true;
			$("#RebootDiv").hide();
			document.getElementById("afterUpdatingFirmwareSelect").selectedIndex = 0;
			$("#AfterUpdatingFirmwareDiv").hide();
		}
		else
		{
			$("#RebootDiv").show();
			$("#AfterUpdatingFirmwareDiv").show();
		}
	}

	function EnableContents(status)
	{
		if (status == true)
		{
			document.getElementById("enUnattended").checked = true;
			document.getElementById("disUnattended").checked = false;

			document.getElementById("enUnattendedDiv").disabled = false;
			$("#enUnattendedDiv").show();
			document.getElementById("LocationListTable").disabled= false;
			$("#LocationListTable").show();
			document.getElementById("DirectoryDiv").disabled= false;
			$("#DirectoryDiv").show();
			document.getElementById("LocationType").disabled= false;
			$("#LocationType").show();
			document.getElementById("SeverAddText").disabled= false;
			$("#SeverAddText").show();
			// document.getElementById("checkRebootBmc").disabled= false;
			document.getElementById("afterUpdatingFirmwareSelect").disabled= false;
			$("#afterUpdatingFirmwareSelect").show();
			document.getElementById("DirectoryText").disabled= false;
			$("#DirectoryText").show();
			document.getElementById("checkUser").disabled= false;
			$("#checkUser").show();
			document.getElementById("UesrNameText").disabled= false;
			$("#UesrNameText").show();
			document.getElementById("PasswordText").disabled= false;
			$("#PasswordText").show();
		}
		else
		{
			document.getElementById("enUnattended").checked = false;
			document.getElementById("disUnattended").checked = true;

			document.getElementById("enUnattendedDiv").disabled = true;
			$("#enUnattendedDiv").hide();
			document.getElementById("LocationListTable").disabled= true;
			$("#LocationListTable").hide();
			document.getElementById("DirectoryDiv").disabled= true;
			$("#DirectoryDiv").hide();
			document.getElementById("LocationType").disabled= true;
			$("#LocationType").hide();
			document.getElementById("SeverAddText").disabled= true;
			$("#SeverAddText").hide();
			// document.getElementById("checkRebootBmc").disabled= true;
			document.getElementById("afterUpdatingFirmwareSelect").disabled= true;
			$("#afterUpdatingFirmwareSelect").hide();
			document.getElementById("DirectoryText").disabled= true;
			$("#DirectoryText").hide();
			document.getElementById("checkUser").disabled= true;
			$("#checkUser").hide();
			document.getElementById("UesrNameText").disabled= true;
			$("#UesrNameText").hide();
			document.getElementById("PasswordText").disabled= true;
			$("#PasswordText").hide();
		}
	}


	function EnableUnattended(status)
	{
		if(status == true)
		{
			//enable the content for unattended support

			EnableContents(true);

			var obj = document.getElementById("SeverAddText");

			if (obj && obj.value && (obj.value.replace(/ /g, '') != "" ) ) 
			{
				UnattdConfig.SetUnattdServer(obj.value.replace(/ /g, ''));
			}
			else 
			{
				UnattdConfig.SetUnattdServer("NULL");
			}

			var obj = document.getElementById("DirectoryText");
			if (obj && obj.value && (obj.value.replace(/ /g, '') != "" ) ) 
			{
				UnattdConfig.SetUnattdDir(obj.value.replace(/ /g, ''));
			}
			else 
			{
				UnattdConfig.SetUnattdDir("NULL");
			}

			switch (UnattdConfig.GetUnattdModeType())
			{
				case UnattdModeType.UNATTENDED_TFTP:
				LocationType.selectedIndex = 0;
				break;
				case UnattdModeType.UNATTENDED_FTP:
				LocationType.selectedIndex = 1;
				break;
				case UnattdModeType.UNATTENDED_NFS:
				LocationType.selectedIndex = 2;
				break;
				case UnattdModeType.UNATTENDED_SMB:
				LocationType.selectedIndex = 3;
				break;
				case UnattdModeType.UNATTENDED_USB:
				LocationType.selectedIndex = 4;
				break;
				case UnattdModeType.UNATTENDED_SFTP:
				LocationType.selectedIndex = 5;
				break;
				default:
				LocationType.selectedIndex = 0;
				UnattdConfig.SetUnattdModeType(UnattdModeType.UNATTENDED_TFTP);
				break;
			}
			SelectLocation(LocationType.options[LocationType.selectedIndex].value);

		}
		else
		{
		//disable the content for unattended support
		top.strUnattdCfgFullStr = null;
		top.strUnattdCfgFullStr_tmp = null;
		EnableContents(false);
		}
	}

	function SelectLocation(theValue)
	{
		var enableServer = false;

		switch (theValue)
		{
			case "TFTP":
					UnattdConfig.SetUnattdModeType(UnattdModeType.UNATTENDED_TFTP);
					enableServer = true;
					document.getElementById("checkUser").checked = false;
					showUserName();
					$("#checkUserName").hide();
					document.getElementById("checkUser").disabled = false;
					break;
			case "SFTP":
					UnattdConfig.SetUnattdModeType(UnattdModeType.UNATTENDED_SFTP);
					enableServer = true;
					document.getElementById("checkUser").checked = true;
					showUserName();
					$("#checkUserName").show();
					document.getElementById("checkUser").disabled = true;
					break;
			case "FTP":
					UnattdConfig.SetUnattdModeType(UnattdModeType.UNATTENDED_FTP);
					enableServer = true;
					document.getElementById("checkUser").checked = false;
					showUserName();
					$("#checkUserName").show();
					document.getElementById("checkUser").disabled = false;
					break;
			case "NFS":
					UnattdConfig.SetUnattdModeType(UnattdModeType.UNATTENDED_NFS);
					enableServer = true;
					document.getElementById("checkUser").checked = false;
					showUserName();
					$("#checkUserName").hide();
					document.getElementById("checkUser").disabled = false;
					break;
			case "SAMBA":
					UnattdConfig.SetUnattdModeType(UnattdModeType.UNATTENDED_SMB);
					enableServer = true;
					document.getElementById("checkUser").checked = false;
					showUserName();
					$("#checkUserName").show();
					document.getElementById("checkUser").disabled = false;
					break;
			case "USB":
					UnattdConfig.SetUnattdModeType(UnattdModeType.UNATTENDED_USB);
					enableServer = false;
					document.getElementById("checkUser").checked = false;
					showUserName();
					$("#checkUserName").hide();
					document.getElementById("checkUser").disabled = false;
					break;
			default:
					enableServer = false;
					break;
		}

		if(top.selectedOSMachineType.indexOf("ibm") != -1)
		{
			document.getElementById("checkUser").checked = false;
			showUserName();
			$("#checkUserName").hide();
		}
		
		ShowSeverAdd(enableServer);
	}

	function ShowSeverAdd(status)
	{
		document.getElementById("SeverAddTag").style.display=(status == true)? "block" : "none" ;
		document.getElementById("SeverAddText").style.display=(status == true)? "block" : "none" ;
	}

	function SetServer(strSvr) {
		var is_ipv4 = strSvr.match(ipv4_pattern);
		var is_ipv6 = strSvr.match(ipv6_pattern);
		if (strSvr == "" || strSvr == null || strSvr == undefined) {
			serverIPValid = false;
		} else if (is_ipv4 == null && is_ipv6 == null) {
			serverIPValid = false;
		} else {
			if(is_ipv6!=null && strSvr.indexOf(":")>-1 && UnattdConfig.GetUnattdModeType()==UnattdModeType.UNATTENDED_NFS)
				strSvr = "[" + strSvr + "]";
			UnattdConfig.SetUnattdServer(strSvr);
			serverIPValid = true;
		}
	}

	function SetDirectory(strDir)
	{
		if (strDir == "" || strDir == null || strDir == undefined)
		{
			directoryValid = false;
		} else {
			directoryValid = true;
			UnattdConfig.SetUnattdDir(strDir);
		}
	}

	function SetUesrName(strUserName)
	{
		if (strUserName == "" || strUserName == null || strUserName == undefined)
		{
			usernameValid = false;
		} else {
			usernameValid = true;
			UnattdConfig.SetUnattdUserName(strUserName);
		}
	}

	function SetPassword(strPassword)
	{
		if (strPassword == "" || strPassword == null || strPassword == undefined)
		{
			passwordValid = false;
		} else {
			var flg = true;
			// Use BMC password format as a standard.
			var pwd_reg = /[a-zA-Z0-9~`!@#$%^&*()\-+={}\[\]|:;'"<>,?\/._]/;
			for (var i = 0; i < strPassword.length; ++i)
			{
				if ((flg = pwd_reg.test(strPassword[i])) == false)
				{
					break;
				}
			}
			passwordValid = flg;
			if(passwordValid)
			{
				UnattdConfig.SetUnattdPassword(strPassword);
			}
		}
	}

    function ClickRebootBmc() {
    	if ($("#checkRebootBmc").prop("checked")) {
    		top.isRebootBmc = true;
    	} else {
    		top.isRebootBmc = false;
    	}
    }

    function showUserName() {
    	if ($("#checkUser").prop("checked")) {
    		top.strUnattdUseUserName = true;
    		$("#UserListTable").show();
    	} else {
    		top.strUnattdUseUserName = false;
    		$("#UserListTable").hide();
    	}
	}
	
	function afterUpdatingFirmware(theValue)
	{
		top.after_updating_firmware = theValue;
	}

	function checkUnattendedConfig() {
		if (document.getElementById("enUnattended").checked) {
			var locationType = $("#LocationType");
			if (locationType.val() == "USB") {
				if (directoryValid == false) {
					alert("Please input directory.");
					return false;
				} else {
					top.strUnattdCfgFullStr = UnattdConfig.generateFullStrFromUnattdCfg();
					top.strUnattdCfgFullStr_tmp = top.strUnattdCfgFullStr;
					if(top.strUnattdUseUserName)
					{
						top.strUnattdCfgPassword = UnattdConfig.GetUnattdPassword();
					}
					return true;
				}
			} else {
				if (directoryValid == false && serverIPValid == false) {
					alert("Please input valid value for Server Address and Directory.");
					return false;
				} else if (directoryValid == true && serverIPValid == false) {
					alert("Please input valid Server Address.");
					return false;
				} else if (directoryValid == false && serverIPValid == true) {
					alert("Please input Directory.");
					return false;
				} else if(top.strUnattdUseUserName && passwordValid == false){
					alert("Please input correct password format.");
					return false;
				} else {
					top.strUnattdCfgFullStr = UnattdConfig.generateFullStrFromUnattdCfg();
					top.strUnattdCfgFullStr_tmp = top.strUnattdCfgFullStr;
					if(top.strUnattdUseUserName)
					{
						top.strUnattdCfgPassword = UnattdConfig.GetUnattdPassword();
					}
					return true;
				}
			}
		} else {
			return true;
		}
	}

	/*
	function CheckUnattendedConfig()
	{
	  	if ( document.getElementById("enUnattended").checked)
	  	{
			var bInvalidInput = false;
			var strErrMsg = "";

			var x=document.getElementById("LocationType");
			if (x.options[x.selectedIndex].value == "USB")
			{
				if (UnattdConfig.GetUnattdDir() == "NULL" || UnattdConfig.GetUnattdDir() == "")
				{
					if(document.getElementById("DirectoryText").value!="")
					{
						bInvalidInput = false;
					}
					else
					{
						bInvalidInput = true;
						strErrMsg = "Please set the Directory!"
					}
				}
				else
				{
					bInvalidInput = false;
				}
			}
			else
			{
				if (UnattdConfig.GetUnattdDir() == "NULL" || UnattdConfig.GetUnattdDir() == "" || UnattdConfig.GetUnattdServer() == "NULL" || UnattdConfig.GetUnattdServer() == "")
				{
					if(document.getElementById("DirectoryText").value!="")
					{
						bInvalidInput = false;
					}
					else
					{
						bInvalidInput = true;
						strErrMsg = "Please set both the Directory and Server Address!"
					}
				}
				else
				{
					bInvalidInput = false;
				}
			}

			if (bInvalidInput)
			{
				alert (strErrMsg);
			}
			else
			{
				//alert(UnattdConfig.GetUnattdModeType());
				top.strUnattdCfgFullStr = UnattdConfig.generateFullStrFromUnattdCfg();
				top.strUnattdCfgFullStr_tmp = top.strUnattdCfgFullStr;
				return true;
			}
		}
	   	else
		{
			return true;
		}
	}	
	*/

	return {
		name: "UnattendedConfiguration",
        index: 0,
        init: unattendedConfiguration_init,
        EnableUnattended: EnableUnattended,
        SelectLocation: SelectLocation,
        SetServer: SetServer,
		SetDirectory: SetDirectory,
		SetUesrName: SetUesrName,
		SetPassword: SetPassword,
		ClickRebootBmc: ClickRebootBmc,
		showUserName: showUserName,
		afterUpdatingFirmware: afterUpdatingFirmware,
        nextAction: checkUnattendedConfig,
        unattendedChooseDirectory: unattendedChooseDirectory,
        unattendedSaveDirectory: unattendedSaveDirectory,
        importId: '#import_unattendedConfiguration',
        selectorId: '.unattendedConfiguration',
        title: "Unattended Mode" 
	}
}();