// Copyright © 2022 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
const {app, BrowserWindow, ipcRenderer, dialog} = require('electron');
const path = require('path');
const url = require('url');
const ipcMain = require('electron').ipcMain;
const Menu = require('electron').Menu;
const os = require('os');
const fs = require('fs');
const process = require('process');
const readline = require('node:readline')
const gl_base_path = path.dirname(process.execPath);
// const gl_base_path = "D:\\code\\bomc-red\\bomc_dir\\build\\out\\windows_x64_Release\\imagefull\\gui"
var gl_support_dir;
if(os.type().toLowerCase().indexOf("windows") >= 0)
    gl_support_dir = path.join("C:\\", "Lenovo_Support")
else
    gl_support_dir = path.join("\/var\/log\/", "Lenovo_Support")
const gl_app_base_path = path.join(__dirname, '..');
const gl_workingDir = gl_app_base_path + "/workingdir";

const logStream = function initLog() {
    if (!fs.existsSync(gl_support_dir)) {
        fs.mkdirSync(gl_support_dir)
    }
    var date = new Date();
    var month = date.getMonth() + 1 < 10 ? "0" + (date.getMonth() + 1) : date.getMonth() + 1;
    var strDate = date.getDate() < 10 ? "0" + date.getDate() : date.getDate();
    var strHour = date.getHours() < 10 ? "0" + date.getHours() : date.getHours();
    var strMinute = date.getMinutes() < 10 ? "0" + date.getMinutes() : date.getMinutes();
    var strSecond = date.getSeconds() < 10 ? "0" + date.getSeconds() : date.getSeconds();
    var curDate = "" + date.getFullYear() + month + strDate + strHour + strMinute + strSecond;
    var logPath = path.join(gl_support_dir, "BoMC_" + curDate + ".log");
    const lf = fs.createWriteStream(logPath, { flags: 'a' });
    lf.write(logPath + "\n");
    return lf;
}();


Utils = {
    printLog: function (level, caller, msg) {
        const getNowFormatDate = function () {
            var date = new Date();
            var seperator1 = "-";
            var seperator2 = ":";
            var month = date.getMonth() + 1 < 10 ? "0" + (date.getMonth() + 1) : date.getMonth() + 1;
            var strDate = date.getDate() < 10 ? "0" + date.getDate() : date.getDate();
            var strHour = date.getHours() < 10 ? "0" + date.getHours() : date.getHours();
            var strMinute = date.getMinutes() < 10 ? "0" + date.getMinutes() : date.getMinutes();
            var strSecond = date.getSeconds() < 10 ? "0" + date.getSeconds() : date.getSeconds();

            var currentdate = date.getFullYear() + seperator1 + month + seperator1 + strDate
                + " " + strHour + seperator2 + strMinute + seperator2 + strSecond;
            return currentdate;
        };
        logStream.write(getNowFormatDate() + " [" + level + "]" + caller + msg + "\n");
    },
    join: function (...args) {
        return path.join(...args);
    },
    get_folder_content: function (dirpath) {
        if (!fs.existsSync(dirpath)) return new Array(0);
        var folder_content_arr = fs.readdirSync(dirpath);
        return folder_content_arr;
    },
    createDirectory: function (dirpath) {
        try {
            if (fs.existsSync(dirpath) && (fs.statSync(dirpath).isDirectory())) {
                return false;
            } else {
                if (!fs.mkdirSync(dirpath, { recursive: true })) {
                    return false;
                }
                return true;
            }
        } catch (e) {
            console.log(e, arguments);
            return false;
        }
    },
    fileExists: function (filepath) {
        return fs.existsSync(filepath);
    },
    isDirectory: function (directoryName) {
        try {
            return (fs.existsSync(directoryName) && (fs.statSync(directoryName).isDirectory()));
        } catch (e) {
            console.log(e, arguments);
            return false;
        }
    },
    deleteFile: function (file) {
        if (fs.existsSync(file)) {
            fs.unlinkSync(file);
        }
        return true;
    },
    secureGetDirectories: function (dir) {
        try {
            fs.accessSync(dir);
        } catch (e) {
            return [];
        }
        return fs.readdirSync(dir).filter(function(file) {
            return fs.statSync(dir + file).isDirectory();
        });
    },
    secureGetFiles: function (dir) {
        try {
            fs.accessSync(dir);
        } catch (e) {
            return [];
        }
        return fs.readdirSync(dir).filter(function(file) {
            return !(fs.statSync(dir + file).isDirectory());
        });
    },
    secureGetEnv: function (anyvar) {
        try {
            Utils.printLog("secureGetEnv: ", anyvar);
            return process.env[anyvar];
        } catch(e) { console.log(e,arguments); Utils.printLog(e.message);}
        return null;
    },
    secureSetEnv: function (anyvar, value) {
        try {
            Utils.printLog("secureSetEnv: ", anyvar, value);
            process.env[anyvar] = value;
        } catch(e) { console.log(e.message);}
    },
    directoryExists: function (directory) {
        return fs.existsSync(directory);
    },
    del_dir: function (dir_path) {
        if (directoryExists(dir_path)) {
            fs.rmdirSync(dir_path);
        }
    },
    // read an external file
    // fileName: string - full native file name or URL
    // returns: string - contents of file if readable, null otherwise
    readTextFile: function (fileName) {
        if (fileName == null || !fs.existsSync(fileName))
		    return null;
	    return fs.readFileSync(fileName, 'utf8');
    },
    // write a text file
    // fileName: string - full native file name
    // text:  string - content of text file
    // append: boolean - true = append text to end of file,  false = overwrite existing file
    // returns: true if file was written successfully, false otherwise
    writeTextFile: function (fileName, fileContent, append) {
        Utils.printLog("writeTextFile", fileName);
        if (!fileContent) {
            Utils.printLog("No fileContent.");
            return false;
        }
        if (append && fs.existsSync(fileName)) {
            fs.appendFileSync(fileName, fileContent);
        } else {
            fs.writeFileSync(fileName, fileContent);
        }
        return true;
    },
    statSync: function (fileName) {
        return fs.statSync(fileName);
    },
    dirname: function (filepath) {
        return path.dirname(filepath);
    },
    basePath: () => {
        return gl_base_path;
    },
    appBasePath: () => {
        return gl_app_base_path;
    },
    WorkingDirPath: () => {
        return gl_workingDir;
    },
    getSupportDir: function () {
        return gl_support_dir;
    },
    createReadStream: function (fileName) {
        return fs.createReadStream(fileName);
    },
    getGenericOSType: function () {
        var osName = os.type().toLowerCase();
        if (osName.indexOf("windows") >= 0) {
            return "windows";
        }
        return "unix";
    },
    getOSType: function () {
        return os.type();
    },
    getOS: function () {
        return  os.type() + " " +  os.release();
    },
    getArch: function () {
        return os.arch();
    },
    getNativeFileName: function (fullPath) {
        try {
            var i;
            var j;
            if (os.type().toLowerCase().indexOf("windows") >= 0) {
                do {
                    i = fullPath.indexOf("/");
                    if (i >= 0) fullPath = fullPath.substring(0,i)+"\\"+fullPath.substring(i+1);
                } while (i >= 0);
                if (fullPath.indexOf(":\\") > 0)
                    while (fullPath.charAt(0) == "\\")
                        fullPath = fullPath.substring(1);
                do {
                    i = fullPath.indexOf("\\.\\");
                    if (i > 0) fullPath = fullPath.substring(0,i)+fullPath.substring(i+2);
                } while (i > 0);
                do {
                    i = fullPath.indexOf("\\\\",1); // skip position 0 to allow for UNC paths
                    if (i > 0) fullPath = fullPath.substring(0,i)+fullPath.substring(i+1);
                } while (i > 0);
                do {
                    j = -1;
                    i = fullPath.indexOf("\\..\\");
                    if (i > 0) {
                        j = fullPath.lastIndexOf("\\",i-1);
                        if (j >= 0) fullPath = fullPath.substring(0,j)+fullPath.substring(i+3);
                    }
                } while (i > 0 && j >= 0);
            }
            else {
                do {
                    i = fullPath.indexOf("\\");
                    if (i >= 0) fullPath = fullPath.substring(0,i)+"/"+fullPath.substring(i+1);
                } while (i >= 0);
                do {
                    i = fullPath.indexOf("/./");
                    if (i > 0) fullPath = fullPath.substring(0,i)+fullPath.substring(i+2);
                } while (i > 0);
                do {
                    i = fullPath.indexOf("//");
                    if (i > 0) fullPath = fullPath.substring(0,i)+fullPath.substring(i+1);
                } while (i > 0);
                do {
                    j = -1;
                    i = fullPath.indexOf("/../");
                    if (i > 0) {
                        j = fullPath.lastIndexOf("/",i-1);
                        if (j >= 0) fullPath = fullPath.substring(0,j)+fullPath.substring(i+3);
                    }
                } while (i > 0 && j >= 0);
            }
            Utils.printLog("INFO", "getNativeFileName value is ", fullPath);
            return fullPath;
        } catch(e) { console.log(e,arguments); }
        return "undefined";
    },
    getFullFileName: function (topDir,fileName) {
        try {
            if (fileName == null || fileName.length == 0) return null;
            var fullPath;
            if ( (os.type().toLowerCase().indexOf("windows") >= 0) && fileName.length > 2 && fileName.charAt(1) == ":") return Utils.getNativeFileName(fileName);
            else if (typeof topDir == "string" && topDir.length > 0 && fileName.charAt(0) != "/" && fileName.charAt(0) != "\\") {
                var c = topDir.charAt(topDir.length-1);
                if (c != '/' && c != '\\') topDir = topDir + '/';
                fullPath = topDir + fileName;
            }
            else fullPath = fileName;
            return Utils.getNativeFileName(fullPath);
        } catch(e) { console.log(e,arguments); Utils.printLog(e,arguments); }
        return "undefined";
    },
    loadJsonFile: function (fileName) {
        const settingFile = path.join(__dirname, "../", fileName);
        if (!fs.existsSync(settingFile)) {
            return {}
        }
        return JSON.parse(fs.readFileSync(settingFile).toString());
    },
    openExternal: function (link) {
        require('electron').shell.openExternal(link);
    },
    showItemInFolder: function (configFile) {
        require("electron").shell.showItemInFolder(configFile);
    },
    getStream: function () {
        return require("stream");
    },
    getTmpDir: function () {
        return os.tmpdir();
    }
};

function runProgram(event, args, callback) {
    Utils.printLog("runProgram", args);
    process.env["LD_PRELOAD"] = "";
    var topDir = gl_base_path;
    args[0] = Utils.getFullFileName(topDir, args[0]);
    var cmd = args[0];
    args.shift();
    var execFileSync = require('child_process').execFileSync;
    if (callback) {
        execFileSync(cmd, args, function(error, stdout, stderr) {
            if (error) {
                console.log(error.code, error);
                Utils.printLog('stderr: ', stderr);
                Utils.printLog('exec error: ' + error);
                event.sender(callback, false, error, stdout, stderr);
                return error.code;
            }
            Utils.printLog('stdout: ' + stdout);
            event.sender.send(callback, true, error, stdout, stderr);
            return 0;
        });
    } else {
        execFileSync(cmd, args, function(error, stdouot, stderr) {
            if (error) {
                console.log(error.code, error);
                Utils.printLog('stderr: ', stderr);
                Utils.printLog('exec error: ' + error);
                return error.code;
            }
            Utils.printLog('stdout: ' + stdout);
            return 0;
        });
    }
}

function secureRunProgram(event, topDir, args, foreGroundValue, isHidden, workingDirectory, callback) {
    Utils.printLog("INFO", "Enter utils secureRunProgram");
    process.env["LD_PRELOAD"] = "";
    // set syncFlag to false
    syncFlag = false;
    args[0] = Utils.getFullFileName(topDir, args[0]);
    var cmd = args[0];
    args.shift();
    Utils.printLog("INFO", "cmd is " + cmd);
    Utils.printLog("INFO", args);
    
    var execFile = require('child_process').execFile;

    if (foreGroundValue == false) {
        if (callback) {
            var retStdout = execFile(cmd, args, function(error, stdout, stderr) {
                if (error) {
                    event.sender.send(callback, false, error, stdout, stderr); //execute callback function here
                    return error.code;
                }
                event.sender.send(callback, true, error, stdout, stderr);
                
            });
            
            retStdout.stdout.on('data', (data) => {Utils.printLog("DEBUG", data.toString());});
            retStdout.stderr.on('data', (data) => {Utils.printLog("DEBUG", data.toString());});
            return 0;
        } else {
            var retStdout = execFile(cmd, args, function(error, stdout, stderr) {
                if (error) {
                    return error.code;
                }
                
            });
            retStdout.stdout.on('data', (data) => {Utils.printLog("DEBUG", data.toString());});
            retStdout.stderr.on('data', (data) => {Utils.printLog("DEBUG", data.toString());});
            return 0;
        }
    } else { //FOREGROUND
        var retStdout = execFile(cmd, args, function(error, stdout, stderr) {
            if (error) 
            {
                return error.code;
            }
            syncFlag = true;
        });
        retStdout.stdout.on('data', (data) => {Utils.printLog("DEBUG", data.toString());});
        retStdout.stderr.on('data', (data) => {Utils.printLog("DEBUG", data.toString());});
        return retStdout;
    }
}

function rewrite_compare_result(event, callback, compare_rewrite_xml, compare_xml, selected_list) {
    const unifyOS = function (os) {
        if(os == null)
            return null;

        var o = os.toLowerCase();
        //o = o.replace(" ", "");
        if(o.indexOf("windows") > -1)
            return "windows";
        if(o.indexOf("aix") > -1){
            return "aix";
        }
        if(o.indexOf("vmware") > -1){
            return "vmware";
        }
        return o;
    }
    Utils.printLog("INFO", "Enter rewrite_compare_result");
    var mt = "";
    var os = "";
    var index = "";
    if (fs.existsSync(compare_rewrite_xml)) {
        fs.unlinkSync(compare_rewrite_xml);
    }

    var tag_sel = 0;
    var instream = fs.createReadStream(compare_xml);
    var outstream = new (require('stream'))();
    var rl = readline.createInterface(instream, outstream);
    rl.on('line', function(line) {
        if (line.indexOf('<MT>') != -1) {
            mt = line.substring(line.indexOf('<MT>') + 4, line.indexOf('</MT>'));
        }
        if (line.indexOf('<OS>') != -1) {
            os = line.substring(line.indexOf('<OS>') + 4, line.indexOf('</OS>'));
        }
        if (line.indexOf('<UPDATEID>') != -1) {
            if(os == "RHEL 7 x64"){
                index = (mt + unifyOS("RHEL 7")).toLowerCase();
            } else if (os == "platform"){
                index = (mt + unifyOS("platform")).toLowerCase();
            } else {
                index = (mt + unifyOS(os)).toLowerCase();
            }
            var selected_list_child = selected_list.get(index);
            if(selected_list_child != undefined)
            {
                for (var i = 0; i < selected_list_child.length; i++) {
                    if (line.indexOf(selected_list_child[i]) != -1) {
                        tag_sel = 1;
                        break;
                    }
                }
            }
        }
        if (line.indexOf('<SELECTED>') != -1) {
            if (line.indexOf('0') != -1) {
                line = line.replace('0', tag_sel);
            } else if (line.indexOf('1') != -1) {
                line = line.replace('1', tag_sel);
            }
        }
        if (line.indexOf('</PACKAGE>') != -1) {
            tag_sel = 0;
        }
        line = line + '\n';
        Utils.writeTextFile(compare_rewrite_xml, line, true);
    });
    rl.on('close', function(line) {
        if (callback)
            event.sender.send(callback);
    });
    Utils.printLog("INFO", "End rewrite_compare_result");
}

module.exports.RegisterUtilsFunctions = function (ipcMain) {
    for (var m in Utils) {
        if (Utils.hasOwnProperty(m) && typeof Utils[m] == "function") {
            const funcName = m;
            ipcMain.on(m, (event, ...args) => {
                event.returnValue = Utils[funcName](...args);
            });
        }
    }
    ipcMain.on("runProgram", function (event, args, callback) {
        runProgram(event, args, callback);
    });
    ipcMain.on("secureRunProgram", function (event, topDir, args, foreGroundValue, isHidden, workingDirectory, callback) {
        secureRunProgram(event, topDir, args, foreGroundValue, isHidden, workingDirectory, callback);
    });
    ipcMain.on("rewrite_compare_result", function (event, callback, compare_rewrite_xml, compare_xml, selected_list) {
        rewrite_compare_result(event, callback, compare_rewrite_xml, compare_xml, selected_list);
    });
}

function _bomc_log(level, msg) {
    function getCallerFileNameAndLine() {
        function getException() {
            try {
                throw Error('');
            } catch (err) {
                return err;
            }
        }
        const err = getException();
        const stack = err.stack;
        const stackArr = stack.split('\n');
        let callerLogIndex = 0;
        for (let i = 0; i < stackArr.length; i++) {
            if (stackArr[i].indexOf("_bomc_log") > 0 && i + 1 < stackArr.length) {
                callerLogIndex = i + 1;
                break;
            }
        }
        if (callerLogIndex !== 0) {
            const callerStackLine = stackArr[callerLogIndex];
            const lastDash = callerStackLine.lastIndexOf('/');
            const lastBackslash = callerStackLine.lastIndexOf('\\');
            return `[${callerStackLine.substring((lastDash > lastBackslash ? lastDash : lastBackslash) + 1, callerStackLine.lastIndexOf(':'))}]`;
        } else {
            return '[-]';
        }
    }
    return Utils.printLog(level, getCallerFileNameAndLine(), msg);
}

module.exports.bomc_log = _bomc_log;