#!/bin/sh
# Copyright © 2021 - present Lenovo.  All rights reserved.
# Confidential and Proprietary.
export DATA_DIR_NAME="RAIDConfig"
RAIDCONFIG_DIR="${RUN_DIR}/configfiles"
RAIDCONFIG_LOG_DIR="$BOMC_LOG_DIR/$DATA_DIR_NAME"

export MD_LOG_DIR=$RAIDCONFIG_LOG_DIR

Resultfile="$RAIDCONFIG_LOG_DIR/raid_show_result.xml"
controller_id_all=""

declare -A index_map
declare -A disk_index
declare -A disk_map

function PrintTarget()
{
    # samlple
    # No.       Target              Volumes
    # 1         md0                 md127, md127
    declare -A target
    local raid_type="$1"
    local point="$2/VOLUMES"
    local key_name=""
    if [ "${raid_type}" == "software" ];then
        key_name="Name"
    elif [ "${raid_type}" == "hardware" ];then
        key_name="VolumeID"
    fi
    target["Target"]="$3"
    local volume_count=`${XML_TOOL} --xpath "count(${point}/*)" ${Resultfile}`
    local volume=""
    for j in $(seq 1 ${volume_count});do
        local name=`${XML_TOOL} --xpath "${point}/VOLUME[${j}]/${key_name}/text()" ${Resultfile}`
        if [ "${volume}" == "" ];then
            volume="${name}"
        else
            volume="${volume}, ${name}"
        fi
    done
    target["Volumes"]="${volume}"
    printf "%-10d%-20s%-40s\n" ${index} ${target["Target"]} "${target["Volumes"]}"
    unset target
    return 0 
}

function PrintRaidConfig()
{
    local show_sw="$1"
    local show_hw="$2"
    controller_count=`${XML_TOOL} --xpath "count(CONTROLLERS/*)" ${Resultfile}`
    if [ ${controller_count} == 0 ];then
        echo "[Warning]: No controller found."
        return ${controller_count}
    fi
 
    index=0
    printf "%-10s%-20s%-40s\n" "No." "Target" "Volumes"
    for i in $(seq 1 ${controller_count});do
        point="/CONTROLLERS/CONTROLLER[${i}]"
        # Check software RAID.
        name=`${XML_TOOL} --xpath "${point}/Name/text()" ${Resultfile} 2>&1`
        if [ "${name}" != "XPath set is empty" ];then
            if [ "${show_sw}" == "1" ];then
                let index=index+1
                index_map["$index"]="$i"
                PrintTarget "software" ${point} ${name}
            fi
            continue
        fi

        # Check hardware RAID.
        controller_id=`${XML_TOOL} --xpath "${point}/ControllerID/text()" ${Resultfile} 2>&1`
        if [ "${controller_id}" != "XPath set is empty" ];then
            if [ "${show_hw}" == "1" ];then
                let index=index+1
                index_map["$index"]="$i"
                PrintTarget "hardware" ${point} ${controller_id}
            fi
            continue
        fi

    done

    echo

    return ${controller_count}
}

function PrintDiskId()
{
	# samlple
	# No.       Disk ID  
	# 1         disk[1-8]   
	local num="$1"
	local point="/CONTROLLERS/CONTROLLER[${num}]/DISKS"
	disk_count=`${XML_TOOL} --xpath "count(${point}/*)" ${Resultfile} 2>/dev/null`
	if [ ${disk_count} == 0 ];then
		echo "[Warning]: No disk found."
		return ${disk_count}
	fi

	index=0
	printf "%-10s%-20s\n" "No." "Disk ID"
	for i in $(seq 1 ${disk_count});do
		disk_id=`${XML_TOOL} --xpath "${point}/DISK[${i}]/DiskID/text()" ${Resultfile} 2>/dev/null`
		if [ "${disk_id}" != "XPath set is empty" ];then
			let index=index+1
			disk_index["$index"]="$i"
			disk_map["$index"]="$disk_id"
			printf "%-10s%-20s\n" ${index} ${disk_id}
		fi
	done

    echo

	return ${disk_count}
}

function PrintSwVolume()
{
    # sample
    # Target: md0
    # Volume              Status              Disks                                   RAID Level          Size(GB)
    # md127               clean, resyncing    /dev/sdc, /dev/sdd                      raid1               250.05
    declare -A volume
    local num="$1"
    local point="/CONTROLLERS/CONTROLLER[${num}]"

    volume["Target"]=`${XML_TOOL} --xpath "${point}/Name/text()" ${Resultfile} 2>/dev/null`
    volume["Disks"]=`${XML_TOOL} --xpath "${point}/DiskArray/text()" ${Resultfile} 2>/dev/null`

    point="${point}/VOLUMES"
    local volume_count=`${XML_TOOL} --xpath "count(${point}/*)" ${Resultfile} 2>/dev/null`
    if [ $volume_count == 0 ];then
        echo
        printf "%s has not been configured." ${volume["Target"]}
        return 0
    fi

    printf "\nTarget: %s\n" "${volume["Target"]}"
    printf "%-20s%-20s%-40s%-20s%-20s\n" "Volume" "Status" "Disks" "RAID Level" "Size(GB)"

    for i in $(seq 1 ${volume_count});do
        volume["Volume"]=`${XML_TOOL} --xpath "${point}/VOLUME[${i}]/Name/text()" ${Resultfile} 2>/dev/null`
        volume["Status"]=`${XML_TOOL} --xpath "${point}/VOLUME[${i}]/State/text()" ${Resultfile} 2>/dev/null`
        volume["RaidLevel"]=`${XML_TOOL} --xpath "${point}/VOLUME[${i}]/RAIDLevel/text()" ${Resultfile} 2>/dev/null`
        # Capital RAID level
        volume["RaidLevel"]=${volume["RaidLevel"]^^}
        # Size sample: <Size>244193280 (232.88 GiB 250.05 GB)</Size>
        # Get size in GB
        volume["Size"]=`${XML_TOOL} --xpath "${point}/VOLUME[${i}]/Size/text()" ${Resultfile} 2>/dev/null`
        Disks=(${volume["Disks"]//,/ })
        printf "%-20s%-20s%-40s%-20s%-20s\n" ${volume["Volume"]} "${volume["Status"]}" "${Disks[0]}" "${volume["RaidLevel"]}" "${volume["Size"]}"
        for n in "${!Disks[@]}";do
            if [ $n -eq 0 ];then
                continue;
            fi
            printf "%-20s%-20s%-40s\n" "" "" "${Disks[$n]}"
        done
    done
}

function PrintHwVolume()
{
    # Target: ctrl[0]   ProductName: ServeRAID M5210     SerialNo: SV334P1094
    # Volume              Status              Disks                                   RAID Level          Size(GB)
    # vol[0-0]            Optimal             disk[0-5], disk[0-6]                    RAID1               271.944
    declare -A volume
    local num="$1"
    local point="/CONTROLLERS/CONTROLLER[${num}]"
    volume["Target"]=`${XML_TOOL} --xpath "${point}/ControllerID/text()" ${Resultfile} 2>/dev/null`
    volume["TargetID"]=`${XML_TOOL} --xpath "${point}/TargetID/text()" ${Resultfile} 2>/dev/null`

    local volume_count=`${XML_TOOL} --xpath "count(${point}/*)" ${Resultfile} 2>/dev/null`
    if [ $volume_count == 0 ];then
        echo
        printf "%s has not been configured." ${volume["Target"]}
        return 0
    fi
    if [[ "${volume["TargetID"]}" =~ "M.2" ]] || [[ "${volume["TargetID"]}" =~ "m.2" ]];then
        volume["Name"]=`${XML_TOOL} --xpath "${point}/Name/text()" ${Resultfile} 2>/dev/null`
        volume["Version"]=`${XML_TOOL} --xpath "${point}/Version/text()" ${Resultfile} 2>/dev/null`
        printf "\nTarget: %-20sName: %-40sVersion: %-20s\n" "${volume["Target"]}" "${volume["Name"]}" "${volume["Version"]}"
        printf "%-20s%-20s%-20s%-20s\n" "Volume" "Status" "RAID Level" "Size(GB)"
    else
        volume["ProductName"]=`${XML_TOOL} --xpath "${point}/ProductName/text()" ${Resultfile} 2>/dev/null`
        volume["SerialNo"]=`${XML_TOOL} --xpath "${point}/SerialNo/text()" ${Resultfile} 2>/dev/null`
        printf "\nTarget: %-20sProductName: %-40sSerialNo: %-20s\n" "${volume["Target"]}" "${volume["ProductName"]}" "${volume["SerialNo"]}"
        printf "%-20s%-20s%-40s%-20s%-20s\n" "Volume" "Status" "Disks" "RAID Level" "Size(GB)"
    fi

    for i in $(seq 1 ${volume_count});do
        point="${point}/VOLUMES"
        volume["Volume"]=`${XML_TOOL} --xpath "${point}/VOLUME[${i}]/VolumeID/text()" ${Resultfile} 2>/dev/null`
        volume["Status"]=`${XML_TOOL} --xpath "${point}/VOLUME[${i}]/Status/text()" ${Resultfile} 2>/dev/null`
        volume["Disks"]=`${XML_TOOL} --xpath "${point}/VOLUME[${i}]/Disks/text()" ${Resultfile} 2>/dev/null`
        # Size sample: <Capacity>271.944 GB</Capacity>
        str_cache=`${XML_TOOL} --xpath "${point}/VOLUME[${i}]/Capacity/text()" ${Resultfile} 2>/dev/null`
        str_array=(${str_cache// / })
        volume["Size"]=${str_array[0]}
        Disks=(${volume["Disks"]//,/ })
        if [[ "${volume["TargetID"]}" =~ "M.2" ]] || [[ "${volume["TargetID"]}" =~ "m.2" ]];then
            volume["RaidLevel"]=`${XML_TOOL} --xpath "${point}/VOLUME[${i}]/RaidLevel/text()" ${Resultfile} 2>/dev/null`
            printf "%-20s%-20s%-20s%-20s\n" ${volume["Volume"]} "${volume["Status"]}" "${volume["RaidLevel"]}" "${volume["Size"]}"
        else
            volume["RaidLevel"]=`${XML_TOOL} --xpath "${point}/VOLUME[${i}]/RAIDState/text()" ${Resultfile} 2>/dev/null`
            printf "%-20s%-20s%-40s%-20s%-20s\n" ${volume["Volume"]} "${volume["Status"]}" "${Disks[0]}" "${volume["RaidLevel"]}" "${volume["Size"]}"
            for n in "${!Disks[@]}";do
	            if [ $n -eq 0 ];then
	                continue;
	            fi
	            printf "%-20s%-20s%-40s\n" "" "" "${Disks[$n]}"
        	done 
        fi
    done
}

function ShowRAIDConfiguration()
{
    ${Run} "$GET_CMD" "blank"
    ret=$?
    if [ $ret != 0 ];then
        return $ret
    fi
    [ ! -e "$Resultfile" ] && echo "[Failure] $Resultfile does not exist."&& return $ret
    PrintRaidConfig 1 1
    controller_count=$?
    [ $controller_count == 0 ]&&return 0

    while [ true ]
    do
        read -p "* Enter your option to show more container details ('q' to quit):" option
        if [ -z "$option" ];then
            continue
        elif [ "x$option" == "xq" ]||[ "x$option" == "xQ" ]; then
			return  0
        elif [ $option -gt 0 ] 2>/dev/null && [ $option -le ${controller_count} ]; then
            point="/CONTROLLERS/CONTROLLER[${option}]"
            name=`${XML_TOOL} --xpath "${point}/Name/text()" ${Resultfile} 2>&1`
            controller_id=`${XML_TOOL} --xpath "${point}/ControllerID/text()" ${Resultfile} 2>&1`
            if [[ "${controller_id}" =~ "vroc" ]] || [[ "${controller_id}" =~ "VROC" ]];then
                PrintSwVolume ${option}
            else
                PrintHwVolume ${option}
            fi
            [ $controller_count ==  1 ]&& break
            echo ""
            PrintRaidConfig 1 1
        else
            echo "Invalid option."	
        fi
    done

    return $ret
}

Choose_value_from_list=""
Choose_target=""
function chooseTarget()
{
    configfile=$1
    targets=($(grep "^\["  $configfile))
    echo -e "No\tTarget"
    tcount=${#targets[@]}
    
    for i in $(seq 1 $tcount)
    do
        targets[$((i-1))]="`echo ${targets[$((i-1))]}|sed 's/\[\(.*\)\]/\1/g'`"
        targets[$((i-1))]=${targets[$((i-1))]%-*}
        echo "${targets[$((i-1))]}" >> $RAIDCONFIG_DIR/tmp
    done
    targets=($(sort -d -u $RAIDCONFIG_DIR/tmp))
    eval rm $RAIDCONFIG_DIR/tmp
    tcount=${#targets[@]}
    [ $tcount == 0 ]&& echo "[WARNING] No target could be found." && return 1

    for i in $(seq 1 $tcount)
    do
        echo -e "$i\t`echo ${targets[$((i-1))]}|sed 's/\[\(.*\)\]/\1/g'`"
    done
    
    if [ $tcount == 1 ];then
        Choose_target=`echo ${targets[0]}|sed 's/\[\(.*\)\]/\1/g'|tr -d '\r'`
        if grep -q "ctrl" <<< "$Choose_target"
        then
            # Convert device name of ctrl: ctrl0-vol0 -> 0  ctrl1-vol0 -> 1
            Choose_target=${Choose_target#*ctrl}
            Choose_target=${Choose_target%-*}
        fi

        if grep -q "vroc" <<< "$Choose_target"
        then
            # Convert device name of vroc: vroc0-vol0 -> vroc0  vroc1-vol0-xxx -> vroc1
            Choose_target=${Choose_target%%-*}
        fi
        return 0
    fi
    while [ true ]
    do
        read -p "* Enter the number of target ('a' to all,'q' to quit):" option
        if [ -z "$option" ];then
				continue
        elif [ "x$option" == "xq" ]||[ "x$option" == "xQ" ]; then
            return 1
        elif [ "x$option" == "xa" ]||[ "x$option" == "xA" ]; then
            Choose_target=""
            return 0
        elif [ $option -gt 0 ] 2>/dev/null && [ $option -le ${tcount} ]; then
            Choose_target=`echo ${targets[$((option-1))]}|sed 's/\[\(.*\)\]/\1/g'|tr -d '\r'`
            if grep -q "ctrl" <<< "$Choose_target"
            then
                # Convert device name of vroc: ctrl0-vol0 -> 0  ctrl1-vol0 -> 1
                Choose_target=${Choose_target#*ctrl}
                Choose_target=${Choose_target%-*}
            fi

            if grep -q "vroc" <<< "$Choose_target"
            then
                # Convert device name of ctrl: vroc0-vol0 -> vroc0  vroc1-vol0-xxx -> vroc1
                Choose_target=${Choose_target%%-*}
            fi
            return 0
		else
            echo "Invalid option."
        fi
    done
}

function chooseConfigFiles()
{
    files=(`ls $RAIDCONFIG_DIR/ 2>/dev/null`)
    [ ${#files[@]} -lt 1 ]  && echo "[Failure] No RAID configuration file could be found." && return 1
    count=0
    echo -e "No.\tFilename"
    for file in ${files[*]}
    do
        let count=count+1
        echo -e "$count\t$file"
    done

    Choose_value_from_list=${files[0]}
	if [ "$count" == 1 ];then
        [ ! -s $RAIDCONFIG_DIR/$Choose_value_from_list ]&& echo "[WARNING] Empty file." && return 1
        grep "^\[" $RAIDCONFIG_DIR/$Choose_value_from_list 1>/dev/null 2>&1
        [ $? != 0 ] && echo "[WARNING] No target could be found in $Choose_value_from_list." && return 1

        echo -e "\n$Choose_value_from_list RAID configure:"
        grep -v  -P "^#|^\r$|^$" $RAIDCONFIG_DIR/$Choose_value_from_list|more
       
        while [ true ]
        do
            read -p "* Are you sure select $Choose_value_from_list? [Y|N]" ans
            [ -z "$ans" ]&&continue
            if [ "x$ans" == "xY" ] || [ "x$ans" == "xy" ];then
                chooseTarget "$RAIDCONFIG_DIR/$Choose_value_from_list" 
                return $?
            elif [ "x$ans" == "xN" ] || [ "x$ans" == "xn" ];then
                return 1
            else
                echo "Invalid input."
            fi
        done  
	else
		echo ""
		while [ true ]
		do
			read -p "* More than one file be found, Enter your option ('q' to quit):" option
			if [ -z "$option" ];then
				continue
			elif [ "x$option" == "xq" ]||[ "x$option" == "xQ" ]; then
				return  1
			elif [ $option -gt 0 ] 2>/dev/null && [ $option -le ${count} ]; then
				Choose_value_from_list=${files[$(($option-1))]}
                [ ! -s $RAIDCONFIG_DIR/$Choose_value_from_list ]&& echo "[WARNING] Empty file." && continue

                grep "^\[" $RAIDCONFIG_DIR/$Choose_value_from_list 1>/dev/null 2>&1
                if [ $? != 0 ] ;then
                    echo "[WARNING] No target could be found in $Choose_value_from_list."
                else
                    echo -e "\n$Choose_value_from_list RAID configure:"
                    grep -v  -P "^#|^\r$|^$" $RAIDCONFIG_DIR/$Choose_value_from_list|more
                    while [ true ]
                    do
                        read -p "* Are you sure select $Choose_value_from_list? [Y|N]" ans
                        [ -z "$ans" ]&&continue
                        if [ "x$ans" == "xY" ] || [ "x$ans" == "xy" ];then
                            
                            chooseTarget "$RAIDCONFIG_DIR/$Choose_value_from_list" 
                            [ $? != 0 ]&& break
                            return 0
                        elif [ "x$ans" == "xN" ] || [ "x$ans" == "xn" ];then
                            break
                        else
                            echo "Invalid input."
                        fi
                    done 
                    echo ""
                    echo -e "No.\tFilename"
                    ct=0
                    for file in ${files[*]}
                    do
                        let ct=ct+1
                        echo -e "$ct\t$file"
                    done
                fi
			else
				echo "Invalid option."	
			fi
		done	
	fi
	return 0

}

function AddRAIDConfiguration()
{
    chooseConfigFiles 
    [ $? != 0 ]&& return 1
    $Run "$SET_CMD" "-" "$Choose_target" "$RAIDCONFIG_DIR/$Choose_value_from_list" 
}

function makesure()
{
	while [ true ]
	do
		read -p "$1" ans  
		if [ "x$ans" == "xy" ] || [ "x$ans" == "xY" ];then	
			return 0
		elif [ "x$ans" == "xn" ] || [ "x$ans" == "xN" ];then
			return 1
		fi
	done
}

function DeleteRAIDConfiguration()
{
    ${Run} "$GET_CMD" "blank"
    ret=$?
    if [ $ret != 0 ];then
        return $ret
    fi
    [ ! -e "$Resultfile" ] && echo "[Failure] $Resultfile does not exist."&& return $ret
    PrintRaidConfig 1 1
    controller_count=$?
    [ $controller_count == 0 ]&& return 0

    while [ true ]
    do
        read -p "* Enter your option('a' to all,'q' to quit):" option
        if [ -z "$option" ];then
            continue
        elif [ "x$option" == "xq" ]||[ "x$option" == "xQ" ]; then
            unset index_map
			return  0
        elif [ "x$option" = "xa" ] || [ "x$option" = "xA" ];then
            makesure "* Are you sure you want to delete all? [Y/N]:"
            if [ $? == 0 ];then
                option=0
                while [ true ]
                do
                    option=$option+1
                    controller_id=`${XML_TOOL} --xpath "CONTROLLERS/CONTROLLER[$option]/ControllerID/text()" ${Resultfile} 2>&1`
                    if [ "${controller_id}" != "XPath set is empty" ];then
                        echo "prepare to clear raid " "$controller_id"
                        $Run "$SET_CMD" "-" "$controller_id"
                    else
                        return 0
                    fi
                done
            fi
        elif [ $option -gt 0 ] 2>/dev/null && [ $option -le ${controller_count} ]; then
            option=${index_map["$option"]}
            # name=`$XML_TOOL --xpath "/CONTROLLERS/CONTROLLER[$option]/Name/text()" $Resultfile 2>&1`
            # if [ "${name}" != "XPath set is empty" ];then
            #     makesure "* Are you sure you want to delete $name? [Y/N]:"
            #     [ $? == 0 ]&& $Run "$SET_CMD" "-" "$name" 
            #     continue
            # fi
            controller_id=`${XML_TOOL} --xpath "CONTROLLERS/CONTROLLER[$option]/ControllerID/text()" ${Resultfile} 2>&1`
            # volume=`${XML_TOOL} --xpath "CONTROLLERS/CONTROLLER[$option]/Volume/text()" ${Resultfile} 2>&1`
            if [ "${controller_id}" != "XPath set is empty" ];then
                makesure "* Are you sure you want to delete $controller_id? [Y/N]:"
                if [ $? == 0 ];then
                    # Convert device name of ctrl: ctrl[0] -> 0
                    controller_id=${controller_id#*[}
                    controller_id=${controller_id%*]}
                    $Run "$SET_CMD" "-" "$controller_id"
                fi
                continue
            fi
        else
            # options to controller ids 1,2,3 -> 4,5,6
            option_array=($option)
            for i in ${!option_array[@]};do
                if [[ "${!disk_index[@]}" =~ "${option_array[$i]}" ]];then
                    temp_disk=${disk_map[${option_array[$i]}]}
                    # Convert device name of disk: disk[1-8] -> 8
                    temp_disk=${temp_disk#*-}
                    temp_disk=${temp_disk%*]}
                    # Convert user option: 1,2,3 -> 8,9,10
                    option_index=(${option_index/${option_array[$i]}/$temp_disk})
                else
                    echo "Invalid option."
                    option_index="invalid option"
                    break
                fi
            done
        fi
    done
}

function ConvertJBODToUnconfiguredGood()
{
    ${Run} "$GET_CMD" "blank"
    ret=$?
    if [ $ret != 0 ];then
        return $ret
    fi
    [ ! -e "$Resultfile" ] && echo "[Failure] $Resultfile does not exist."&& return $ret
    PrintRaidConfig 0 1
    controller_count=$?
    if [ $controller_count == 0 ];then
        echo "[Failue] no JBOD found."
        return 0
    fi

    while [ true ]
    do
        read -p "* Enter your option('q' to quit):" option
        if [ -z "$option" ];then
            continue
        elif [ "x$option" == "xq" ]||[ "x$option" == "xQ" ]; then
            unset index_map
			return  0
        elif [ $option -gt 0 ] 2>/dev/null && [ $option -le ${controller_count} ]; then
            option=${index_map["$option"]}
            name=`$XML_TOOL --xpath "/CONTROLLERS/CONTROLLER[$option]/ControllerID/text()" $Resultfile`

            PrintDiskId ${option}
		    [ $? == 0 ]&& continue
		
            while [ true ]
            do
                echo "Hint:If more than one disk is selected,use a comma to separate each disk. E.g. '1,2,3'."
                read -p "* Enter your option('1'or'1,2' to disk No.,'a' to all,'p' to previous,'q' to quit):" option_index
                if [ -z "$option_index" ];then
                    continue
                elif [ "x$option_index" == "xp" ]||[ "x$option_index" == "xP" ]; then
                    PrintRaidConfig 0 1
                    unset disk_index
                    unset disk_map
                    break
                elif [ "x$option_index" == "xq" ]||[ "x$option_index" == "xQ" ]; then
                    unset index_map
                    unset disk_index
                    unset disk_map
                    return 0
                elif [ "x$option_index" = "xa" ]||[ "x$option_index" = "xA" ];then
                    makesure "* Are you sure you want to convert $name all disks to unconfigured Good? [Y/N]:"
                    if [ $? == 0 ];then
                        # Convert device name of ctrl: ctrl[0] -> 0
                        name=${name#*[}
                        name=${name%*]}
                        $Run "$SET_CMD" "-" "$name" ""
                    fi
                else
                    #set bash internal field separator to comma
                    ORIG_IFS=$IFS
                    IFS=$(echo -en ",")
                    option_array=($option_index)
                    IFS=$ORIG_IFS

                    for i in ${!option_array[@]};do
                        if [[ "${!disk_index[@]}" =~ "${option_array[$i]}" ]];then
                            temp_disk=${disk_map[${option_array[$i]}]}
                            # Convert device name of disk: disk[1-8] -> 8
                            temp_disk=${temp_disk#*-}
                            temp_disk=${temp_disk%*]}
                            # Convert user option: 1,2,3 -> 8,9,10
                            option_index=(${option_index/${option_array[$i]}/$temp_disk})
                        else
                            echo "Invalid option."
                            option_index="invalid option"
                            break
                        fi
                    done

                    if [ "$option_index" != "invalid option" ];then
                        makesure "* Are you sure you want to convert disk $option_index to unconfigured Good? [Y/N]:"
                        if [ $? == 0 ];then
                            name=${name#*[}
                            name=${name%*]}
                            $Run "$SET_CMD" "-" "$name" "$option_index"
                        fi	
                    fi
                fi
            done
        else
            echo "Invalid option."	
        fi
    done
}

function ConvertUnconfiguredGoodToJBOD()
{
    ${Run} "$GET_CMD" "blank"
    ret=$?
    if [ $ret != 0 ];then
        return $ret
    fi
    [ ! -e "$Resultfile" ] && echo "[Failure] $Resultfile does not exist."&& return $ret
    PrintRaidConfig 0 1
    controller_count=$?
    [ $controller_count == 0 ]&& return 0

    while [ true ]
    do
        read -p "* Enter your option('q' to quit):" option
        if [ -z "$option" ];then
            continue
        elif [ "x$option" == "xq" ]||[ "x$option" == "xQ" ]; then
            unset index_map
			return  0
        elif [ $option -gt 0 ] 2>/dev/null && [ $option -le ${controller_count} ]; then
            option=${index_map["$option"]}
            name=`$XML_TOOL --xpath "/CONTROLLERS/CONTROLLER[$option]/ControllerID/text()" $Resultfile`
            
            PrintDiskId ${option}
		    [ $? == 0 ]&& continue
		
            while [ true ]
            do
                echo "Hint:If more than one disk is selected,use a comma to separate each disk. E.g. '1,2,3'."
                read -p "* Enter your option('1'or'1,2' to disk No.,'a' to all,'p' to previous,'q' to quit):" option_index
                if [ -z "$option_index" ];then
                    continue
                elif [ "x$option_index" == "xp" ]||[ "x$option_index" == "xP" ]; then
                    PrintRaidConfig 0 1
                    unset disk_index
                    unset disk_map
                    break
                elif [ "x$option_index" == "xq" ]||[ "x$option_index" == "xQ" ]; then
                    unset index_map
                    unset disk_index
                    unset disk_map
                    return 0
                elif [ "x$option_index" = "xa" ]||[ "x$option_index" = "xA" ];then
                    makesure "* Are you sure you want to convert $name all disks to unconfigured Good? [Y/N]:"
                    if [ $? == 0 ];then
                        # Convert device name of ctrl: ctrl[0] -> 0
                        name=${name#*[}
                        name=${name%*]}
                        $Run "$SET_CMD" "-" "$name" ""
                    fi
                else
                    #set bash internal field separator to comma
                    ORIG_IFS=$IFS
                    IFS=$(echo -en ",")
                    option_array=($option_index)
                    IFS=$ORIG_IFS

                    for i in ${!option_array[@]};do
                        if [[ "${!disk_index[@]}" =~ "${option_array[$i]}" ]];then
                            temp_disk=${disk_map[${option_array[$i]}]}
                            # Convert device name of disk: disk[1-8] -> 8
                            temp_disk=${temp_disk#*-}
                            temp_disk=${temp_disk%*]}
                            # Convert user option: 1,2,3 -> 8,9,10
                            option_index=(${option_index/${option_array[$i]}/$temp_disk})
                        else
                            echo "Invalid option."
                            option_index="invalid option"
                            break
                        fi
                    done

                    if [ "$option_index" != "invalid option" ];then
                        makesure "* Are you sure you want to convert disk $option_index to unconfigured Good? [Y/N]:"
                        if [ $? == 0 ];then
                            name=${name#*[}
                            name=${name%*]}
                            $Run "$SET_CMD" "-" "$name" "$option_index"
                        fi	
                    fi
                fi
            done
        else
            echo "Invalid option."	
        fi
    done
}

function ChangeConnectorModeMicrochipRAID()
{
    ${Run} "$GET_CMD" "blank"
    ret=$?
    if [ $ret != 0 ];then
        return $ret
    fi
    [ ! -e "$Resultfile" ] && echo "[Failure] $Resultfile does not exist."&& return $ret

    while [ true ]
    do
        PrintRaidConfig 0 1
        controller_count=$?
        [ $controller_count == 0 ] && return 0
        read -p "* Enter your option('q' to quit):" option
        if [ -z "$option" ];then
            continue
        elif [ "x$option" == "xq" ]||[ "x$option" == "xQ" ]; then
            unset index_map
			return  0
        elif [ $option -gt 0 ] 2>/dev/null && [ $option -le ${controller_count} ]; then
            option=${index_map["$option"]}
            controller_id=`${XML_TOOL} --xpath "CONTROLLERS/CONTROLLER[$option]/ControllerID/text()" ${Resultfile} 2>&1`
            if [ "${controller_id}" != "XPath set is empty" ];then
                read -p "* Enter the connector id (0,1, 'q' to quit): " connector_id
                [ "x$connector_id" == "xq" ] || [ "x$connector_id" == "xQ" ] && return 0
                read -p "* Enter the mode ( HBA | RAID | MIX , 'q' to quit): " mode
                [ "x$mode" == "xq" ] || [ "x$mode" == "xQ" ] && return 0
                makesure "* Are you sure you want to change Connector ID $connector_id to $mode? [Y/N]:"
                if [ $? == 0 ];then
                    # Convert device name of ctrl: ctrl[0] -> 0
                    controller_id=${controller_id#*[}
                    controller_id=${controller_id%*]}
                    ${Run} "$SET_CMD" "blank" "$controller_id" "$connector_id" "$mode"
                fi
                continue
            fi
        else
            echo "Invalid option."	
        fi
    done
    return $ret
}

mkdir -p ${RAIDCONFIG_LOG_DIR} 1>/dev/null 2>/dev/null
#echo "calling $1"
$1
