#!/bin/sh
# Copyright © 2021 - present Lenovo.  All rights reserved.
# Confidential and Proprietary.

#run "command" "after_do" "option1" "option2"
count=$#
Command=$1
After_do="-"
if [ $# -gt 1 ];then
    After_do=$2
fi



while [ $# -ge 3 ];do
	#Command=`echo "$Command"|sed -e "s/()/text.xt/"`
	Command=`echo ${Command/()/\'${3}\'}`
   	shift
done
#echo "$Command"

full_command=""
if [ "x$BOOT_OS_ENV_TYPE" == x"MCP" ];then
    logfile="asu_`date +%Y%m%d%H%M%S`.txt"
    full_command="$ASU_BIN $Command ${ASU_ADD_OPTION} --logfile ${MD_LOG_DIR}/${logfile}"
else
    # if input is empty, remove --bmc-username
    if echo "$Command" | grep " --bmc-username ''" >/dev/null 2>&1 ; then
        Command=`echo ${Command/ --bmc-username \'\'/}`
    fi

    # if input is empty, remove --bmc-password
    if echo "$Command" | grep " --bmc-password ''" >/dev/null 2>&1 ; then
        Command=`echo ${Command/ --bmc-password \'\'/}`
    fi

    # if input is empty, remove --bmc-cim-port
    if echo "$Command" | grep " --bmc-cim-port ''" >/dev/null 2>&1 ; then
        Command=`echo ${Command/ --bmc-cim-port \'\'/}`
    fi

    # if input is empty, remove --bmc-rest-port
    if echo "$Command" | grep " --bmc-rest-port ''" >/dev/null 2>&1 ; then
        Command=`echo ${Command/ --bmc-rest-port \'\'/}`
    fi

    # if input is empty, remove --drive
    if echo "$Command" | grep " --drive ''" >/dev/null 2>&1 ; then
        Command=`echo ${Command/ --drive \'\'/}`
    fi

    # if input is empty, remove --ctrl means operate to all
    if echo "$Command" | grep " --ctrl ''" >/dev/null 2>&1 ; then
        Command=`echo ${Command/ --ctrl \'\'/}`
    fi

    if echo "$Command" | grep " --output" >/dev/null 2>&1 ; then
        full_command="$ONECLI_BIN $Command $ONECLI_ADD_OPTION"
    else
        full_command="$ONECLI_BIN $Command $ONECLI_ADD_OPTION --output ${MD_LOG_DIR}"
    fi
fi

#echo "full_command = " "${full_command}"
${RunPrintResult} "${full_command}" "${After_do}"


