#!/bin/sh
# Copyright © 2021 - present Lenovo.  All rights reserved.
# Confidential and Proprietary.
SMART_LOG_DIR="${BOMC_LOG_DIR}/smart"

export MD_LOG_DIR=$SMART_LOG_DIR
mkdir -p $SMART_LOG_DIR 1>/dev/null 2>&1

if [ $IS_CFC == 1 ];then   #CFC SMART data use smartctl tools
    #run smartctl --scan command and get the command result
    SMART_SCAN=`smartctl --scan`
    #check if command succeed
    if [ "$?" != "0" ]
    then
        echo "[Failue] smartctl --scan failed."
        exit -1
    fi

    #set bash internal field separator to newline
    ORIG_IFS=$IFS
    IFS=$(echo -en "\n\b")

    SMART_DEVICE_INDEX=1
    #declare -A SMART_CMD_ARRAY

    #parse the information we need
    for i in $SMART_SCAN
    do
        SMART_CMD_ARRAY[$SMART_DEVICE_INDEX]=$i
        SMART_DEVICE_INDEX=`expr $SMART_DEVICE_INDEX + 1`
    done

    #set bash internal field separator back to original value
    IFS=$ORIG_IFS

    #print the menu list for smartctl
    echo "-------------------------"
    printf "| No.|\tDiskName\t|\n"
    for i in ${!SMART_CMD_ARRAY[@]}
    do
        TAMP_INDEX=$i
        TAMP_NAME=${SMART_CMD_ARRAY[$i]%"-d"*}
        echo "-------------------------"
        printf "| %s  |\t%s\t|\n" $TAMP_INDEX $TAMP_NAME
    done
    echo "-------------------------"

    #let user to select the disk which want to show detail information
    echo "Hint: Select the target disk. Use a comma to separate each disk. E.g. '1,2,3'. Select 'ALL' to select all disks."
    read -p "Enter one or more disks to show: " TAMP_TARGET_DEVICE_INDEX

    ORIG_IFS=$IFS
    IFS=$(echo -en ",")

    TARGET_DEVICE_ARRAY=($TAMP_TARGET_DEVICE_INDEX)

    IFS=$ORIG_IFS

    #check if the target device index is ALL
    SELECT_ALL=0
    for i in ${TARGET_DEVICE_ARRAY[@]}
    do
        if [ `echo $i | tr '[:lower:]' '[:upper:]'` == "ALL" ]
        then
            echo "Your select disks is all."
            SELECT_ALL=1
        fi
    done

    name="smartdata_`date +%Y%m%d%H%M%S`.txt"
    if [ $SELECT_ALL != 0 ]
    then
        for i in ${!SMART_CMD_ARRAY[@]}
        do
            echo "---------------------------------------------------------------" | tee -a $SMART_LOG_DIR/$name
		    echo "  [Command:]smartctl --all ${SMART_CMD_ARRAY[$i]%"#"*}" | tee -a $SMART_LOG_DIR/$name
		    echo "---------------------------------------------------------------" | tee -a $SMART_LOG_DIR/$name
            smartctl --all ${SMART_CMD_ARRAY[$i]%"#"*} | tee -a $SMART_LOG_DIR/$name
            echo "" | tee -a $SMART_LOG_DIR/$name
        done
    else
        for i in ${!TARGET_DEVICE_ARRAY[@]}
        do
            if [[ "${!SMART_CMD_ARRAY[@]}" =~ "${TARGET_DEVICE_ARRAY[$i]}" ]]
            then
                TARGET_INDEX=${TARGET_DEVICE_ARRAY[$i]}
                echo "---------------------------------------------------------------" | tee -a $SMART_LOG_DIR/$name
			    echo "  [Command:]smartctl --all ${SMART_CMD_ARRAY[$TARGET_INDEX]%%"#"*}" | tee -a $SMART_LOG_DIR/$name
			    echo "---------------------------------------------------------------" | tee -a $SMART_LOG_DIR/$name
                smartctl --all ${SMART_CMD_ARRAY[$TARGET_INDEX]%%"#"*} | tee -a $SMART_LOG_DIR/$name
                echo "" | tee -a $SMART_LOG_DIR/$name
            else
                echo "Invalid option."
            fi
        done
    fi 
else
    echo "Get disk drive SMART data."
    read -p "Enter the BMC username (empty as default): " bmc_username
    read -p "Enter the BMC password (empty as default): " bmc_password
    read -p "Enter the REST port (empty for no change): " rest_port
    read -p "Enter the CIM port (empty for no change): " cim_port
    ${Run} "${GET_CMD}" "-" "$bmc_username" "$bmc_password" "$cim_port" "$rest_port" "$SMART_LOG_DIR"
fi

echo "logs saved in "$SMART_LOG_DIR"."

while [ true ]
    do
        read -p "* Do you want to save it? (Y/N)"  ans
        [ -z "$ans" ]&&continue
        if [ "x$ans" == "xY" ] || [ "x$ans" == "xy" ];then
            name="smartdata_`date +%Y%m%d%H%M%S`.tar.gz"
            cd $SMART_LOG_DIR
            tar zcf $RUN_DIR/$name * 1>/dev/null 2>&1
            [ $? != 0 ]&& echo "[Failure] Failed to compress smartdata result." && return
            $EXSTORAGE "save" $RUN_DIR/$name
            break
        elif [ "x$ans" == "xN" ] || [ "x$ans" == "xn" ];then
            break
        else
            echo "Invalid input."
        fi
    done