#!/bin/sh
# Copyright © 2018 - present Lenovo.  All rights reserved.
# Confidential and Proprietary.
VPD_LOG_DIR="${BOMC_LOG_DIR}/vpd"

export MD_LOG_DIR=$VPD_LOG_DIR


function setVpd()
{
	vpd_batch_tmp="/tmp/vpd_tmp"
	rm -f $vpd_batch_tmp 1>/dev/null 2>&1

	if [ $IS_AMD == 1 ] || [ $IS_CFC == 1 ]; then
		read -p "* Enter the setting value for VPD.AssetTag (empty for no change):" AssetTag
		read -p "* Enter the setting value for VPD.Model (empty for no change):" Model
		read -p "* Enter the setting value for VPD.SKU (empty for no change):" SKU
		read -p "* Enter the setting value for VPD.SerialNumber (empty for no change):" SerialNumber

		[ -n "${AssetTag}" ] && echo set VPD.AssetTag \"${AssetTag}\" >${vpd_batch_tmp}
		[ -n "${Model}" ] && echo set VPD.Model \"${Model}\" >>${vpd_batch_tmp}
		[ -n "${SKU}" ] && echo set VPD.SKU \"${SKU}\" >>${vpd_batch_tmp}
		[ -n "${SerialNumber}" ] && echo set VPD.SerialNumber \"${SerialNumber}\" >>${vpd_batch_tmp}
	else
		read -p "* Enter the setting value for SysInfoProdName(MachineType/Model) (empty for no change):" prodName
		read -p "* Enter the setting value for SysInfoProdIdentifier (empty for no change):" prodIdentifier
		read -p "* Enter the setting value for SysInfoSerialNum (empty for no change):" serialNum
	
		[ -n "${prodName}" ] && echo set SYSTEM_PROD_DATA.SysInfoProdName \"${prodName}\" >${vpd_batch_tmp}
		[ -n "${prodIdentifier}" ] && echo set SYSTEM_PROD_DATA.SysInfoProdidentifier \"${prodIdentifier}\" >>${vpd_batch_tmp}
		[ -n "${serialNum}" ] && echo set SYSTEM_PROD_DATA.SysInfoSerialNum \"${serialNum}\" >>${vpd_batch_tmp}
	fi

	[ -e "${vpd_batch_tmp}" ] && ${Run} "${SET_CMD}" "-" "${vpd_batch_tmp}" "$rest_port"
	rm -f ${vpd_batch_tmp} >/dev/null 2>&1					
}


function UpdateVPD()
{
	vpd_batch_tmp="/tmp/vpd_tmp"
	echo "Get current VPD information."
	read -p "Enter the REST port (empty for no change): " rest_port

	if [ $IS_AMD == 1 ] || [ $IS_CFC == 1 ]; then
		echo  "show VPD.AssetTag
		show VPD.Model
		show VPD.SKU
		show VPD.SerialNumber " >${vpd_batch_tmp}
		${Run} "${GET_CMD}" "cat $ONECLI_CONSOLE_FILE | grep '^VPD'" "${vpd_batch_tmp}" "$rest_port"
	else
		echo  "show SYSTEM_PROD_DATA.SysInfoProdName
		show SYSTEM_PROD_DATA.SysInfoProdIdentifier
		show SYSTEM_PROD_DATA.SysInfoSerialNum " >${vpd_batch_tmp}
		${Run} "${GET_CMD}" "cat $ONECLI_CONSOLE_FILE | grep '^SYSTEM_PROD_DATA'" "${vpd_batch_tmp}" "$rest_port"
	fi

	ret=$?
	rm -f ${vpd_batch_tmp} >/dev/null 2>&1
	[ $ret != 0 ] && return
	echo ""
	while [ true ]
	do
		read -p "* Are you sure you want to change these values? [Y/N]:" ans
		if [ "x$ans" == "xy" ] || [ "x$ans" == "xY" ];then
			setVpd
			return
		elif [ "x$ans" == "xn" ] || [ "x$ans" == "xN" ];then
			return
		fi
	done
						
}

mkdir -p $VPD_LOG_DIR 1>/dev/null 2>&1
$1
