#!/bin/bash
# Copyright © 2018 - present Lenovo.  All rights reserved.
# Confidential and Proprietary.
export UXLITE_BOOTABLE=/toolscenter
export UXSPI_BOOTABLE=/toolscenter
export UXSPI_REDUCE_COPY=1

ROOT_PATH="/tmp"
#ROOT_PATH="/mnt/hgfs/myshare/20081014/lib/linuxboot"
CONFIG_FILE=${ROOT_PATH}/bomc.config
MTLIST_FILE_LINUX64=${ROOT_PATH}/menu/SYSTEM_SUPPORT_LIST.xml
MTLIST_FILE_LINUXPPC64=${ROOT_PATH}/menu/systemslistppc.xml
MTLIST_FILE=""
BOOT_ENV=""
UXSPI_FOLDER=${ROOT_PATH}/update
DSA_FOLDER=${ROOT_PATH}/dsa
UXSPI_BIN=${ROOT_PATH}/uxspi/uxspi500.sles11_64
DSA_BIN=${ROOT_PATH}/dsa/start.sh

EXTTOOL_PATH=${ROOT_PATH}

FUN_NUM=0
FUNCTIONS=""
#FUN_NUM=4
VERSION="13.1.0"
LABELSTR=""

MACHINEARRAY=""
MT_ARRAY_DSA=""
MT_ARRAY_UXSPI=""

MACHINELISTHEADER="This bootable media is created for the following machines:"
MACHINELISTSTR=""

WELCOME="Welcome to Lenovo XClarity Essentials "
DESCRIPTION="Lenovo XClarity Essentials is collection server management stand alone tools to help Deploy, Configure, Update and Diagnose your machines. This wizard will help you manage your system more efficiently." 

FUNCTIONSTR=""
FUNCTIONMAPPING=""

AUTORUNSTR=""
AUTORUNID=""

DES_DEPLOYMENT="Deployment tools help you become productive faster by minimizing the time it takes to get your systems up and running.\n"

DES_CONFIGURATION="Configuration tools allow remote scripted configuration of System x Servers and Bladecenters.\n"

DES_UPDATES="Keep your systems up-to-date and running optimally with tools that make it easy to apply the latest system software updates.\n"

DES_DIAGNOSTICS="Intelligent tools that enable rapid, remote diagnosis and resolution help minimize the costs associated with system downtime.\n"

DES_EXT_TOOL="Third party tool is what you'd like to run.\n"

SELECT_INFO="Do you want to start it now? Y(yes)/N(no)/Q(quit)"

USAGE_HANDLE_RESULT="Usage: handle_result result current_item"
USAGE_CALL_FUN="Usage: call_fun current_item"
USAGE_PARSE_SELECT="Usage: parse_select current_item"

EXT_TOOL_DIR=""

function print_welcome()
{
	echo -e ${WELCOME}"\n"
	echo -e ${DESCRIPTION}"\n"
}
function initial_label()
{
	if [ -f ${CONFIG_FILE} ]
	then
		#`dos2unix ${CONFIG_FILE}` 
		LABELSTR=`cat ${CONFIG_FILE} | grep IBM_SYSTEM_MEDIALABEL | sed 's/IBM_SYSTEM_MEDIALABEL=//'`
		LABELSTR="Discriptive name:\n   "${LABELSTR}"\n"	
	fi
}
function print_label()
{
	echo -e ${LABELSTR}	
}
#function print_machinelist()
#{
#	echo -e ${MACHINELISTSTR}
#}

function initMTList()
{
# map family name and machine type in SYSTEM_SUPPORT_LIST_2.10.xml
if [ ! -e /tmp/MT_MAP ]
then
  cat ${MTLIST_FILE} | sed '1,2d; $d; s/<system><xname>\(.*\)<\/xname><machineType>\(.*\)<\/machineType>.*/\1 - machine type \2/' > /tmp/MT_MAP
fi

if [ ! -e /tmp/DSA_MT_DISPLAY ]
then
  for mt in ${MT_ARRAY_DSA}
  do
  if cat /tmp/MT_MAP | grep $mt > /dev/null 2>&1;then
    cat /tmp/MT_MAP | grep $mt >> /tmp/DSA_MT_DISPLAY
  else
    echo "Unknown - $mt" >> /tmp/DSA_MT_DISPLAY
  fi
  done
fi

if [ ! -e /tmp/UXSPI_MT_DISPLAY ]
then
  for mt in ${MT_ARRAY_UXSPI}
  do
  if cat /tmp/MT_MAP | grep $mt > /dev/null 2>&1;then
    cat /tmp/MT_MAP | grep $mt >> /tmp/UXSPI_MT_DISPLAY
  else
    echo "Unknown - $mt" >> /tmp/UXSPI_MT_DISPLAY
  fi
  done
fi

}

function parse_machinelist()
{
	if [ -f ${CONFIG_FILE} ]
	then
	  MTLIST_FILE=${MTLIST_FILE_LINUX64}
          MT_ARRAY_DSA=`cat ${CONFIG_FILE} | grep IBM_SYSTEM_MT_DSA | sed 's/IBM_SYSTEM_MT_DSA=//' | sed 's/,/ /g'`
          MT_ARRAY_UXSPI=`cat ${CONFIG_FILE} | grep IBM_SYSTEM_MT_UXSPI | sed 's/IBM_SYSTEM_MT_UXSPI=//' | sed 's/,/ /g'`
          # map family name and machine type in SYSTEM_SUPPORT_LIST_2.10.xml
          initMTList
	fi
}
function print_dsa_machinelist()
{
	if [ -z "$MT_ARRAY_DSA" ] || echo ${MT_ARRAY_DSA} | grep -E 'NULL' > /dev/null 2>&1
	then
	       echo -e "This bootable media is not intended to run Diagnostic Tool on any system\nYou may take your own risk to continue." 
	else
		echo -e "${MACHINELISTHEADER} (to run Diagnostic Tool)"
		if echo ${MT_ARRAY_DSA} | grep -E '(all|ALL)'> /dev/null 2>&1 
		then
	 		echo "   All Intel and AMD processor-based systems supported."
		else
                    if [ -e /tmp/DSA_MT_DISPLAY ]
                    then
                      cat /tmp/DSA_MT_DISPLAY | more
                    fi
		fi
	fi
}

function print_uxspi_machinelist()
{
	if [ -z "$MT_ARRAY_UXSPI" ] || echo ${MT_ARRAY_UXSPI} | grep -E 'NULL' > /dev/null 2>&1
	then
	       echo -e "This bootable media is not intended to run Update Tool on any system\nYou may take your own risk to continue." 
	else
		echo -e "${MACHINELISTHEADER} (to run Update Tool)"
		if echo ${MT_ARRAY_UXSPI} | grep -E '(all|ALL)'> /dev/null 2>&1 
		then
	 		echo "   All Intel and AMD processor-based systems supported."
		else
		    if [ -e /tmp/UXSPI_MT_DISPLAY ]
                    then
                      cat /tmp/UXSPI_MT_DISPLAY | more
                    fi
		fi
	fi
}
function initial_function()
{
	if [ -f ${CONFIG_FILE} ]
	then
	   FUNCTIONS=`cat ${CONFIG_FILE} | grep IBM_SYSTEM_FUNCTION | sed 's/IBM_SYSTEM_FUNCTION=//'`
	   EXT_TOOL_DIR=`cat ${CONFIG_FILE} | grep IBM_SYSTEM_EXT_TOOL | sed 's/IBM_SYSTEM_EXT_TOOL=//'`
	fi
	FUNCTIONSTR="\nLenovo XClarity Essentials have following function:\n"
	FUNCTIONEND="\nEnter the item number to "
	#adding deployment
	#adding configuration
	#adding updates
	#if [ -d ${UXSPI_FOLDER} ] 
	if echo ${FUNCTIONS} | grep update> /dev/null 2>&1 
	then
		FUN_NUM=`expr $FUN_NUM + 1`
		FUNCTIONSTR=${FUNCTIONSTR}"   <"${FUN_NUM}"> Updates\n"
		FUNCTIONEND=${FUNCTIONEND}"Updates|"
		FUNCTIONMAPPING=${FUNCTIONMAPPING}" "${FUN_NUM}"->3"	
	fi
	#adding diagnostics
	#if [ -d ${DSA_FOLDER} ]
	if echo ${FUNCTIONS} | grep dsa> /dev/null 2>&1 
	then
		FUN_NUM=`expr $FUN_NUM + 1`
		FUNCTIONSTR=${FUNCTIONSTR}"   <"${FUN_NUM}"> Diagnostics\n"
		FUNCTIONEND=${FUNCTIONEND}"Diagnostics|"
		FUNCTIONMAPPING=${FUNCTIONMAPPING}" "${FUN_NUM}"->4"	
	fi
	
	
	if [ -n "$EXT_TOOL_DIR" ] 
	then
		EXTTOOL_PATH=${ROOT_PATH}/${EXT_TOOL_DIR}
		if [ -d ${EXTTOOL_PATH} ]
		then
		  FUN_NUM=`expr $FUN_NUM + 1`
		  FUNCTIONSTR=${FUNCTIONSTR}"   <"${FUN_NUM}"> 3rd Party Tool\n"
		  FUNCTIONEND=${FUNCTIONEND}"3rd Party Tool"
		  FUNCTIONMAPPING=${FUNCTIONMAPPING}" "${FUN_NUM}"->5"
    fi	
	fi
	
	FUNCTIONEND=${FUNCTIONEND}" ('q' to quit Lenovo XClarity Essentials):\n"
	FUNCTIONSTR=${FUNCTIONSTR}${FUNCTIONEND}

	 
}
function print_function()
{
	echo -e ${FUNCTIONSTR}
}

initial_autorun()
{
	
	if [ -f ${CONFIG_FILE} ]
	then
		AUTORUNSTR=`cat ${CONFIG_FILE} | grep IBM_SYSTEM_AUTORUN | sed 's/IBM_SYSTEM_AUTORUN=//'`
		#echo ${AUTORUNSTR}
	fi
	case ${AUTORUNSTR} in
	update)
		AUTORUNID=3;
		AUTORUNSTR="Updates";;
	dsa)
		AUTORUNID=4;
		AUTORUNSTR="Diagnostics";;
		
	esac
	#echo ${AUTORUNID}	
}

function print_menu()
{
	clear
	print_welcome
	print_label
	parse_machinelist
	print_function
}

function print_detail()
{
	if [ $# -ne 1 ]
	then
		echo ${USAGE_PRINT_DETAIL}
		return 
	fi

	case "$1" in
	1)
		echo -e ${DES_DEPLOYMENT};;
	2)
		echo -e ${DES_CONFIGURATION};;
	3)
		echo -e ${DES_UPDATES}
		print_uxspi_machinelist;;
	4)
		echo -e ${DES_DIAGNOSTICS}
		print_dsa_machinelist;;
	5)
		echo -e ${DES_EXT_TOOL};;
	*)
		echo "Unknow input"
		return 1;;
	esac

	echo -e ${SELECT_INFO}
}

function parse_select()
{
	if [ $# -ne 1 ]
	then
		echo  ${USAGE_PARSE_SELECT}
	fi

	while true
	do
		read SELECT
	
		case "${SELECT}" in
		Y)
			return 0;;
		y)
			return 0;;
		N)
			return 1;;
		n)
			return 1;;
		Q)
			return 2;;
		q)
			return 2;;
		*)
			#clear
			#print_detail $1;;
			echo "Invalid input"
			echo $SELECT_INFO;;
			#echo -e "\b";;
		esac
	done
}

function copy_payload()
{
	echo "Copying payload ..."
	if [ ${COPY_TO_RAMDISK} -eq 1 ]
	then
	    mount /dev/sr0 /run/initramfs/live  > /dev/null 2>&1
	fi
	files=$(ls ${UXSPI_BOOTABLE} | grep .xml | grep -v lnvgy_utl_lxce_bomc-)
	for filename in $files
	do
		cp -nfr /run/initramfs/live/${filename%.xml}.* ${UXSPI_BOOTABLE}
	done
	if [ ${COPY_TO_RAMDISK} -eq 1 ]
	then
	    umount /run/initramfs/live  > /dev/null 2>&1
	fi
}

function call_fun()
{
	if [ $# -ne 1 ]
	then
		echo ${USAGE_CALL_FUN}
		return 
	fi

	clear
	case "$1" in
	1)
		;;
	2)
		;;	
	3)
		copy_payload
		cd ${UXSPI_TUI_CMD_WORKING_DIR}
		${UXSPI_TUI_CMD};;
	4)
		${DSA_TUI_CMD};;
	5)
		cd ${EXTTOOL_PATH}	
		sh;;
	*)
		echo unknown command...;;	
	esac
}

function handle_result()
{
	if [ $# -ne 2 ]
	then
		echo ${USAGE_HANDLE_RESULT}
		return 
	fi

	if [ $1 -eq 0 ] 
	then
		call_fun $2
		print_menu
	else
		print_menu
	fi
}

function parse_input()
{
	#stty -echo
	read INPUT
	#stty echo

	if [ "${INPUT}" = "r2d2" ]
	then
	   sh
	fi
  
	if [ "${INPUT}" = "q" ] || [ "${INPUT}" = "Q" ]
	then
		echo "Goodbye!"
		exit 0
	elif [ ${INPUT} -le ${FUN_NUM} ] && [ ${INPUT} -gt 0 ]
	then
		clear
		for map in ${FUNCTIONMAPPING}
		do
			if echo ${map} | grep "${INPUT}->" > /dev/null 2>&1
			then
				PARSED_INPUT=`echo $map|grep "${INPUT}->"|sed "s/${INPUT}->//"`
			fi	
		done
		print_detail ${PARSED_INPUT}
		parse_select ${PARSED_INPUT}
		handle_result $? ${PARSED_INPUT}
	else 
		print_menu
	fi
}
	
function do_work()
{
	while true
	do
		parse_input
	done
}

#initial the label, machine type and function from the config and support list file
initial_label
#initial_machinelist
initial_function
initial_autorun

#auto run
if [ ${AUTORUNID} -gt 0 ]
then
	echo "Starting IBM ${AUTORUNSTR}...."
	sleep 5
 	clear
	call_fun ${AUTORUNID}
fi

#print the label,machine type list and function
print_menu

#do the job
do_work

