#!/bin/sh
# Copyright © 2018 - present Lenovo.  All rights reserved.
# Confidential and Proprietary.
#
# This script prepares menu(both GUI and TUI) for ToolsCenter 

#disable Crtl+z and Ctrl+c
trap "" 2 20

ROOT_PATH=/tmp
CONFIG_FILE=${ROOT_PATH}/bomc.config
BOMC_LOG_FILE=/tmp/bomc.log
BOMC_MENU_PROGRAM_CLI=""
SHOW_MENU_USAGE="Usage: show_menu.sh unattended|attended"


if [ "$1" = "unattended" ]
then
	BOMC_MENU_PROGRAM=${ROOT_PATH}/menu/unattended_menu.sh
  
	if [ "${BOMC_SOL_MODE}" = "1" ]
	then
	      echo "Calling unattended_menu.sh cli" >> ${BOMC_LOG_FILE}
    		${BOMC_MENU_PROGRAM} cli
	elif cat ${CONFIG_FILE} | grep "IBM_SYSTEM_TUI=NO" > /dev/null 2>&1 
	then 
	  echo "Calling unattended_menu.sh gui" >> ${BOMC_LOG_FILE}
		${BOMC_MENU_PROGRAM} gui
	else
	  echo "Calling unattended_menu.sh cli" >> ${BOMC_LOG_FILE}
		${BOMC_MENU_PROGRAM} cli
	fi
elif [ "$1" = "attended" ]
then
	BOMC_MENU_PROGRAM_CLI=${ROOT_PATH}/menu/menu.sh
  
	if [ "${BOMC_SOL_MODE}" = "1" ]
	then
	    echo "Calling menu.sh" >> ${BOMC_LOG_FILE}
    	${BOMC_MENU_PROGRAM_CLI}
	elif cat ${CONFIG_FILE} | grep "IBM_SYSTEM_TUI=NO" > /dev/null 2>&1 
	then 
	  	echo "Starting GUI..." >> ${BOMC_LOG_FILE}
	  	if [ "${BOOT_OS_ENV_TYPE}" = "MCP" ]
	  	then
		  	echo 'fluxbox & /tmp/menu/updategui_start.sh' > ~/.xinitrc	
		fi
		if [ "${BOOT_OS_ENV_TYPE}" = "SaLIE" ]
		then
			# Invoke curl before lxce_ux.bin
			# Hope this action can load curl from ISO, even if the ISO mount is broken, curl is still working.
			curl -h 2>&1 > /dev/null
			echo 'fluxbox & /tmp/lxce_ux/start_lxce_ux.sh' > ~/.xinitrc	
		fi
    	startx 1>$UX_LOG_DIR/show_menu.log 2>&1
	else
	   echo "Calling menu.sh" >> ${BOMC_LOG_FILE}
		${BOMC_MENU_PROGRAM_CLI}
	fi
else
	echo ${SHOW_MENU_USAGE}
fi
