# Copyright © 2017 - present Lenovo.  All rights reserved.
# Confidential and Proprietary.
echo -e "#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::#
The script gives instructions and sample commands for remote media mount/unmount
for ThinkSystem platform. Make sure \"curl\" is installed on your running OS.
User can mount an image to XCC using Samber, NFS, SFTP, etc
Note, you need to change the parameters accordingly.
e.g, IP address, image file path, image URL type/protocol, username, password, etc
See sample commands below for how to mount an image hosted at
sftp://192.168.1.3/home/image/image.iso to BMC with an IP of 192.168.1.2
#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::#\n\n"


echo -e "a) use POST command to map media from remote server"

echo "curl -k -u USERID:PASSW0RD -X POST https://192.168.1.2/redfish/v1/Managers/1/Oem/Lenovo/RemoteMap/MountImages/ --header \"Content-Type:application/json\" -d '{\"FilePath\":\"sftp://192.168.1.3/home/image/image.iso\",\"Type\":\"SFTP\",\"Username\":\"userid\",\"Password\":\"password\",\"Domain\":\"192.168.1.2\",\"Readonly\":true,\"Options\":\"ro\"}'"

echo -e "\nb) use GET command to confirm if the remote media is generated as expect:"
echo -e "curl -k -u USERID:PASSW0RD -X GET https://192.168.1.2/redfish/v1/Managers/1/Oem/Lenovo/RemoteMap/MountImages/ --header \"Content-Type:application/json\""

echo -e "\nc) use POST command to mount all the mapped images:\n"
echo -e "curl -k -u USERID:PASSW0RD -X POST https://192.168.1.2/redfish/v1/Managers/1/Oem/Lenovo/RemoteMap/Actions/LenovoRemoteMapService.Mount --header \"Content-Type:application/json\" -d '{}'"

echo -e "\nd) use POST command to unmount all the mapped images:"
echo -e "curl -k -u USERID:PASSW0RD -X POST https://192.168.1.2/redfish/v1/Managers/1/Oem/Lenovo/RemoteMap/Actions/LenovoRemoteMapService.UMount --header \"Content-Type:application/json\" -d '{}'"


