// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Acquire_Updates = function() {

    /*
     * in this file, use a combination of mt & os as talbe/div's 'index' or 'contentIndex'
     */
    var ac_progress_timer;
    var ac_content_index = 0;
    var ac_isNew_content = true;
    var ac_current_content_count = 0;
    var ac_content_count = 1;
    var ac_canceled = false;

    var ac_moving_hide = false;
    var acquire_updating = false;
    // counter: when there is error downloading some package in the current content area, +1
    // if this value is greater than 0, indicating that there need a warning at title area to notice user 
    var ac_current_warn_count = 0;
    // counter: when there is any error at the acquiring process, +1
    // if this value is greater than 0, there need a warning at summary area to notice user
    var ac_total_warn_count = 0;

    var ac_content_index_static = 0;
    var ac_content_index_static_set = false;
    var ac_success_exist = false;


    /**
     * used to calculate downloading rate
     */
    var ac_downloaded = 0;

    //buffer the html element frequently refered
    _doc = document;
     //need the explorer to parse the js file after html file loaded
    header = [];
    var noneOS = "none";
    var isUXSPI = false;
    var contentDiv = "";
    var temp_series_content_count = 0;
    var finishSyncCount = 0;

    // The parameters after --includeid
    var updateIdList = "";

    function ac_init() {
        printLog("INFO","Acquire Updates page init.");
        // clean the previous value of logfile
        setLogFile("");
        updateIdList ="";
        header = [$.i18n.prop("AcquireUpdates.Component"), $.i18n.prop("AcquireUpdates.UpdateID"), $.i18n.prop("AcquireUpdates.Size"), $.i18n.prop("AcquireUpdates.Status"), $.i18n.prop("AcquireUpdates.ReleaseDate")];
        beginAcq(_doc.getElementById("beginBtn_acquire"));
    }

    function ac_collect() {
        printLog("INFO","Next was clicked.");
        return true;
    }

    //user use 'uxspi' acquire type
    function uxsp_acquire() {
        var args = new Array();
        args.push(top.getSystemFile("oneCli"));
        args.push("update");
        args.push("acquire");
        args.push("--xml");
        // args.push("--scope");
        // args.push("latest");
        // args.push("--report");

        //set mt
        if(top.gl_OOB_Params.Enabled){
            args.push("--mt");
            args.push(top.gl_OOB_Params.MT);
        }else{
            var mtString = "";
            if (getTaskName() != top.gl_isUpdate) {
                for (var i = 0; i < top.gl_mt_list.length; i++) {
                    mtString += top.gl_mt_list[i] + ",";
                }
            }
            args.push("--mt");
            if (mtString == ""){
                mtString = top.gl_current_mt;
                args.push(mtString);
            }else{
                args.push(mtString.substring(0, mtString.length-1));
            }
        }
        

        //set os
        if(!top.gl_OOB_Params.Enabled){
            var osString = "";
            if (getTaskName() != top.gl_isUpdate) {
                for (var i = 0; i < top.gl_os_list.length; i++) {
                    osString += top.gl_os_list[i] + ",";
                }
            }
            args.push("--ostype");
            if (osString == ""){
                osString = top.gl_current_os;
                args.push(osString);
            }else{
               args.push(osString.substring(0, osString.length-1)); 
            }
        }
        
        args.push("--dir");
        args.push(top.gl_workingDir);

        //set proxy
        args.push(...add_proxy_para());

        if(top.gl_OOB_Params.Enabled){
            args.push("--ostype");
            args.push("platform");
        }
        
        args.push(...add_output_log5());

        top.store_onecli_command(args);

        printLog("INFO","run commend:" + getRunProgramCommend(args));
        runProgram(args, null, onAcqFinished);
    }

    

    function onAcqFinished(){
        acquire_updating = false;
    }

    function clearResultFiles() {
        deleteFile(top.getSupportFile("acquireResult"));
        var series = 2;
        // To avoid dead loop
        while(series<=100)
        {
            var tempFilename = top.getSupportFileBySeries("acquireResult", series)
            if(fileExists(tempFilename))
            {
                deleteFile(tempFilename);
                series++;
            }
            else
            {
                break;
            }
        }
        deleteFile(top.getSupportFile("commonResult"));
    }

    function beginAcq(ref) {
        printLog("INFO","button 'Begin' was clicked.");
        togglePrevious(false);
        toggleNext(false);
        contentDiv = $("#AcquireUpdateContentDiv").html();
        ac_content_index = 0;
        ac_current_content_count = 0;
        ac_content_count = 1;
        ac_isNew_content = true;
        acquire_updating = false;
        ac_canceled = false;
        ac_current_warn_count = 0;
        ac_total_warn_count = 0;
        ac_success_exist = false;

        _doc.getElementById("beginBtn_acquire").style.display = "none";
        _doc.getElementById("acqMsg_acquire").style.display = "block";
        _details = _doc.getElementById("details_acquire");
        _details.style.display = "block";
        //_details.innerHTML = "";

        // Preparation
        ac_content_index_static = 0;
        ac_content_index_static_set = false;
	    finishSyncCount = 0;
        clearResultFiles();
        // keep ac2_result.xml
        // remove ac_result.xml
        // ac2_result.xml is used to download image related packages, it is needed after user selects packages to download
        // but ac_result.xml must be deleted before acquiring packages because if it is not removed, the acquiring result table will display all meta packages
        // top.deleteFile(top.getSupportFile("acquireResult"));

        // for inband and oob case:
        // always use individual_acquire
        // legacy logic only support creating repository
        // add by chenhao 20170623
        // 
        if (getTaskName() == top.gl_isUpdate) {
            top.gl_isUXSP = false;
            before_individual_acquire();
        //
        } else if (top.gl_isUXSP) {
            //ac_content_count = parseInt(top.gl_mt_list.length) * parseInt(top.gl_os_list.length) > 1 ? parseInt(top.gl_mt_list.length) * parseInt(top.gl_os_list.length) : 1;
            //This "1" means the item of UXSPI
            ac_content_count = parseInt(top.gl_mt_list.length) * parseInt(top.gl_os_list.length);
            uxsp_acquire();
        } else {
            before_individual_acquire();
        }
        createAllContents();
        acquire_updating = true; // move to there to avoid it is still false even reaching showStatus_ac()
        ac_progress_timer = setInterval(showStatus_ac, 1000);
    }

    function before_individual_acquire() {
        if (getTaskName() != top.gl_isUpdate) {
            // use --includeid
            for (var i = 0; i < top.gl_su_list.length; i++) {
                updateIdList += top.gl_su_list[i] + ",";
            }
            if (updateIdList) {
                updateIdList = updateIdList.substring(0, updateIdList.length - 1);
            } else {
                updateIdList = "";
            }
            individual_acquire();
        } else {
            // use --comparexml
            rewrite_compare_result(top.gl_su_list, null, individual_acquire);
        }
    }

    //user use 'individual' acquire type
    function individual_acquire() {
        var args = new Array();
        args.push(top.getSystemFile("oneCli"));
        args.push("update");
        args.push("acquire");
        args.push("--xml");
        // args.push("--scope");
        // args.push("individual");
        //args.push("--report");

        if (getTaskName() != top.gl_isUpdate) {
            args.push("--includeid")
            args.push(updateIdList);
        } else {
            args.push("--comparexml");
            args.push(top.getSupportFile('compareResult', 'rewrite'));
        }
        
        args.push("--dir");
        args.push(top.gl_workingDir);

        // set proxy
        args.push(...add_proxy_para());
        args.push(...add_output_log5());

        // No supersede
        args.push("--nosupersede");

        args.push("--noprereq");

        top.store_onecli_command(args);

        printLog("INFO","run commend:" + getRunProgramCommend(args));
        runProgram(args, null, onAcqFinished);

    }

    function ac_cancel() {
        printLog("INFO","button 'Cancel' was clicked.");
        ac_canceled = true;
        clearInterval(ac_progress_timer);
        top.killOneCli();
        $("#AcquireUpdateContentDiv").html(contentDiv);
        //modified by youqw at 2016.10.19
        _doc.getElementById("acqMsg_acquire").style.display = "none";
        _doc.getElementById("details_acquire").style.display = "none";
        _doc.getElementById("beginBtn_acquire").style.display = "block";
        togglePrevious(true);
    }


    function showStatus_ac(success, error) {
        temp_series_content_count = 0;

        //Handled cancel behavior in ac_cancel() function
        if (ac_canceled)
            return;
        var doc = top.readTextFile(top.getSupportFile("acquireResult"));
        // One status One Times
        var acquire_updating_cache = acquire_updating;
        _updateDetailContent(doc, acquire_updating_cache);

        var series = 2;
        // To avoid dead loop
        while(series<=100)
        {
            var tempFilename = top.getSupportFileBySeries("acquireResult", series)
            if(fileExists(tempFilename))
            {
                var doc = top.readTextFile(tempFilename);
                _updateDetailContent(doc, acquire_updating_cache);
                series++;
            }
            else
            {
                break;
            }
        }

        // if (!acquire_updating 
        //    &&(ac_content_index == ac_content_count || (ac_content_index == 0 && doc == null)) //no files generated and errors occured, (doc == null) for only one content case
        //    || ac_error_happened) 
        if (!acquire_updating_cache) {   
            if (ac_content_index_static_set == false) {
                ac_content_index_static = ac_content_index;
                ac_content_index_static_set = true;
            }
            if (finishSyncCount < (ac_content_count + 1 - ac_content_index_static)) {
                finishSyncCount++;
                return;
            }
            clearInterval(ac_progress_timer);
            var resultFile;
            resultFile = top.readTextFile(top.getSupportFile("commonResult"));
            if (resultFile) //end...
            {
                var resultDom, resultMsg;
                resultDom = ezJsLib.XmlDom.parse(resultFile);
                resultMsg = ezJsLib.XmlDom.getValueByTagFromNode("MESSAGE", resultDom.documentElement);
                if (resultDom.documentElement.getElementsByTagName("ERROR").length > 0 
                    && ezJsLib.XmlDom.getValueByTagFromNode("ERROR", resultDom.documentElement) == "Yes")
                {
                    complete(0, resultMsg);
                }
                else
                {
                    complete(1, resultMsg);
                }
                setLogFile(ezJsLib.XmlDom.getValueByTag("LOGFILE", resultDom));
            } 
            else //unkown error!
            {
                complete(0, top.getComErrMsg());
            }
        }

        //It's a little ungly to include all codes into try-catch block. But I need to handle intercurrent issue
        //When the user activiate reload behavior, the app will throw exceptions because the content has been cleaned up
        // try {
        //     
        // } catch (e) {
            // do nothing...
        // }
    }

    function _updateDetailContent(doc, acquire_updating_cache) {
        if (doc == null) 
        {
            if (acquire_updating_cache) 
            {
                _doc.getElementById("acqMsg2_acquire").innerHTML = $.i18n.prop("AcquireUpdates.Connecting");
            }
            return;
        }
        var dom = ezJsLib.XmlDom.parse(doc);
        //doc is not null but dom is null
        if (dom == null) 
        {
            return;
        }

        // Record content number of this series
        var t_index = 0;
        while(true) {
            if(ezJsLib.XmlDom.getNodeByTagAndIndex("CONTENT", dom, t_index)!=null)
            {
                t_index++;
            }
            else
            {
                break;
            }
        }

        var content = ezJsLib.XmlDom.getNodeByTagAndIndex("CONTENT", dom, ac_content_index-temp_series_content_count);
        if (content == null) 
        {
            //refresh the progress bar
            _updateProgress(content);
            temp_series_content_count += t_index;
            return;
        }
        
        temp_series_content_count += t_index;

        var mt = ezJsLib.XmlDom.getValueByTagFromNode("MT", content);
        // For BMU downloading
        if((top.gl_isUXSP && hasPurleyOrOther(top.gl_mt_list) == "purley" && top.gl_selectPlatform)
             || (top.gl_OOB_Params.Enabled)){ 
            if (mt == "") {
                mt = "BMU";
            }
        }
        var os = ezJsLib.XmlDom.getValueByTagFromNode("OS", content);
        var total = ezJsLib.XmlDom.getValueByTagFromNode("TOTAL", content);
        var windowsInsensitive = (getTaskName() == top.gl_isUpdate) && !top.gl_OOB_Params.Enabled && top.gl_current_os=="windows";
        // Add the suffix "UXSP". If not, this 'index' will lead to the same table as 'Update_Selection'
        var index = top.gl_isUXSP ? ((mt + getOSKey(os, windowsInsensitive)).toLowerCase() + "UXSP") : "0";
        // fix a problem that MT is ac2_result.xml is NONE, hence here index will be none
        // in this case, skip this loop
        if (index == 'none' || index == 'noneUXSP') return;
        
        updateTitle(index, "Acquiring");
        //update content coming...
        //if (top.gl_isUXSP) {
        _doc.getElementById("acqMsg1_acquire").style.display = "block";
        _doc.getElementById("contentProgress_acquire").style.display = "block";
        _doc.getElementById('cancelBtn_acquire').style.marginLeft = "36px";
        //}
        if (ac_isNew_content) 
        {
            if (total > 0)
                showPlusIcon(index);
            updateTotal(index, total);
            ac_current_content_count = total;
            var table = createTable(index, true);
            for (var i = 0; i < total; i++) 
            {
                //default consider that its a full xml file, including all nodes
                var component = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("COMPONENT", content, i);
                var updateId = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("UPDATEID", content, i);
                var description = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("DESCRIPTION", content, i);
                var size = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("SIZE", content, i);
                var statusValue = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("STATUS", content, i);
                var releaseDate = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("RELEASEDATE", content, i);

                //add a new row
                var newRow = table.insertRow(-1);

                var newCell1 = newRow.insertCell(-1);
                if (component == "Undefined")
                    component = "UXSP";
                newCell1.innerHTML = component;
                newCell1.title = component;
                newCell1.className = "EntityTableCell";

                var newCell4 = newRow.insertCell(-1);
                newCell4.innerHTML = updateId;
                newCell4.title = description.replace(/ \(InstallXML\)/g, "");
                newCell4.className = "EntityTableCell";

                var newCell6 = newRow.insertCell(-1);
                newCell6.innerHTML = formatNumberWithComma(size);
                newCell6.title = formatNumberWithComma(size);
                newCell6.className = "EntityTableCell";
                newCell6.align = "right";

                var newCell7 = newRow.insertCell(-1);
                if('' != statusValue) {
                    if (statusValue == 'Not Started') {
                        newCell7.innerHTML = "<img src='images/statusStopped_obj16.gif'>" + statusValue;
                    } else {
                        newCell7.innerHTML = "<img src='images/statusNormal_obj16.gif'>" + statusValue;
                    }
                    newCell7.title = statusValue;
                } else {
                    // newCell7.title = "<img src='images/statusNormal_obj16.gif'>" + "Not Started";
                    newCell7.innerHTML = "<img src='images/statusStopped_obj16.gif'>" + "Not Started";
                    newCell7.title =  'Not Started';
                }
                
                newCell7.className = "EntityTableCell";

                var newCell9 = newRow.insertCell(-1);
                newCell9.innerHTML = releaseDate;
                newCell9.title = releaseDate;
                newCell9.className = "EntityTableCell";

                ac_isNew_content = false;
            }
            if (total == 0) 
            {
                updateTitle(index, "None");
                ac_isNew_content = true;
                //start parsing new content
                ac_content_index++;
            }
        } 
        else 
        {
            var package_finished_count = 0;
            table = _doc.getElementById("table" + index);
            for (var i = 0; i < total; i++) 
            {
                var statusValue = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("STATUS", content, i);
                var tSize = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("SIZE", content, i);
                var aSize = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("ACQUIREDSIZE", content, i);
                var releaseDate = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("RELEASEDATE", content, i);
                table.rows[1 + i].cells[3].title = statusValue;
                table.rows[1 + i].cells[4].innerHTML = releaseDate;
                table.rows[1 + i].cells[4].title = releaseDate;
                if (statusValue == "Already Downloaded") 
                {
                    table.rows[1 + i].cells[3].innerHTML = "<img src='images/statusNormal_obj16.gif'>" + statusValue;

                    package_finished_count++;
                    ac_success_exist = true;
                    //}else if(statusValue == "Acquiring"){
                } 
                else if (statusValue.indexOf("Acquiring") != -1) 
                {
                    /*
                     * If the cli exits abnormally when downloading, the status of the UXSP will be always "acquiring",
                     * and the status on the xml won't be changed.
                     * In this case, what we need to do is to skip this content to next content because the next content maybe ok        *
                     */
                    if (!acquire_updating_cache) 
                    {
                        table.rows[1 + i].cells[3].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + statusValue;
                        updateTitle(index, "Error");
                        ac_isNew_content = true;
                        //start parsing new content
                        ac_content_index++;
                        return;
                    } 
                    else 
                    {
                        table.rows[1 + i].cells[3].innerHTML = "<img src='images/progress_anim2_small.gif'>" + statusValue + "(" + formatData(aSize / tSize * 100) + "%)";
                        updateTitle(index, statusValue);
                    }
                } 
                else if (statusValue == "Done") 
                {
                    table.rows[1 + i].cells[3].innerHTML = "<img src='images/statusSuccess_obj16.gif'>" + statusValue;
                    package_finished_count++;
                    ac_success_exist = true;
                } 
                else if (statusValue == "Error") 
                {
                    table.rows[1 + i].cells[3].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + statusValue;
                    updateTitle(index, "Error");
                    package_finished_count++;
                    ac_current_warn_count++;
                } 
                else 
                {
                    if (!acquire_updating_cache) 
                    {
                        updateTitle(index, "Error");
                        ac_isNew_content = true;
                        //start parsing new content
                        ac_content_index++;
                        return;
                    }
                }
            }
            if (package_finished_count == ac_current_content_count) 
            {
                ac_total_warn_count += ac_current_warn_count;
                if (ac_current_warn_count > 0) {
                    updateTitle(index, "Warning");
                } else {
                    updateTitle(index, "Done");
                }
                // reset ac_current_warn_count for new content
                ac_current_warn_count = 0;

                ac_isNew_content = true;
                //start parsing new content
                ac_content_index++;
            }
        }
        _updateProgress(content);
    }

    function _updateProgress(content) {
        if (content == null) {
            if (ac_isNew_content) {
                //if content is null, restore the package downloading progress bar to zero
                _doc.getElementById("meterValue_acquire").style.marginRight = "100%";
                _doc.getElementById("acqMsg2_acquire").innerHTML = $.i18n.prop("AcquireUpdates.Waitting");
            }
            return;
        }
        var total = ezJsLib.XmlDom.getValueByTagFromNode("TOTAL", content);
        var currentUpdateId = ezJsLib.XmlDom.getValueByTagFromNode("CURRENTUPDATEID", content);
        var currentUpdateIdIndex = -1;
        for (var i = 0; i < total; i++) {
            var updateId = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("UPDATEID", content, i);
            if (updateId == currentUpdateId) {
                currentUpdateIdIndex = i;
                break
            }
        }
        // Bug 109854 - [OneGui_all os] OneGui show overall process do not correct
        // if (currentUpdateIdIndex == -1) {
        //     return;
        // }

        var total = 0; //kb
        var updateId = "";
        var rate = 0; //kb/s
        var packages = content.getElementsByTagName("PACKAGE");
        //progress of contents...
        if (/**top.gl_isUXSP && **/ac_content_index < ac_content_count) {
            _doc.getElementById("acqMsg1_acquire").innerHTML = $.i18n.prop("AcquireUpdates.WarningMsg1")+": " + (ac_content_index+1) + " / " + " " + (ac_content_count) + " " + $.i18n.prop("AcquireUpdates.updatepacks");
            _doc.getElementById("contentMeter_acquire").style.marginRight = formatData((1 - ac_content_index / ac_content_count) * 100) + "%";
        }

        // Bug 109854 - [OneGui_all os] OneGui show overall process do not correct
        if (currentUpdateIdIndex == -1) {
            return;
        }

        /************************************************************/
        /* New process bar, percentage of the individual update     */
        /************************************************************/
        ac_downloaded = packages[currentUpdateIdIndex].getElementsByTagName("ACQUIREDSIZE")[0].childNodes[0].nodeValue;
        rate = packages[currentUpdateIdIndex].getElementsByTagName("DOWNLOADSPEED")[0].childNodes[0].nodeValue;
        total = packages[currentUpdateIdIndex].getElementsByTagName("SIZE")[0].childNodes[0].nodeValue;
        updateId = packages[currentUpdateIdIndex].getElementsByTagName("UPDATEID")[0].childNodes[0].nodeValue;
        var statusValue = packages[currentUpdateIdIndex].getElementsByTagName("STATUS")[0].childNodes[0].nodeValue;
        if (packages.length != 0) {
            _doc.getElementById("meterValue_acquire").style.marginRight = formatData((1 - ac_downloaded / total) * 100) + "%";
            if (statusValue == "Already Downloaded")
                _doc.getElementById("acqMsg2_acquire").innerHTML = $.i18n.prop("AcquireUpdates.Acquiring")+" [" + updateId + "]<br>" + ac_downloaded + " / " + total + " KB";
            else
                _doc.getElementById("acqMsg2_acquire").innerHTML = $.i18n.prop("AcquireUpdates.Acquiring")+" [" + updateId + "]<br>" + ac_downloaded + " / " + total + " KB (" + rate + " " + $.i18n.prop("AcquireUpdates.kbsec") + ")";
        } else //empty content
        {
            _doc.getElementById("meterValue_acquire").style.marginRight = "0%";
            _doc.getElementById("acqMsg2_acquire").innerHTML = $.i18n.prop("AcquireUpdates.Acquiring")+" (0 / 0) - 100% " + $.i18n.prop("AcquireUpdates.Completed");
        }
    }

    function formatData(input) {
        var per = input.toString();
        if (per.indexOf(".") > 0)
            per = per.substring(0, per.indexOf(".") + 3);
        return per;
    }

    //if downloads finished, execute this
    function complete(c, msg) {
        _doc.getElementById("acqMsg_acquire").style.display = "none";
        var temp;
        temp = msg.split("\n");
        var msg2;
        msg2 = temp.join("<br>");
        switch (c) {
            case 0: //error
                _doc.getElementById("noMsg_acquire").style.display = "block";
                _doc.getElementById("noMsg2_acquire").innerHTML = $.i18n.prop("AcquireUpdates.WarningMsg5")+" <br>"+$.i18n.prop("AcquireUpdates.WarningMsg6") + msg;
                break;
            case 1:
                _doc.getElementById("cplMsg_acquire").style.display = "block";
                if (ac_total_warn_count > 0) {
                    $("#cplIcon").attr("src", "images/statusWarning.png");
                    msg2 += $.i18n.prop("AcquireUpdates.ErrorDownloadPackage");
                } else {
                    $("#cplIcon").attr("src", "images/statusSuccess.png");
                }
                _doc.getElementById("cplMsg2_acquire").innerHTML = msg2;
                break;
        }
        toggleNext(ac_success_exist);
        togglePrevious(true);
        
    }

    function openNoUpdatesURL() {
        var mywidth = 600;
        var myheight = 400;
        var myleft = (screen.width - mywidth) / 2;
        var mytop = (screen.height - myheight) / 2;
        var logOpts = 'width=' + mywidth + ', height=' + myheight;
        logOpts += ', top=' + mytop + ', left=' + myleft;
        logOpts += ', directories=no';
        logOpts += ', location=no';
        logOpts += ', menubar=yes';
        logOpts += ', resizable=yes';
        logOpts += ', scrollbars=yes';
        logOpts += ', status=no';
        logOpts += ', toolbar=no';
        logOpts += ', close=yes';
        logOpts += ', show=true';
        logOpts += ', title=Lenovo XClarity Essentials UpdateXpress';
        /*
        var logContent = top.readTextFile(top.pathJoin(top.getSupportDir(), "noUpdate.html"));
        logContent = "<HTML><BODY><PRE>" + logContent + "<\/PRE><\/BODY><\/HTML>";
        top.writeTextFile(top.getSupportFile("logHtml"), logContent);
        */
        var logWindow = window.open("./content/noUpdates.html", "", logOpts);
        if (window.focus) logWindow.focus();
    }

    /**
     * update 'total' parameter in content title
     */
    /*Style: 'resizable,toolbar,status,menubar,personalbar,location,directories,titlebar,close,scrollbars'*/
    function updateTotal(index, total) {
        var spans = _doc.getElementById(TITLE_PRE + index).getElementsByTagName("span");

        if (total == 0)
            spans[0].innerHTML = "("+$.i18n.prop("AcquireUpdates.WarningMsg2")+" <a href=\"javascript:void 0\" onclick=Acquire_Updates.openNoUpdatesURL()> "+$.i18n.prop("AcquireUpdates.WarningMsg4")+"</a>)";
        else
            spans[0].innerHTML = total + " " + $.i18n.prop("AcquireUpdates.Updates") + " ";
    }

    /**
     * before any download begins, show all the waiting contents first.
     */
    function createAllContents() 
    {
        if(!top.gl_isUXSP) 
        {
            // Under individual mode, all path will lead user to select the packages on the prev selection page.
            createContent(null, null, null, 0, createTitle);
            return;
        }

        // Do Update
        if (getTaskName() == top.gl_isUpdate) 
        {
            if(top.gl_OOB_Params.Enabled) 
            {
                // Under OOB UXSP mode, only the packages which are OS independent will be download.
                var tempOS = noneOS;
                if (hasPurleyOrOther([top.gl_OOB_Params.MT]) == "purley") {
                    tempOS = "platform";
                }
                var index = (top.gl_OOB_Params.MT + tempOS).toLowerCase();
                createContent("Machine", top.gl_OOB_Params.MT, getOSDisplayName(tempOS), index, createTitle);
            }
            else
            {
                // Under Local UXSP mode, only the packages which are OS matched will be download.
                var index = (top.gl_current_mt + top.gl_current_os).toLowerCase();
                createContent("Machine", top.gl_current_mt, getOSDisplayName(top.gl_current_os), index, createTitle);
            }

            // Add BMU section, only for OOB and UXSP
            if(top.gl_OOB_Params.Enabled) 
            {
                var tempMT = "BMU";
                var tempOS = noneOS;
                var index = (tempMT + tempOS).toLowerCase();
                createContent("", tempMT, tempOS, index, createTitle);
            }

            return;
        }
        
        // Build local repo mode, users may select multi MTs or OSs.
        for (var i = 0; i < top.gl_xname_mt_list.length; i++) 
        {
            var a = top.gl_xname_mt_list[i];
            if (a[2] == "0") //unselected
                continue;
            var xname = a[0];
            var mt = a[1];
            for (var j = 0; j < top.gl_os_list.length; j++) 
            {
                var os = top.gl_os_list[j];
                var index = (mt + os).toLowerCase() + "UXSP";
                createContent(xname, mt, getOSDisplayName(os), index, createTitle);
            }
        }
        
        if(top.gl_isUXSP && hasPurleyOrOther(top.gl_mt_list) == "purley" && top.gl_selectPlatform) 
        {
            var tempMT = "BMU";
            var tempOS = noneOS;
            var index = (tempMT + tempOS).toLowerCase() + "UXSP";
            createContent("", tempMT, tempOS, index, createTitle);
        }
    }

    /**
     * create a title bar for a content
     */
    function createTitle(xname, mt, os, index, contentDiv) {
        var titleInnerHTML = new Array();
        titleInnerHTML.push("<div class='ContentTitleDiv' id='" + TITLE_PRE + index + "' onclick='toggleContent(this)'>");
        titleInnerHTML.push("<img style='margin-left:18px;' alt=\"Not Started\" src=\"images/statusStopped_obj16.gif\">&nbsp;");
        if (top.gl_isUXSP) {
            if (!isUXSPI) {
                titleInnerHTML.push(xname + " type " + mt + " - " + os + " - <span></span>");
            } else {
                titleInnerHTML.push($.i18n.prop("AcquireUpdates.WarningMsg3")+"<span></span>");
            }
        } else
            titleInnerHTML.push($.i18n.prop("AcquireUpdates.Individual") + " - <span></span>");
        titleInnerHTML.push("</div>");
        contentDiv.innerHTML = titleInnerHTML.join("");
    }

    return {
        name: "Acquire_Updates",
        index: 0,
        init: ac_init,
        nextAction: ac_collect,
        previousAction: function() {
            printLog("INFO","Previous was clicked.");
            toggleNext(true);
            return true;
        },  
        ac_cancel: ac_cancel,
        beginAcq: beginAcq,
        openNoUpdatesURL: openNoUpdatesURL,
        importId: '#import_acquire_updates',
        selectorId: '.acquire_updates',
        title: "Navi.AcquireUpdates",
        needRefresh: true
    }
}();