// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Machine_Types = function() {
	
	/*********************************
	sysCount is used to tag ids of all candidates.
	This value will only increase when the user adds a new machine type.
	If the user remove an existing machine type, this value won't decrease.
	So we need to use try and catch block to embrace every code which is used
	to traverse all candidates.
	*********************************/
	var sysCount = 0;
	/********************************
	This field is used to record actual number of candidates.
	*********************************/
	var actualCount = 0;
	/********************************
	This field is used to record original count.
	*********************************/
	var oriCount = 0;
	var updateListResultFile = "";
	
	function machine_types_init()
	{
		printLog("INFO","Machine Types page init.");
	    var configFile;
	    updateListResultFile = top.pathJoin(top.getSupportDir(), top.BUILD_FIX_ID+".xml");
	    try
	    {

	        configFile = top.readTextFile(top.getSupportFile("configList"));
	        if (configFile == null)
	        {
	            throw $.i18n.prop("MachineType.NoFile");
	        }
	        var cfDom = ezJsLib.XmlDom.parse(configFile);
	        top.gl_configlist_time_stamp = ezJsLib.XmlDom.getValueByTag("timestamp", cfDom);
	        populateSysList(cfDom);
	    }
	    catch (e)  						//load config sys file failed, load default one
	    {
	        //alert("load default");
	        restoreDefault(false);
	    }
	    //}
	}

	function mt_collect()
	{
		printLog("INFO","Next was clicked.");
	    var mt_list = new Array();
	    top.gl_config_list = new Array();
	    /**
	     * Use two recursion to make that new machine types added by the usr will be in the header of the list
	     */
	    for (var i = oriCount; i < sysCount; i++)
	    {
	        try
	        {
	            var a = new Array();
	            a.push(document.getElementById("sysRow" + i).cells[1].innerHTML);
	            a.push(document.getElementById("sysRow" + i).cells[2].innerHTML);
	            if (document.getElementById("sysMT" + i).checked == true)
	            {
	                mt_list.push(document.getElementById("sysMT" + i).value);
	                a.push("1");
	            }
	            else
	            {
	                a.push("0");
	            }
	            //It's a hidden field used to indicate whether there is UXSP for this machine
	            a.push(document.getElementById("sysRow" + i).cells[3].innerHTML);
	            top.gl_config_list.push(a);
	        }
	        catch (e)
	        {
	            ;
	        }
	    }
	    for (var i = 0; i < oriCount; i++)
	    {
	        try
	        {
	            var a = new Array();
	            a.push(document.getElementById("sysRow" + i).cells[1].innerHTML);
	            a.push(document.getElementById("sysRow" + i).cells[2].innerHTML);
	            if (document.getElementById("sysMT" + i).checked == true)
	            {
	                mt_list.push(document.getElementById("sysMT" + i).value);
	                a.push("1");
	            }
	            else
	            {
	                a.push("0");
	            }
	            //It's a hidden field used to indicate whether there is UXSP for this machine
	            a.push(document.getElementById("sysRow" + i).cells[3].innerHTML);
	            top.gl_config_list.push(a);
	        }
	        catch (e)
	        {
	            ;
	        }
	    }
	    top.gl_store_mt = true;
	    top.gl_mt_list = new Array();
	    for (var i = 0; i < mt_list.length; i++)
	    {
	        var flag = false;
	        //remove duplicate items
	        for (var j = 0; j < top.gl_mt_list.length; j++)
	        {
	            if (mt_list[i] == top.gl_mt_list[j])
	            {
	                flag = true;
	                break;
	            }
	        }
	        if (!flag)
	            top.gl_mt_list.push(mt_list[i]);
	    }
	    if (top.gl_mt_list.length < 1)
	    {
	        alert($.i18n.prop("MachineType.WarnMsg1"));
	        return false;
	    }
	    else
	    {
	        top.gl_mt_list.sort();			//sort mt_list
	        sortConfigList();
	    }
	    // when leave , write TempConfig file
		// writeDynamicConfigFile();
	    writeConfigFile();
	    return true;
	}

	function checkAll(ref)
	{
		printLog("INFO","check box 'select/deselect all' "+(ref.checked?"checked.":"unchecked."));
	    if (ref.checked)
	        document.getElementById("removebtn").disabled = false;
	    else
	        document.getElementById("removebtn").disabled = true;
	    for (var i = 0; i < sysCount; i++)
	    {
	        try
	        {
	            if (ref.checked)
	                document.getElementById("sysRow" + i).className = "RowSelected";
	            else
	                document.getElementById("sysRow" + i).className = "RowUnselected";
	            if (document.getElementById("sysRow" + i).style.display != "none")
	                document.getElementById("sysMT" + i).checked = ref.checked;
	        }
	        catch (e)
	        {
	            ;
	        }
	    }
	}

	function toggleRowSelect(id, ref)
	{
		printLog("INFO", id + " " + (ref.checked?" checked.":" unchecked."));
	    if (ref.checked)
	    {
	        document.getElementById(id).className = "RowSelected";
	        document.getElementById("removebtn").disabled = false;
	        for (var i = 0; i < sysCount; i++)
	        {
	            try
	            {
	                if (document.getElementById("sysRow" + i).style.display == "none")
	                    continue;
	                if (!document.getElementById("sysMT" + i).checked)
	                    return;
	            }
	            catch (e)
	            {
	                ;
	            }
	        }
	        document.getElementById("checkAll").checked = true;
	    }
	    else
	    {
	        document.getElementById(id).className = "RowUnselected";
	        document.getElementById("checkAll").checked = false;
	        for (var i = 0; i < sysCount; i++)
	        {
	            try
	            {
	                if (document.getElementById("sysRow" + i).style.display == "none")
	                    continue;
	                if (document.getElementById("sysMT" + i).checked)
	                    return;
	            }
	            catch (e)
	            {
	                ;
	            }
	        }
	        document.getElementById("removebtn").disabled = true;
	    }
	}

	function populateSysList(dom)
	{

	    resultStr = "";
	    var root = dom.documentElement;
	    var allSystems = root.getElementsByTagName("system");
	    var i = 0;
	    var j = 0;
	    var sa = true;
	    //keep the display position of current machine type
	    var pos = -1;
	    //indicate whether there is a default selection in the config file
	    var selected = false;

	    oriCount = actualCount = sysCount = allSystems.length;
	    if (sysCount == 0)
	        sa = false;

	    resultStr = "<table id=\"mttable\" cellpadding=\"2\" cellspacing=\"0\" border=\"1\" style=\"width:100%;\">";
	    resultStr += "	<thead><tr>";
	    resultStr += "		<td class='EntityTableHeaderMTOS' title='select/deselect all'><input type='checkbox' onclick=\"Machine_Types.checkAll(this);\" id='checkAll'></td>";
	    resultStr += "		<td class='EntityTableHeaderMTOS'><div id='productFamilyBtn' type='CaseInsensitiveString' colNo='1' style='cursor:pointer;' onclick='Machine_Types.sortMTTable(event)'>"+$.i18n.prop("MachineType.Product")+"<div></td>";
	    resultStr += "		<td class='EntityTableHeaderMTOS'><div id='machineTypeBtn' type='CaseInsensitiveString' colNo='2' style='cursor:pointer;' onclick='Machine_Types.sortMTTable(event)'>"+$.i18n.prop("MachineType.MainHeader")+"<div></td>";
	    resultStr += "	</tr></thead>\r\n";

	    for (i = 0; i < sysCount; i++)
	    {
	        var mt = allSystems.item(i).childNodes[1].firstChild.nodeValue;
	        var sl = allSystems.item(i).childNodes[2].firstChild.nodeValue;
	        var nu = allSystems.item(i).childNodes[3].firstChild.nodeValue;

	        if (top.gl_isUXSP && nu == "1")
	        {
	            //used to keep the machines which do not include UXSP
	            resultStr += "<tr id='sysRow" + i + "' style='display:none;'>";
	            resultStr += "<td class='EntityTableCellMTOS'><input onclick=\"Machine_Types.toggleRowSelect('sysRow" + i + "', this);\" type='checkbox' value = " + mt + " name='sys' id='sysMT" + i + "'></td>";
	        }
	        else if (sl == "1")
	        {
	            resultStr += "<tr id='sysRow" + i + "' class='RowSelected'>";
	            resultStr += "<td class='EntityTableCellMTOS'><input onclick=\"Machine_Types.toggleRowSelect('sysRow" + i + "', this);\" type='checkbox' value = " + mt + " name='sys' id='sysMT" + i + "' checked></td>";
	            selected = true;
	        }
	        else
	        {
	            resultStr += "<tr id='sysRow" + i + "'>";
	            resultStr += "<td class='EntityTableCellMTOS'><input onclick=\"Machine_Types.toggleRowSelect('sysRow" + i + "', this);\" type='checkbox' value = " + mt + " name='sys' id='sysMT" + i + "'></td>";
	            sa = false;
	        }

	        if (mt == top.gl_current_mt)
	        {
	            pos = i;
	        }
	        //for (j = 0; j < allSystems.item(i).childNodes.length; j++)
	        for (j = 0; j < 2; j++)
	        {
	            if (allSystems.item(i).childNodes[j].firstChild)
	                resultStr += "<td class='EntityTableCellMTOS'>" + allSystems.item(i).childNodes[j].firstChild.nodeValue + "</td>";
	        }

	        if (allSystems.item(i).childNodes[3].firstChild)
	            resultStr += "<td class='EntityTableCellMTOS' style='display:none;'>" + allSystems.item(i).childNodes[3].firstChild.nodeValue + "</td>";

	        resultStr += "</tr>";

	    }
	    resultStr += "</table>";
	    document.getElementById("systemsList").innerHTML = resultStr;

	    if (!selected && pos != -1)
	        document.getElementById("sysMT" + pos).checked = true;

	    if (!selected && pos == -1)
	        document.getElementById("removebtn").disabled = true;
	    else
	        document.getElementById("removebtn").disabled = false;

	    if (sa)
	        document.getElementById("checkAll").checked = true;

	}

	function showaddsystem(status)
	{
	    if (status)
	    {
			printLog("INFO","module 'addSystem' was shown.");
	        document.getElementById("systemsList").style.height = "15em";
	        document.getElementById("addSystem").style.display = "";
	    }
	    else
	    {
			printLog("INFO","module 'addSystem' was Hidden.");
	        document.getElementById("systemsList").style.height = "20em";
	        document.getElementById("addSystem").style.display = "none";
	        clearUserInputForAddSystem();
	    }
	}

	function addsystemitem()
	{
		printLog("INFO","button 'Ok' was clicked.");
	    var family = document.getElementById("txtfamily").value;
	    family = family.trim();
	    if (family == "")
	    {
	        alert($.i18n.prop("MachineType.WarnMsg2"));
	        document.getElementById("txtfamily").value = "";
	        return;
	    }
	    var mt = document.getElementById("txtmachinetype").value;
	    mt = mt.trim();
	    var regExp = /^[a-zA-Z\d]{4}$/gi;
	    if (!mt.match(regExp))
	    {
	        alert($.i18n.prop("MachineType.WarnMsg3"));
	        document.getElementById("txtmachinetype").value = "";
	        return;
	    }

	    var mttable = document.getElementById("mttable");
	    if (isInMTList(family, mt, mttable.rows)) 		//already in the list
	    {
	        alert($.i18n.prop("MachineType.WarnMsg4",family,mt));
	        return;
	    }

	    document.getElementById("checkAll").disabled = false;
	    //var x = mttable.insertRow(actualCount + 1);
	    var x = mttable.insertRow(1);
	    x.setAttribute("id","sysRow" + sysCount);
	    x.className = "RowSelected";
	    var cell0 = x.insertCell(0);
	    cell0.innerHTML = "<input onclick=\"Machine_Types.toggleRowSelect('sysRow" + sysCount + "', this);\" type='checkbox' value = " + mt + " name='sys' id='sysMT" + sysCount + "' checked>";
	    cell0.className = "EntityTableCellMTOS";
	    var cell1 = x.insertCell(1);
	    cell1.innerHTML = family;
	    cell1.className = "EntityTableCellMTOS";
	    var cell2 = x.insertCell(2);
	    cell2.innerHTML = mt;
	    cell2.className = "EntityTableCellMTOS";
	    var cell3 = x.insertCell(3);
	    cell3.style.display = "none";
	    // NoUXP should always be 0
	    /*
	    if (top.gl_isUXSP)
	        cell3.innerHTML = "0";
	    else
	        cell3.innerHTML = "1";
	    */
	    cell3.innerHTML = "0";
	    cell3.className = "EntityTableCellMTOS";

	    showaddsystem(false);
	    clearUserInputForAddSystem();
	    actualCount++;
	    sysCount++;
	    document.getElementById("removebtn").disabled = false;
	}

	function clearUserInputForAddSystem() {
		document.getElementById("txtfamily").value = "";
		document.getElementById("txtmachinetype").value = "";
	}

	/*
	 * check if the family-mt already exists in the list
	 */
	function isInMTList(family, mt, rows)
	{
	    for (var i = 1; i < rows.length; i++)
	    {
	        if (rows[i].cells[2].innerHTML == mt)
	            return true;
	    }
	    return false;
	}

	function deleteitem()
	{
		printLog("INFO","button 'Remove' was clicked.");
	    if (!window.confirm($.i18n.prop("MachineType.TipsMsg1")))
	        return;
	    var mttable = document.getElementById("mttable");
	    for (var i = 1; i < mttable.rows.length;)
	    {
	        if (mttable.rows[i].cells[0].firstChild.checked)
	        {
	            mttable.deleteRow(i);
	            actualCount--;
	        }
	        else
	            i++;
	    }
	    if (document.getElementById("checkAll").checked)
	    {
	        document.getElementById("checkAll").checked = false;
	        document.getElementById("checkAll").disabled = true;
	    }
	    document.getElementById("removebtn").disabled = true;
	    
	}

	function toggleElementsStatus(disable) {
	    var buttons = document.getElementsByTagName("input");
	    for (var i = 0; i < buttons.length; ++i) {
	        if (buttons[i].type == "button") {
	            buttons[i].disabled = disable;
	        }
	    }
	    var table = document.getElementById("mttable");
	    table.disabled = disable;
	    var selects = table.getElementsByTagName("input");
	    for (var i = 0; i < selects.length; ++i) {
	    	if (selects[i].type == "checkbox" && selects[i].id != "") {
	    		selects[i].disabled = disable;
	    	}
	    }
	    togglePrevious(!disable);
	    toggleNext(!disable);
	}

	function writeSystemsListFile(resultArray) {
		var root = '<?xml version="1.0" ?>\n';
		root += "<root>\n";
		for (var i = 0; i < resultArray.length; i++) {
			var commaIndex = resultArray[i].indexOf(",");
			var xName = resultArray[i].substr(0, commaIndex);
			var machineType = resultArray[i].substr(commaIndex + 1);
			root += "<system><xname>" + xName + "</xname><machineType>" + machineType + "</machineType><selected>0</selected><noUXSP>0</noUXSP></system>\n"
		}
		root += "</root>\n";
		top.writeTextFile(top.getSupportFile("configList"), root);
	}

	function updateListCallback(success) {
		top.hideBmcWaitingMsg();
		// get update list fail:
		if (!success) {
			toggleElementsStatus(false);
			alert($.i18n.prop("MachineType.FailedToGetSystemList"));
		} else {
			try {
				var resultFile = top.readTextFile(updateListResultFile);
				var resultDom = ezJsLib.XmlDom.parse(resultFile);
				var resultProperty = ezJsLib.XmlDom.getValueByTagFromNode("PROPERTY.ARRAY", resultDom.documentElement);
				var resultStr = resultProperty.toString();
				resultStr = resultStr.trim();
				var resultArray = resultStr.split("\n");
				for (var i = 0; i < resultArray.length; i++) {
					resultArray[i] = resultArray[i].trim();
					resultArray[i] = resultArray[i].replace("-[", ",");
					resultArray[i] = resultArray[i].replace("]-", "");
				}
				$("#systemsList").empty();
				deleteFile(top.getSupportFile("configList"));
				writeSystemsListFile(resultArray);
				var systemsListFile = top.readTextFile(top.getSupportFile("configList"));
				populateSysList(ezJsLib.XmlDom.parse(systemsListFile));
				toggleElementsStatus(false);
			} catch(e) {
				toggleElementsStatus(false);
				alert($.i18n.prop("MachineType.FailedToGetSystemList"));
			}
		}
	}

	/**
	 * update machinetype list.  */
	function UpdateList()
	{
		printLog("INFO","button 'Update List' was clicked.");
	    var args = new Array();
	    args.push(top.getSystemFile("oneCli"));
        args.push("update");
        args.push("acquire");
        args.push("--xml");
        args.push("--scope");
        args.push("individual");
        args.push("--metaonly");
        args.push("--dir");
        args.push(top.getSupportDir());
        args.push(...add_output_log5());

	    args.push(...add_proxy_para());

	    args.push("--includeid");
	    args.push(top.BUILD_FIX_ID);
	    args.push("--nosupersede");

	    // delete the previous result file
	    deleteFile(updateListResultFile);
		toggleElementsStatus(true);
		top.showBmcWaitingMsg();
		printLog("INFO","run commend:" + getRunProgramCommend(args));
	    runProgram(args, null, updateListCallback);
	}

	/**
	 * show the default machinetype list. However, until real acquisition begins, the config xml file won't be changed
	 */
	function restoreDefault(isManual)
	{
		printLog("INFO","function restoreDefault begin.");
	    deleteFile(top.getSupportFile("configList"));
	    var defaultFile = top.readTextFile(top.getSystemFile("mtList"));
		populateSysList(ezJsLib.XmlDom.parse(defaultFile));
		if (isManual)
			alert($.i18n.prop("MachineType.RestoreDefaultDone"));
		printLog("INFO","function restoreDefault end.");
	}

	/**
	 * according to sorted top.gl_mt_list, get a sorted top.gl_config_list
	 */
	function sortConfigList()
	{
	    top.gl_xname_mt_list = new Array();
	    for (var i = 0; i < top.gl_mt_list.length; i++)
	    {
	        var a = new Array();
	        var marketN = "";
	        for (var j = 0; j < top.gl_config_list.length; j++)
	        {
	            if (top.gl_mt_list[i] == top.gl_config_list[j][1] && top.gl_config_list[j][2] == "1")
	            {
	                marketN += top.gl_config_list[j][0] + "/";
	            }
	        }
	        a.push(marketN.substr(0, marketN.length - 1));
	        a.push(top.gl_mt_list[i]);
	        a.push("1");
	        top.gl_xname_mt_list.push(a);
	    }
	}

	/***************************************************/
	/**************** sort table ***********************/
	/***************************************************/
	var INCREASE = 1;
	var DECREASE = -1;

	function sortMTTable(event)
	{
	    event = event || window.event;
	    var target = event.srcElement ? event.srcElement : event.target;
	    target._order = target._order ?  -target._order : INCREASE;
	    var table = document.getElementById("mttable");

	    //change/hide arrows
	    var headerDivs = table.rows[0].getElementsByTagName("div");
	    for (var i = 0; i < headerDivs.length; i++)
	    {
	        headerDivs[i].className = "";
	    }
	    target.className = (target._order == INCREASE) ? "SortArrowUp" : "SortArrowDown";

	    //sort columns in array
	    var rows = new Array();
	    for (var i = 0; i < table.rows.length - 1; i++)
	    {
	        rows[i] = table.rows[i + 1];
	    }
	    rows.sort(compareByColumns(target.getAttribute("colNo"), target.getAttribute("type"), target._order));

	    //append sorted rows to table body
	    //var oFragment = document.createDocumentFragment();
	    var tBody = table.tBodies[0];
	    for (var i = 0; i < rows.length; i++)
	    {
	        //oFragment.appendChild(rows[i]);
	        var ifChecked = rows[i].firstChild.firstChild.checked;
	        tBody.appendChild(rows[i]);
	        //We need to update node's check status or else it will be 'unchecked' by default
	        tBody.lastChild.firstChild.firstChild.checked = ifChecked;
	    }
	    //table.tBodies[0].appendChild(oFragment);
	}

	function CaseInsensitiveString(s)
	{
	    return String(s).toUpperCase();
	}

	function parseDate(s)
	{
	    return Date.parse(s.replace(/\-/g, '/'));
	}


	function compareByColumns(colNo, sType, order)
	{
	    var fTypeCast = String;

	    if (sType == "Number")
	        fTypeCast = Number;
	    else if (sType == "Date")
	        fTypeCast = parseDate;
	    else if (sType == "CaseInsensitiveString")
	        fTypeCast = CaseInsensitiveString;

	    return function (r1, r2)
	    {
	        if (fTypeCast(r1.cells[colNo].innerHTML) < fTypeCast(r2.cells[colNo].innerHTML))
	            return (order == DECREASE) ? +1 : -1;
	        if (fTypeCast(r1.cells[colNo].innerHTML) > fTypeCast(r2.cells[colNo].innerHTML))
	            return (order == DECREASE) ? -1 : +1;
	        return 0;
	    };
	}


	return {
		index: 0,
		name: "Machine_Types",
        init: machine_types_init, 
        addsystemitem: addsystemitem,
        showaddsystem: showaddsystem,
        deleteitem: deleteitem,
        UpdateList: UpdateList,
        restoreDefault: restoreDefault,
        checkAll: checkAll,
        sortMTTable: sortMTTable,
        nextAction: mt_collect,
        toggleRowSelect: toggleRowSelect,
		importId: '#import_machine_types',
        selectorId: '.machine_types',
        title: "Navi.MachineTypes"
	}
}();