// Copyright © 2022 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Security_Pack = function () {

    let isMotionDetection;
    let isTrusionDetection;

    let commandStage = "init";
    let allCommandSuccess = true;

    let rebootTimerHandle = undefined;

    function SP_init() {
        printLog("INFO","Security Pack page init.");
        if (commandStage == "done") {
            top.togglePrevious(false);
        } else {
            top.toggleNext(false);
            if(top.gl_Machine_Params.MotionDetectionEnable){
                document.getElementById("SPMontionDetection").setAttribute("checked", top.gl_Machine_Params.MotionDetectionEnable);
            }
            if(top.gl_Machine_Params.ChassisIntrusionDetectionEnable){
                document.getElementById("SPChassisIntrusionDetection").setAttribute("checked", top.gl_Machine_Params.ChassisIntrusionDetectionEnable);
            }
            toggleDetectionButton(document.getElementById("SPMontionDetection"));
            toggleDetectionButton(document.getElementById("SPChassisIntrusionDetection"));

            $("#EnableSecurityConfirmDiv").show();
            $("#SP_Pack_button").show();
            $("#EnableSecurityConfirmInput").focus();
            checkUserDecision();
            $("#SPMontionDetection").parent().parent().parent().removeClass("notclick");
        }
    }

    function toggleDetectionButton(buttonObj) {
        printLog("INFO","The option "+buttonObj.id+" is "+(buttonObj.checked?"checked.":"unchecked."));
        if (buttonObj.checked) {
            document.getElementById(buttonObj.id+"Status").innerText = $.i18n.prop("SecurityPack.Enabled");
        } else {
            document.getElementById(buttonObj.id+"Status").innerText = $.i18n.prop("SecurityPack.Disabled");
        }
    }

    function showTipsInfo(str, id){
		if (str == ""){
			$("#SP_EnableSecurityPack").parent().hide();
            $("#SP_EnableSecurityPack").parent().children(".ErrorMessage")[0].innerHTML = "";
            $("#SP_SetMotionDetection").parent().hide();
            $("#SP_SetMotionDetection").parent().children(".ErrorMessage")[0].innerHTML = "";
            $("#SP_SetChassisIntrutionDetection").parent().hide();
            $("#SP_SetChassisIntrutionDetection").parent().children(".ErrorMessage")[0].innerHTML = "";
            $("#SP_LockServer").parent().hide();
            $("#SP_LockServer").parent().children(".ErrorMessage")[0].innerHTML = "";
            $("#SP_OSPoweroff").parent().hide();
            $("#SP_OSPoweroff").parent().children(".ErrorMessage")[0].innerHTML = "";
			return;
		}
		$("#"+id).parent().show();
        $("#"+id).parent().children(".ErrorMessage")[0].innerHTML = str;
	}

    function collectUserOptions() {
        isMotionDetection = document.getElementById("SPMontionDetection").checked;
        isTrusionDetection = document.getElementById("SPChassisIntrusionDetection").checked;
    }

    function showRebootTips(){
        $("#SP_status").parent().show();
        document.getElementById("SP_status").value = 0;
        rebootTimerHandle = setInterval(function(){
            document.getElementById("SP_status").value++;
        }, 1000);
    }

    function hideRebootTips(){
        $("#SP_status").parent().hide();
        clearInterval(rebootTimerHandle);
    }

    function SP_EnableSecurityPack() {
        deleteFile(top.getSupportFile("commonResult"));
        $("#SP_EnableSecurityPack").parent().show();
        progressSetRunning("SP_EnableSecurityPack");
        let args = [];
		args.push(top.getSystemFile("oneCli"));
		args.push("edgeserver");
		args.push("enablesecuritypack");
        args.push("--bmc");
		args.push(SplitFullConnInfo());
        args.push("--never-check-trust");
		args.push(...add_output_log5());
        top.store_onecli_command(args);
		printLog("INFO", "run commend:" + getRunProgramCommend(args));
		runProgram(args, null, onEnabled);
        showRebootTips();
    }

    function onEnabled(success) {
        hideRebootTips();
        if (!success) {
            commandStage = "enable_fail";
            allCommandSuccess = false;
            progressSetFailed("SP_EnableSecurityPack");
            return SP_MainProcess();
        } else {
            commandStage = "enabled";
            progressSetSuccess("SP_EnableSecurityPack");
            return SP_MainProcess();
        }
    }

    function SP_Lock() {
        deleteFile(top.getSupportFile("commonResult"));
        $("#SP_LockServer").parent().show();
        progressSetRunning("SP_LockServer");
        let args = [];
		args.push(top.getSystemFile("oneCli"));
		args.push("edgeserver");
		args.push("lock");
        args.push("--bmc");
		args.push(SplitFullConnInfo());
        args.push("--never-check-trust");
		args.push(...add_output_log5());
        top.store_onecli_command(args);
		printLog("INFO", "run commend:" + getRunProgramCommend(args));
		runProgram(args, null, onLocked);
    }

    function onSetMotionDetectionFinished(success){
        if (!success) {
            commandStage = "set_motion_detection_fail";
            allCommandSuccess = false;
            progressSetFailed("SP_SetMotionDetection");
            return SP_MainProcess();
        } else {
            commandStage = "set_motion_detection_success";
            progressSetSuccess("SP_SetMotionDetection");
            return SP_MainProcess();
        }
    }

    function SP_SetMotionDetection(){
        deleteFile(top.getSupportFile("commonResult"));
        document.getElementById("SP_SetMotionDetectionDesc").innerText = isMotionDetection? $.i18n.prop("SecurityPack.Status.EnableMotionDetection"): $.i18n.prop("SecurityPack.Status.DisableMotionDetection");
        $("#SP_SetMotionDetection").parent().show();
        progressSetRunning("SP_SetMotionDetection");
        let args = [];
		args.push(top.getSystemFile("oneCli"));
		args.push("edgeserver");
        if(isMotionDetection){
            args.push("enablemotiondetection");
        }else{
            args.push("disablemotiondetection");
        }
        args.push("--bmc");
		args.push(SplitFullConnInfo());
        args.push("--never-check-trust");
		args.push(...add_output_log5());
        top.store_onecli_command(args);
		printLog("INFO", "run commend:" + getRunProgramCommend(args));
		runProgram(args, null, onSetMotionDetectionFinished);
    }

    function onSetIntrusionDetectionFinished(success){
        if (!success) {
            commandStage = "set_intrusion_detection_fail";
            allCommandSuccess = false;
            progressSetFailed("SP_SetChassisIntrutionDetection");
            return SP_MainProcess();
        } else {
            commandStage = "set_intrusion_detection_success";
            progressSetSuccess("SP_SetChassisIntrutionDetection");
            return SP_MainProcess();
        }
    }

    function SP_SetChassisInstrusionDetection(){
        deleteFile(top.getSupportFile("commonResult"));
        document.getElementById("SP_SetChassisIntrutionDetectionDesc").innerText = isTrusionDetection? $.i18n.prop("SecurityPack.Status.EnableChassisIntrusionDetection"): $.i18n.prop("SecurityPack.Status.DisableChassisIntrusionDetection");
        $("#SP_SetChassisIntrutionDetection").parent().show();
        progressSetRunning("SP_SetChassisIntrutionDetection");
        let args = [];
		args.push(top.getSystemFile("oneCli"));
		args.push("edgeserver");
        if(isTrusionDetection){
            args.push("enableintrusiondetection");
        }else{
            args.push("disableintrusiondetection");
        }
        args.push("--bmc");
		args.push(SplitFullConnInfo());
        args.push("--never-check-trust");
		args.push(...add_output_log5());
        top.store_onecli_command(args);
		printLog("INFO", "run commend:" + getRunProgramCommend(args));
		runProgram(args, null, onSetIntrusionDetectionFinished);
    }

    function onLocked(success) {
        if (!success) {
            commandStage = "lock_fail";
            allCommandSuccess = false;
            progressSetFailed("SP_LockServer");
            return SP_MainProcess();
        } else {
            commandStage = "locked";
            progressSetSuccess("SP_LockServer");
            return SP_MainProcess();
        }
    }

    function SP_OSPoweroff() {
        deleteFile(top.getSupportFile("commonResult"));
        $("#SP_OSPoweroff").parent().show();
        progressSetRunning("SP_OSPoweroff");
        let args = [];
		args.push(top.getSystemFile("oneCli"));
        args.push("misc");
		args.push("ospower");
		args.push("turnoff");
        args.push("--bmc");
		args.push(SplitFullConnInfo());
        args.push("--never-check-trust");
		args.push(...add_output_log5());
        top.store_onecli_command(args);
		printLog("INFO", "run commend:" + getRunProgramCommend(args));
		runProgram(args, null, onOSPoweroff);
    }

    function onOSPoweroff(success) {
        if (!success) {
            commandStage = "power_fail";
            allCommandSuccess = false;
            progressSetFailed("SP_OSPoweroff");
            return SP_MainProcess();
        } else {
            commandStage = "poweroff";
            progressSetSuccess("SP_OSPoweroff");
            return SP_MainProcess();
        }
    }

    function SP_MainProcess() {
        printLog("INFO","Enable was clicked.");
        if (commandStage == "init") {
            showTipsInfo("");
            collectUserOptions();
            SP_EnableSecurityPack();
        } else if (commandStage == "enabled") {
            return SP_SetMotionDetection();
        } else if (commandStage == "set_motion_detection_success") {
            return SP_SetChassisInstrusionDetection();
        } else if (commandStage == "set_intrusion_detection_success") {
            return SP_Lock();
        } else if (commandStage == "locked") {
            return SP_OSPoweroff();
        } else if (commandStage == "poweroff") {
            getCommonResult(); // Set log
            commandStage = "done";
            top.toggleNext(true);
            // Add TShield_Setting page dynamically
            if (top.gl_steps_current.indexOf(TShield_Setting) == -1) {
                let currentIndex = top.gl_wizard.data("state").currentIndex;
                // Security_Pack, Task_complete -> Security_Pack, Task_Complete, TShield_Setting, Task_Complete
                top.gl_steps_current.splice(currentIndex + 2, 0, TShield_Setting, Task_Complete);
                if (top.gl_steps_current.indexOf(Proxy_Setting) == -1) {
                    top.gl_steps_current.splice(currentIndex + 2, 0, Proxy_Setting);
                } else if (top.gl_steps_current.indexOf(Proxy_Setting) > currentIndex) {
                    while (top.gl_steps_current.indexOf(Proxy_Setting) != -1) {
                        top.gl_steps_current.splice(top.gl_steps_current.indexOf(Proxy_Setting), 1);
                    }
                    top.gl_steps_current.splice(currentIndex + 2, 0, Proxy_Setting);
                }
                top.gl_task.push(top.gl_activate);
                top.onecliCommandStrings.push("");
                top.logFiles.push("");
                configSteps(top.gl_steps_current);
                // Reset buttons beacuse configSteps affect them
                toggleDetectionButton(document.getElementById("SPMontionDetection"));
                toggleDetectionButton(document.getElementById("SPChassisIntrusionDetection"));
            }
        } else {
            // Error case
            showErrorMessage();
            top.togglePrevious(true);
            $("#EnableSecurityConfirmDiv").show();
            $("#SP_Pack_button").show();
            $("#SPMontionDetection").parent().parent().parent().removeClass("notclick");
        }
    }

    function getCommonResult() {
        let resultFile = top.readTextFile(top.getSupportFile("commonResult"));
        var resultDom, resultMsg;
        if (resultFile != null) {
            resultDom = ezJsLib.XmlDom.parse(resultFile);
            resultMsg = ezJsLib.XmlDom.getValueByTagFromNode("MESSAGE", resultDom.documentElement);
            setLogFile(ezJsLib.XmlDom.getValueByTag("LOGFILE", resultDom));
            return resultMsg;
        } else {
            return top.getComErrMsg();
        }
    }
    function showErrorMessage() {
        let errorMsg = $.i18n.prop("SecurityPack.EnableError") + "<br>"
        let id = "SP_EnableSecurityPack";
        if(commandStage == "set_motion_detection_fail"){
            errorMsg = $.i18n.prop("SecurityPack.SetMotionError") + "<br>";
            id = "SP_SetMotionDetection";
        } else if(commandStage == "set_intrusion_detection_fail"){
            errorMsg = $.i18n.prop("SecurityPack.SetChassisIntrutionError") + "<br>";
            id = "SP_SetChassisIntrutionDetection";
        } else if (commandStage == "lock_fail") {
            errorMsg = $.i18n.prop("SecurityPack.LockError") + "<br>";
            id = "SP_LockServer";
        } else if (commandStage == "power_fail") {
            errorMsg = $.i18n.prop("SecurityPack.OSPoweroffError") + "<br>";
            id = "SP_OSPoweroff";
        }

        errorMsg += getCommonResult();
        showTipsInfo(errorMsg, id);
        commandStage = "init";
    }

    function showFloatingTips(obj, divID) {
        let elemRect = obj.getBoundingClientRect();
        document.getElementById(divID).style.position = "fixed";
        document.getElementById(divID).style.top = (elemRect.top + 20) + "px";
        document.getElementById(divID).style.left = (elemRect.left + 20) + "px";
        document.getElementById(divID).style.width = (document.body.clientWidth - elemRect.left - 40) + "px";
        $("#"+divID).show();
    }
    function hideFloatingTips(divID) {
        $("#"+divID).hide();
    }

    function progressSetSuccess(progressId) {
        document.getElementById(progressId).src = "images/statusSuccess_obj16.gif";
    }
    function progressSetRunning(progressId) {
        document.getElementById(progressId).src = "images/progress_anim2_small.gif";
    }
    function progressSetFailed(progressId) {
        document.getElementById(progressId).src = "images/statusCritical_obj16.gif";
    }

    function startEnableOperation(){
        commandStage = "init";
        $("#EnableSecurityConfirmDiv").hide();
        $("#SP_Pack_button").hide();
        $("#SP_EnableSecurityPack").parent().hide();
        $("#SP_SetMotionDetection").parent().hide();
        $("#SP_SetChassisIntrutionDetection").parent().hide();
        $("#SP_LockServer").parent().hide();
        $("#SP_OSPoweroff").parent().hide();
        $("#SPMontionDetection").parent().parent().parent().addClass("notclick");
        top.toggleNext(false);
        top.togglePrevious(false);
        allCommandSuccess = true;
        SP_MainProcess();
    }

    function checkUserDecision() {
        let val = $("#EnableSecurityConfirmInput").val();
        if (val.toLowerCase() == "yes") {
            document.getElementById("SP_Pack_button").style.backgroundColor = "#2184be";
            document.getElementById("SP_Pack_button").style.color = "#fff";
            $("#SP_Pack_button").prop("disabled", false);
        } else {
            document.getElementById("SP_Pack_button").style.backgroundColor = "#eee";
            document.getElementById("SP_Pack_button").style.color = "#aaa";
            $("#SP_Pack_button").prop("disabled", true);
        }
    }

    return {
        index: 0,
        name: "Security_Pack",
        init: SP_init,
        nextAction: function() {
            top.togglePrevious(true);
            return true;
        },
        previousAction: function() {
            top.toggleNext(true);
            return true;
        },
        showFloatingTips: showFloatingTips,
        hideFloatingTips: hideFloatingTips,
        toggleDetectionButton: toggleDetectionButton,
        startEnableOperation: startEnableOperation,
        checkUserDecision: checkUserDecision,
        importId: '#import_security_pack',
        selectorId: '.security_pack',
        title: "Navi.SecurityPack",
        needReInit: true
    }
}();