// Copyright © 2023 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Sed_Backup = function () {
    let setPassword;
    let confirmPassword;
    let backupFilePath;

    function sed_backup_init() {
        printLog("INFO","Sed Backup page init.");
        document.getElementById("sedbak_dir").value = top.getSupportDir() + "backup.txt";
        checkPassword();
    }

    function checkPassword() {
        let isCompliantPassword = true;
        let isCompliantComfirm = true;
        readInputPassword();
        document.getElementById("sedbak_tip1").style.display = "none";
        document.getElementById("sedbak_tip2").style.display = "none";
        document.getElementById("sedbak_tip3").style.display = "none";
        document.getElementById("sedbak_tip4").style.display = "none";
        document.getElementById("sedbak_tip5").style.display = "none";
        document.getElementById("sedbak_tip6").style.display = "none";
        // SetPassword input box
        if (setPassword.length == 0) {
            isCompliantPassword = false;
            document.getElementById("sedbak_tip1").style.display = "block";
            document.getElementById("sedbak_tip2").style.display = "block";
        } else if (setPassword.length < 9 ||  setPassword.length > 64) {
            isCompliantPassword = false;
            document.getElementById("sedbak_tip2").style.display = "block";
        }
        if (isCompliantPassword) {
            document.getElementById("sedbak_password").style.borderColor="#ccc";
            document.getElementById("sedbak_password").style.outline="";
        } else {
            document.getElementById("sedbak_password").style.borderColor="red";
            document.getElementById("sedbak_password").style.outline="1px solid red";
        }
        // ConfirmPassword input box
        if (confirmPassword.length == 0) {
            isCompliantComfirm = false;
            document.getElementById("sedbak_tip3").style.display = "block";
            document.getElementById("sedbak_tip6").style.display = "block";
        } else if (confirmPassword.length < 9 ||  confirmPassword.length > 64) {
            isCompliantComfirm = false;
            document.getElementById("sedbak_tip6").style.display = "block";
        }
        if (setPassword.length == 0) {
            isCompliantComfirm = false;
            document.getElementById("sedbak_tip5").style.display = "block";
        } else if (confirmPassword != setPassword) {
            isCompliantComfirm = false;
            document.getElementById("sedbak_tip4").style.display = "block";
        }
        if (isCompliantComfirm) {
            document.getElementById("sedbak_password_repeat").style.borderColor="#ccc";
            document.getElementById("sedbak_password_repeat").style.outline="";
        } else {
            document.getElementById("sedbak_password_repeat").style.borderColor="red";
            document.getElementById("sedbak_password_repeat").style.outline="1px solid red";
        }
        // button
        if (isCompliantPassword && isCompliantComfirm) {
            document.getElementById("sedbak_startButton").style.backgroundColor="#2184be";
            document.getElementById("sedbak_startButton").style.color="#fff";
            $("#sedbak_startButton").prop("disabled",false);
        } else {
            document.getElementById("sedbak_startButton").style.backgroundColor="#eee";
            document.getElementById("sedbak_startButton").style.color="#aaa";
            $("#sedbak_startButton").prop("disabled",true);
        }
    }

    function showFloatingTips(obj, divID) {
        let elemRect = obj.getBoundingClientRect();
        document.getElementById(divID).style.position = "fixed";
        document.getElementById(divID).style.bottom = (document.documentElement.clientHeight - elemRect.top + 1) + "px";
        document.getElementById(divID).style.top = "auto";
        document.getElementById(divID).style.left = (elemRect.left) + "px";
        document.getElementById(divID).style.width = (elemRect.width * 1.5) + "px";
        $("#"+divID).show();
    }
    function hideFloatingTips(divID) {
        $("#"+divID).hide();
    }

    function readInputPassword() {
        setPassword = $("#sedbak_password").val();
        confirmPassword = $("#sedbak_password_repeat").val();
    }

    function readInputPath() {
		let path = document.getElementById("sedbak_dir").value;
        if (path.endsWith("\\") || path.endsWith("/")) {
            alert($.i18n.prop("SedBackup.NotAFilePath"));
            return false;
        }
        let dir =top.dirname(path);
		let ret = validatePath(dir);
		if(ret != "success")
		{
			if(ret == "Common.UnavailablePath") {
				if(confirm($.i18n.prop("SedBackup.DirectoryNotExist"))) {
					createDirectory(dir);
                    if(!directoryExists(dir)) {
                        alert($.i18n.prop("Common.CreatePathFailure"));
                        return false;
                    }
                } else {
                    return false;
                }
			} else {
				alert($.i18n.prop(ret));
				return false;
			}
		}
        if (top.fileExists(path)) {
            if(!confirm($.i18n.prop("SedBackup.OverwriteFile", top.basename(path)))) {
                return false;
            }
        }
		backupFilePath = path;
        return true;
    }

    function openWorkingDir() {
		printLog("INFO","button 'Browse...' was clicked.");
	    setFileParentdir("sedbak_dir", "backup.txt");
	}

    function bak_start() {
        printLog("INFO","Start was clicked.");
        $("#SedBak_Backup").parent().hide();
        $("#SedBak_ErrorMsg").hide();
        if (!readInputPath()) {
            return false;
        }
        readInputPassword();
        $("#sedbak_dir,#sedbak_password,#sedbak_password_repeat,#sedbak_startButton,#sedbak_browser").prop("disabled",true);
        top.togglePrevious(false);
        top.toggleNext(false);
        $("#SedBak_Backup").parent().show();
        document.getElementById("SedBak_Backup").src = "images/progress_anim2_small.gif";
        let args = [];
        args.push(top.getSystemFile("oneCli"));
		args.push("config");
		args.push("backup");
        args.push("Security.SED_AK");
        args.push("--file");
        args.push(backupFilePath);
        args.push("--passphrase");
        args.push(setPassword);
        args.push("--bmc");
		args.push(SplitFullConnInfo());
        args.push("--never-check-trust");
        args.push("--redfish");
        args.push(...add_output_log5());
        top.store_onecli_command(args);
		printLog("INFO", "run commend:" + getRunProgramCommend(args));
		runProgram(args, null, onBackupFinished);
    }

    function onBackupFinished(success) {
        if (success) {
            document.getElementById("SedBak_Backup").src = "images/statusSuccess_obj16.gif";
            getCommonResult();
        } else {
            document.getElementById("SedBak_Backup").src = "images/statusCritical_obj16.gif";
            $("#SedBak_ErrorMsg").show();
            document.getElementById("SedBak_ErrorMsg").innerHTML = getCommonResult();
        }
        $("#sedbak_dir,#sedbak_password,#sedbak_password_repeat,#sedbak_startButton,#sedbak_browser").prop("disabled",false);
        top.togglePrevious(true);
        top.toggleNext(true);
    }

    function getCommonResult() {
        let resultFile = top.readTextFile(top.getSupportFile("commonResult"));
        var resultDom, resultMsg;
        if (resultFile != null) {
            resultDom = ezJsLib.XmlDom.parse(resultFile);
            resultMsg = ezJsLib.XmlDom.getValueByTagFromNode("MESSAGE", resultDom.documentElement);
            setLogFile(ezJsLib.XmlDom.getValueByTag("LOGFILE", resultDom));
            return resultMsg;
        } else {
            return top.getComErrMsg();
        }
    }

    return {
        index: 0,
        name: "Sed_Backup",
        init: sed_backup_init,
        nextAction: function() {
            return true;
        },
        previousAction: function() {
            return true;
        },
        checkPassword: checkPassword,
        showFloatingTips: showFloatingTips,
        hideFloatingTips: hideFloatingTips,
        openWorkingDir: openWorkingDir,
        bak_start: bak_start,
        importId: '#import_sed_backup',
        selectorId: '.sed_backup',
        title: "Navi.SedBackup",
        needReInit: true
    }
}();