// Copyright © 2022 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
TShield_Setting = function () {

    let tsInfo = {
        UserName: "", 
        Password: "", 
        Group: "",
        OTP: ""
    };

    let isCouldSkipDefault;

    let commandStage = "init";
    let tokenFile;
    let challengeResponse;

    // Total retry times if failed
    let DEFAULT_RETRY_TIMES = 2;
    let maxRetryTimes = 0;
    let currentRetriedTimes = 0;
    // Current command's info
    let currentFunc;
    let currentDivId;

    // <tagid>
    //     introText<a href=url>linkedPattern</a>
    // </tagid>
    function setExternalUrl(tagid, introText, linkedPattern, url) {
        let aTag = document.createElement("a");
        aTag.id = tagid + "link";
        aTag.href = url;
        aTag.target = "_blank";
        aTag.innerText = $.i18n.prop(linkedPattern);
        let tagContent = $.i18n.prop(introText, aTag.outerHTML);
        document.getElementById(tagid).innerHTML = tagContent;
        setExternalExplorer(tagid + "link");
    }

    function resetExternalUrl() {
        setExternalUrl("activate_ts_help", "TShieldSetting.ActivateHelp", "TShieldSetting.Pattern3", "https://support.lenovo.com/sv/en/solutions/HT509033");
        setExternalUrl("create_ts_userid_activate", "TShieldSetting.CreateUserIntroForActivate", "TShieldSetting.Pattern2", "https://support.lenovo.com/us/en/solutions/ht509195");
        setExternalUrl("create_ts_userid_claim", "TShieldSetting.CreateUserIntroForClaim", "TShieldSetting.Pattern1", "https://support.lenovo.com/us/en/solutions/ht509195");
        setExternalUrl("create_ts_orgid", "TShieldSetting.CreateOrgIntro", "TShieldSetting.Pattern1", "https://portal.naea1.uds.lenovo.com/selforgcreators");
        setExternalUrl("find_ts_orgid", "TShieldSetting.FindOrgIntro", "TShieldSetting.Pattern1", "https://portal.thinkshield.lenovo.com/remindDomain");
    }

    function TS_init() {
        printLog("INFO","TShield Setting page init.");
        if (commandStage == "done") {
            top.togglePrevious(false);
            top.toggleNext(true);
        } else {
            if (top.gl_task.indexOf(top.gl_enableSecurity) != -1) {
                // Come from Enable Security Pack, so this page could be skipped
                isCouldSkipDefault = true;
            } else {
                isCouldSkipDefault = false;
            }
            top.toggleNext(isCouldSkipDefault);
        }
        // Enable external url
        resetExternalUrl();

        if (gl_syncEdgeStatus == getTaskName()) {
            document.getElementById("TSMainHeader").innerText = $.i18n.prop("TShieldSetting.SyncStatusTitle");
            document.getElementById("activate_ts_help").style.display = "none";
            document.getElementById("create_ts_userid_activate").style.display = "none";
            document.getElementById("create_ts_userid_claim").style.display = "block";
            document.getElementById("TSbutton").innerText = $.i18n.prop("TShieldSetting.SyncBtn");
        } else {
            document.getElementById("TSMainHeader").innerText = $.i18n.prop("TShieldSetting.UnlockTitle");
            document.getElementById("activate_ts_help").style.display = "block";
            document.getElementById("create_ts_userid_activate").style.display = "block";
            document.getElementById("create_ts_userid_claim").style.display = "none";
            document.getElementById("TSbutton").innerText = $.i18n.prop("TShieldSetting.ActivateBtn");
        }
        tokenFile = top.getSupportFile("tokenFile");
    }

    function writeTSParams(){
        tsInfo.UserName = $("#TSUserName").val();
		tsInfo.Password = $("#TSPassword").val();
		tsInfo.Group    = $("#TSGroup").val();
        // tsInfo.OTP      = $("#TSOTP").val();
	}

    function showTipsInfo(str, id){
		if (str == ""){
			$("#TSTips").hide();
			return;
		}
		$("#"+id).show();
		$("#"+id+"Info").html(str);
	}

    function checkParamIsNull(){
		var ret = "";
		$(["TSGroup", "TSUserName", "TSPassword"]).each(function(i, n){
			let value=$("#" + n).val();
			if(!value || value == ""){
				ret = "TSTips";
				$("#"+n).focus();
				return false;
			}
		});
		return ret;
	}

    function progressSetSuccess(progressId) {
        document.getElementById(progressId).src = "images/statusSuccess_obj16.gif";
    }
    function progressSetRunning(progressId) {
        document.getElementById(progressId).src = "images/progress_anim2_small.gif";
    }
    function progressSetFailed(progressId) {
        document.getElementById(progressId).src = "images/statusCritical_obj16.gif";
    }

    function getCommonResult() {
        let resultFile = top.readTextFile(top.getSupportFile("commonResult"));
        var resultDom, resultMsg;
        if (resultFile != null) {
            resultDom = ezJsLib.XmlDom.parse(resultFile);
            resultMsg = ezJsLib.XmlDom.getValueByTagFromNode("MESSAGE", resultDom.documentElement);
            setLogFile(ezJsLib.XmlDom.getValueByTag("LOGFILE", resultDom));
            return resultMsg;
        } else {
            return top.getComErrMsg();
        }
    }

    function taskFailed() {
        progressSetFailed(currentDivId);
        let currentMessageDiv = document.getElementById(currentDivId).parentNode.getElementsByClassName("ErrorMessage")[0];
        currentMessageDiv.style.display="block";
        currentMessageDiv.innerHTML = $.i18n.prop("TShieldSetting.ErrorMessage", getCommonResult());
        taskAllComplete(false);
    }
    function taskRetry() {
        if (currentRetriedTimes < maxRetryTimes) {
            currentFunc();
        } else {
            taskFailed();
        }
    }
    function taskRun(cmdDivId, cmdFunc, retryTimes) {
        currentDivId = cmdDivId;
        currentFunc = cmdFunc;
        $("#"+currentDivId).parent().show();
        progressSetRunning(currentDivId);
        currentRetriedTimes = 0;
        if (retryTimes != undefined) {
            maxRetryTimes = retryTimes;
        } else {
            maxRetryTimes = DEFAULT_RETRY_TIMES;
        }
        currentFunc();
    }

    function taskAllComplete(success) {
        if (success == true) {
            commandStage = "done";
            top.togglePrevious(false);
            top.toggleNext(true);
            getCommonResult(); // only for set log file in the end
            // Add Sed_Backup page dynamically
            if (top.gl_steps_current.indexOf(Sed_Backup) == -1) {
                top.gl_steps_current.splice(top.gl_steps_current.indexOf(TShield_Setting) + 2, 0, Sed_Backup, Task_Complete);
                top.gl_task.push(top.gl_sedBackup);
                top.onecliCommandStrings.push("");
                top.logFiles.push("");
                configSteps(top.gl_steps_current);
                resetExternalUrl(); // Reset URL beacuse configSteps affect them
            }
        } else {
            // $("#TSUserName,#TSPassword,#TSGroup,#TSOTP").prop("disabled", false);
            $("#TSUserName,#TSPassword,#TSGroup").prop("disabled", false);
            commandStage = "init";
            top.togglePrevious(true);
            $("#TSStartButtonDiv").show();
            top.toggleNext(isCouldSkipDefault);
        }
    }

    function syncEdgeStatusActive(isPreviousSuccess) {
        if (isPreviousSuccess == false) {
            return taskRetry();
        }
        switch (commandStage) {
            case "init":
                Array.from(document.getElementById("TS_processLogs").getElementsByTagName("div")).forEach(div => {
                    div.style.display="none";
                });
                Array.from(document.getElementsByClassName("ErrorMessage")).forEach(errorMsg => {
                    errorMsg.style.display="none";
                });
                taskRun("TS_Gettoken", cmdGettoken);
                break;

            case "gettokenDone":
                progressSetSuccess("TS_Gettoken");
                taskRun("TS_Claim", cmdClaim);
                break;

            case "claimDone":
                progressSetSuccess("TS_Claim");
                taskRun("TS_SetActive", cmdSetActive);
                break;   

            case "setActiveDone":
                progressSetSuccess("TS_SetActive");
                taskAllComplete(true);
                break;
        
            default:
                break;
        }
    }

    function activateLocked(isPreviousSuccess) {
        if (isPreviousSuccess == false) {
            return taskRetry();
        }
        switch (commandStage) {
            case "init":
                Array.from(document.getElementById("TS_processLogs").getElementsByTagName("div")).forEach(div => {
                    div.style.display="none";
                })
                Array.from(document.getElementsByClassName("ErrorMessage")).forEach(errorMsg => {
                    errorMsg.style.display="none";
                });
                taskRun("TS_Gettoken", cmdGettoken);
                break;

            case "gettokenDone":
                progressSetSuccess("TS_Gettoken");
                taskRun("TS_Claim", cmdClaim);
                break;

            case "claimDone":
                progressSetSuccess("TS_Claim");
                taskRun("TS_Activate", cmdActivate);
                break;

            case "activateDone":
                // progressSetSuccess("TS_Activate");
                taskRun("TS_Activate", cmdCallHome);
                break;

            case "callhomeDone":
                progressSetSuccess("TS_Activate");
                taskRun("TS_Unlock", cmdUnlock);
                break;

            case "unlockDone":
                progressSetSuccess("TS_Unlock");
                taskRun("TS_SetActive", cmdSetActive);
                break;

            case "setActiveDone":
                progressSetSuccess("TS_SetActive");
                taskAllComplete(true);
                break;
        
            default:
                break;
        }
    }

    function cmdGettoken() {
        ++currentRetriedTimes;
        if (top.fileExists(tokenFile)) {
            top.deleteFile(tokenFile);
        }
        deleteFile(top.getSupportFile("commonResult"));
        let args = [];
        args.push(top.getSystemFile("oneCli"));
		args.push("edgeserver");
		args.push("gettoken");
        args.push("--ts-username");
        args.push(tsInfo.UserName);
        args.push("--ts-password");
        args.push(tsInfo.Password);
		args.push("--ts-organization-id");
        args.push(tsInfo.Group);
        // if (tsInfo.OTP != "") {
        //     args.push("--ts-otp");
        //     args.push(tsInfo.OTP);
        // }
        args.push("--ts-token-file");
        args.push(tokenFile);
        args.push(...add_proxy_para());
        args.push(...add_output_log5());
        top.store_onecli_command(args);
		printLog("INFO", "run commend:" + getRunProgramCommend(args));
        commandStage = "gettokenDone";
		runProgram(args, null, cmdNextStep);
    }

    function cmdClaim() {
        ++currentRetriedTimes;
        deleteFile(top.getSupportFile("commonResult"));
        let args = [];
		args.push(top.getSystemFile("oneCli"));
		args.push("edgeserver");
		args.push("claim");
        args = args.concat(SplitXCCInfo());
        args.push("--ts-token-file");
        args.push(tokenFile);
        args.push("--active-code");
        args.push(top.gl_Machine_Params.ActivationCode);
        args.push(...add_proxy_para());
		args.push(...add_output_log5());
        top.store_onecli_command(args);
		printLog("INFO", "run commend:" + getRunProgramCommend(args));
        commandStage = "claimDone";
		runProgram(args, null, cmdNextStep);
    }

    function cmdCallHome() {
        ++currentRetriedTimes;
        deleteFile(top.getSupportFile("commonResult"));
        challengeResponse = "";
        let args = [];
		args.push(top.getSystemFile("oneCli"));
		args.push("edgeserver");
		args.push("callhome");
        args = args.concat(SplitXCCInfo());
        args.push("--ts-token-file");
        args.push(tokenFile);
        args.push("--challenge-otp");
        args.push(top.gl_Machine_Params.ChallengeText);
        args.push("--ts-organization-id");
        args.push(tsInfo.Group);
        args.push(...add_proxy_para());
		args.push(...add_output_log5());
        top.store_onecli_command(args);
		printLog("INFO", "run commend:" + getRunProgramCommend(args));
        commandStage = "callhomeDone";
		runProgram(args, null, (success) => {
            let tsStatusPath = top.getSupportFile("thinkShieldStatus");
            if (success && top.fileExists(tsStatusPath)) {
                printLog("INFO","ThinkShield status file exists, try to parse it.");
                try {
                    let tsStatus = JSON.parse(top.readTextFile(tsStatusPath));
                    challengeResponse = tsStatus["ChallengeResponseText"];
                    if (challengeResponse == undefined || challengeResponse == "") {
                        success = false;
                    }
                } catch (e) {
                    success = false;
                }
            } else {
                success = false;
            }
            cmdNextStep(success);
        });
    }

    function cmdUnlock() {
        ++currentRetriedTimes;
        deleteFile(top.getSupportFile("commonResult"));
        let args = [];
		args.push(top.getSystemFile("oneCli"));
		args.push("edgeserver");
		args.push("unlock");
        args.push("--response-otp");
        args.push(challengeResponse);
        args.push("--bmc");
		args.push(SplitFullConnInfo());
        args.push("--never-check-trust");
		args.push(...add_output_log5());
        top.store_onecli_command(args);
		printLog("INFO", "run commend:" + getRunProgramCommend(args));
        commandStage = "unlockDone";
		runProgram(args, null, cmdNextStep);
    }

    function cmdActivate() {
        ++currentRetriedTimes;
        deleteFile(top.getSupportFile("commonResult"));
        let args = [];
		args.push(top.getSystemFile("oneCli"));
		args.push("edgeserver");
		args.push("activate");
        args = args.concat(SplitXCCInfo());
        args.push("--ts-token-file");
        args.push(tokenFile);
        args.push(...add_proxy_para());
		args.push(...add_output_log5());
        top.store_onecli_command(args);
		printLog("INFO", "run commend:" + getRunProgramCommend(args));
        commandStage = "activateDone";
		runProgram(args, null, cmdNextStep);
    }

    function cmdSetActive() {
        ++currentRetriedTimes;
        deleteFile(top.getSupportFile("commonResult"));
        let args = [];
		args.push(top.getSystemFile("oneCli"));
		args.push("edgeserver");
		args.push("setstatustoactive");
        args = args.concat(SplitXCCInfo());
        args.push("--ts-token-file");
        args.push(tokenFile);
        args.push(...add_proxy_para());
		args.push(...add_output_log5());
        top.store_onecli_command(args);
		printLog("INFO", "run commend:" + getRunProgramCommend(args));
        commandStage = "setActiveDone";
		runProgram(args, null, cmdNextStep);
    }

    function cmdNextStep(isPreviousSuccess) {
        if(gl_syncEdgeStatus == getTaskName()) {
            // In this case, only set status to active, because it only show this task when "Security Enabled, Status Active"
            syncEdgeStatusActive(isPreviousSuccess);
        } else {
            activateLocked(isPreviousSuccess);
        }
    }

    function SplitXCCInfo() {
        let conn = [];
        conn.push("--mt");
        conn.push(top.gl_OOB_Params.MT);
        conn.push("--sn");
        conn.push(top.gl_Machine_Params.SN);
        return conn.concat();
    }

    function edgeGetInfoCmd() {
		let edgeserverStatusPath = top.getSupportFile("edgeserverStatus");
		if (top.fileExists(edgeserverStatusPath)) {
			top.deleteFile(edgeserverStatusPath);
		}
		let args = [];
		args.push(top.getSystemFile("oneCli"));
		args.push("edgeserver");
		args.push("getsecurityinfo");
		args.push("--bmc");
		args.push(SplitFullConnInfo());
		args.push("--never-check-trust");
		args.push(...add_output_log5());
		printLog("INFO", "run commend:" + getRunProgramCommend(args));
		runProgram(args, null, edgeGetInfo);
	}

	function edgeGetInfo() {
		let edgeserverStatusPath = top.getSupportFile("edgeserverStatus");
		if (top.fileExists(edgeserverStatusPath)) {
			try {
				let xccInfo = JSON.parse(top.readTextFile(edgeserverStatusPath));
				top.gl_Machine_Params.ActivationCode = xccInfo["Active Code"];
				top.gl_Machine_Params.ChallengeText = xccInfo["Challenge Text"];
			} catch (e) {
				printLog("ERROR","Failed to read edgeserverStatus json.");
			}
		}
        cmdNextStep();
        /**
         * Main process
         * cmdNextStep
         *   - syncEdgeStatusActive
         *     - Gettoken  - Claim  - SetActive
         *   - activateLocked
         *     - Gettoken  - Claim  - Activate  - CallHome  - Unlock  - SetActive
         */
	}

    function startSecurityOperation() {
        printLog("INFO","Start was clicked.");
        top.toggleNext(false);
        top.togglePrevious(false);
        $("#TSStartButtonDiv").hide();
        showTipsInfo("");
        let retid = checkParamIsNull();
        if (retid != "") {
            showTipsInfo($.i18n.prop("TShieldSetting.ParamsNeeded"), retid);
            top.togglePrevious(true);
            $("#TSStartButtonDiv").show();
            top.toggleNext(isCouldSkipDefault);
            return false;
        }
        // $("#TSUserName,#TSPassword,#TSGroup,#TSOTP").prop("disabled", true);
        $("#TSUserName,#TSPassword,#TSGroup").prop("disabled", true);
        writeTSParams();
        edgeGetInfoCmd();//the XCC status maybe changed, so need to re-get information here.
    }

    return {
        index: 0,
        name: "TShield_Setting",
        init: TS_init,
        nextAction: function() {
            top.togglePrevious(true);
            return true;
        },
        previousAction: function() {
            top.toggleNext(true);
            return true;
        },
        startSecurityOperation: startSecurityOperation,
        importId: '#import_tshield_setting',
        selectorId: '.tshield_setting',
        title: "Navi.TShieldSetting",
        needReInit: true
    }
}();