// Copyright © 2022 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Target_Server = function () {
    let userCanceled = false;
    let isGettingMachineType = false;
    let certNewIMM = false;
    let certIMMTempContent;
    let certIMMSaveContent;
    let certIMMTempFile = '';
    let scan_status = "";
    let tagCheckDefault = false;
    // 0: create, 1: inband, 2: oob
    let userSelected = 2;

	let PASSWORD_NEED_RESET = 54;
	// The new password will be set as OOB.Password if success, so it is unnecessary to be saved separately
	let newPassword;
	let isPasswordchangeable = false;

	let ipData = {};

	let tmpDir = top.getEnv("TEMP");

	let fileName = "temp_ip.json";

    function checkDefault() {
        tagCheckDefault = document.getElementById("bmcAcceptCertDefault").checked;
        printLog("INFO", "check box 'Accept BMC server's certificate by default.' " + (tagCheckDefault ? "checked." : "unchecked."));
    }

    function acc_init() {
        printLog("INFO", "TargetServer page init.");
		if (top.gl_uxlite_bootable) {
			return acc_init_bootable();
		}
        tagCheckDefault = document.getElementById("bmcAcceptCertDefault").checked;
        scan_status = "init";
        certNewIMM = false;
        certIMMTempFile = top.pathJoin(top.getSupportDir(), "IMM_Cert.txt");

		top.gl_curTaskIndex = 0;

        initAccountParams();
        updateManagementType(userSelected);
        toggleInbandSection();
        Banner.set_active_status("", "");

		isPasswordchangeable = false;
		document.getElementById("ChangePasswordDiv").style.display = "none";
        printLog("DEBUG", "function acc_init end.");
    }

	function acc_init_bootable() {
		printLog("INFO", "Bootable case, goto init for bootable");
		// Remove all elements except inbandBMC
		let inbandDivContent = document.getElementById("inbandBMC").outerHTML;
		let parentDiv = document.getElementById("inbandBMC").parentNode;
		parentDiv.innerHTML = inbandDivContent;
		userSelected = 1;
		initAccountParams();
		toggleInbandSection();

		top.gl_OOB_Params.Enabled = false;
		top.gl_Inband_Params.Enabled = true;
		top.gl_curTaskIndex = 0;
		top.gl_task = [top.gl_isUpdate];
		top.onecliCommandStrings = [""];
		top.logFiles = [""];

		setTimeout(needForceCompare,1000);
	}
	function needForceCompare(){
		top.initForceCompare();
		if (top.is_autorun() || top.is_unattend() || top.isAmd(top.gl_current_mt)) {
			// AMD servers do not need offer bmc information, skip this page like autorun mode
			top.gl_Inband_Params.UserInput = false;
			gl_wizard.steps("next");
		}
	}

    function toggleInbandSection() {
		if ($("#inbandInput").prop("checked")) {
			printLog("INFO","check box 'Input BMC access information' checked.");
			$("#inbandInputSection").show();
			// AMD machine bmc port is default with 443
			if(top.isAmd(top.gl_current_mt)) {
				$("#inband_cim_port_input").hide();
				$("#inband_rest_port_input").hide();
                $("#inbandCimPort").val("");
				$("#inbandRestPort").val("");
			} else {
                $("#inband_cim_port_input").show();
                $("#inband_rest_port_input").show();
            }
            top.gl_Inband_Params.UserInput = true;
		} else {
			printLog("INFO","check box 'Input BMC access information' unchecked.");
			$("#inbandInputSection").hide();
            top.gl_Inband_Params.UserInput = false;
		}
		$("#showInbandBMCTips").hide();//fix coverity issue 63435
	}
    
    function updateManagementType(idx) {
        printLog("INFO","radio '" + idx + "' was selected.");
        let newShowStep = [];
        if (top.bCheckForLatest) {
            newShowStep = [Welcome, Proxy_Setting, Obtain_Latest_Version, Target_Server, Update_Task, Finish];
        } else {
            newShowStep = [Welcome, Target_Server, Update_Task, Finish];
        }

		switch (idx)
		{
            case 0:
				top.gl_task = [top.gl_createRepo];
                newShowStep.splice(newShowStep.indexOf(Update_Task), 1,  Update_Type, Machine_Types, Target_Operating_Systems, Target_Directory, Update_Selection, Acquire_Updates, Task_Complete);
                if (!top.bCheckForLatest) {
					newShowStep.splice(newShowStep.indexOf(Machine_Types), 0, Proxy_Setting);
				}
				configSteps(newShowStep);
                document.getElementById("OOBBMC").style.display = "none";
                document.getElementById("inbandBMC").style.display = "none";
                top.gl_OOB_Params.Enabled = false;
                top.gl_Inband_Params.Enabled = false;
                break;

            case 1:
				// For a specific server, tasks will be set in next page
				top.gl_task = [];
                configSteps(newShowStep);
                document.getElementById("OOBBMC").style.display = "none";
                document.getElementById("inbandBMC").style.display = "block";
                top.gl_OOB_Params.Enabled = false;
                top.gl_Inband_Params.Enabled = true;
                break;

            case 2:
				top.gl_task = [];
                configSteps(newShowStep);
                document.getElementById("OOBBMC").style.display = "block";
                document.getElementById("inbandBMC").style.display = "none";
                top.gl_OOB_Params.Enabled = true;
                top.gl_Inband_Params.Enabled = false;
                break;
		}
        userSelected = idx;
    }

    function initAccountParams() {
        top.gl_OOB_Params.IMM_Address = "";
        top.gl_OOB_Params.IMM_UserName = "";
        top.gl_OOB_Params.IMM_Password = "";
        top.gl_OOB_Params.IMM_Port = "";
        top.gl_OOB_Params.MT = "";
        top.gl_Inband_Params.IMM_UserName = "";
        top.gl_Inband_Params.IMM_Password = "";
        top.gl_Inband_Params.IMM_Port = "";
        top.gl_Inband_Params.REST_Port = "";
		try{
			var tempData = top.readTextFile(fileName);
			ipData = JSON.parse(tempData);
			if(ipData == null) ipData = {};
			updateList(document.getElementById("oobHostName").value);
		}catch(e){}
    }

	function updateList(ipAddr){
		document.getElementById("iplist").innerText   = "";
		let i = 0;
		for(let key of Object.keys(ipData)){
			console.info("add ip:", key);
			let value = ipData[key];
			temp = document.createElement("option");
			temp.innerText = key;
			document.getElementById("iplist").insertBefore(temp, null);
			if(ipAddr == key){
				document.getElementById("oobPort").value = value["port"];
				document.getElementById("oobUserName").value = value["username"];
			}
		};
	}

    function checkInbandInput() {
		let cimPortValue = $("#inbandCimPort").val();
		let restPortValue = $("#inbandRestPort").val();
		let userValue = $("#inbandUserName").val();
		let passValue = $("#inbandPassword").val();
		if (cimPortValue && (isNaN(cimPortValue) || cimPortValue < 1 || cimPortValue > 65535)) {
			$("#inbandCimPort").focus();
			showTipsInfo($.i18n.prop("TargetServer.TipsInfo4"), "showInbandBMCTips");
			return false;
		}
		if (restPortValue && (isNaN(restPortValue) || restPortValue < 1 || restPortValue > 65535)) {
			$("#inbandRestPort").focus();
			showTipsInfo($.i18n.prop("TargetServer.TipsInfo4"), "showInbandBMCTips");
			return false;
		}
		if (!userValue && passValue) {
			$("#inbandUserName").focus();
			showTipsInfo($.i18n.prop("TargetServer.TipsInfo1"), "showInbandBMCTips");
			return false;
		}
		if (userValue && !passValue) {
			$("#inbandPassword").focus();
			showTipsInfo($.i18n.prop("TargetServer.TipsInfo1"), "showInbandBMCTips");
			return false;
		}
		return true;
	}

    function writeInbandParams() {
		top.gl_Inband_Params.IMM_UserName = $("#inbandUserName").val();
		top.gl_Inband_Params.IMM_Port = $("#inbandCimPort").val();
		top.gl_Inband_Params.IMM_Password = $("#inbandPassword").val();
		top.gl_Inband_Params.REST_Port = $("#inbandRestPort").val();
	}

    function showTipsInfo(str, id){
		if (str == ""){
			$("#showBMCTips").hide();
			$("#showInbandBMCTips").hide();
			return;
		}
		$("#"+id).show();
		$("#"+id+"Info").html(str);
	}

    function checkParamIsNull(){
		var ret = "";
		$(["oobHostName", "oobUserName", "oobPassword"]).each(function(i, n){
			let value=$("#" + n).val();
			if(!value || value == ""){
				ret = "showBMCTips";
				$("#"+n).focus();
				return false;
			}
		});
		return ret;
	}

    function checkHostName(hostName) {
		let expHostName = /((^\s*((([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]))\s*$)|(^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$))|(^\s*((?=.{1,255}$)(?=.*[A-Za-z].*)[0-9A-Za-z](?:(?:[0-9A-Za-z]|\b-){0,61}[0-9A-Za-z])?(?:\.[0-9A-Za-z](?:(?:[0-9A-Za-z]|\b-){0,61}[0-9A-Za-z])?)*)\s*$)/;
		let flag = expHostName.test(hostName);
		if (flag) return true;
		else return false;
	}

    function checkOOBParams(){
		let retid = checkParamIsNull();
		if(retid!=""){
			showTipsInfo($.i18n.prop("TargetServer.TipsInfo3"), retid);
			return false;
		}

		let oobHostName = $("#oobHostName").val();
		if (!checkHostName(oobHostName)){
			showTipsInfo($.i18n.prop("TargetServer.TipsInfo2"), "showBMCTips");
			return false;
		} 

		let oobPort = $("#oobPort").val();
		if(oobPort && (isNaN(oobPort) || oobPort<1 || oobPort>65535) ){
			showTipsInfo($.i18n.prop("TargetServer.TipsInfo4"), "showBMCTips");
			return false;
		}
		// check newPassword if needed
		if (isPasswordchangeable) {
			let tmpPassword1 = $("#oobNewPassword").val();
			let tmpPassword2 = $("#oobConfirmPassword").val();
			if (!checkNewPassword()) {
				showTipsInfo($.i18n.prop("TargetServer.TipsInfo6"), "showBMCTips");
				$("#oobNewPassword").focus();
				return false;
			}
			if (tmpPassword1 != tmpPassword2) {
				showTipsInfo($.i18n.prop("TargetServer.TipsInfo9"), "showBMCTips");
				$("#oobConfirmPassword").focus();
				return false;
			}
		}
		return true;
	}

	function checkNewPassword() {
		let val = $("#oobNewPassword").val();
		let acceptedCount = 0;
		// Set All false
		for (let i = 0; i < 8; ++i) {
			document.getElementById("TS_TipImg" + i).src = "images/statusCritical_obj16.gif";
		}
		// If user type null, it regard as user don't want to change the password, so return true
		if (!(val.length > 0)) {
			document.getElementById("TargetServerTipMarker").className="glyphicon glyphicon-remove";
			document.getElementById("TargetServerTipMarker").style.color = "red";
			return true;
		}
		// Only contain the following characters
		if (val.search(/[^a-zA-Z0-9~`!@#\$%\^&\*\(\)\-\+=\{\}\[\]\|:;"'<>,\\?\/\._]/) == -1) {
			document.getElementById("TS_TipImg0").src = "images/statusSuccess_obj16.gif";
			++acceptedCount;
		}
		// Must contain at least one letter
		if (val.search(/[a-z]|[A-Z]/) != -1) {
			document.getElementById("TS_TipImg1").src = "images/statusSuccess_obj16.gif";
			++acceptedCount;
		}
		// Must contain at least one number
		if (val.search(/[0-9]/) != -1) {
			document.getElementById("TS_TipImg2").src = "images/statusSuccess_obj16.gif";
			++acceptedCount;
		}
		// Must contain at least 2 of the following combinations
		let count = 0;
		count += (val.search(/[A-Z]/)==-1?0:1);
		count += (val.search(/[a-z]/)==-1?0:1);
		count += (val.search(/[~`!@#\$%\^&\*\(\)\-\+=\{\}\[\]\|:;"'<>,\\?\/\._]/)==-1?0:1);
		if (count >= 2) {
			document.getElementById("TS_TipImg3").src = "images/statusSuccess_obj16.gif";
			++acceptedCount;
		}
		// No spaces or white-space characters
		if (val.indexOf(" ") == -1) {
			document.getElementById("TS_TipImg4").src = "images/statusSuccess_obj16.gif";
			++acceptedCount;
		}
		// Passwords may have no more than 2 consecutive instances of the same character
		if (val.search(/([^\n])\1{2}/) == -1) {
			document.getElementById("TS_TipImg5").src = "images/statusSuccess_obj16.gif";
			++acceptedCount;
		}
		// The password cannot be literary same as the user name, UserNameUserName or emaNresU
		let tmpUserName = $("#oobUserName").val();
		let repeatedUserName = "";
		if (tmpUserName.length > 0) {
			for (let i = 0; i < val.length / tmpUserName.length; ++i) {
				repeatedUserName += tmpUserName;
			}
		}
		if (val != tmpUserName.split("").reverse().join("") && val != repeatedUserName) {
			document.getElementById("TS_TipImg6").src = "images/statusSuccess_obj16.gif";
			++acceptedCount;
		}
		// No less than 8 and no more than 32
		if (val.length >= 8 && val.length <= 32) {
			document.getElementById("TS_TipImg7").src = "images/statusSuccess_obj16.gif";
			++acceptedCount;
		}

		if (acceptedCount == 8) {
			document.getElementById("TargetServerTipMarker").className="glyphicon glyphicon-ok";
			document.getElementById("TargetServerTipMarker").style.color = "limegreen";
			return true;
		}
		document.getElementById("TargetServerTipMarker").className="glyphicon glyphicon-remove";
		document.getElementById("TargetServerTipMarker").style.color = "red";
		return false;
	}

    function writeOOBParams(){
		top.gl_OOB_Params.IMM_Address = $("#oobHostName").val();
		top.gl_OOB_Params.IMM_UserName = $("#oobUserName").val();
		top.gl_OOB_Params.IMM_Port = $("#oobPort").val();
		top.gl_OOB_Params.IMM_Password = $("#oobPassword").val();
		newPassword = $("#oobNewPassword").val();
		ipData[top.gl_OOB_Params.IMM_Address] = {
			"username": top.gl_OOB_Params.IMM_UserName,
			"port": top.gl_OOB_Params.IMM_Port
		};
		top.writeTextFile(fileName, JSON.stringify(ipData, null, 2));
	}

    function getIMMCert() {
		if (userCanceled) {
			top.togglePrevious(true);
			top.toggleNext(true);
			return;
		}
		let args = [];
    	args.push(top.getSystemFile("oneCli"));
    	args.push("misc");
    	args.push("gettrust");
    	args.push("--host");
    	args.push(top.gl_OOB_Params.IMM_Address);
		if (top.gl_OOB_Params.IMM_Port != null && top.gl_OOB_Params.IMM_Port != undefined && top.gl_OOB_Params.IMM_Port != "") {
			args.push("--port");
			args.push(top.gl_OOB_Params.IMM_Port);
		}
    	args.push("--type");
    	args.push("https");
    	args.push("--result");
    	certIMMSaveFile = "IMM_" + top.gl_OOB_Params.IMM_Address + ".txt";
    	certIMMSaveFile = top.pathJoin(top.getSupportDir(), certIMMSaveFile);
    	top.deleteFile(certIMMTempFile);
		args.push(certIMMTempFile);
		args.push(...add_output_log5());
    	printLog("INFO","run commend:" + getRunProgramCommend(args));
    	runProgram(args, null, getIMMCertCB);
    	return "waiting";
	}

	function getIMMCertCB(success) {
		if (userCanceled) {
			top.togglePrevious(true);
			top.toggleNext(true);
			return "waiting";
		}
		if (!success || !top.fileExists(certIMMTempFile)) {
			scan_status = "bmc_fail";
			goNextStep();
		} else {
			scan_status = "bmc_success";
			goNextStep();
		}
	}

	/** Add change password function */
	function beginConnectServer() {
		userCanceled = false;
		writeOOBParams();
		if (!isPasswordchangeable || !newPassword || newPassword == "") {
			return beginGetMT();
		} else {
			showTipsInfo("");
			top.showUnstoppableWaitMsg([$.i18n.prop("TargetServer.ChangePasswdTip")]);
			deleteFile(top.getSupportFile("commonResult"));
			let args = [];
			args.push(top.getSystemFile("oneCli"));
			args.push("misc");
			args.push("bmcpassword");
			args.push("--bmc");
			args.push(SplitFullConnInfo());
			args.push("--never-check-trust");
			args.push("--newpwd");
			args.push(newPassword);
			args.push(...add_output_log5());
			printLog("INFO","run commend:" + getRunProgramCommend(args));
			runProgram(args, null, changePasswordCB, ["This command will change the password of BMC, do you confirm"]);
		}
	}

	function changePasswordCB(success) {
		top.hideUnstoppableWaitMsg();
		if (!success) {
			let errorInfo = "";
			try{
				let comm_ret_doc = top.readTextFile(top.getSupportFile("commonResult"));
				let comm_dom = ezJsLib.XmlDom.parse(comm_ret_doc);
				errorInfo = ezJsLib.XmlDom.getValueByTagFromNode("MESSAGE", comm_dom.documentElement);
			} catch(e) {
				if (errorInfo == "") errorInfo = $.i18n.prop("TargetServer.TipsInfo5");
			}
			showTipsInfo(errorInfo, "showBMCTips");
			scan_status = "init";
			return false;
		} else {
			isPasswordchangeable = false;
			document.getElementById("ChangePasswordDiv").style.display = "none";
			top.gl_OOB_Params.IMM_Password = newPassword;
			$("#oobPassword").val(newPassword);
			return beginConnectServer();
		}
	}
	/** End change password function */

    function beginGetMT(){
		if(isGettingMachineType == "runned"){
			isGettingMachineType = false;
			// Check the current mt is in support list. Add by wengmh1 2017/3/3
			if(!top.checkSupportMachineType(gl_OOB_Params.MT))
			{
				alert($.i18n.prop("Common.SystemNotSupport"));
				scan_status = "init";
				return false;
			}
			if (top.gl_OOB_Params.Enabled) {
                if(top.isAmd()) {
					if(top.gl_OOB_Params.IMM_Port != "" && top.gl_OOB_Params.IMM_Port != "443") {
						top.hideBmcWaitingMsg();
						top.hideCertWaitMsg();
						alert($.i18n.prop('TargetServer.Amd.Port', top.gl_OOB_Params.MT));
						return false;
					}
				}
			}
			Banner.set_active_status(gl_OOB_Params.MT, "");
			scan_status = "init";
			return true;
		}else if("runError" == isGettingMachineType){
			isGettingMachineType = false;
			scan_status = "init";
			return false;
		}else{
			showTipsInfo("");
			if(!checkOOBParams()){ 
				scan_status = "init";
				return false;
			}
			
			if(!isGettingMachineType)
				getMachineTypeByIMM();
			if(isGettingMachineType){
				top.togglePrevious(false);
				top.toggleNext(false);
				return "waiting";
			}
		}
	}

    function getMachineTypeByIMM(){
		deleteFile(top.getSupportFile("commonResult"));
		deleteFile(top.getSupportFile("scanResult"));
		
		$("#oobHostName,#oobPort,#oobUserName,#oobPassword,#oobNewPassword,#oobConfirmPassword").prop("disabled",true);
		isGettingMachineType = true;
		top.showBmcWaitingMsg();

		let args = [];
        args.push(top.getSystemFile("oneCli"));
        args.push("update");
        args.push("scan");
		args.push("--imm");
		args.push(SplitFullConnInfo());

		args.push("--never-check-trust");
		args.push(...add_output_log5());
		printLog("INFO","run commend:" + getRunProgramCommend(args));
		runProgram(args, null, onGetMachineTypeFinished);
	}

    function onGetMachineTypeFinished(){
		if (userCanceled) {
			top.togglePrevious(true);
			top.toggleNext(true);
			return;
		}
		let isError = false;
		let errorInfo = "";
		let errorCode = 0;
		try{
			let comm_ret_doc = top.readTextFile(top.getSupportFile("commonResult"));
			let comm_dom = ezJsLib.XmlDom.parse(comm_ret_doc);
			if("Yes" == ezJsLib.XmlDom.getValueByTagFromNode("ERROR", comm_dom.documentElement)){
				isError = true;
				errorInfo = ezJsLib.XmlDom.getValueByTagFromNode("MESSAGE", comm_dom.documentElement);
				errorCode = ezJsLib.XmlDom.getValueByTagFromNode("ERRORCODE", comm_dom.documentElement);
			}

			// Bug 113848 - [UpdateXpress_all os]Select a blue machine for UpdateXpress remote update , the error message is not correct
			if (errorInfo.indexOf("You are running on an IBM system. But the current command is not supported") != -1) {
				errorInfo = "blue";
				top.gl_OOB_Params.MT = "blue";
			} else {
				let doc = top.readTextFile(top.getSupportFile("scanResult"));
				let dom = ezJsLib.XmlDom.parse(doc);
				let mt = ezJsLib.XmlDom.getValueByTagFromNode("MT", dom.documentElement);
				if (!mt || typeof(mt) == "undefined") {
					isError = true;
					errorInfo = $.i18n.prop("TargetServer.TipsInfo8");
				} else {
					gl_OOB_Params.MT = mt;
				}
			}
		} catch(e) {
			isError = true;
			if (errorInfo == "") errorInfo = $.i18n.prop("TargetServer.TipsInfo8");
		}
		
		top.togglePrevious(true);
		top.toggleNext(true);
		$("#oobHostName,#oobPort,#oobUserName,#oobPassword,#oobNewPassword,#oobConfirmPassword").prop("disabled",false);
		top.hideBmcWaitingMsg();
		
		if (errorCode == PASSWORD_NEED_RESET) {
			isPasswordchangeable = true;
			document.getElementById("ChangePasswordDiv").style.display = "block";
			$("#oobNewPassword").val("");
			$("#oobConfirmPassword").val("");
			checkNewPassword();
			showTipsInfo(errorInfo, "showBMCTips");
			isGettingMachineType = "runError";
		} else if (isError) {
			if (errorInfo == "blue") {
				isGettingMachineType = "runned";
			} else {
				showTipsInfo(errorInfo, "showBMCTips");
				isGettingMachineType = "runError";
			}
		} else {
			isGettingMachineType = "runned";
		}
		goNextStep();
	}

    function startGetCert() {
		printLog("INFO","Next was clicked.");
        if (userSelected == 0) {
			top.onecliCommandStrings = [""];
			top.logFiles = [""];
			top.gl_mt_list = new Array();
			top.gl_os_list = new Array();
            return true;
        }
		if (top.gl_Inband_Params.Enabled) {
			// Inband input check
			if (top.gl_Inband_Params.UserInput) {
				if (!checkInbandInput()) {
					return false;
				}
				writeInbandParams();
				$("#showInbandBMCTips").hide();
			}
            if(!top.checkSupportMachineType(top.gl_current_mt))
            {
                if (top.gl_current_admin_account == "YES") {
                    alert($.i18n.prop("Common.SystemNotSupport"));
                    return false;
                } else {
                    alert($.i18n.prop("Common.AdminAcquired"));
                    return false;
                }
            }
			if (top.gl_uxlite_bootable != "1") {
				// Bootable will be set with BootableMedia_xxx
            	Banner.set_active_status(top.gl_current_mt, top.gl_current_os_d);
			}
			return true;
		} else if (top.gl_OOB_Params.Enabled) {
            if (scan_status == "init") {
                showTipsInfo("");
                userCanceled = false;
                if (!checkOOBParams()) return false;
                writeOOBParams();
                if (!tagCheckDefault) {
                    top.showCertWaitMsg();
                    return getIMMCert();
                } else {
                    scan_status = "start_get_mt";
                    return beginConnectServer();
                }
            } else if (scan_status == "bmc_fail") {
                top.hideCertWaitMsg();
                scan_status = "init";
                if (!userCanceled) {
                    showTipsInfo($.i18n.prop("TargetServer.GetTrustFailed"), "showBMCTips");
                    return false;
                } else {
                    top.togglePrevious(true);
                    top.toggleNext(true);
                    return "waiting";
                }
            } else if (scan_status == "bmc_success") {
                top.hideCertWaitMsg();
                certIMMSaveContent = null;
                certNewIMM = false;

                try {
                    certIMMTempContent = top.readTextFile(certIMMTempFile);
                } catch (e) {
                    showTipsInfo($.i18n.prop("TargetServer.GetTrustFailed"), "showBMCTips");
                    return false;
                }
                try {
                    certIMMSaveContent = top.readTextFile(certIMMSaveFile);
                } catch(e) {
                    certIMMSaveContent = null;
                }

                if (certIMMTempContent == '') certNewIMM = false;
                if (certIMMTempContent == certIMMSaveContent) certNewIMM = false;
                if (certIMMTempContent != certIMMSaveContent && certIMMTempContent != '') certNewIMM = true;

                if (certNewIMM) {
                    document.getElementById("bmcCertDialog").style.height = "295px";
                    $("#bmcCertSection").show();
                    $("#bmcCertArea").html(certIMMTempContent);
                } else {
                    return beginConnectServer();
                }

                if (!userCanceled) {
                    showCertContentMsg();
                    return "waiting";
                } else {
                    scan_status = "init";
                    return "waiting";
                }
            } else if (scan_status == "cert_no_accept") {
                top.togglePrevious(true);
                top.toggleNext(true);
                scan_status = "init";
                return "waiting";
            } else if (scan_status == "start_get_mt") {
                if (certNewIMM) {
                    if (top.fileExists(certIMMSaveFile)) {
                        top.deleteFile(certIMMSaveFile);
                    }
                    top.writeTextFile(certIMMSaveFile, certIMMTempContent);
                }
                return beginConnectServer();
            }
		}
	}

    function showCertContentMsg() {
        $("#bmcCertConfirmDiv").show();
    }

    function hideCertContentMsg() {
		$("#bmcCertConfirmDiv").hide();
	}

    function acceptCert() {
		hideCertContentMsg();
		cleanCertContent();
		scan_status = "start_get_mt";
		goNextStep();
	}

	function noAcceptCert() {
		hideCertContentMsg();
		cleanCertContent();
		scan_status = "cert_no_accept";
		goNextStep();
	}

	function cleanCertContent() {
		$("#bmcCertSection").hide();
		$("#bmcCertArea").html("");
	}

    
	function setUserCancel(value) {
        userCanceled = value;
        isGettingMachineType = false;
        scan_status = "init";
        $("#oobHostName, #oobPort, #oobUserName, #oobPassword,#oobNewPassword,#oobConfirmPassword").prop("disabled", false);
    }

    function userCancelGetCert(value) {
    	scan_status = "init";
    	userCanceled = true;
    	$("#oobHostName, #oobPort, #oobUserName, #oobPassword,#oobNewPassword,#oobConfirmPassword").prop("disabled", false);
    }

	function showPasswordTips() {
		$("#PasswordTipsDiv").show();
	}
	function hidePasswordTips() {
		$("#PasswordTipsDiv").hide();
	}

	function oobHostNameChanged(){
		let val = document.getElementById("oobHostName").value;
		updateList(val);
	}
    
    return {
        index: 0,
        name: "Target_Server",
        init: acc_init,
        nextAction: startGetCert,
        previousAction: function () {
            printLog("INFO", "Previous was clicked.");
            showTipsInfo("");
            return true;
        },
        checkDefault: checkDefault,
        toggleInbandSection: toggleInbandSection,
        acceptCert: acceptCert,
        noAcceptCert: noAcceptCert,
        updateManagementType: updateManagementType,
        setUserCancel: setUserCancel,
        userCancelGetCert: userCancelGetCert,
		showPasswordTips: showPasswordTips,
		hidePasswordTips: hidePasswordTips,
		checkNewPassword: checkNewPassword,
		oobHostNameChanged: oobHostNameChanged,
        needReInit: true,
        importId: '#import_target_server',
        selectorId: '.target_server',
        title: "Navi.TargetServer"
    }
}();