// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Update_Execution = function() {
    var up_progress_timer;
    var up_table_visibility;
    var up_total;
    var up_package_index;
    var up_running;
    // var up_isPurley;
    var up_isGrantly;
    var up_isELIE;
    var up_args;
    var up_isbundle;
    
    var up_flashResult; // up_flashResult & 1: error, up_flashResult & 2: warning

    const ONECLIRESULT_TASK_STAGED = 86;

    // current index of payload that is copying
    var copyIndex = 0;
    // total number of payloads that need copy
    var copyTotal = 0;
    // if a payload is failed to copy, will push into this array
    // if copyError.length > 0, will warn user
    // if copyError.length = copyTotal, will let user retry
    var copyError = new Array();

    var waitForComplete = 0;

    // for salie, after comparing updates and user select packages to update, will copy payloads from /run/initramfs/live to /toolscenter
    // after copying, start normal process
    function up_init() {
        printLog("INFO","Update Execution page init.");
        $("#ue-taskid").parent().hide();
        // fix problem that when it is bootable, unattended mode in usb, Update_Execution will be inited when Update Comparison is not finished. 
        // do not init Update Execution when Update Comparison is not finished. 
        if (top.gl_uxlite_bootable) {
            if (top.gl_isOnecli == undefined) {
                return;
            }
        }
        // init page
        // transfer to appropriate value
        if (top.gl_uxlite_bootable) {
            $('#BundleDiv').hide();
            up_isbundle = false;
        } else {
            $('#BundleDiv').show();
            up_isbundle = $("#EnableBundleCheckbox").prop("checked");
        }
        if (up_isbundle) {
            $('#ApplyTimeDiv').show();
        } else {
            $('#ApplyTimeDiv').hide();
        }
        if (top.gl_OOB_Params.Enabled) {
            $('#ApplyTimeOption option[value="OnReset"]').show();
            $('#ApplyTimeOption option[value="Immediate"]').show();
            $('#ApplyTimeOption option[value="Immediate"]').prop("selected", true);
            $('#InstructionalForOnReset').hide();
            $('#InstructionalForImmediate').show();
            $('#InstructionalForOnStartUpdateRequest').hide();
        } else {
            $('#ApplyTimeOption option[value="OnReset"]').show();
            $('#ApplyTimeOption option[value="Immediate"]').hide();
            $('#ApplyTimeOption option[value="OnReset"]').prop("selected", true);
            $('#InstructionalForOnReset').show();
            $('#InstructionalForImmediate').hide();
            $('#InstructionalForOnStartUpdateRequest').hide();
        }

        var osRelease = '';
        if (top.gl_uxlite_bootable && top.fileExists('/etc/redhat-release')) {
            try {
                osRelease = top.readTextFile('/etc/redhat-release');
            } catch(e) {
                osRelease = ''; 
            }
        } else if (top.gl_uxlite_bootable && top.fileExists('/etc/elie_version')) {
            try {
                osRelease = top.readTextFile('/etc/elie_version');
            } catch(e) {
                osRelease = ''; 
            }
        }
        up_isELIE = (osRelease.indexOf('ELIE') != -1);
        // only need copy payloads when it is salie and it is not boot by usb key or pxe
        // for salie, in /etc/redhat-release, it is CentOS
        // for elie, in /etc/elie_version, it is ELIE
        if ((osRelease.indexOf('CentOS') != -1 || osRelease.indexOf('ELIE') != -1) && top.need_copy() && !in_ramdisk()) {
            startCopy();
        }
        else {
            up_init_normal();
        }
        up_flashResult = 0;
    }

    function startCopy() {
        top.togglePrevious(false);
        top.toggleNext(false);
        copyTotal = top.gl_co_list.length;
        copyIndex = 0;
        copyError = new Array();
        $('#copyMsg').html('');
        $('#errMsgExec2').html('');
        $('#errMsgExec').hide();
        $('#warnMsgExec').hide();
        $('#warnMsgExec2').html('');
        $('#copy_success').hide();
        $('#copyBeginSection').hide();
        $('#EnableBundleDiv').hide();
        $('#ApplyTimeDiv').hide();
        $('#updateBeginSection').hide();
        document.getElementById('copyProgress').style.marginRight = '100%';
        $('#copy_status').show();
        if (up_isELIE) {
            top.createDirectory("/run/initramfs/live");
            var mountArgs = new Array();
            mountArgs.push("mount");
            mountArgs.push("/dev/sr0");
            mountArgs.push("/run/initramfs/live");
            printLog("INFO","run commend:" + getRunProgramCommend(mountArgs));
            runProgram(mountArgs, null, copyPayload);
        }
        else {
            copyPayload(true);
        }
    }

    function copyPayload(success) {
        if (!success) {
            copyError.push(top.gl_co_list[copyIndex - 1]);
        }
        if (copyIndex > copyTotal - 1) {
            if (up_isELIE) {
                var umountArgs = new Array();
                umountArgs.push("umount");
                umountArgs.push("/run/initramfs/live");
                printLog("INFO","run commend:" + getRunProgramCommend(umountArgs));
                runProgram(umountArgs, null, completeCopy);
            }
            else {
                completeCopy();
            }
        } else {
            var payloadFile = top.gl_payload_list[copyIndex];
            if (payloadFile.substring(0, "/toolscenter/".length) != "/toolscenter/") {
                payloadFile = "/toolscenter/" + payloadFile;
            }
            var parentDir = top.dirname(payloadFile);
            payloadFile = payloadFile.substring("/toolscenter".length);
            top.createDirectory(parentDir);
            var copyArgs = new Array();
            copyArgs.push("cp");
            copyArgs.push("-rf");
            copyArgs.push("/run/initramfs/live" + payloadFile);
            copyArgs.push("/toolscenter" + payloadFile)
            copyIndex++;
            // show progress
            document.getElementById("copyMsg").innerHTML = $.i18n.prop("UpdateExec.Copying") + " " + copyIndex + " of " + copyTotal;
            var percentage = formatData((1 - copyIndex / copyTotal) * 100) + "%";
            document.getElementById("copyProgress").style.marginRight = percentage;
            printLog("INFO","run commend:" + getRunProgramCommend(copyArgs));
            runProgram(copyArgs, null, copyPayload);
        }
    }

    function completeCopy() {
        $('#copy_status').hide();
        top.togglePrevious(true);
        if (copyError.length == copyTotal) {
            $('#errMsgExec').show();
            $('#errMsgExec2').html($.i18n.prop('UpdateExec.FailCopyAll'));
            $('#copyBeginSection').show();
            top.toggleNext(false);
        } else if (copyError.length > 0) {
            $('#warnMsgExec').show();
            var warnMsg = $.i18n.prop('UpdateExec.FailCopySome');
            for (var i = 0; i < copyError.length; i++) {
                warnMsg += '<br>' + copyError[i];
            }
            $('#warnMsgExec2').html(warnMsg);
            $('#copyBeginSection').show();
            $('#EnableBundleDiv').show();
            if (up_isbundle) $('#ApplyTimeDiv').show();
            $('#updateBeginSection').show();
            top.toggleNext(true);
        } else {
            $('#copy_success').show();
            $('#copyBeginSection').hide();
            up_init_normal();
        }
    }

    function up_init_normal() {
        // init
        // if execution page is inited, View Log at Finish page should show flash log instead of acquiring log.
        // clean the previous value of logfile
        // if flash is success, it will assign a new value to this variable, else, it will remain an empty string.
        setLogFile("");
        up_table_visibility = false;
        up_total = -1;
        up_package_index = 0;
        up_running = false;
        up_args = new Array();
        top.togglePrevious(true);

        $("#up_status").hide();
        $('#EnableBundleDiv').show();
        if (up_isbundle) $('#ApplyTimeDiv').show();
        $("#updateBeginSection").show();
        toggleNext(false);
        // fix problem that flash is not started automatically when autorun is enabled
        if (top.gl_uxlite_bootable == '1') {
            if (top.is_unattend() || top.is_autorun()) {
                $("#updateBeginBtn").click();
            }
        }
        // up_isPurley = top.isPurley();
        up_isGrantly = top.isGrantly();
        /*
        if (top.gl_OOB_Params.MT.startsWith("7x") || top.gl_OOB_Params.MT.startsWith("7X") || top.gl_current_mt_d.startsWith("7x") || top.gl_current_mt_d.startsWith("7X")) {
            up_isPurley = true;
        }
        */
    }

    function confirmUpdate() { 
        printLog("INFO","button 'Begin Update' was clicked.");
        $('#copy_status').hide();
        $('#errMsgExec').hide();
        $('#warnMsgExec').hide();
        $('#copy_success').hide(); 
        $('#copyBeginSection').hide();
        if (top.gl_uxlite_bootable == "1" && (top.is_unattend() || top.is_autorun())) {
            beginExecute();
        } else {
            if (top.gl_OOB_Params.Enabled) {
                if (confirm($.i18n.prop("UpdateExec.RebootConfirm"))) {
                    beginExecute();
                }
            } else {
                if (confirm($.i18n.prop("UpdateExec.UpdateConfirm"))) {
                    beginExecute();
                }
            }
        }
    }

    function beginExecute() {
        // show status bar and hide begin button
        $('#EnableBundleDiv').hide();
        $('#ApplyTimeDiv').hide();
        $("#updateBeginSection").hide();
        $("#up_status").show();
        beginUpdate();
    }

    function updateCB() {
        up_args.push("--comparexml");
        up_args.push(top.getSupportFile('compareResult', 'rewrite'));
        togglePrevious(false);
        toggleNext(false);
        up_running = true;
        top.store_onecli_command(up_args);
        printLog("INFO","run commend:" + getRunProgramCommend(up_args));
        runProgram(up_args, null, markComplete);
        up_progress_timer = setInterval(showStatus_up, 1000);
    }

    function RemoteServerConnInfo() {
        if (top.gl_Remote_Params.Remote_UserName != "" || top.gl_Remote_Params.Remote_Password != "") {
            if (top.gl_Remote_Params.Remote_Port == "") {
                if (top.gl_Remote_Params.Remote_Address.indexOf(":") != -1) {
                    return (top.gl_Remote_Params.Remote_UserName + ":" + top.gl_Remote_Params.Remote_Password + "@[" + top.gl_Remote_Params.Remote_Address + "]" + top.gl_Remote_Params.Remote_Location);
                } else {
                    return (top.gl_Remote_Params.Remote_UserName + ":" + top.gl_Remote_Params.Remote_Password + "@" + top.gl_Remote_Params.Remote_Address + top.gl_Remote_Params.Remote_Location);
                }
            } else {
                if (top.gl_Remote_Params.Remote_Address.indexOf(":") != -1) {
                    return (top.gl_Remote_Params.Remote_UserName + ":" + top.gl_Remote_Params.Remote_Password + "@[" + top.gl_Remote_Params.Remote_Address + "]:" + top.gl_Remote_Params.Remote_Port + top.gl_Remote_Params.Remote_Location);
                } else {
                    return (top.gl_Remote_Params.Remote_UserName + ":" + top.gl_Remote_Params.Remote_Password + "@" + top.gl_Remote_Params.Remote_Address + ":" + top.gl_Remote_Params.Remote_Port + top.gl_Remote_Params.Remote_Location);
                }
            }
        } else {
            if (top.gl_Remote_Params.Remote_Port == "") {
                if (top.gl_Remote_Params.Remote_Address.indexOf(":") != -1) {
                    return ("[" + top.gl_Remote_Params.Remote_Address + "]" + top.gl_Remote_Params.Remote_Location);
                } else {
                    return (top.gl_Remote_Params.Remote_Address + top.gl_Remote_Params.Remote_Location);
                }
            } else {
                if (top.gl_Remote_Params.Remote_Address.indexOf(":") != -1) {
                    return ("[" + top.gl_Remote_Params.Remote_Address + "]:" + top.gl_Remote_Params.Remote_Port + top.gl_Remote_Params.Remote_Location);
                } else {
                    return (top.gl_Remote_Params.Remote_Address + ":" + top.gl_Remote_Params.Remote_Port + top.gl_Remote_Params.Remote_Location);
                }
            }
        }
    }

    function beginUpdate() {
        //Preparation
        waitForComplete = 0;
        deleteFile(top.getVarLogFile("updateResult", "uxspi"));
        deleteFile(top.getSupportFile("updateResult", "oneCli"));
        deleteFile(top.getSupportFile("commonResult"));
        up_args = new Array();
        up_args.push(top.getSystemFile("oneCli"));
        up_args.push("update");
        up_args.push("flash");
        // if(top.gl_isOnecli) {
        //     up_args.push("--nocompare");
        // }
        if (top.gl_OOB_Params.Enabled) {
            up_args.push("--uselocalimg");
            up_args.push("--imm");
            up_args.push(SplitFullConnInfo());
            
            if (top.gl_Remote_Params.Use_Sep_Remote) {
                // One and only one protocol has been selected in OOBSetting
                if (top.gl_Remote_Params.Use_Sep_SFTP) {
                    up_args.push("--sftp");
                } else if (top.gl_Remote_Params.Use_Sep_HTTPS) {
                    up_args.push("--https");
                } else if (top.gl_Remote_Params.Use_Sep_FTP) {
                    up_args.push("--ftp");
                } else if (top.gl_Remote_Params.Use_Sep_HTTP) {
                    up_args.push("--http");
                }
                up_args.push(RemoteServerConnInfo());
            }
            up_args.push("--never-check-trust");
        } else {
            // inband CFC also use external server
            if (top.gl_Remote_Params.Use_Sep_Remote) {
                if (top.gl_Remote_Params.Use_Sep_SFTP) {
                    up_args.push("--sftp");
                } else if (top.gl_Remote_Params.Use_Sep_HTTPS) {
                    up_args.push("--https");
                } else if (top.gl_Remote_Params.Use_Sep_FTP) {
                    up_args.push("--ftp");
                } else if (top.gl_Remote_Params.Use_Sep_HTTP) {
                    up_args.push("--http");
                }
                up_args.push(RemoteServerConnInfo());
                up_args.push("--never-check-trust");
            }
        }

        // inband parameters
        // add by chenhao at 20170606
        if (top.gl_Inband_Params.Enabled && top.gl_Inband_Params.UserInput) {
            if (top.gl_Inband_Params.IMM_UserName != "" && top.gl_Inband_Params.IMM_UserName != null && top.gl_Inband_Params.IMM_UserName != undefined
             && top.gl_Inband_Params.IMM_Password != "" && top.gl_Inband_Params.IMM_Password != null && top.gl_Inband_Params.IMM_Password != undefined) {
                up_args.push("--bmc-username");
                up_args.push(top.gl_Inband_Params.IMM_UserName);
                up_args.push("--bmc-password");
                up_args.push(top.gl_Inband_Params.IMM_Password);
            }

            if (top.gl_Inband_Params.IMM_Port != "" && top.gl_Inband_Params.IMM_Port != null && top.gl_Inband_Params.IMM_Port != undefined) {
                up_args.push("--bmc-cim-port");
                up_args.push(top.gl_Inband_Params.IMM_Port);
            }

            if (top.gl_Inband_Params.REST_Port != "" && top.gl_Inband_Params.REST_Port != null && top.gl_Inband_Params.REST_Port != undefined) {
                up_args.push("--bmc-rest-port");
                up_args.push(top.gl_Inband_Params.REST_Port);
            }
        }

        // bundle parameters
        if (up_isbundle) {
            up_args.push("--bundle");
            up_args.push("--applytime");
            var applyTimeArg = $('#ApplyTimeOption').prop("value");
            up_args.push(applyTimeArg);
        }

        up_args.push("--dir");
        up_args.push(top.gl_workingDir);
        up_args.push(...add_output_log5());
        var updateIds = "";
        var forceIds = "";

        if (top.gl_optionBackup == true) {
            up_args.push("--backup");
        }

        // grantley bmu function
        // red systems have bmu function always
        // no need to determine whether the system is purley or grantley
        // if (top.gl_OOB_Params.Enabled && up_isPurley) {  
        if (!top.gl_OOB_Params.Enabled && !top.gl_isOnecli) {   // UXSPI case
            for (var i = 0; i < top.gl_selected_list.length; i++) {
                if (i == 0) updateIds += top.gl_selected_list[i]; 
                else updateIds += "," + top.gl_selected_list[i];
            }
            up_args.push("--includeid");
            up_args.push(updateIds);

            if (top.gl_forceid_list.length > 0) {
                for (var i = 0; i < top.gl_forceid_list.length; i++) {
                    if (i == 0) forceIds += top.gl_forceid_list[i]; 
                    else forceIds += "," + top.gl_forceid_list[i];
                }
                up_args.push("--forceid");
                up_args.push(forceIds);
            }
            
            togglePrevious(false);
            toggleNext(false);
            up_running = true;
            // defect-160364: BOMC boot from USBkey, when update fail, then click "previous" return to "update conparison" page, can't click “next” button
            var co_file_path = top.getVarLogFile("compareResult", "uxspi");
            var co_file_bak_path = top.getVarLogFile("compareResult", "uxspi_bak");
            if (co_file_path) {
                top.rename(co_file_path, co_file_bak_path);
            }
            printLog("INFO","run command:" + getRunProgramCommend(up_args));
            runProgram(up_args, null, markComplete);
            up_progress_timer = setInterval(showStatus_up, 1000);
        } else {    // inband case and oob case
            if (!up_isbundle && top.gl_OOB_Params.Enabled && !top.isAmd()) {
                up_args.push('--platform');
            }
            if (top.is_reboot_bmc() == false) {
                up_args.push('--noreboot');
            }
            rewrite_compare_result(top.gl_selected_list, top.gl_forceid_list, updateCB);
        }
    }

    function markComplete(rc, error) {
        up_running = false;
    }

    function up_backEntry() {
        // do nothing when back from the next page
    }

    function showStatus_up() {
        var up_running_cache = up_running;
        var content;        
        if(top.fileExists(top.getSupportFile("updateResult", "oneCli"))) {
            content = top.readTextFile(top.getSupportFile("updateResult", "oneCli"));    
        } else if(top.fileExists(top.getVarLogFile("updateResult", "uxspi"))) {
            content = top.readTextFile(top.getVarLogFile("updateResult", "uxspi"));
        }
        if (content != null) {
            var dom = ezJsLib.XmlDom.parse(content);
            if (!up_table_visibility)  {
                createDetailTable(dom);
                up_table_visibility = true;
            }
            updateDetailTable(dom, up_running_cache);
            updateProgressBar(up_running_cache);
        }
        //if (!up_running_cache && (up_total == up_package_index)) 
        // Bug 117321 - xClarity Essential tool BoMC v11.0 window hung and fail to exit after system update completed.
        // for bootable mode, will detect whether common_result.xml is completed writing
        // if it is completed writing, will set up_running_cache to false
        // added by chenhao: 2017.11.1
        if (top.gl_uxlite_bootable) {
            if (top.fileExists(top.getSupportFile('commonResult'))) {
                var resultFile = top.readTextFile(top.getSupportFile('commonResult'));
                var resultDom;
                var resultRC;
                if (resultFile != null) {
                    try {
                        resultDom = ezJsLib.XmlDom.parse(resultFile);
                        resultRC = ezJsLib.XmlDom.getValueByTagFromNode("RETURNCODE", resultDom.documentElement);
                    } catch(e) {
                        // do nothing
                    }
                    console.log('resultRC is: ' + resultRC);
                    if (resultRC != null || resultRC != undefined) {
                        up_running_cache = false;
                    }
                }
            }
        }
        if (!up_running_cache) {
            clearInterval(up_progress_timer);
            getCommonResult();
            if (needPrereqWarn()) {
                top.gl_needPrereqWarn = true;
            }
            togglePrevious(true);
            toggleNext(true);
            showTaskId();
        }
    }

    function reConfigSteps(hasTaskId) {
        if(hasTaskId){
            let currentIndex = top.gl_wizard.data("state").currentIndex;
            if (top.gl_steps_current[currentIndex + 1] == Task_Complete) {
                top.gl_steps_current.splice(currentIndex + 1, 0, Staged_Task);
            }
            configSteps(top.gl_steps_current);
            Staged_Task.setSkipRepoter(true);
        } else {
            let currentIndex = top.gl_wizard.data("state").currentIndex;
            if (top.gl_steps_current[currentIndex + 1] == Staged_Task) {
                top.gl_steps_current.splice(currentIndex + 1, 1);
            }
            configSteps(top.gl_steps_current);
        }
    }

    function showTaskId(){
        var applyTimeArg = $('#ApplyTimeOption').prop("value");
        if(!up_isbundle){
            return;
        }
        var content = null;

        if(top.fileExists(top.getSupportFile("flashResult"))) {
            content = top.readTextFile(top.getSupportFile("flashResult"));
            if (content != null) {
                var dom = ezJsLib.XmlDom.parse(content);
                let taskId = ezJsLib.XmlDom.getValueByTag("TASKID", dom);
                let applytime = ezJsLib.XmlDom.getValueByTag("APPLYTIME", dom);
                document.getElementById("ue-taskid").innerText = taskId;
                if(taskId != null && taskId.length > 0){
                    $("#ue-taskid").parent().show();
                    Staged_Task.setTaskId(taskId);
                    reConfigSteps(true);
                } else {
                    Staged_Task.setTaskId("");
                    reConfigSteps(false);
                }
            }
        }
    }

    function needPrereqWarn() {
        var content = null;
        var res = false;

        if(top.fileExists(top.getSupportFile("updateResult", "oneCli"))) {
            content = top.readTextFile(top.getSupportFile("updateResult", "oneCli"));
            if (content != null) {
                var dom = ezJsLib.XmlDom.parse(content);
                var total = ezJsLib.XmlDom.getValueByTag("TOTAL", dom);
                var res_code;
                var prereq_code = "1703";
                for (var i = 0; i < total; i++) {
                    res_code = ezJsLib.XmlDom.getValueByTagAndIndex("RESCODE", dom, i);
                    if (res_code === prereq_code) {
                        res = true;
                        break;
                    } else {
                        res = false;
                    }
                }
            }
        }

        return res;
    }

    function createDetailTable(dom) {
        var table = document.getElementById('up_progress_table');
        var mt, os, total;
        if (top.gl_isOnecli) {   
            mt = top.gl_current_mt_d;
            os = top.gl_current_os_d;
            // arch = top.gl_current_arch_d;
        } else {
            mt = ezJsLib.XmlDom.getValueByTag("MT", dom);
            os = ezJsLib.XmlDom.getValueByTag("OS", dom);
            // arch = ezJsLib.XmlDom.getValueByTag("ARCH", dom);
        }
        // for OOB case, need to get MT from remote machine
        if (top.gl_OOB_Params.Enabled) mt = top.gl_OOB_Params.MT;

        total = ezJsLib.XmlDom.getValueByTag("TOTAL", dom);

        document.getElementById("up_progress").style.display = "";
        table.style.visibility = "visible";
        /************ Why the following method does not work on IE? Include <td> in the <tr>?*************/
        /*var con = "<td colspan=\"2\" class='EntityTableCell2'>Machine-Type=\""
                    + mt + "\", OS="
                    + os + "</td>";
        alert(con);
        table.insertRow(-1).innerHTML = con;*/

        var newCell = table.insertRow(-1).insertCell(-1);
        newCell.colSpan = 4;
        newCell.className = "EntityTableCell2";
        if (top.gl_uxlite_bootable == "1") {
            newCell.innerHTML = "Machine-Type=\"" + mt + "\"";
        } else if (top.gl_OOB_Params.Enabled) {
            newCell.innerHTML = "Remote Machine-Type=\"" + mt + "\"";
        } else {
            // newCell.innerHTML = "Machine-Type=\"" + mt + "\", OS=" + os + " (" + arch + ")";
            newCell.innerHTML = "Machine-Type=\"" + mt + "\", OS=" + os;
        }
        up_total = parseInt(total);
        for (var i = 0; i < total; i++) {
            //default consider that its a full xml file, including all nodes
            var nameValue, reboot, statusValue, errorMsg, updateId, CompValue, resultValue, rclevel;
            nameValue = ezJsLib.XmlDom.getValueByTagAndIndex("NAME", dom, i);
            reboot = ezJsLib.XmlDom.getValueByTagAndIndex("REBOOT", dom, i);
            errorMsg = ezJsLib.XmlDom.getValueByTagAndIndex("ERRORMESSAGE", dom, i);
            updateId = ezJsLib.XmlDom.getValueByTagAndIndex("UPDATEID", dom, i);
            CompValue = ezJsLib.XmlDom.getValueByTagAndIndex("COMPONENT", dom, i);
            resultValue = ezJsLib.XmlDom.getValueByTagAndIndex("RESULT", dom, i);
            statusValue = ezJsLib.XmlDom.getValueByTagAndIndex("STATUS", dom, i);
            rclevel = ezJsLib.XmlDom.getValueByTagAndIndex("RCLEVEL", dom, i);
            if (top.gl_isOnecli)
            {
                statusValue = ezJsLib.XmlDom.getStatus(statusValue);
            }
            // Check whether uEFI update succeed.
            var pos = CompValue.indexOf("UEFI")
            if (pos != -1) {
                top.gl_isValidUefiUpdate = true;//fix coverity issue 46956
            }

            //add a new row
            var newRow = table.insertRow(-1);

            var newCell1 = newRow.insertCell(-1);
            newCell1.innerHTML = nameValue;
            newCell1.title = nameValue;
            newCell1.className = "EntityTableCell";

            /*
            var newCell4 = newRow.insertCell(-1);
            newCell4.innerHTML = newVersion;
            newCell4.title = newVersion;
            newCell4.className = "EntityTableCell";
            */

            var newCell6 = newRow.insertCell(-1);
            if (reboot.indexOf("No") != -1) {
                newCell6.innerHTML = reboot;
            } else {
                newCell6.innerHTML = "Required";
            }
            newCell6.title = reboot;
            newCell6.className = "EntityTableCell";

            var newCell7 = newRow.insertCell(-1);
            newCell7.title = statusValue;
            newCell7.className = "EntityTableCell";
            if (statusValue == "Successfully Installed") {
                newCell7.innerHTML = "<img src='images/statusSuccess_obj16.gif'>" + statusValue;
            } else if (statusValue == "Running") {
                newCell7.innerHTML = "<img src='images/progress_anim2_small.gif'>" + statusValue;
            } else if (statusValue == "Not Started") {
                newCell7.innerHTML = "<img src='images/statusStopped_obj16.gif'>" + statusValue;
            } else {
                var values = new Array();
                filterStatusValue(values, statusValue);
                if (values.length == 3) {
                    newCell7.title = values[2];
                    if (values[0] == "Not Applicable") {
                        newCell7.innerHTML = "<img src='images/statusInformation_obj16.gif'>" + values[0] + " <a href=\"javascript:void 0\" onclick=\"alert('" + values[2] + "');\">" + $.i18n.prop("UpdateExec.HardwareNotPresent") + "</a>";
                        up_flashResult |= 0x2;
                    } else {
                        newCell7.innerHTML = "<img src='images/statusCritical_obj16.gif'>" + values[0] + " <a href=\"javascript:void 0\" onclick=\"alert('" + values[2] + "');\">" + $.i18n.prop("UpdateExec.More") + "</a>";
                        up_flashResult |= 0x1;
                    }
                } else if (values.length == 1) {
                    if (errorMsg == "") {
                        table.rows[up_package_index + 2].cells[3].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + values[0];
                        up_flashResult |= 0x1;
                    } else {
                        newCell7.title = errorMsg;
                        newCell7.innerHTML = "<img src='images/statusCritical_obj16.gif'>" + values[0] + " <a href=\"javascript:void 0\" onclick=\"alert('" + errorMsg + "');\">" + $.i18n.prop("UpdateExec.FailMsg") + "</a>";
                        up_flashResult |= 0x1;
                    }
                } else {
                    switch (rclevel) {
                        case '0': // info should not be here, display critical icon
                            newCell7.innerHTML = "<img src='images/statusCritical_obj16.gif'>" + statusValue;
                            up_flashResult |= 0x1;
                            break;
                        case '1': // error
                            newCell7.innerHTML = "<img src='images/statusCritical_obj16.gif'>" + statusValue;
                            up_flashResult |= 0x1;
                            break;
                        case '2': // warning
                            newCell7.innerHTML = "<img src='images/statusWarning_obj16.gif'>" + statusValue;
                            up_flashResult |= 0x2;
                            break;
                        default:
                            newCell7.innerHTML = "<img src='images/statusCritical_obj16.gif'>" + statusValue;
                            up_flashResult |= 0x1;
                            break;
                    }
                }
            }
            // add new column "Result"
            // 20161115 by chenhao
            var newCell8 = newRow.insertCell(-1);
            if (!resultValue || resultValue == "") {
                // do nothing
            } else {
                newCell8.innerHTML = resultValue;
                newCell8.title = resultValue;
            }
            newCell8.className = "EntityTableCell";
        }
    }

    function updateStatusAndRebootCell(row, iconPath, statusValue, rebootValue) {
        row.cells[2].innerHTML = iconPath + statusValue;
        row.cells[2].title = statusValue;
        row.cells[1].title = rebootValue;
        row.cells[1].innerHTML = rebootValue;
    }

    function updateDetailTable(dom, up_running_cache) {
        var table = document.getElementById('up_progress_table');
        var root = dom.documentElement;
        var nodes = root.getElementsByTagName("PACKAGE");
        var finishCount = 0;
        for(var nodeIndex = 0; nodeIndex < nodes.length; nodeIndex++) {
            if(!top.gl_OOB_Params.Enabled && up_isGrantly) {
                var statusNodes = nodes[nodeIndex].getElementsByTagName("STATUS");
                var msgNodes = nodes[nodeIndex].getElementsByTagName("ERRORMESSAGE");
                var errorMsg = "";
                var resultNodes = nodes[nodeIndex].getElementsByTagName("RESULT");
                var resultMsg = "";
                var rclevelNodes = nodes[nodeIndex].getElementsByTagName("RCLEVEL");
                var rclevel = null;
                if (msgNodes[0]) {
                    if (msgNodes[0].childNodes[0]) {
                        errorMsg = msgNodes[0].childNodes[0].nodeValue;
                    }
                }
                if (resultNodes[0]) {
                    if (resultNodes[0].childNodes[0]) {
                        resultMsg = resultNodes[0].childNodes[0].nodeValue;
                    }
                    if (!resultMsg || resultMsg == "") {
                        // do nothing
                    } else {
                        table.rows[nodeIndex + 2].cells[3].title = resultMsg;
                        table.rows[nodeIndex + 2].cells[3].innerHTML = resultMsg;
                    }
                }
                if (rclevelNodes[0]) {
                    if (rclevelNodes[0].childNodes[0]) {
                        rclevel = resultNodes[0].childNodes[0].nodeValue;
                    }
                }
                if (statusNodes[0]) {
                    if (statusNodes[0].childNodes[0]) {
                        var statusValue = ezJsLib.XmlDom.getStatus(statusNodes[0].childNodes[0].nodeValue);
                        table.rows[nodeIndex + 2].cells[2].title = statusValue;
                        if (statusValue == "Not Started") {
                            //do nothing, keep original table
                            if (!up_running_cache) 
                                finishCount++;
                        } else if (statusValue == "Running") {
                            if (!up_running_cache) {
                                table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + $.i18n.prop("UpdateExec.NotFinish");
                                up_flashResult |= 0x1;
                                finishCount++;
                            } else {
                                table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/progress_anim2_small.gif'>" + statusValue;
                            }
                        } else if (statusValue == "Successfully Installed") {
                            table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusSuccess_obj16.gif'>" + statusValue;
                            finishCount++;
                        } else {
                            //table.rows[nodeIndex + 2].cells[3].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + statusValue;
                            var updateId = ezJsLib.XmlDom.getValueByTagFromNode("UPDATEID", nodes[nodeIndex]);
                            var values = new Array();
                            filterStatusValue(values, statusValue);
                            if (values.length == 3) {
                                table.rows[nodeIndex + 2].cells[2].title = values[2];
                                if (values[0] == "Not Applicable") {
                                    table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusInformation_obj16.gif'>" + values[0] + " <a href=\"javascript:void 0\" onclick=\"alert('" + values[2] + "');\">" + $.i18n.prop("UpdateExec.HardwareNotPresent") + "</a>";
                                    up_flashResult |= 0x2;
                                } else {
                                    table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + values[0] + " <a href=\"javascript:void 0\" onclick=\"alert('" + values[2] + "');\">" + $.i18n.prop("UpdateExec.More") + "</a>";
                                    up_flashResult |= 0x1;
                                }
                            } else if (values.length == 1) {
                                if (errorMsg == "") {
                                    table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + values[0];
                                    up_flashResult |= 0x1;
                                } else {
                                    table.rows[nodeIndex + 2].cells[2].title = errorMsg;
                                    table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + values[0] + " <a href=\"javascript:void 0\" onclick=\"alert('" + errorMsg + "');\">" + $.i18n.prop("UpdateExec.FailMsg") + "</a>";
                                    up_flashResult |= 0x1;
                                }
                            } else {
                                switch (rclevel) {
                                    case '0': // info should not be here, display critical icon
                                        table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + statusValue;
                                        up_flashResult |= 0x1;
                                        break;
                                    case '1': // error
                                        table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + statusValue;
                                        up_flashResult |= 0x1;
                                        break;
                                    case '2': // warning
                                        table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusWarning_obj16.gif'>" + statusValue;
                                        up_flashResult |= 0x2;
                                        break;
                                    default:
                                        table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + statusValue;
                                        up_flashResult |= 0x1;
                                        break;
                                }
                            }
                            finishCount++;
                        }
                    }
                }
            } else {    // for OOB and Purley case: add by chenhao: 20161101
                var statusNodes = nodes[nodeIndex].getElementsByTagName("STATUS");
                var resultNodes = nodes[nodeIndex].getElementsByTagName("RESULT");
                var rcNodes = nodes[nodeIndex].getElementsByTagName("RCODE");
                var rebootNodes = nodes[nodeIndex].getElementsByTagName("REBOOT");
                var rclevelNodes = nodes[nodeIndex].getElementsByTagName("RCLEVEL"); // 0: info 1: error 2: warning
                var statusValue, resultValue, rcValue, rebootValue, rclevel;
                try {
                    statusValue = statusNodes[0].childNodes[0].nodeValue;
                } catch(e) {
                    statusValue = "";
                }
                try {
                    resultValue = resultNodes[0].childNodes[0].nodeValue;
                } catch(e) {
                    resultValue = "";
                }
                try {
                    rebootValue = rebootNodes[0].childNodes[0].nodeValue;
                } catch (e) {
                    rebootValue = "";
                }
                rebootValue = top.reboot_decode(rebootValue.toString());
                try {
                    rcValue = rcNodes[0].childNodes[0].nodeValue;
                } catch(e) {
                    rcValue = 0;
                }
                try {
                    rclevel = rclevelNodes[0].childNodes[0].nodeValue;
                } catch(e) {
                    rclevel = "";
                }
                /*
                if (statusValue) {
                    table.rows[nodeIndex + 2].cells[2].title = statusValue;
                    table.rows[nodeIndex + 2].cells[2].innerHTML = statusValue;
                }
                if (rebootValue) {
                    table.rows[nodeIndex + 2].cells[1].title = rebootValue;
                    table.rows[nodeIndex + 2].cells[1].innerHTML = rebootValue;
                }
                */
                    if (!resultValue || resultValue == "") {         // no result value ==> the update of the package is not finished
                    if (rcValue == 0 || rcValue == ONECLIRESULT_TASK_STAGED) {
                        if (!up_running_cache) {
                            updateStatusAndRebootCell(table.rows[nodeIndex + 2], "<img src='images/statusCritical_obj16.gif'>", statusValue, rebootValue);
                            up_flashResult |= 0x1;
                            finishCount++;
                        } else {
                            // For those packages that are not the one being installed, if its status is "Ready", change it to "Not Started"
                            // show stopped icon
                            if (statusValue == "Ready" && nodeIndex != finishCount) {
                                statusValue = "Not Started";
                                updateStatusAndRebootCell(table.rows[nodeIndex + 2], "<img src='images/statusStopped_obj16.gif'>", statusValue, rebootValue);
                            } else {
                                updateStatusAndRebootCell(table.rows[nodeIndex + 2], "<img src='images/progress_anim2_small.gif'>", statusValue, rebootValue);
                            }
                        }
                    } else {
                        updateStatusAndRebootCell(table.rows[nodeIndex + 2], "<img src='images/statusCritical_obj16.gif'>", statusValue, rebootValue);
                        up_flashResult |= 0x1;
                    } 
                } else {
                    table.rows[nodeIndex + 2].cells[3].innerHTML = resultValue;
                    table.rows[nodeIndex + 2].cells[3].title = resultValue;
                    switch (rclevel) {
                        case '0': // info
                            if (rcValue == 0 || rcValue == ONECLIRESULT_TASK_STAGED) { // regard ONECLIRESULT_TASK_STAGED as success result
                                updateStatusAndRebootCell(table.rows[nodeIndex + 2], "<img src='images/statusSuccess_obj16.gif'>", statusValue, rebootValue);
                            } else {
                                updateStatusAndRebootCell(table.rows[nodeIndex + 2], "<img src='images/statusCritical_obj16.gif'>", statusValue, rebootValue);
                                up_flashResult |= 0x1;
                            }
                            break;
                        case '1': // error
                            updateStatusAndRebootCell(table.rows[nodeIndex + 2], "<img src='images/statusCritical_obj16.gif'>", statusValue, rebootValue);
                            up_flashResult |= 0x1;
                            break;
                        case '2': // warning
                            updateStatusAndRebootCell(table.rows[nodeIndex + 2], "<img src='images/statusWarning_obj16.gif'>", statusValue, rebootValue);
                            up_flashResult |= 0x2;
                            break;
                        default: // if RCLEVEL is not defined or RCLEVEL is empty
                            if (rcValue == 0 || rcValue == ONECLIRESULT_TASK_STAGED) {
                                updateStatusAndRebootCell(table.rows[nodeIndex + 2], "<img src='images/statusSuccess_obj16.gif'>", statusValue, rebootValue);
                            } else {
                                updateStatusAndRebootCell(table.rows[nodeIndex + 2], "<img src='images/statusCritical_obj16.gif'>", statusValue, rebootValue);
                                up_flashResult |= 0x1;
                            }
                            break;
                    }
                    finishCount++;
                }
            }
        }
        up_package_index = finishCount;
    }

    /*
     * Filter status value and sort "Install did not succeed" and other detail message.
     */
    function filterStatusValue(values, statusValue) {
        var criterion = "Install did not succeed";
        var pos = statusValue.indexOf(criterion);
        if (pos != -1) {
            values.push(criterion);
            if (statusValue.length > criterion.length) {
                values.push("Error Message");
                values.push(statusValue.substring(pos + criterion.length + 1, statusValue.length + 1));
            }
        } else {
            var criterion2 = "Not Applicable";
            var pos2 = statusValue.indexOf(criterion2);
            if (pos2 != -1) {
                values.push(criterion2);
                if (statusValue.length > criterion2.length) {
                    values.push("Update Message");
                    values.push(statusValue.substring(pos2 + criterion2.length + 1, statusValue.length + 1));
                }
            }
        }
    }

    function updateProgressBar(running) {
        if ((up_package_index + 1) > up_total) {
            if (!running) {
                return;
            } else {
                if (waitForComplete < 6) {
                    waitForComplete++;
                    return;
                } else {
                    document.getElementById("upMsg").innerHTML = $.i18n.prop("UpdateExec.CollectData");
                    document.getElementById("progressSectionExec").style.display = "none";
                    document.getElementById("progressImageExec").style.marginTop = "-10px";
                }
            }
        } else {
            document.getElementById("upMsg").innerHTML = $.i18n.prop("UpdateExec.Updating") + (up_package_index + 1) + " of " + up_total;
            var percentage = formatData((1 - (up_package_index + 1) / up_total) * 100) + "%";
            document.getElementById("installProgress").style.marginRight = percentage;
        }
    }

    //display messages from common_result.xml
    function getCommonResult() {
        var resultFile = top.readTextFile(top.getSupportFile("commonResult"));
        var resultDom, resultMsg, resultError;
        if (resultFile != null) {
            resultDom = ezJsLib.XmlDom.parse(resultFile);
            resultMsg = ezJsLib.XmlDom.getValueByTagFromNode("MESSAGE", resultDom.documentElement);
            resultError = false;
            if (resultDom.documentElement.getElementsByTagName("ERRORCODE").length > 0) {
                resultError = true;
                var errorCode = ezJsLib.XmlDom.getValueByTagFromNode("ERRORCODE", resultDom.documentElement);
                if (errorCode == 0 || errorCode == ONECLIRESULT_TASK_STAGED) {
                    resultError = false;
                }
            }
            /* if (resultError) {
                complete(0, resultMsg);
            } else if (resultMsg.indexOf("failed") != -1) {
                complete(2, resultMsg);
            } else {
                complete(1, resultMsg);
            } */
            if (resultError) {
                if (up_flashResult & 0x1) { // error
                    complete(1, resultMsg);
                } else if (up_flashResult & 0x2) { // warning
                    complete(2, resultMsg);
                }
            } else {
                complete(0, resultMsg);
            }
            setLogFile(ezJsLib.XmlDom.getValueByTag("LOGFILE", resultDom));
        } else {
            complete(1, top.getComErrMsg());
        }
    }

    function complete(c, msg) {
        switch (c) {
            case 0: // info
                document.getElementById("up_status").innerHTML = "<img src=\"images/statusSuccess.gif\" style=\"float:left;\"> <class=\"MessageDescription\" style=\"margin-left:36px;\" id=\"upMsg\">";
                var pos = msg.indexOf("\n");
                if (pos != -1) {
                    document.getElementById("upMsg").innerHTML = "<h3 id=\"upMsgContent1\"></h3>";
                    if (pos != msg.length - 1) {
                        document.getElementById("upMsg").innerHTML = "<h3 id=\"upMsgContent1\"></h3><br><p id=\"upMsgContent2\"></p>";
                        document.getElementById("upMsgContent2").innerText = msg.substring(pos + 1);
                    }
                    document.getElementById("upMsgContent1").innerText = msg.substring(0, pos);
                } else {
                    document.getElementById("up_status").innerHTML = "<img src=\"images/statusSuccess.gif\" style=\"float:left;\"> <class=\"MessageDescription\" style=\"margin-left:36px;\" id=\"upMsg\">";
                    // Don't use innerHTML = msg, because there are illegal characters in msg such as < >
                    document.getElementById("upMsg").innerText = msg;
                }
                break;
            case 1: // error
                $("#up_status").hide();
                $("#errMsgExec").show();
                $("#errMsgExec2").html($.i18n.prop("UpdateExec.ErrorInstall") + "<br>" + $.i18n.prop("UpdateExec.ErrorMsg", msg) + "<br>" + $.i18n.prop("UpdateExec.MoreInfo", top.getSupportDir()));
                // document.getElementById("up_status").style.display = "none";
                // document.getElementById("errMsgExec").style.display = "block";
                // document.getElementById("errMsgExec2").innerHTML = "Error(s) occured while installing! <br>Error message: " + msg;
                break;
            case 2: // warning
                $("#up_status").hide();
                $("#warnMsgExec").show();
                $("#warnMsgExec2").html(msg);
                // document.getElementById("up_status").style.display = "none";
                // document.getElementById("warnMsgExec").style.display = "block";
                // document.getElementById("warnMsgExec").childNodes[0].src = "images/statusWarning.png";
                // document.getElementById("warnMsgExec2").innerHTML = msg;
                break;
            default:
                break;
        }
        clearInterval(up_progress_timer);
        waitForComplete = 0;
        //We consider the user has completed his behavior, so they can't go previous page.
        //top.enableButton("nextButton", true);
        //top.enableButton("previousButton", true);
        if (top.getEnv("BOMC_UNATTENDED_MODE")) {
            top.Exit(false);
            return;
        }
    }

    function toggleEnableBundle() {
        if ($("#EnableBundleCheckbox").prop("checked")) {
			printLog("INFO","check box 'Bundle' checked.");
			$("#ApplyTimeDiv").show();
			up_isbundle = true;
		} else {
			printLog("INFO","check box 'Bundle' unchecked.");
			$("#ApplyTimeDiv").hide();
			up_isbundle = false;
		}
    }

    function changeApplyTimeOpt() {
        var applytime = $('#ApplyTimeOption').prop("value");
        printLog('INFO','[Update_Execution.html:ApplyTimeOption] Apply Time: ' + applytime);
        if (applytime == "OnReset") {
            $('#InstructionalForOnReset').show();
            $('#InstructionalForImmediate').hide();
            $('#InstructionalForOnStartUpdateRequest').hide();
        } else if (applytime == "Immediate") {
            $('#InstructionalForOnReset').hide();
            $('#InstructionalForImmediate').show();
            $('#InstructionalForOnStartUpdateRequest').hide();
        } else if (applytime == "OnStartUpdateRequest") {
            $('#InstructionalForOnReset').hide();
            $('#InstructionalForImmediate').hide();
            $('#InstructionalForOnStartUpdateRequest').show();
        }
    }

    function onCopyTaskID(){
        let taskid = document.getElementById("ue-taskid").innerText;
        window.copyToClipBoard(taskid);
    }

    return {
        init: up_init,
        backEntry: up_backEntry,
        index: 0,
        name: "Update_Execution",
        nextAction: function() { 
            printLog("INFO","Next was clicked.");
            clearInterval(up_progress_timer);
            return true;
        },
        previousAction: function() {
            printLog("INFO","Previous was clicked.");
            // defect-160364: BOMC boot from USBkey, when update fail, then click "previous" return to "update conparison" page, can't click “next” button
            if (!top.gl_OOB_Params.Enabled && !top.gl_isOnecli) {
                var co_file_path = top.getVarLogFile("compareResult", "uxspi");
                var co_file_bak_path = top.getVarLogFile("compareResult", "uxspi_bak");
                if (top.fileExists(co_file_bak_path)) {
                    top.rename(co_file_bak_path, co_file_path);
                }
            }
            clearInterval(up_progress_timer);
            toggleNext(true);
            return true;
        },     
        beginExecute: beginExecute,
        confirmUpdate: confirmUpdate, 
        toggleEnableBundle: toggleEnableBundle,
        changeApplyTimeOpt: changeApplyTimeOpt,
        startCopy: startCopy,
        onCopyTaskID: onCopyTaskID,
        importId: '#import_update_execution',
        selectorId: '.update_execution',
        title: "Navi.UpdateExecution",
        needRefresh: true
    }

}();