Write "Set Static IPv4"
$IP = "172.17.1.99"
$MaskBits = 24
$Gateway = "172.17.1.1"
$DNS1 = "172.17.1.21"
$DNS2 = "172.17.1.22"
$IPType = "IPv4"
$adapter = Get-NetAdapter | ? {$_.Status -eq "up"}
If (($adapter | Get-NetIPConfiguration).IPv4Address.IPAddress) {
 $adapter | Remove-NetIPAddress -AddressFamily $IPType -Confirm:$false
}
If (($adapter | Get-NetIPConfiguration).Ipv4DefaultGateway) {
 $adapter | Remove-NetRoute -AddressFamily $IPType -Confirm:$false
}
$adapter | New-NetIPAddress `
 -AddressFamily $IPType `
 -IPAddress $IP `
 -PrefixLength $MaskBits `
 -DefaultGateway $Gateway
$adapter | Set-DnsClientServerAddress -ServerAddresses ("$DNS1","$DNS2")
