CREATE COLUMN TABLE "SBODEMOIT"."OCRV" ("AbsId" INTEGER CS_INT NOT NULL , "PayId" INTEGER CS_INT DEFAULT 0 NOT NULL , "CreditCard" SMALLINT CS_INT DEFAULT 0, "CrdCardNum" NVARCHAR(64), "CardValid" LONGDATE CS_LONGDATE, "VoucherNum" NVARCHAR(27), "OwnerIdNum" NVARCHAR(15), "OwnerPhone" NVARCHAR(20), "PayDate" LONGDATE CS_LONGDATE, "PayAmount" DECIMAL(21,6) CS_FIXED, "CreditCurr" NVARCHAR(3), "CreditRate" DECIMAL(21,6) CS_FIXED, "Deposited" NVARCHAR(1) DEFAULT 'O', "DepNum2" INTEGER CS_INT DEFAULT 0, "DepNum" INTEGER CS_INT, "AcctCode" NVARCHAR(15), "VouchAcct" NVARCHAR(15), "CreditAcct" NVARCHAR(15), "CardCode" NVARCHAR(15), "CrTypeCode" SMALLINT CS_INT, "NumOfPmnts" SMALLINT CS_INT DEFAULT 1, "Canceled" NVARCHAR(1) DEFAULT 'N', "Storno" NVARCHAR(1) DEFAULT 'N', "Transfered" NVARCHAR(1) DEFAULT 'N', "Instance" SMALLINT CS_INT DEFAULT 0 NOT NULL , "DataSource" NVARCHAR(1) DEFAULT 'N', "UserSign" SMALLINT CS_INT, "TransRef" NVARCHAR(20), "CardName" NVARCHAR(100), PRIMARY KEY ("AbsId", "PayId", "Instance")) UNLOAD PRIORITY 5  AUTO MERGE ;
ALTER TABLE "SBODEMOIT"."OCRV" WITH PARAMETERS ('CONCAT_ATTRIBUTE'=('$VoucherNum$PayId$CreditCard$Storno$','VoucherNum','PayId','CreditCard','Storno'));
CREATE INDEX "OCRV_CRED_CARD" ON "SBODEMOIT"."OCRV" ( "CreditCard" ASC );
CREATE INDEX "OCRV_CUST_CODE" ON "SBODEMOIT"."OCRV" ( "CardCode" ASC );
CREATE INDEX "OCRV_DEP_ABS1" ON "SBODEMOIT"."OCRV" ( "DepNum" ASC );
CREATE INDEX "OCRV_IS_VALID" ON "SBODEMOIT"."OCRV" ( "VoucherNum" ASC, "PayId" ASC, "CreditCard" ASC, "Storno" ASC );
CREATE INDEX "OCRV_CRED_ACCT" ON "SBODEMOIT"."OCRV" ( "CreditAcct" ASC );
CREATE INDEX "OCRV_DEP_ABS2" ON "SBODEMOIT"."OCRV" ( "DepNum2" ASC );
CREATE INDEX "OCRV_DEPOSITED" ON "SBODEMOIT"."OCRV" ( "Deposited" ASC );
CREATE INDEX "OCRV_VOUCHER_ID" ON "SBODEMOIT"."OCRV" ( "AbsId" ASC )