CREATE VIEW "SBODEMOPT"."SBO_FI_GL_01" ( "GL_ACCOUNT", "SBO_ALTACT", "DEBIT", "CREDIT", "BALANCE", "FISCPER", "CURRENCY", "CURTYPE" ) AS SELECT 
				DISTINCT
				left(J."Account",10) as "GL_ACCOUNT",
				left(IFNULL(A."AccntntCod",'DEFT_ACCT'),10)  as "SBO_ALTACT",
				(SELECT SUM(J2."Debit") as "DEBIT" from "SBODEMOPT"."JDT1" as J2 where (J2."FinncPriod"=J."FinncPriod") and J2."Account"=J."Account")  as "DEBIT", 
				(SELECT SUM(J2."Credit") from "SBODEMOPT"."JDT1" as J2 where (J2."FinncPriod"=J."FinncPriod") and J2."Account"=J."Account")  as "CREDIT", 		
				(SELECT SUM(J2."Debit"-J2."Credit") from "SBODEMOPT"."JDT1" as J2 where (J2."FinncPriod"<=J."FinncPriod") and J2."Account"=J."Account") as "BALANCE",		
				'0' || TO_CHAR(MONTH(J."RefDate")) || TO_CHAR(YEAR(J."RefDate")) as "FISCPER",
				CASE (SELECT Top 1 C."MainCurncy" from "SBODEMOPT"."OADM" as C) 		
          			WHEN '€' THEN 'EUR'	
					WHEN 'Eur' THEN 'EUR'
					WHEN '$' THEN 'USD'
          			ELSE (SELECT Top 1 C."MainCurncy" from "SBODEMOPT"."OADM" as C)
      			END		
	 			AS "CURRENCY",
				'10' AS "CURTYPE"		
				FROM "SBODEMOPT"."JDT1" as J 
				INNER JOIN "SBODEMOPT"."OACT" as A ON J."Account"=A."AcctCode" WITH READ ONLY