/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.nio;

import com.oracle.nio.BufferSecretsPermission;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import sun.misc.JavaNioAccess;
import sun.misc.SharedSecrets;
import sun.nio.ch.DirectBuffer;

public final class BufferSecrets<A> {
    private static final JavaNioAccess javaNioAccess = SharedSecrets.getJavaNioAccess();
    private static final BufferSecrets<?> theBufferSecrets = new BufferSecrets();

    private BufferSecrets() {
    }

    public static <A> BufferSecrets<A> instance() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new BufferSecretsPermission("access"));
        }
        return theBufferSecrets;
    }

    public ByteBuffer newDirectByteBuffer(long address, int capacity, A ob) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Negative capacity: " + capacity);
        }
        return javaNioAccess.newDirectByteBuffer(address, capacity, ob);
    }

    public long address(Buffer buf) {
        if (buf instanceof DirectBuffer) {
            return ((DirectBuffer)((Object)buf)).address();
        }
        if (buf == null) {
            throw new NullPointerException();
        }
        throw new UnsupportedOperationException();
    }

    public A attachment(Buffer buf) {
        if (buf instanceof DirectBuffer) {
            return (A)((DirectBuffer)((Object)buf)).attachment();
        }
        if (buf == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public void truncate(Buffer buf) {
        javaNioAccess.truncate(buf);
    }
}

