/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdk.ext;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.AccessController;
import java.security.PrivilegedActionException;

public abstract class WithJDKExtNativeLib {
    public static final String LIB_BASE_NAME = "sapjdkext";
    public static final boolean onWindows = AccessController.doPrivileged(() -> System.getProperty("os.name").startsWith("Windows"));
    private static final boolean doTrace = AccessController.doPrivileged(() -> Boolean.getBoolean("com.sap.jdk.ext.natives.traceLoading"));

    private static void trace(String msg) {
        if (doTrace) {
            System.err.println(msg);
        }
    }

    private static void trace(Throwable t) {
        if (doTrace) {
            t.printStackTrace(System.err);
        }
    }

    private static String getLibraryName() {
        String libraryName = System.getProperty("com.sap.jdk.ext.natives.libraryname");
        if (libraryName != null && !libraryName.isEmpty()) {
            WithJDKExtNativeLib.trace("Native library name given by property: " + libraryName);
            return libraryName;
        }
        String prefix = "lib";
        String suffix = ".so";
        String os = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        if (os.indexOf("windows") != -1) {
            suffix = ".dll";
            prefix = "";
        } else if (os.indexOf("hp-ux") != -1 && arch.indexOf("pa_risc") != -1) {
            suffix = ".sl";
        } else if (os.indexOf("mac os") != -1) {
            if ("amd64".equals(arch) || "x86_64".equals(arch)) {
                suffix = ".dylib";
            } else if ("x86".equals(arch) || "i386".equals(arch)) {
                suffix = ".dylib";
            }
        }
        return prefix + LIB_BASE_NAME + suffix;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getPlatformDirName() throws IOException {
        String os = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        String platform = null;
        if (os.indexOf("windows") != -1) {
            if ("i386".equals(arch)) return "ntintel";
            if ("x86".equals(arch)) {
                return "ntintel";
            }
            if ("amd64".equals(arch)) return "ntamd64";
            if ("x86_64".equals(arch)) {
                return "ntamd64";
            }
            if (!"ia64".equals(arch)) throw new IOException("Unknown architecture '" + arch + "' on Windows");
            return "ntia64";
        }
        if (os.indexOf("linux") != -1 || os.indexOf("powerpc") != -1) {
            if ("i386".equals(arch)) return "linuxintel";
            if ("x86".equals(arch)) {
                return "linuxintel";
            }
            if ("amd64".equals(arch)) return "linuxx86_64";
            if ("x86_64".equals(arch)) {
                return "linuxx86_64";
            }
            if ("ia64".equals(arch)) {
                return "linuxia64";
            }
            if ("ppc64".equals(arch)) return "linuxppc64";
            if ("powerpc".equals(arch)) {
                return "linuxppc64";
            }
            if ("ppc64le".equals(arch)) {
                return "linuxppc64le";
            }
            if ("zarch_64".equals(arch)) return "linuxs390x";
            if (!"s390x".equals(arch)) throw new IOException("Unknown architecture '" + arch + "' on Linux");
            return "linuxs390x";
        }
        if (os.indexOf("sunos") != -1) {
            if ("sparcv9".equals(arch)) return "sun_64";
            if ("sparc".equals(arch)) {
                return "sun_64";
            }
            if ("amd64".equals(arch)) return "sunx86_64";
            if (!"x86".equals(arch)) throw new IOException("Unknown architecture '" + arch + "' on Solaris");
            return "sunx86_64";
        }
        if (os.indexOf("hp-ux") != -1) {
            if (arch.indexOf("ia64") != -1) {
                return "hpia64";
            }
            if (arch.indexOf("pa_risc") == -1) throw new IOException("Unknown architecture '" + arch + "' on HP-UX");
            return "hp_64";
        }
        if (os.indexOf("aix") != -1) {
            if (!"ppc64".equals(arch)) throw new IOException("Unknown architecture '" + arch + "' on AIX");
            return "rs6000_64";
        }
        if (os.indexOf("os400") != -1 || os.indexOf("os/400") != -1) {
            if ("ppc64".equals(arch)) return "as400_pase_64";
            if (!"powerpc".equals(arch)) throw new IOException("Unknown architecture '" + arch + "' on OS/400");
            return "as400_pase_64";
        }
        if (os.indexOf("mac os") == -1) throw new IOException("Unknown os '" + os + "'.");
        if ("amd64".equals(arch)) return "bsdx86_64";
        if ("x86_64".equals(arch)) {
            return "bsdx86_64";
        }
        if ("x86".equals(arch)) return "bsdintel";
        if (!"i386".equals(arch)) throw new IOException("Unknown architecture '" + arch + "' on Mac OS X");
        return "bsdintel";
    }

    private static void loadWithAppropriateMechanism() throws IOException {
        String platformRootDirectory = System.getProperty("com.sap.jdk.ext.natives.platformRoot");
        if (platformRootDirectory != null && !platformRootDirectory.isEmpty()) {
            WithJDKExtNativeLib.loadFromPlatformRoot(platformRootDirectory);
            return;
        }
        String libDirectory = System.getProperty("com.sap.jdk.ext.natives.directory");
        if (libDirectory != null && !libDirectory.isEmpty()) {
            WithJDKExtNativeLib.loadFromDirectory(libDirectory);
            return;
        }
        boolean justLoad = false;
        ClassLoader cl = WithJDKExtNativeLib.class.getClassLoader();
        if (cl == null) {
            WithJDKExtNativeLib.trace("Class Loader is system class loader (" + cl + ").");
            justLoad = true;
        } else {
            String clname = cl.toString();
            if (clname.contains("PlatformClassLoader")) {
                WithJDKExtNativeLib.trace("Class Loader is platform class loader (" + clname + ").");
                justLoad = true;
            } else if (clname.contains("com.sap.jvm.se") && clname.contains("EquinoxClassLoader")) {
                WithJDKExtNativeLib.trace("Class Loader is Eclipse class loader (" + clname + ").");
                justLoad = true;
            } else {
                WithJDKExtNativeLib.trace("Class Loader is " + clname + ".");
            }
        }
        if (justLoad) {
            WithJDKExtNativeLib.trace("Loading via System.loadLibrary(\"sapjdkext\").");
            System.loadLibrary(LIB_BASE_NAME);
            return;
        }
        WithJDKExtNativeLib.trace("Class Loader is " + cl + ", using jar extraction mechanism.");
        WithJDKExtNativeLib.loadFromJar();
    }

    private static void loadFromPlatformRoot(String platformRoot) throws IOException {
        WithJDKExtNativeLib.trace("Loading library sapjdkext from platform root directory " + platformRoot + ".");
        String platform = WithJDKExtNativeLib.getPlatformDirName();
        WithJDKExtNativeLib.loadFromDirectory(platformRoot + File.separator + platform);
    }

    private static void loadFromDirectory(String libDirectory) throws IOException {
        WithJDKExtNativeLib.trace("Loading library sapjdkext from directory " + libDirectory + ".");
        String libraryName = WithJDKExtNativeLib.getLibraryName();
        String libpath = new File(libDirectory + File.separator + libraryName).getAbsolutePath();
        WithJDKExtNativeLib.trace("Loading " + libpath + "...");
        System.load(libpath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadFromJar() throws IOException {
        WithJDKExtNativeLib.trace("Loading library sapjdkext from current jar.");
        String explicitDir = System.getProperty("com.sap.jdk.ext.natives.tempDir");
        File targetDir = null;
        if (explicitDir == null) {
            String tempDir = System.getProperty("java.io.tmpdir");
            targetDir = new File(tempDir, LIB_BASE_NAME + System.nanoTime());
            if (!targetDir.mkdir()) {
                throw new IOException("Failed to create temp directory " + targetDir.getName());
            }
            targetDir.deleteOnExit();
        } else {
            targetDir = new File(explicitDir);
        }
        String libraryName = WithJDKExtNativeLib.getLibraryName();
        File tempLib = new File(targetDir, libraryName);
        String resourceName = "/lib/" + libraryName;
        try (InputStream is = WithJDKExtNativeLib.class.getResourceAsStream(resourceName);){
            Files.copy(is, tempLib.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable t) {
            tempLib.delete();
            WithJDKExtNativeLib.trace(t);
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            IOException e = new IOException("Could not load resource " + resourceName + ".");
            e.initCause(t);
            throw e;
        }
        try {
            System.load(tempLib.getAbsolutePath());
        }
        finally {
            if (!tempLib.delete()) {
                tempLib.deleteOnExit();
            }
        }
    }

    static {
        try {
            AccessController.doPrivileged(() -> {
                WithJDKExtNativeLib.loadWithAppropriateMechanism();
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            WithJDKExtNativeLib.trace(e);
            throw new ExceptionInInitializerError(e);
        }
    }
}

