/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdk.ext.filesocket;

import com.sap.jdk.ext.WithJDKExtNativeLib;
import com.sap.jdk.ext.filesocket.FileSocketAddress;
import com.sap.jdk.ext.filesocket.ServerFileSocket;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Phaser;

public abstract class AbstractFileSocket
extends WithJDKExtNativeLib
implements Closeable {
    private long fileSocket_pd = 0L;
    private boolean closed = false;
    protected Phaser shutdownPhaser = new Phaser(1){

        @Override
        protected boolean onAdvance(int phase, int parties) {
            return true;
        }
    };
    protected FileSocketAddress address = null;

    protected AbstractFileSocket() throws IOException {
        this.create0();
    }

    private static native void init0();

    private native void create0() throws IOException;

    private native void close0() throws IOException;

    private native void destroy0(String var1);

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.fileSocket_pd != 0L) {
            this.close0();
        }
        this.closed = true;
        this.shutdownPhaser.arriveAndAwaitAdvance();
        this.destroy0(onWindows || !(this instanceof ServerFileSocket) || this.address == null ? null : this.address.getSocketIdentifier());
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public FileSocketAddress getAddress() {
        return this.address;
    }

    public String toString() {
        String handle = this.fileSocket_pd != 0L ? Long.toString(this.fileSocket_pd) : "<none>";
        String identifier = this.address != null ? this.address.getSocketIdentifier() : "<none>";
        return "handle=" + handle + "; identifier=" + identifier;
    }

    static {
        AbstractFileSocket.init0();
    }
}

