/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdk.ext.filesocket;

import com.sap.jdk.ext.filesocket.AbstractFileSocket;
import com.sap.jdk.ext.filesocket.FileSocketAddress;
import com.sap.jdk.ext.filesocket.FileSocketException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileSocket
extends AbstractFileSocket {
    private int writeTimeout = 0;
    private int readTimeout = 0;
    private boolean connected = false;
    private final FileSocketInputStream in = new FileSocketInputStream();
    private final FileSocketOutputStream out = new FileSocketOutputStream();

    public FileSocket() throws IOException {
    }

    public FileSocket(FileSocketAddress addr) throws IOException {
        this.connect(addr);
    }

    public FileSocket(FileSocketAddress addr, int timeout) throws IOException {
        this.connect(addr, timeout);
    }

    private native void connect0(String var1, int var2) throws IOException;

    private native int read0(byte[] var1, int var2, int var3, int var4) throws IOException;

    private native int write0(byte[] var1, int var2, int var3, int var4) throws IOException;

    private native int available0();

    public void connect(FileSocketAddress addr) throws IOException {
        this.connect(addr, -1);
    }

    public void connect(FileSocketAddress addr, int timeout) throws IOException {
        if (addr == null) {
            throw new NullPointerException("FileSocketAddress is null");
        }
        if (this.isClosed()) {
            throw new FileSocketException("FileSocket is already closed");
        }
        if (this.isConnected()) {
            throw new FileSocketException("FileSocket is already connected");
        }
        this.connect0(addr.getSocketIdentifier(), timeout);
        this.address = addr;
        this.connected = true;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(int timeout) {
        this.writeTimeout = timeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int timeout) {
        this.readTimeout = timeout;
    }

    public InputStream getInputStream() throws IOException {
        if (this.isClosed()) {
            throw new FileSocketException("FileSocket closed");
        }
        if (!this.connected) {
            throw new FileSocketException("FileSocket not connected");
        }
        return this.in;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.isClosed()) {
            throw new FileSocketException("FileSocket closed");
        }
        if (!this.connected) {
            throw new FileSocketException("FileSocket not connected");
        }
        return this.out;
    }

    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        super.close();
        this.connected = false;
    }

    @Override
    public String toString() {
        return "FileSocket [" + super.toString() + "; connected=" + this.connected + "]";
    }

    private final class FileSocketOutputStream
    extends OutputStream {
        private boolean streamClosed = false;
        private byte[] buf = new byte[1];

        private FileSocketOutputStream() {
        }

        @Override
        public synchronized void write(int b) throws IOException {
            this.buf[0] = (byte)b;
            this.write(this.buf, 0, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            if (this.streamClosed) {
                throw new FileSocketException("OutputStream is closed.");
            }
            if (FileSocket.this.shutdownPhaser.register() < 0) {
                throw new IOException("InputStream is shutting down.");
            }
            try {
                if (FileSocket.this.write0(b, off, len, FileSocket.this.writeTimeout) < 0) {
                    throw new FileSocketException("Unspecific error while writing");
                }
            }
            finally {
                FileSocket.this.shutdownPhaser.arriveAndDeregister();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.streamClosed) {
                return;
            }
            this.streamClosed = true;
            FileSocket.this.close();
        }
    }

    private final class FileSocketInputStream
    extends InputStream {
        private boolean streamClosed = false;
        private byte[] buf = new byte[1];

        private FileSocketInputStream() {
        }

        @Override
        public synchronized int read() throws IOException {
            int numRead = this.read(this.buf, 0, 1);
            if (numRead <= 0) {
                return -1;
            }
            return this.buf[0] & 0xFF;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            if (this.streamClosed) {
                throw new IOException("InputStream is closed.");
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (FileSocket.this.shutdownPhaser.register() < 0) {
                throw new IOException("InputStream is shutting down.");
            }
            try {
                int n = FileSocket.this.read0(b, off, len, FileSocket.this.readTimeout);
                return n;
            }
            finally {
                FileSocket.this.shutdownPhaser.arriveAndDeregister();
            }
        }

        @Override
        public int available() throws IOException {
            if (this.streamClosed) {
                throw new IOException("InputStream is closed.");
            }
            if (FileSocket.this.shutdownPhaser.register() < 0) {
                throw new IOException("InputStream is shutting down.");
            }
            try {
                int n = FileSocket.this.available0();
                return n;
            }
            finally {
                FileSocket.this.shutdownPhaser.arriveAndDeregister();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.streamClosed) {
                return;
            }
            this.streamClosed = true;
            FileSocket.this.close();
        }
    }
}

