/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdk.ext.filesocket;

import com.sap.jdk.ext.WithJDKExtNativeLib;
import java.io.File;

public class FileSocketAddress {
    public static final String FSA_BASE_LOCATION = WithJDKExtNativeLib.onWindows ? "\\\\.\\pipe" : "/tmp";
    private final String socketIdentifier;

    public FileSocketAddress(String socketIdentifierOrName) {
        if (socketIdentifierOrName == null) {
            throw new NullPointerException("FileSocketAddress must have an identifier");
        }
        if (socketIdentifierOrName.length() == 0) {
            throw new IllegalArgumentException("FileSocketAddress must have a length > 0");
        }
        this.socketIdentifier = socketIdentifierOrName.contains(File.separator) ? socketIdentifierOrName : FSA_BASE_LOCATION + File.separator + socketIdentifierOrName;
    }

    public String getSocketIdentifier() {
        return this.socketIdentifier;
    }

    public String toString() {
        return this.getClass().getName() + "[identifier=" + this.socketIdentifier + "]";
    }
}

