/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdk.ext.filesocket;

import com.sap.jdk.ext.filesocket.AbstractFileSocket;
import java.net.SocketException;

public class FileSocketException
extends SocketException {
    private static final long serialVersionUID = -6045112300130104298L;
    private final String socketIdentifier;

    public FileSocketException(String msg) {
        super(msg);
        this.socketIdentifier = null;
    }

    public FileSocketException(String msg, AbstractFileSocket socket) {
        super(msg);
        this.socketIdentifier = socket.address == null ? null : socket.address.getSocketIdentifier();
    }

    @Override
    public String getMessage() {
        if (this.socketIdentifier == null || this.socketIdentifier.isEmpty()) {
            return super.getMessage();
        }
        return super.getMessage() + " (socket: " + this.socketIdentifier + ")";
    }
}

