/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdk.ext.filesocket;

import com.sap.jdk.ext.filesocket.AbstractFileSocket;
import java.net.SocketTimeoutException;

public class FileSocketTimeoutException
extends SocketTimeoutException {
    private static final long serialVersionUID = 8786274348610579789L;
    private final String socketIdentifier;

    public FileSocketTimeoutException(String msg) {
        super(msg);
        this.socketIdentifier = null;
    }

    public FileSocketTimeoutException(String msg, AbstractFileSocket socket) {
        super(msg);
        this.socketIdentifier = socket.address == null ? null : socket.address.getSocketIdentifier();
    }

    @Override
    public String getMessage() {
        if (this.socketIdentifier == null || this.socketIdentifier.isEmpty()) {
            return super.getMessage();
        }
        return super.getMessage() + " (socket: " + this.socketIdentifier + ")";
    }
}

