/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdk.ext.filesocket;

import com.sap.jdk.ext.filesocket.AbstractFileSocket;
import com.sap.jdk.ext.filesocket.FileSocket;
import com.sap.jdk.ext.filesocket.FileSocketAddress;
import com.sap.jdk.ext.filesocket.FileSocketException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class ServerFileSocket
extends AbstractFileSocket {
    private static Set<String> boundIdentifiers = new HashSet<String>();
    private boolean bound = false;
    private int backlog = 50;
    private boolean restrictAccess = true;
    private Thread shutdownThread = null;

    public ServerFileSocket() throws IOException {
        if (!onWindows) {
            this.registerShutdownHook();
        }
    }

    public ServerFileSocket(FileSocketAddress addr) throws IOException {
        this();
        this.bind(addr);
    }

    public ServerFileSocket(FileSocketAddress addr, int backlog, boolean restrictAccess) throws IOException {
        this();
        this.bind(addr, backlog, restrictAccess);
    }

    private synchronized void registerShutdownHook() {
        if (this.shutdownThread == null) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        ServerFileSocket.this.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
            try {
                Runtime.getRuntime().addShutdownHook(t);
                this.shutdownThread = t;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private synchronized void deregisterShutdownHook() {
        if (this.shutdownThread != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private native void bind0() throws IOException;

    private native FileSocket accept0() throws IOException;

    public boolean isBound() {
        return this.bound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(FileSocketAddress addr) throws IOException {
        if (addr == null) {
            throw new IllegalArgumentException("FileSocketAddress is null");
        }
        if (this.isClosed()) {
            throw new FileSocketException("FileSocket is already closed");
        }
        if (this.isBound()) {
            throw new FileSocketException("FileSocket is already bound");
        }
        this.address = addr;
        String identifier = addr.getSocketIdentifier();
        Set<String> set = boundIdentifiers;
        synchronized (set) {
            if (boundIdentifiers.contains(identifier)) {
                throw new FileSocketException("FileSocket is already bound");
            }
            boundIdentifiers.add(identifier);
        }
        try {
            this.bind0();
            this.bound = true;
        }
        catch (Throwable t) {
            Set<String> set2 = boundIdentifiers;
            synchronized (set2) {
                boundIdentifiers.remove(identifier);
            }
            throw t;
        }
    }

    public void bind(FileSocketAddress addr, int backlog, boolean restrictAccess) throws IOException {
        if (backlog < 0) {
            throw new IllegalArgumentException("Backlog must not be negative");
        }
        this.backlog = backlog;
        this.restrictAccess = restrictAccess;
        this.bind(addr);
    }

    public FileSocket accept() throws IOException {
        if (this.isClosed()) {
            throw new FileSocketException("FileSocket is already closed");
        }
        if (!this.isBound()) {
            throw new FileSocketException("FileSocket not bound");
        }
        if (this.shutdownPhaser.register() < 0) {
            throw new IOException("InputStream is shutting down.");
        }
        try {
            FileSocket fileSocket = this.accept0();
            return fileSocket;
        }
        finally {
            this.shutdownPhaser.arriveAndDeregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        super.close();
        if (this.bound && this.address != null) {
            Set<String> set = boundIdentifiers;
            synchronized (set) {
                boundIdentifiers.remove(this.address.getSocketIdentifier());
            }
            this.bound = false;
        }
        if (!onWindows) {
            this.deregisterShutdownHook();
        }
    }

    @Override
    public String toString() {
        return "ServerFileSocket [" + super.toString() + "; bound=" + this.bound + "]";
    }
}

