/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdk.ext.util;

import com.sap.jdk.ext.WithJDKExtNativeLib;

public final class Console
extends WithJDKExtNativeLib {
    private static final int MODE_DEFAULT = 0;
    private static final int MODE_NON_CANONICAL = 1;
    public static final short CHR_MOVE_TO_BEG = 1;
    public static final short CHR_CANCEL = 3;
    public static final short CHR_EXIT = 4;
    public static final short CHR_MOVE_TO_END = 5;
    public static final short CHR_DELETE_PREV_CHAR = 8;
    public static final short CHR_COMPLETE = 9;
    public static final short CHR_NEWLINE_1 = 10;
    public static final short CHR_KILL_LINE = 11;
    public static final short CHR_NEWLINE_2 = 13;
    public static final short CHR_CLEAR_LINE = 27;
    public static final short CHR_DELETE_NEXT_CHAR = 127;
    public static final short CHR_PREV_CHAR = 331;
    public static final short CHR_NEXT_CHAR = 333;
    public static final short CHR_NEXT_HISTORY = 336;
    public static final short CHR_PREV_HISTORY = 328;
    private static Console console = new Console();
    private static Object modeLock = new Object();
    private static Object readLock = new Object();
    private static Object queryLock = new Object();

    private Console() {
    }

    private static native void setMode0(int var0);

    private static native int readChar0();

    private static native int getWidth0();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMode(Mode mode) {
        Object object = modeLock;
        synchronized (object) {
            switch (mode) {
                case DEFAULT: {
                    Console.setMode0(0);
                    return;
                }
                case NON_CANONICAL: {
                    Console.setMode0(1);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readChar() {
        Object object = readLock;
        synchronized (object) {
            return Console.readChar0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWidth() {
        Object object = queryLock;
        synchronized (object) {
            return Console.getWidth0();
        }
    }

    public static Console get() {
        return console;
    }

    public static enum Mode {
        DEFAULT,
        NON_CANONICAL;

    }
}

