/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdk.ext.util;

import com.sap.jdk.ext.WithJDKExtNativeLib;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class ProcessManagement
extends WithJDKExtNativeLib {
    private ProcessManagement() {
    }

    public static List<ProcessInfo> getProcessesReferencingFile(File file) throws IOException {
        List<ProcessInfo> result;
        if (file == null) {
            throw new IllegalArgumentException("Parameter file must not be null");
        }
        List<ProcessInfo> list = result = onWindows ? ProcessManagement.getProcessesReferencingFile0(file.getAbsolutePath()) : null;
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    private static native List<ProcessInfo> getProcessesReferencingFile0(String var0) throws IOException;

    public static final class ProcessInfo {
        private long pid;
        private String name;

        private ProcessInfo(long pid, String name) {
            this.pid = pid;
            this.name = name;
        }

        public long getPid() {
            return this.pid;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name + "(" + this.pid + ")";
        }
    }
}

