/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm;

import java.security.AccessController;
import java.util.Iterator;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public class APIServiceLoader<S> {
    protected ServiceLoader<S> serviceLoader;

    protected APIServiceLoader(ServiceLoader<S> sl) {
        this.serviceLoader = sl;
    }

    public static <S> APIServiceLoader<S> load(Class<S> service) {
        ServiceLoader sl = AccessController.doPrivileged(() -> ServiceLoader.load(service));
        return new APIServiceLoader<S>(sl);
    }

    public Optional<S> findFirst() {
        Iterator iterator = this.serviceLoader.iterator();
        while (iterator.hasNext()) {
            try {
                return AccessController.doPrivileged(() -> Optional.of(iterator.next()));
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
            }
        }
        return Optional.empty();
    }
}

