/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.extension.java.base;

import java.util.ArrayList;

public final class ClassLoaderInformation {
    private final byte[] name;
    private final ClassLoader[] otherParents;
    private final byte[][] urls;
    private final byte[][] dependencies;

    public ClassLoaderInformation(ClassLoader loader, String name, ClassLoader[] parents, String[] urls, String[] dependencies) {
        this.name = (byte[])(name != null ? ClassLoaderInformation.asByteArray(name) : null);
        if (parents != null) {
            ArrayList<ClassLoader> others = new ArrayList<ClassLoader>();
            for (ClassLoader parent : parents) {
                if (parent == loader.getParent()) continue;
                others.add(parent);
            }
            this.otherParents = others.toArray(new ClassLoader[others.size()]);
        } else {
            this.otherParents = null;
        }
        if (urls != null) {
            this.urls = new byte[urls.length][];
            for (int i = 0; i < urls.length; ++i) {
                this.urls[i] = ClassLoaderInformation.asByteArray(urls[i]);
            }
        } else {
            this.urls = null;
        }
        if (dependencies != null) {
            this.dependencies = new byte[dependencies.length][];
            for (int i = 0; i < dependencies.length; ++i) {
                this.dependencies[i] = ClassLoaderInformation.asByteArray(dependencies[i]);
            }
        } else {
            this.dependencies = null;
        }
    }

    public byte[] getName() {
        return this.name;
    }

    public ClassLoader[] getOtherParents() {
        return this.otherParents;
    }

    public byte[][] getUrls() {
        return this.urls;
    }

    public byte[][] getDependencies() {
        return this.dependencies;
    }

    private static byte[] asByteArray(String str) {
        char c;
        int strlen = str.length();
        int utflen = 0;
        char[] charr = new char[strlen];
        int count = 0;
        str.getChars(0, strlen, charr, 0);
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            utflen = 65535;
            return ClassLoaderInformation.asByteArray(str.substring(0, 16384) + " ... <truncated>");
        }
        byte[] bytearr = new byte[utflen];
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
            bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        return bytearr;
    }
}

