/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.extension.java.base;

import com.sap.jvm.extension.java.base.ClassLoaderInformation;
import com.sap.jvm.extension.java.base.EquinoxClassLoaderExtractorLuna;
import com.sap.jvm.extension.java.base.ReferenceHolder;
import java.io.File;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;

public class EquinoxClassLoaderExtractor {
    private static final String BASE_CLASS_LOADER_NAME = "org.eclipse.osgi.baseadaptor.loader.BaseClassLoader";
    private static final String DEFAULT_LOADER_NAME = "org.eclipse.osgi.internal.baseadaptor.DefaultClassLoader";
    private static final String COMPOSITE_CLASS_LOADER_NAME = "org.eclipse.osgi.internal.composite.CompositeClassLoader";
    private static final String CLASS_PATH_MANAGER_NAME = "org.eclipse.osgi.baseadaptor.loader.ClasspathManager";
    private static final String CLASS_PATH_ENTRY_NAME = "org.eclipse.osgi.baseadaptor.loader.ClasspathEntry";
    private static final String FRAGMENT_CLASSPATH_NAME = "org.eclipse.osgi.baseadaptor.loader.FragmentClasspath";
    private static final String BUNDLE_FILE_NAME = "org.eclipse.osgi.baseadaptor.bundlefile.BundleFile";
    private static final String BUNDLE_LOADER_NAME = "org.eclipse.osgi.internal.loader.BundleLoader";
    private static final String ABSTRACT_BUNDLE_NAME = "org.eclipse.osgi.framework.internal.core.AbstractBundle";
    private static final String BUNDLE_HOST_NAME = "org.eclipse.osgi.framework.internal.core.BundleHost";
    private static final String BUNDLE_LOADER_PROXY_NAME = "org.eclipse.osgi.internal.loader.BundleLoaderProxy";
    private static volatile ReferenceHolder<EquinoxClassLoaderExtractor> refHolder = new ReferenceHolder<Object>(null, null);
    private static final boolean isEnabled = EquinoxClassLoaderExtractor.isEnabled();
    private Class<?> baseClassLoaderClass;
    private Class<?> bundleLoaderClass;
    private Class<?> classPathEntryClass;
    private Class<?> classpathManagerClass;
    private Class<?> fragmentClasspathClass;
    private Class<?> bundleFileClass;
    private Class<?> abstractBundleClass;
    private Class<?> bundleHostClass;
    private Class<?> bundleLoaderProxyClass;
    private Method getClassPathManagerMethod;
    private Method getDelegateMethod;
    private Method getFragmentClasspathsMethod;
    private Method getHostClassPathEntriesMethod;
    private Method getEntriesMethod;
    private Method getBundleFileMethod;
    private Method getBaseFileMethod;
    private Method getBundleMethod;
    private Method getSymbolicNameMethod;
    private Method getFragmentsMethod;
    private Method getBundleLoaderMethod;
    private Method getSymbolicNameProxyMethod;
    private Field requiredBundlesField;
    private Field classLoaderField;

    public static ClassLoaderInformation getInfo(ClassLoader loader) {
        if (!isEnabled) {
            return null;
        }
        WeakReference<Class<? extends ClassLoader>> ref = EquinoxClassLoaderExtractor.refHolder.loaderClassRef;
        if (ref.get() == loader.getClass()) {
            return EquinoxClassLoaderExtractor.getInfoImpl(loader);
        }
        String name = loader.getClass().getName();
        if (name.equals(DEFAULT_LOADER_NAME) || name.equals(COMPOSITE_CLASS_LOADER_NAME)) {
            return EquinoxClassLoaderExtractor.getInfoImpl(loader);
        }
        return EquinoxClassLoaderExtractorLuna.getInfo(loader);
    }

    private static ClassLoaderInformation getInfoImpl(final ClassLoader loader) {
        try {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoaderInformation>(){

                @Override
                public ClassLoaderInformation run() {
                    ReferenceHolder holder = refHolder;
                    EquinoxClassLoaderExtractor extractor = (EquinoxClassLoaderExtractor)holder.extractorRef.get();
                    if (extractor != null && holder.loaderClassRef.get() == loader.getClass()) {
                        return extractor.getInfoForLoader(loader);
                    }
                    try {
                        extractor = EquinoxClassLoaderExtractor.getExtractor(loader);
                        refHolder = new ReferenceHolder<EquinoxClassLoaderExtractor>(loader.getClass(), extractor);
                        return extractor.getInfoForLoader(loader);
                    }
                    catch (ClassNotFoundException e) {
                        return null;
                    }
                    catch (NoSuchMethodException e) {
                        return null;
                    }
                    catch (NoSuchFieldException e) {
                        return null;
                    }
                    catch (SecurityException e) {
                        return null;
                    }
                }
            });
        }
        catch (Throwable t) {
            return null;
        }
    }

    public ClassLoaderInformation getInfoForLoader(ClassLoader loader) {
        try {
            return this.getInfoForLoaderImpl(loader);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    private ClassLoaderInformation getInfoForLoaderImpl(ClassLoader loader) throws IllegalAccessException, InvocationTargetException {
        String[] urls = this.getUrls(loader);
        Object bundleLoader = this.getBundleLoader(loader);
        Object bundle = this.getBundle(bundleLoader);
        String name = this.getSymbolicName(bundle);
        Object[] requiredBundles = this.getRequiredBundleProxies(bundleLoader);
        ClassLoader[] parents = this.getClassLoadersForProxies(requiredBundles);
        ArrayList<String> toAdd = new ArrayList<String>();
        this.addSymbolicNamesForProxies(requiredBundles, toAdd);
        this.addFragmentNames(bundle, toAdd);
        String[] dependencies = toAdd.size() == 0 ? null : toAdd.toArray(new String[toAdd.size()]);
        return new ClassLoaderInformation(loader, name, parents, urls, dependencies);
    }

    private static EquinoxClassLoaderExtractor getExtractor(ClassLoader loader) throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException, SecurityException {
        EquinoxClassLoaderExtractor result = new EquinoxClassLoaderExtractor();
        result.baseClassLoaderClass = EquinoxClassLoaderExtractor.forName(loader, BASE_CLASS_LOADER_NAME);
        result.bundleLoaderClass = EquinoxClassLoaderExtractor.forName(loader, BUNDLE_LOADER_NAME);
        result.classPathEntryClass = EquinoxClassLoaderExtractor.forName(loader, CLASS_PATH_ENTRY_NAME);
        result.bundleFileClass = EquinoxClassLoaderExtractor.forName(loader, BUNDLE_FILE_NAME);
        result.classpathManagerClass = EquinoxClassLoaderExtractor.forName(loader, CLASS_PATH_MANAGER_NAME);
        result.fragmentClasspathClass = EquinoxClassLoaderExtractor.forName(loader, FRAGMENT_CLASSPATH_NAME);
        result.abstractBundleClass = EquinoxClassLoaderExtractor.forName(loader, ABSTRACT_BUNDLE_NAME);
        result.bundleHostClass = EquinoxClassLoaderExtractor.forName(loader, BUNDLE_HOST_NAME);
        result.bundleLoaderProxyClass = EquinoxClassLoaderExtractor.forName(loader, BUNDLE_LOADER_PROXY_NAME);
        result.getClassPathManagerMethod = result.baseClassLoaderClass.getMethod("getClasspathManager", new Class[0]);
        result.getDelegateMethod = result.baseClassLoaderClass.getMethod("getDelegate", new Class[0]);
        result.getFragmentClasspathsMethod = result.classpathManagerClass.getMethod("getFragmentClasspaths", new Class[0]);
        result.getHostClassPathEntriesMethod = result.classpathManagerClass.getMethod("getHostClasspathEntries", new Class[0]);
        result.getEntriesMethod = result.fragmentClasspathClass.getMethod("getEntries", new Class[0]);
        result.getBundleFileMethod = result.classPathEntryClass.getMethod("getBundleFile", new Class[0]);
        result.getBaseFileMethod = result.bundleFileClass.getMethod("getBaseFile", new Class[0]);
        result.getBundleMethod = result.bundleLoaderClass.getMethod("getBundle", new Class[0]);
        result.getSymbolicNameMethod = result.abstractBundleClass.getMethod("getSymbolicName", new Class[0]);
        result.getFragmentsMethod = result.bundleHostClass.getMethod("getFragments", new Class[0]);
        result.getBundleLoaderMethod = result.bundleLoaderProxyClass.getMethod("getBundleLoader", new Class[0]);
        result.getSymbolicNameProxyMethod = result.bundleLoaderProxyClass.getMethod("getSymbolicName", new Class[0]);
        result.requiredBundlesField = result.bundleLoaderClass.getDeclaredField("requiredBundles");
        result.requiredBundlesField.setAccessible(true);
        result.classLoaderField = result.bundleLoaderClass.getDeclaredField("classloader");
        result.classLoaderField.setAccessible(true);
        return result;
    }

    private Object getBundleLoader(Object loader) throws IllegalAccessException, InvocationTargetException {
        Object result;
        if (this.baseClassLoaderClass.isAssignableFrom(loader.getClass()) && this.bundleLoaderClass.isAssignableFrom((result = this.getDelegateMethod.invoke(loader, new Object[0])).getClass())) {
            return result;
        }
        return null;
    }

    private Object getBundle(Object bundleLoader) throws IllegalAccessException, InvocationTargetException {
        Object bundle;
        if (bundleLoader != null && (bundle = this.getBundleMethod.invoke(bundleLoader, new Object[0])) != null && this.abstractBundleClass.isAssignableFrom(bundle.getClass())) {
            return bundle;
        }
        return null;
    }

    private String getSymbolicName(Object bundle) throws IllegalAccessException, InvocationTargetException {
        if (bundle == null) {
            return null;
        }
        Object name = this.getSymbolicNameMethod.invoke(bundle, new Object[0]);
        if (name instanceof String) {
            return (String)name;
        }
        return null;
    }

    private void addFragmentNames(Object bundle, ArrayList<String> toAdd) throws IllegalAccessException, InvocationTargetException {
        if (bundle == null) {
            return;
        }
        if (!this.bundleHostClass.isAssignableFrom(bundle.getClass())) {
            return;
        }
        Object fragments = this.getFragmentsMethod.invoke(bundle, new Object[0]);
        if (fragments instanceof Object[]) {
            for (Object fragment : (Object[])fragments) {
                if (fragment == null || !this.abstractBundleClass.isAssignableFrom(fragment.getClass())) continue;
                toAdd.add("Fragment: " + this.getSymbolicName(fragment));
            }
        }
    }

    private Object[] getRequiredBundleProxies(Object bundleLoader) throws IllegalAccessException, InvocationTargetException {
        if (bundleLoader == null) {
            return null;
        }
        Object field = this.requiredBundlesField.get(bundleLoader);
        if (field instanceof Object[]) {
            return (Object[])field;
        }
        return null;
    }

    private ClassLoader[] getClassLoadersForProxies(Object[] proxies) throws IllegalAccessException, InvocationTargetException {
        if (proxies == null) {
            return null;
        }
        ArrayList<ClassLoader> result = new ArrayList<ClassLoader>();
        for (Object proxy : proxies) {
            Object classLoader;
            Object loader;
            if (proxy == null || !this.bundleLoaderProxyClass.isAssignableFrom(proxy.getClass()) || (loader = this.getBundleLoaderMethod.invoke(proxy, new Object[0])) == null || !this.bundleLoaderClass.isAssignableFrom(loader.getClass()) || !((classLoader = this.classLoaderField.get(loader)) instanceof ClassLoader)) continue;
            result.add((ClassLoader)classLoader);
        }
        return result.toArray(new ClassLoader[result.size()]);
    }

    private void addSymbolicNamesForProxies(Object[] proxies, ArrayList<String> toAdd) throws IllegalAccessException, InvocationTargetException {
        if (proxies != null) {
            for (Object proxy : proxies) {
                if (proxy == null || !this.bundleLoaderProxyClass.isAssignableFrom(proxy.getClass())) continue;
                toAdd.add("Required Bundle: " + (String)this.getSymbolicNameProxyMethod.invoke(proxy, new Object[0]));
            }
        }
    }

    private String[] getUrls(Object loader) throws IllegalAccessException, InvocationTargetException {
        if (loader == null) {
            return null;
        }
        if (!this.baseClassLoaderClass.isAssignableFrom(loader.getClass())) {
            return null;
        }
        Object manager = this.getClassPathManagerMethod.invoke(loader, new Object[0]);
        if (manager == null) {
            return null;
        }
        ArrayList<String> urls = new ArrayList<String>();
        Object classpathEntries = this.getHostClassPathEntriesMethod.invoke(manager, new Object[0]);
        this.addUrlsForClasspathEntries(classpathEntries, urls);
        Object fragmentClasspaths = this.getFragmentClasspathsMethod.invoke(manager, new Object[0]);
        if (fragmentClasspaths instanceof Object[]) {
            for (Object fragmentClasspath : (Object[])fragmentClasspaths) {
                if (!this.fragmentClasspathClass.isAssignableFrom(fragmentClasspath.getClass())) continue;
                classpathEntries = this.getEntriesMethod.invoke(fragmentClasspath, new Object[0]);
                this.addUrlsForClasspathEntries(classpathEntries, urls);
            }
        }
        return urls.size() == 0 ? null : urls.toArray(new String[urls.size()]);
    }

    private void addUrlsForClasspathEntries(Object classpathEntries, ArrayList<String> toAdd) throws IllegalAccessException, InvocationTargetException {
        if (classpathEntries instanceof Object[]) {
            for (Object entry : (Object[])classpathEntries) {
                Object file;
                Object bundleFile = this.getBundleFileMethod.invoke(entry, new Object[0]);
                if (bundleFile == null || !((file = this.getBaseFileMethod.invoke(bundleFile, new Object[0])) instanceof File)) continue;
                try {
                    toAdd.add(((File)file).toURI().toURL().toExternalForm());
                }
                catch (MalformedURLException e) {
                    toAdd.add(((File)file).toString());
                }
            }
        }
    }

    static Class<?> forName(ClassLoader loader, String name) throws ClassNotFoundException {
        ClassLoader forNameLoader = loader.getClass().getClassLoader();
        if (forNameLoader == null) {
            return ClassLoader.getSystemClassLoader().loadClass(name);
        }
        return forNameLoader.loadClass(name);
    }

    static boolean isEnabled() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return !"false".equals(System.getProperty("com.sap.jvm.equinoxClassLoaderInfo"));
            }
        });
    }
}

