/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.extension.java.base;

import com.sap.jvm.extension.java.base.ClassLoaderInformation;
import com.sap.jvm.extension.java.base.EquinoxClassLoaderExtractor;
import com.sap.jvm.extension.java.base.ReferenceHolder;
import java.io.File;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;

public class EquinoxClassLoaderExtractorLuna {
    private static final String EQUINOX_CLASS_LOADER_NAME = "org.eclipse.osgi.internal.loader.EquinoxClassLoader";
    private static final String MODULE_CLASS_LOADER_NAME = "org.eclipse.osgi.internal.loader.ModuleClassLoader";
    private static final String CLASS_PATH_MANAGER_NAME = "org.eclipse.osgi.internal.loader.classpath.ClasspathManager";
    private static final String CLASS_PATH_ENTRY_NAME = "org.eclipse.osgi.internal.loader.classpath.ClasspathEntry";
    private static final String FRAGMENT_CLASSPATH_NAME = "org.eclipse.osgi.internal.loader.classpath.FragmentClasspath";
    private static final String BUNDLE_FILE_NAME = "org.eclipse.osgi.storage.bundlefile.BundleFile";
    private static final String BUNDLE_LOADER_NAME = "org.eclipse.osgi.internal.loader.BundleLoader";
    private static final String BUNDLE_NAME = "org.osgi.framework.Bundle";
    private static final String MODULE_WIRING_NAME = "org.eclipse.osgi.container.ModuleWiring";
    private static final String MODULE_REVISION_NAME = "org.eclipse.osgi.container.ModuleRevision";
    private static final String GENERATION_NAME = "org.eclipse.osgi.storage.BundleInfo$Generation";
    private static final String MODULE_WIRE_NAME = "org.eclipse.osgi.container.ModuleWire";
    private static volatile ReferenceHolder<EquinoxClassLoaderExtractorLuna> refHolder = new ReferenceHolder<Object>(null, null);
    private static final boolean isEnabled = EquinoxClassLoaderExtractor.isEnabled();
    private Class<?> equinoxClassLoaderClass;
    private Class<?> moduleClassLoaderClass;
    private Class<?> bundleLoaderClass;
    private Class<?> classPathEntryClass;
    private Class<?> classpathManagerClass;
    private Class<?> fragmentClasspathClass;
    private Class<?> bundleFileClass;
    private Class<?> bundleClass;
    private Class<?> moduleWiringClass;
    private Class<?> moduleRevisionClass;
    private Class<?> generationClass;
    private Class<?> moduleWireClass;
    private Method getClassPathManagerMethod;
    private Method getBundleLoaderMethod;
    private Method getFragmentClasspathsMethod;
    private Method getHostClassPathEntriesMethod;
    private Method getEntriesMethod;
    private Method getGenerationMethod;
    private Method getBundleFileMethod;
    private Method getBaseFileMethod;
    private Method getWiringMethod;
    private Method getBundleMethod;
    private Method getSymbolicNameMethod;
    private Method getClassLoaderMethod;
    private Method getRequiredModuleWiresMethod;
    private Method getRevisionWiringMethod;
    private Method getSymbolicNameRevisionMethod;
    private Method getRevisionGenerationMethod;
    private Method getProviderWiringMethod;

    public static ClassLoaderInformation getInfo(ClassLoader loader) {
        if (!isEnabled) {
            return null;
        }
        WeakReference<Class<? extends ClassLoader>> ref = EquinoxClassLoaderExtractorLuna.refHolder.loaderClassRef;
        if (ref.get() == loader.getClass()) {
            return EquinoxClassLoaderExtractorLuna.getInfoImpl(loader);
        }
        String name = loader.getClass().getName();
        if (name.equals(EQUINOX_CLASS_LOADER_NAME)) {
            return EquinoxClassLoaderExtractorLuna.getInfoImpl(loader);
        }
        return null;
    }

    private static ClassLoaderInformation getInfoImpl(final ClassLoader loader) {
        try {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoaderInformation>(){

                @Override
                public ClassLoaderInformation run() {
                    ReferenceHolder holder = refHolder;
                    EquinoxClassLoaderExtractorLuna extractor = (EquinoxClassLoaderExtractorLuna)holder.extractorRef.get();
                    if (extractor != null && holder.loaderClassRef.get() == loader.getClass()) {
                        return extractor.getInfoForLoader(loader);
                    }
                    try {
                        extractor = EquinoxClassLoaderExtractorLuna.getExtractor(loader);
                        refHolder = new ReferenceHolder<EquinoxClassLoaderExtractorLuna>(loader.getClass(), extractor);
                        return extractor.getInfoForLoader(loader);
                    }
                    catch (ClassNotFoundException e) {
                        return null;
                    }
                    catch (NoSuchMethodException e) {
                        return null;
                    }
                    catch (NoSuchFieldException e) {
                        return null;
                    }
                    catch (SecurityException e) {
                        return null;
                    }
                }
            });
        }
        catch (Throwable t) {
            return null;
        }
    }

    public ClassLoaderInformation getInfoForLoader(ClassLoader loader) {
        try {
            return this.getInfoForLoaderImpl(loader);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    private ClassLoaderInformation getInfoForLoaderImpl(ClassLoader loader) throws IllegalAccessException, InvocationTargetException {
        String[] urls = this.getUrls(loader);
        Object bundleLoader = this.getBundleLoader(loader);
        Object bundle = this.getBundle(loader);
        String name = this.getSymbolicName(bundle);
        ArrayList<String> toAdd = new ArrayList<String>();
        ClassLoader[] parents = this.getClassLoadersFromBundleLoader(bundleLoader, toAdd);
        this.addFragmentNames(loader, toAdd);
        String[] dependencies = toAdd.size() == 0 ? null : toAdd.toArray(new String[toAdd.size()]);
        return new ClassLoaderInformation(loader, name, parents, urls, dependencies);
    }

    private static EquinoxClassLoaderExtractorLuna getExtractor(ClassLoader loader) throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException, SecurityException {
        EquinoxClassLoaderExtractorLuna result = new EquinoxClassLoaderExtractorLuna();
        result.equinoxClassLoaderClass = EquinoxClassLoaderExtractor.forName(loader, EQUINOX_CLASS_LOADER_NAME);
        result.moduleClassLoaderClass = EquinoxClassLoaderExtractor.forName(loader, MODULE_CLASS_LOADER_NAME);
        result.bundleLoaderClass = EquinoxClassLoaderExtractor.forName(loader, BUNDLE_LOADER_NAME);
        result.classPathEntryClass = EquinoxClassLoaderExtractor.forName(loader, CLASS_PATH_ENTRY_NAME);
        result.bundleFileClass = EquinoxClassLoaderExtractor.forName(loader, BUNDLE_FILE_NAME);
        result.classpathManagerClass = EquinoxClassLoaderExtractor.forName(loader, CLASS_PATH_MANAGER_NAME);
        result.fragmentClasspathClass = EquinoxClassLoaderExtractor.forName(loader, FRAGMENT_CLASSPATH_NAME);
        result.bundleClass = EquinoxClassLoaderExtractor.forName(loader, BUNDLE_NAME);
        result.moduleWiringClass = EquinoxClassLoaderExtractor.forName(loader, MODULE_WIRING_NAME);
        result.moduleRevisionClass = EquinoxClassLoaderExtractor.forName(loader, MODULE_REVISION_NAME);
        result.generationClass = EquinoxClassLoaderExtractor.forName(loader, GENERATION_NAME);
        result.moduleWireClass = EquinoxClassLoaderExtractor.forName(loader, MODULE_WIRE_NAME);
        result.getClassPathManagerMethod = result.equinoxClassLoaderClass.getMethod("getClasspathManager", new Class[0]);
        result.getBundleLoaderMethod = result.equinoxClassLoaderClass.getMethod("getBundleLoader", new Class[0]);
        result.getFragmentClasspathsMethod = result.classpathManagerClass.getMethod("getFragmentClasspaths", new Class[0]);
        result.getHostClassPathEntriesMethod = result.classpathManagerClass.getMethod("getHostClasspathEntries", new Class[0]);
        result.getEntriesMethod = result.fragmentClasspathClass.getMethod("getEntries", new Class[0]);
        result.getGenerationMethod = result.fragmentClasspathClass.getMethod("getGeneration", new Class[0]);
        result.getBundleFileMethod = result.classPathEntryClass.getMethod("getBundleFile", new Class[0]);
        result.getBaseFileMethod = result.bundleFileClass.getMethod("getBaseFile", new Class[0]);
        result.getWiringMethod = result.bundleLoaderClass.getMethod("getWiring", new Class[0]);
        result.getBundleMethod = result.moduleClassLoaderClass.getMethod("getBundle", new Class[0]);
        result.getSymbolicNameMethod = result.bundleClass.getMethod("getSymbolicName", new Class[0]);
        result.getClassLoaderMethod = result.moduleWiringClass.getMethod("getClassLoader", new Class[0]);
        result.getRequiredModuleWiresMethod = result.moduleWiringClass.getMethod("getRequiredModuleWires", String.class);
        result.getRevisionWiringMethod = result.moduleWiringClass.getMethod("getRevision", new Class[0]);
        result.getSymbolicNameRevisionMethod = result.moduleRevisionClass.getMethod("getSymbolicName", new Class[0]);
        result.getRevisionGenerationMethod = result.generationClass.getMethod("getRevision", new Class[0]);
        result.getProviderWiringMethod = result.moduleWireClass.getMethod("getProviderWiring", new Class[0]);
        return result;
    }

    private Object getBundleLoader(Object loader) throws IllegalAccessException, InvocationTargetException {
        Object result;
        if (this.equinoxClassLoaderClass.isAssignableFrom(loader.getClass()) && this.bundleLoaderClass.isAssignableFrom((result = this.getBundleLoaderMethod.invoke(loader, new Object[0])).getClass())) {
            return result;
        }
        return null;
    }

    private Object getBundle(Object loader) throws IllegalAccessException, InvocationTargetException {
        Object bundle;
        if (this.equinoxClassLoaderClass.isAssignableFrom(loader.getClass()) && (bundle = this.getBundleMethod.invoke(loader, new Object[0])) != null && this.bundleClass.isAssignableFrom(bundle.getClass())) {
            return bundle;
        }
        return null;
    }

    private String getSymbolicName(Object bundle) throws IllegalAccessException, InvocationTargetException {
        if (bundle == null) {
            return null;
        }
        Object name = this.getSymbolicNameMethod.invoke(bundle, new Object[0]);
        if (name instanceof String) {
            return (String)name;
        }
        return null;
    }

    private void addFragmentNames(Object loader, ArrayList<String> toAdd) throws IllegalAccessException, InvocationTargetException {
        if (loader == null) {
            return;
        }
        if (!this.equinoxClassLoaderClass.isAssignableFrom(loader.getClass())) {
            return;
        }
        Object manager = this.getClassPathManagerMethod.invoke(loader, new Object[0]);
        Object fragmentClasspaths = this.getFragmentClasspathsMethod.invoke(manager, new Object[0]);
        if (fragmentClasspaths instanceof Object[]) {
            for (Object fragmentClasspath : (Object[])fragmentClasspaths) {
                Object revision;
                Object generation;
                if (!this.fragmentClasspathClass.isAssignableFrom(fragmentClasspath.getClass()) || (generation = this.getGenerationMethod.invoke(fragmentClasspath, new Object[0])) == null || !this.generationClass.isAssignableFrom(generation.getClass()) || (revision = this.getRevisionGenerationMethod.invoke(generation, new Object[0])) == null || !this.moduleRevisionClass.isAssignableFrom(revision.getClass())) continue;
                toAdd.add("Fragment: " + this.getSymbolicNameRevisionMethod.invoke(revision, new Object[0]));
            }
        }
    }

    private ClassLoader[] getClassLoadersFromBundleLoader(Object bundleLoader, ArrayList<String> toAdd) throws IllegalAccessException, InvocationTargetException {
        if (!this.bundleLoaderClass.isAssignableFrom(bundleLoader.getClass())) {
            return null;
        }
        Object wiring = this.getWiringMethod.invoke(bundleLoader, new Object[0]);
        if (!this.moduleWiringClass.isAssignableFrom(wiring.getClass())) {
            return null;
        }
        Object requiredWires = this.getRequiredModuleWiresMethod.invoke(wiring, new Object[]{null});
        if (!(requiredWires instanceof List)) {
            return null;
        }
        List requiredWiresList = (List)requiredWires;
        ArrayList<ClassLoader> result = new ArrayList<ClassLoader>();
        for (Object requiredWire : requiredWiresList) {
            Object revision;
            Object providerWiring;
            if (!this.moduleWireClass.isAssignableFrom(requiredWire.getClass()) || !this.moduleWiringClass.isAssignableFrom((providerWiring = this.getProviderWiringMethod.invoke(requiredWire, new Object[0])).getClass())) continue;
            Object loader = this.getClassLoaderMethod.invoke(providerWiring, new Object[0]);
            if (loader instanceof ClassLoader) {
                result.add((ClassLoader)loader);
            }
            if (!this.moduleRevisionClass.isAssignableFrom((revision = this.getRevisionWiringMethod.invoke(providerWiring, new Object[0])).getClass())) continue;
            toAdd.add("Required Bundle: " + this.getSymbolicNameRevisionMethod.invoke(revision, new Object[0]));
        }
        return result.toArray(new ClassLoader[result.size()]);
    }

    private String[] getUrls(Object loader) throws IllegalAccessException, InvocationTargetException {
        if (loader == null) {
            return null;
        }
        if (!this.equinoxClassLoaderClass.isAssignableFrom(loader.getClass())) {
            return null;
        }
        Object manager = this.getClassPathManagerMethod.invoke(loader, new Object[0]);
        ArrayList<String> urls = new ArrayList<String>();
        Object classpathEntries = this.getHostClassPathEntriesMethod.invoke(manager, new Object[0]);
        this.addUrlsForClasspathEntries(classpathEntries, urls);
        Object fragmentClasspaths = this.getFragmentClasspathsMethod.invoke(manager, new Object[0]);
        if (fragmentClasspaths instanceof Object[]) {
            for (Object fragmentClasspath : (Object[])fragmentClasspaths) {
                if (!this.fragmentClasspathClass.isAssignableFrom(fragmentClasspath.getClass())) continue;
                classpathEntries = this.getEntriesMethod.invoke(fragmentClasspath, new Object[0]);
                this.addUrlsForClasspathEntries(classpathEntries, urls);
            }
        }
        return urls.size() == 0 ? null : urls.toArray(new String[urls.size()]);
    }

    private void addUrlsForClasspathEntries(Object classpathEntries, ArrayList<String> toAdd) throws IllegalAccessException, InvocationTargetException {
        if (classpathEntries instanceof Object[]) {
            for (Object entry : (Object[])classpathEntries) {
                Object file;
                Object bundleFile = this.getBundleFileMethod.invoke(entry, new Object[0]);
                if (bundleFile == null || !((file = this.getBaseFileMethod.invoke(bundleFile, new Object[0])) instanceof File)) continue;
                try {
                    toAdd.add(((File)file).toURI().toURL().toExternalForm());
                }
                catch (MalformedURLException e) {
                    toAdd.add(((File)file).toString());
                }
            }
        }
    }
}

