/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.extension.java.base;

import com.sap.jvm.extension.java.base.VmNativesJavaBase;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;

public class ExtendedExceptionGenerator {
    private static final boolean REVERSE_LOOKUP_ENABLED;
    private static final int TIME_OUT_AFTER = 1000;
    private static final int TIME_OUT_LENGTH = 120000;
    private static long timeoutTimestamp;
    private static ReverseLookupThread hangingThread;
    private static boolean reverseLookup;
    private static Hashtable<InetAddress, String> hostNameCache;

    public static String composeMessage(int[] socketInformation) {
        if (socketInformation[0] != 6 && socketInformation[0] != 4) {
            return "";
        }
        boolean isSin6 = socketInformation[0] == 6;
        int remotePort = socketInformation[1];
        int localPort = socketInformation[2];
        int remotePort_alt = socketInformation[3];
        int length = isSin6 ? 16 : 4;
        byte[] remoteAddress = new byte[length];
        byte[] localAddress = new byte[length];
        byte[] remoteAddress_alt = new byte[length];
        for (int i = 0; i < length; ++i) {
            remoteAddress[i] = (byte)socketInformation[4 + i];
            localAddress[i] = (byte)socketInformation[20 + i];
            remoteAddress_alt[i] = (byte)socketInformation[36 + i];
        }
        InetAddress localSA = null;
        InetAddress remoteSA = null;
        if (localPort != -1) {
            try {
                localSA = InetAddress.getByAddress(localAddress);
            }
            catch (UnknownHostException uhe) {
                localPort = -1;
            }
        }
        if (remotePort != -1) {
            try {
                remoteSA = InetAddress.getByAddress(remoteAddress);
            }
            catch (UnknownHostException uhe) {
                remotePort = -1;
            }
        }
        if (remotePort == -1 && remotePort_alt != -1) {
            try {
                remoteSA = InetAddress.getByAddress(remoteAddress_alt);
                remotePort = remotePort_alt;
            }
            catch (UnknownHostException uhe) {
                remotePort = -1;
            }
        }
        return " (local " + ExtendedExceptionGenerator.getMessage(localPort, localSA) + ", remote " + ExtendedExceptionGenerator.getMessage(remotePort, remoteSA) + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static String getMessage(int port, InetAddress sa) {
        if (port == -1) return "host unknown";
        String hostAddress = sa.getHostAddress();
        String host = "address " + hostAddress;
        if (!REVERSE_LOOKUP_ENABLED) return "port " + port + " to " + host;
        String hostName = hostNameCache.get(sa);
        if (hostName == null) {
            long currentTimestamp;
            if (!reverseLookup && (currentTimestamp = System.currentTimeMillis()) - timeoutTimestamp >= 120000L && !hangingThread.isAlive()) {
                reverseLookup = REVERSE_LOOKUP_ENABLED;
            }
            if (reverseLookup) {
                Class<ExtendedExceptionGenerator> clazz = ExtendedExceptionGenerator.class;
                // MONITORENTER : com.sap.jvm.extension.java.base.ExtendedExceptionGenerator.class
                ReverseLookupThread rlThread = new ReverseLookupThread();
                rlThread.setName("Get name of IP address " + hostAddress);
                rlThread.setDaemon(true);
                rlThread.socketAddress = sa;
                rlThread.nameOfHost = "";
                rlThread.start();
                try {
                    rlThread.join(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (rlThread.isAlive()) {
                    timeoutTimestamp = System.currentTimeMillis();
                    hangingThread = rlThread;
                    reverseLookup = false;
                }
                hostName = rlThread.nameOfHost;
                // MONITOREXIT : clazz
                if (!"".equals(hostName)) {
                    if (hostNameCache.size() > 10000) {
                        hostNameCache.clear();
                    }
                    hostNameCache.put(sa, hostName);
                }
            }
        }
        if (hostAddress.equals(hostName)) return "port " + port + " to " + host;
        if ("".equals(hostName)) return "port " + port + " to " + host;
        host = host + " (" + hostName + ")";
        return "port " + port + " to " + host;
    }

    static {
        String reverseLookupEnabled = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return VmNativesJavaBase.getValueOfXXOption("ReverseLookupEnabled");
            }
        });
        REVERSE_LOOKUP_ENABLED = "2|true".equals(reverseLookupEnabled);
        timeoutTimestamp = 0L;
        hangingThread = null;
        reverseLookup = REVERSE_LOOKUP_ENABLED;
        hostNameCache = new Hashtable();
    }

    private static class ReverseLookupThread
    extends Thread {
        public InetAddress socketAddress;
        public volatile String nameOfHost = "";

        private ReverseLookupThread() {
        }

        @Override
        public void run() {
            String hostName;
            final InetAddress mySA = this.socketAddress;
            this.nameOfHost = hostName = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return mySA.getHostName();
                }
            });
        }
    }
}

