/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.extension.java.base;

import com.sap.jvm.extension.java.base.NativeTracer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class NativeExtensionCommandHandler {
    private static final String EXTENSION_COMMAND_HANDLER_PROPERTY = "SAPJVM_EXTENSION_COMMAND_HANDLER";
    private static final String HANDLER_METHOD_NAME = "handleCommand";
    private static final NativeTracer TRACER = NativeTracer.get("Profiling");
    private static Object extensionCommandHandler = null;
    private static Method handlerMethod = null;

    public static synchronized void registerHandler(Object handler) {
        extensionCommandHandler = handler;
        handlerMethod = NativeExtensionCommandHandler.getHandlerMethod();
        NativeExtensionCommandHandler.class.notifyAll();
    }

    public static synchronized byte[] handleCommand(byte[] data, long timeToWait) {
        String className;
        if (extensionCommandHandler == null && (className = System.getProperty(EXTENSION_COMMAND_HANDLER_PROPERTY)) != null) {
            NativeExtensionCommandHandler.initializeCommandHandler(className);
        }
        long t = System.currentTimeMillis();
        long te = t + timeToWait;
        while (handlerMethod == null && te - t > 0L) {
            try {
                NativeExtensionCommandHandler.class.wait(te - t);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            t = System.currentTimeMillis();
        }
        if (handlerMethod == null) {
            return null;
        }
        byte[] retValue = null;
        try {
            retValue = (byte[])handlerMethod.invoke(extensionCommandHandler, new Object[]{data});
        }
        catch (IllegalAccessException ex) {
            TRACER.error(ex, "The handler method of the registered extension command handler '" + extensionCommandHandler.getClass() + "' cannot be accessed.");
        }
        catch (InvocationTargetException ex) {
            TRACER.error(ex, "The handler method of the registered extension command handler '" + extensionCommandHandler.getClass() + "' cannot be called.");
        }
        return retValue == null ? new byte[]{} : retValue;
    }

    private static void initializeCommandHandler(String className) {
        try {
            Class<?> clazz = Class.forName(className, true, ClassLoader.getSystemClassLoader());
            extensionCommandHandler = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException ex) {
            TRACER.error(ex, "The registered extension command handler '" + System.getProperty(EXTENSION_COMMAND_HANDLER_PROPERTY) + "' cannot be found.");
            return;
        }
        catch (IllegalAccessException ex) {
            TRACER.error(ex, "The registered extension command handler '" + System.getProperty(EXTENSION_COMMAND_HANDLER_PROPERTY) + "' cannot be accessed.");
            return;
        }
        catch (IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            TRACER.error(ex, "The registered extension command handler '" + System.getProperty(EXTENSION_COMMAND_HANDLER_PROPERTY) + "' cannot be instantiated.");
            return;
        }
        handlerMethod = NativeExtensionCommandHandler.getHandlerMethod();
    }

    private static Method getHandlerMethod() {
        if (extensionCommandHandler == null) {
            return null;
        }
        try {
            return extensionCommandHandler.getClass().getDeclaredMethod(HANDLER_METHOD_NAME, byte[].class);
        }
        catch (NoSuchMethodException ex) {
            TRACER.error(ex, "The registered extension command handler '" + System.getProperty(EXTENSION_COMMAND_HANDLER_PROPERTY) + "' does not contain a method with the following signature: byte[] handleCommand(byte[]).");
            return null;
        }
    }
}

