/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.extension.java.base;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import jdk.internal.misc.Unsafe;

public final class NativeTracer {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final int NORMAL = 2;
    private static final int WARNING = 1;
    private static final int ERROR = 0;
    private final int traceFlag;
    private final long traceFlagAddr;
    private static final String INTERNALS_TRACE_NAME = "JdkInternals";
    private static final String NETWORK_IO_BASIC_TRACE_NAME = "NetworkIoBasic";
    public static final NativeTracer INTERNALS_TRACE = new NativeTracer("JdkInternals");
    public static final NativeTracer NETWORK_IO_BASIC_TRACE = new NativeTracer("NetworkIoBasic");
    private static Map<String, NativeTracer> instances = null;

    private NativeTracer(String traceName) {
        this.traceFlag = NativeTracer.getTraceFlag0(traceName);
        this.traceFlagAddr = this.traceFlag >= 0 ? NativeTracer.getTraceFlagAddr0(this.traceFlag) : 0L;
    }

    public static synchronized NativeTracer get(String traceName) {
        NativeTracer result;
        if (instances == null) {
            instances = new HashMap<String, NativeTracer>();
            instances.put(INTERNALS_TRACE_NAME, INTERNALS_TRACE);
            instances.put(NETWORK_IO_BASIC_TRACE_NAME, NETWORK_IO_BASIC_TRACE);
        }
        if ((result = instances.get(traceName)) == null) {
            result = new NativeTracer(traceName);
            instances.put(traceName, result);
        }
        return result;
    }

    public boolean on() {
        if (this.traceFlag == -1) {
            return true;
        }
        return unsafe.getByte(this.traceFlagAddr) != 0;
    }

    public void tr(String message) {
        if (this.on()) {
            this.traceImpl(2, message);
        }
    }

    public void tr(Supplier<String> message) {
        if (this.on()) {
            this.traceImpl(2, message.get());
        }
    }

    public void tr(Throwable throwable, String message) {
        if (this.on()) {
            this.traceImpl(2, throwable, message);
        }
    }

    public void tr(Throwable throwable, Supplier<String> message) {
        if (this.on()) {
            this.traceImpl(2, throwable, message.get());
        }
    }

    public void warning(String message) {
        this.traceImpl(1, message);
    }

    public void warning(Throwable throwable, String message) {
        this.traceImpl(1, throwable, message);
    }

    public void error(String message) {
        this.traceImpl(0, message);
    }

    public void error(Throwable throwable, String message) {
        this.traceImpl(0, throwable, message);
    }

    public synchronized void traceImpl(int level, String message) {
        try {
            NativeTracer.trace0(message, this.traceFlag, level);
        }
        catch (UnsatisfiedLinkError e) {
            System.err.print(message.replaceAll("\n", System.lineSeparator()));
        }
    }

    private void traceImpl(int level, Throwable throwable, String message) {
        if (throwable == null) {
            this.traceImpl(level, message);
        } else {
            CharArrayWriter charWriter = new CharArrayWriter();
            PrintWriter writer = new PrintWriter(charWriter);
            throwable.printStackTrace(writer);
            writer.flush();
            this.traceImpl(level, message + "\nAssociated Exception:\n" + charWriter.toString());
        }
    }

    private static native int getTraceFlag0(String var0);

    private static native long getTraceFlagAddr0(int var0);

    private static native void trace0(String var0, int var1, int var2);
}

