/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.extension.java.base;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import jdk.internal.misc.Unsafe;

public class ProfilingControl {
    private static List<ProfilingControl> controls = new ArrayList<ProfilingControl>();
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long synchronizationFlagAddr = ProfilingControl.getSynchronizationFlagAddr();
    private long profilingControlPtr = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfilingControl(String fileNamePrefix, int eventBufferSize, int mappingBufferSize) {
        this.profilingControlPtr = ProfilingControl.start(fileNamePrefix, eventBufferSize, mappingBufferSize);
        List<ProfilingControl> list = controls;
        synchronized (list) {
            controls.add(this);
        }
    }

    public synchronized void sendCommand(byte[] command, int offset, int length) {
        if (!ProfilingControl.sendCommand(this.profilingControlPtr, command, offset, length)) {
            this.profilingControlPtr = 0L;
        }
    }

    public synchronized boolean isValid() {
        return this.profilingControlPtr != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (this.profilingControlPtr != 0L) {
            ProfilingControl.stop(this.profilingControlPtr);
            this.profilingControlPtr = 0L;
            List<ProfilingControl> list = controls;
            synchronized (list) {
                controls.remove(this);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopAllProfilingRuns() {
        List<ProfilingControl> list = controls;
        synchronized (list) {
            for (ProfilingControl control : controls) {
                if (control.profilingControlPtr == 0L) continue;
                ProfilingControl.stop(control.profilingControlPtr);
                control.profilingControlPtr = 0L;
            }
            controls.clear();
        }
    }

    public static boolean isSynchronizationTraceEnabled() {
        return unsafe.getByte(synchronizationFlagAddr) != 0;
    }

    private static native long getSynchronizationFlagAddr();

    public static native void notifyReentrantLockUnlock(AbstractQueuedSynchronizer var0);

    private static native boolean sendCommand(long var0, byte[] var2, int var3, int var4);

    private static native long start(String var0, int var1, int var2);

    private static native boolean stop(long var0);
}

