/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.extension.java.base;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;

public class PropertiesHelper {
    public static byte[] convertToUTF8ArraySorted(Properties props) {
        Properties p = (Properties)props.clone();
        String[] names = new String[p.size()];
        Enumeration e = p.keys();
        int index = 0;
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            names[index] = o instanceof String ? (String)o : "" + o;
            ++index;
        }
        Arrays.sort(names, String.CASE_INSENSITIVE_ORDER);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bos, "UTF-8"));
            for (int i = 0; i < names.length; ++i) {
                bw.write(PropertiesHelper.escapeSafe(names[i], true));
                bw.write(61);
                bw.write(PropertiesHelper.escapeSafe(p.getProperty(names[i]), false));
                bw.newLine();
            }
            bw.close();
            return bos.toByteArray();
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }

    private static String escapeSafe(String theString, boolean escapeSpace) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(Integer.toHexString(aChar >> 12 & 0xF));
                        outBuffer.append(Integer.toHexString(aChar >> 8 & 0xF));
                        outBuffer.append(Integer.toHexString(aChar >> 4 & 0xF));
                        outBuffer.append(Integer.toHexString(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }
}

