/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.extension.java.base;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.TimeZone;

public class ShowSettingsHelper {
    public static void printTimeZone(PrintStream ostream, String indent) {
        TimeZone timeZone = TimeZone.getDefault();
        ostream.println("Time zone settings:");
        ostream.println(indent + "default time zone = " + timeZone.getDisplayName());
        ostream.println(indent + "default time zone id = " + timeZone.getID());
        ostream.println();
    }

    private static void printNetworkInterface(NetworkInterface ni, InetAddress local, PrintStream ostream, String indent) {
        Integer index = null;
        try {
            Method getIndex = ni.getClass().getDeclaredMethod("getIndex", new Class[0]);
            getIndex.setAccessible(true);
            index = (Integer)getIndex.invoke(ni, new Object[0]);
        }
        catch (Exception getIndex) {
            // empty catch block
        }
        ostream.println(indent + "Interface: " + ni.getName() + " (" + ni.getDisplayName() + ")");
        if (index != null) {
            ostream.println(indent + "    Index " + index);
        }
        Enumeration<InetAddress> it = ni.getInetAddresses();
        int ipNr = 1;
        while (it.hasMoreElements()) {
            InetAddress addr = it.nextElement();
            if (addr.equals(local)) {
                ostream.println(indent + "  * IP-Addr Nr. " + ipNr + ": " + addr.toString());
            } else {
                ostream.println(indent + "    IP-Addr Nr. " + ipNr + ": " + addr.toString());
            }
            ++ipNr;
        }
    }

    public static void printNetwork(PrintStream ostream, String indent) {
        ostream.println("Network settings:");
        if ("true".equals(System.getProperty("java.net.preferIPv4Stack"))) {
            ostream.println(indent + "Prefering IPV4 over IPV6");
        }
        InetAddress local = null;
        try {
            Enumeration<NetworkInterface> it;
            local = InetAddress.getLocalHost();
            if (local != null) {
                it = NetworkInterface.getNetworkInterfaces();
                NetworkInterface localNi = null;
                while (it.hasMoreElements()) {
                    NetworkInterface ni = it.nextElement();
                    Enumeration<InetAddress> it2 = ni.getInetAddresses();
                    while (it2.hasMoreElements()) {
                        InetAddress addr = it2.nextElement();
                        if (!local.equals(addr)) continue;
                        if (localNi != null) {
                            ostream.println(indent + "Local Host IP-Address bound to more than one network interface!");
                            continue;
                        }
                        localNi = ni;
                    }
                }
                ostream.println(indent + "Local Host Name: " + local.getCanonicalHostName());
                if (localNi != null) {
                    ostream.println(indent + "Local Host IP-Addr: " + local + " via " + localNi.getName() + " (" + localNi.getDisplayName() + ")");
                } else {
                    ostream.println(indent + "Local Host IP-Addr: " + local);
                }
            }
            ostream.println();
            it = NetworkInterface.getNetworkInterfaces();
            while (it.hasMoreElements()) {
                NetworkInterface ni = it.nextElement();
                ShowSettingsHelper.printNetworkInterface(ni, local, ostream, indent);
            }
        }
        catch (Exception e) {
            ostream.println(indent + "Cannot get information about network interfaces:");
            e.printStackTrace(ostream);
        }
        ostream.println();
    }

    public static void main(String[] args) {
        ShowSettingsHelper.printNetwork(System.out, "    ");
    }
}

