/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.extension.java.base;

import com.sap.jvm.extension.java.base.NonAlertingInternalError;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class VmNativesJavaBase {
    public static native boolean enqueueErrorQueue(Throwable var0);

    public static String getCurrentWorkingDirectory() {
        String result = VmNativesJavaBase.getCurrentWorkingDirectory0();
        return result == null ? "<unknown>" : result;
    }

    private static native String getCurrentWorkingDirectory0();

    public static native Object getExtendedExceptionInformation(Throwable var0);

    public static native long[] getProcessGroupMembers(long var0);

    public static native String getValueOfXXOption(String var0);

    public static void logAssertionError(String msg, StackTraceElement[] elements) {
        if (msg == null) {
            if (elements.length > 0) {
                VmNativesJavaBase.logAssertionErrorImpl("Assertion in " + elements[0]);
            } else {
                VmNativesJavaBase.logAssertionErrorImpl("Assertion without stack");
            }
        } else if (elements.length > 0) {
            VmNativesJavaBase.logAssertionErrorImpl("\"" + msg + "\" in " + elements[0]);
        } else {
            VmNativesJavaBase.logAssertionErrorImpl("\"" + msg + "\" without stack");
        }
    }

    private static native void logAssertionErrorImpl(String var0);

    public static void logInternalError(InternalError error) {
        if (error instanceof NonAlertingInternalError) {
            return;
        }
        String msg = error.getMessage();
        StackTraceElement[] elements = error.getStackTrace();
        if (msg == null) {
            if (elements.length > 0) {
                VmNativesJavaBase.logInternalErrorImpl("Internal error " + error.getClass().getName() + " in " + elements[0]);
            } else {
                VmNativesJavaBase.logInternalErrorImpl("Internal error " + error.getClass().getName() + " without stack");
            }
        } else if (elements.length > 0) {
            VmNativesJavaBase.logInternalErrorImpl("Internal error " + error.getClass().getName() + " with message \"" + msg + "\" in " + elements[0]);
        } else {
            VmNativesJavaBase.logInternalErrorImpl("Internal error " + error.getClass().getName() + " with message \"" + msg + "\" without stack");
        }
    }

    private static native void logInternalErrorImpl(String var0);

    public static native void notifyDefaultTimeZone(String var0);

    public static native byte[] executeAttachOperation(String var0, String ... var1) throws IOException;

    public static void removeNativeStackTrace(Throwable throwable) {
        Throwable t = throwable;
        for (int max = 100; t != null && max > 0; t = t.getCause(), --max) {
            t.getStackTrace();
            Class<?> clazz = t.getClass();
            if (clazz == NullPointerException.class || clazz == ArrayIndexOutOfBoundsException.class) {
                t.getMessage();
            }
            VmNativesJavaBase.removeNativeStackTrace0(t);
        }
    }

    private static native void removeNativeStackTrace0(Throwable var0);

    public static native void setWorkspaceUrl(String var0);

    public static String createExceptionTextWithPath(String defaultMsg, String errMsg, String path) {
        String userDir;
        String cwd = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return VmNativesJavaBase.getCurrentWorkingDirectory();
            }
        });
        if (!cwd.equals(userDir = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("user.dir");
            }
        }))) {
            return defaultMsg + ", " + errMsg + " (path " + path + ", working dir " + cwd + ", user dir " + userDir + ")";
        }
        return defaultMsg + ", " + errMsg + " (path " + path + ", working dir " + cwd + ")";
    }
}

