/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl;

import com.sap.jvm.inspector.debugging.DebuggingBackendService;
import com.sap.jvm.inspector.debugging.DebuggingBackendServiceLoader;
import com.sap.jvm.inspector.debugging.RemoteDebuggingBackendProvider;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.net.ServerSocket;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Timer;
import java.util.TimerTask;

public class RemoteDebuggingBackendProviderImpl
extends UnicastRemoteObject
implements RemoteDebuggingBackendProvider {
    private static final DebuggingBackendService theDebuggingBackendService = DebuggingBackendServiceLoader.load(DebuggingBackendService.class).findFirst().orElse(null);
    private static final long serialVersionUID = 2733950682648580427L;
    private static final long CONNECTION_TIMEOUT_MS = 30000L;
    private static final Timer timer = new Timer();

    public RemoteDebuggingBackendProviderImpl() throws RemoteException {
    }

    public RemoteDebuggingBackendProviderImpl(RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        super(0, csf, ssf);
    }

    @Override
    public int createDebuggingBackend(final String debuggeeHost, final int debugeePort, final boolean waitForStart) throws RemoteException {
        try {
            final ServerSocket socket = new ServerSocket(0);
            int port = socket.getLocalPort();
            final TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    if (socket.isClosed()) {
                        return;
                    }
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        Trace.error((Throwable)e, "Error while closing debugging backend server socket.");
                    }
                }
            };
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        theDebuggingBackendService.startBackend(socket, debuggeeHost, debugeePort, waitForStart, true);
                        task.cancel();
                    }
                    catch (IOException e) {
                        Trace.error((Throwable)e, "Caught IOException when starting debugging backend.");
                    }
                }
            }, "Debugging-Backend-RMI-Creation-Thread");
            thread.setDaemon(true);
            thread.start();
            timer.schedule(task, 30000L);
            return port;
        }
        catch (IOException e) {
            throw new RemoteException("Caught IOException opening server socket for debugging backend.", e);
        }
    }
}

