/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl;

import com.sap.jdk.ext.filesocket.FileSocket;
import com.sap.jdk.ext.filesocket.FileSocketAddress;
import com.sap.jvm.inspector.InspectorInfo;
import com.sap.jvm.inspector.filesocket.FileSocketAdapter;
import com.sap.jvm.inspector.filesocket.Socket2SocketAdapter;
import com.sap.jvm.inspector.filesocket.remote.RemoteFileSocketConnection;
import com.sap.jvm.util.misc.SocketAdapter;
import com.sap.jvm.util.misc.SocketAdapterFactory;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Timer;
import java.util.TimerTask;

public class RemoteFileSocketConnectionImpl
extends UnicastRemoteObject
implements RemoteFileSocketConnection {
    final int NUM_CONNECTION_TRIALS = 10;
    private static final long serialVersionUID = 2736091420784880427L;
    private RMIServerSocketFactory ssf;

    public RemoteFileSocketConnectionImpl() throws RemoteException {
    }

    public RemoteFileSocketConnectionImpl(RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        super(0, csf, ssf);
        this.ssf = ssf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int createFileSocketConnection(int pid, int timeoutMs) throws RemoteException {
        int port = -1;
        try {
            ServerSocket server;
            final FileSocket fileSocket = new FileSocket();
            String socketIdentifier = InspectorInfo.getProfilingServerIdentifier(pid);
            if (socketIdentifier == null || socketIdentifier.length() == 0) {
                return -1;
            }
            FileSocketAddress profilingServerAddr = new FileSocketAddress(socketIdentifier);
            int fraqTimeoutMs = timeoutMs / 20;
            Throwable lastError = null;
            for (int num = 1; num <= 10 && !fileSocket.isConnected(); ++num) {
                try {
                    fileSocket.connect(profilingServerAddr, fraqTimeoutMs);
                    continue;
                }
                catch (IOException e) {
                    lastError = e;
                    continue;
                }
                finally {
                    try {
                        if (!fileSocket.isConnected()) {
                            Thread.sleep(fraqTimeoutMs);
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (!fileSocket.isConnected()) {
                throw new RemoteException(lastError.getMessage());
            }
            ServerSocket serverSocket = server = this.ssf != null ? this.ssf.createServerSocket(0) : new ServerSocket(0);
            if (server == null) {
                return -1;
            }
            port = server.getLocalPort();
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Timer t = new Timer(true);
                        t.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                try {
                                    server.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }, 30000L);
                        Socket clientSocket = server.accept();
                        FileSocketAdapter fromSocket = new FileSocketAdapter(fileSocket);
                        SocketAdapter toSocket = SocketAdapterFactory.getForSocket(clientSocket);
                        Socket2SocketAdapter downStreamAdapter = new Socket2SocketAdapter(fromSocket, toSocket);
                        downStreamAdapter.start();
                        Socket2SocketAdapter upStreamAdapter = new Socket2SocketAdapter(toSocket, fromSocket);
                        upStreamAdapter.start();
                    }
                    catch (IOException e) {
                    }
                    finally {
                        try {
                            server.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }.start();
        }
        catch (IOException e) {
            port = -1;
        }
        return port;
    }
}

