/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.common.monitor.stacktrace;

import com.sap.jvm.impl.common.monitor.stacktrace.AddressValueImpl;
import com.sap.jvm.impl.common.monitor.stacktrace.ArrayReferenceImpl;
import com.sap.jvm.impl.common.monitor.stacktrace.ArrayTypeImpl;
import com.sap.jvm.impl.common.monitor.stacktrace.BooleanValueImpl;
import com.sap.jvm.impl.common.monitor.stacktrace.ByteValueImpl;
import com.sap.jvm.impl.common.monitor.stacktrace.CharValueImpl;
import com.sap.jvm.impl.common.monitor.stacktrace.DoubleValueImpl;
import com.sap.jvm.impl.common.monitor.stacktrace.ExtendedStackTraceElementImpl;
import com.sap.jvm.impl.common.monitor.stacktrace.ExtendedStackTraceImpl;
import com.sap.jvm.impl.common.monitor.stacktrace.FloatValueImpl;
import com.sap.jvm.impl.common.monitor.stacktrace.IntValueImpl;
import com.sap.jvm.impl.common.monitor.stacktrace.LongValueImpl;
import com.sap.jvm.impl.common.monitor.stacktrace.NonNullValueImpl;
import com.sap.jvm.impl.common.monitor.stacktrace.ObjectReferenceImpl;
import com.sap.jvm.impl.common.monitor.stacktrace.ObjectTypeImpl;
import com.sap.jvm.impl.common.monitor.stacktrace.Resolvable;
import com.sap.jvm.impl.common.monitor.stacktrace.ShortValueImpl;
import com.sap.jvm.impl.common.monitor.stacktrace.StringReferenceImpl;
import com.sap.jvm.impl.common.monitor.stacktrace.TypeImpl;
import com.sap.jvm.impl.common.monitor.stacktrace.UnknownValueImpl;
import com.sap.jvm.monitor.stacktrace.ExtendedStackTrace;
import com.sap.jvm.monitor.stacktrace.ExtendedStackTraceElement;
import com.sap.jvm.monitor.stacktrace.ObjectReference;
import com.sap.jvm.monitor.stacktrace.Value;
import com.sap.vmc.util.diag.DiagBufReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@Deprecated
public final class ExtendedStackTraceHelper {
    public static void readBytes(InputStream inputStream, byte[] dest) throws IOException {
        int read;
        for (int nrOfBytes = dest.length; nrOfBytes > 0; nrOfBytes -= read) {
            read = inputStream.read(dest, dest.length - nrOfBytes, nrOfBytes);
            if (read >= 1) continue;
            throw new IOException("Could not read enough bytes");
        }
    }

    public static ExtendedStackTrace getStackTraceFromReader(DiagBufReader reader) throws IOException {
        HashMap<Long, Object> resolverMap = new HashMap<Long, Object>();
        int nrOfStackTraceElements = reader.readNodeStart("ExtendedStackTrace") - 1;
        long throwableAddres = reader.readLong();
        ExtendedStackTraceElement[] elements = new ExtendedStackTraceElementImpl[nrOfStackTraceElements];
        for (int i = 0; i < nrOfStackTraceElements; ++i) {
            elements[i] = ExtendedStackTraceHelper.getNextElement(reader);
        }
        reader.readNodeEnd("ExtendedStackTrace");
        int nrOfClasses = reader.readNodeStart("Classes");
        for (int i = 0; i < nrOfClasses; ++i) {
            TypeImpl type = ExtendedStackTraceHelper.readType(reader);
            Long address = new Long(type.getAddress());
            resolverMap.put(address, type);
        }
        reader.readNodeEnd("Classes");
        int nrOfStrings = reader.readNodeStart("Strings") / 3;
        for (int i = 0; i < nrOfStrings; ++i) {
            ExtendedStackTraceHelper.readString(reader, resolverMap);
        }
        reader.readNodeEnd("Strings");
        for (int nrOfEntries = reader.readNodeStart("Objects"); nrOfEntries > 0; nrOfEntries -= ExtendedStackTraceHelper.readObject(reader, resolverMap)) {
        }
        reader.readNodeEnd("Objects");
        ObjectReference throwable = (ObjectReference)resolverMap.get(new Long(throwableAddres));
        Set<Map.Entry<Long, Object>> set = resolverMap.entrySet();
        Iterator<Map.Entry<Long, Object>> it = set.iterator();
        while (it.hasNext()) {
            Object next = it.next().getValue();
            if (!(next instanceof Resolvable)) continue;
            ((Resolvable)next).resolve(resolverMap);
        }
        for (int i = 0; i < elements.length; ++i) {
            elements[i].resolve(resolverMap);
        }
        reader.close();
        return new ExtendedStackTraceImpl(throwable, elements);
    }

    public static ExtendedStackTrace createDummyStackTrace() {
        ObjectTypeImpl dummyObjType = new ObjectTypeImpl(1L, 0L, "", false, new String[0], new char[0], null, null);
        ObjectReferenceImpl dummyRef = new ObjectReferenceImpl(1L, dummyObjType, true, null);
        ExtendedStackTraceImpl dummyTrace = new ExtendedStackTraceImpl(dummyRef, new ExtendedStackTraceElementImpl[0]);
        return dummyTrace;
    }

    private static ExtendedStackTraceElementImpl getNextElement(DiagBufReader reader) throws IOException {
        int i;
        int nrOfEntries = reader.readNodeStart("StackTraceElement");
        long classBlockAddress = reader.readLong();
        String className = reader.readString();
        long classLoaderAddress = reader.readLong();
        String methodName = reader.readString();
        String methodSignature = reader.readString();
        boolean isNative = reader.readBoolean();
        boolean isCompiled = reader.readBoolean();
        int pcOffset = reader.readInt();
        int lineNumber = reader.readInt();
        String fileName = reader.readString();
        boolean isStatic = reader.readBoolean();
        int nrOfDeclaredParameters = reader.readInt();
        int nrOfAssociatedTypes = reader.readInt();
        int entriesPerLocal = 3;
        int readEntries = 12;
        int nrOfLocals = (nrOfEntries - readEntries - nrOfAssociatedTypes) / entriesPerLocal;
        long[] associatedTypes = new long[nrOfAssociatedTypes];
        for (int i2 = 0; i2 < nrOfAssociatedTypes; ++i2) {
            associatedTypes[i2] = reader.readLong();
        }
        int[] slots = new int[nrOfLocals];
        String[] names = new String[nrOfLocals];
        Value[] values = new Value[nrOfLocals];
        for (i = 0; i < nrOfLocals; ++i) {
            slots[i] = reader.readInt();
            String typeAndName = reader.readString();
            names[i] = typeAndName.substring(1);
            char type = typeAndName.charAt(0);
            values[i] = ExtendedStackTraceHelper.readValue(type, reader);
        }
        for (i = 0; i < nrOfLocals; ++i) {
            for (int j = i + 1; j < nrOfLocals; ++j) {
                if (slots[i] <= slots[j]) continue;
                int tmpInt = slots[i];
                slots[i] = slots[j];
                slots[j] = tmpInt;
                String tmpString = names[i];
                names[i] = names[j];
                names[j] = tmpString;
                Value tmpValue = values[i];
                values[i] = values[j];
                values[j] = tmpValue;
            }
        }
        ExtendedStackTraceElementImpl result = new ExtendedStackTraceElementImpl(className, classBlockAddress, classLoaderAddress, methodName, methodSignature, isNative, isCompiled, lineNumber, fileName, pcOffset, isStatic, nrOfDeclaredParameters, names, values, associatedTypes);
        reader.readNodeEnd("StackTraceElement");
        return result;
    }

    private static int readObject(DiagBufReader reader, HashMap<Long, Object> resolverMap) throws IOException {
        long address = reader.readLong();
        boolean isReadOnly = (address & 1L) == 1L;
        address &= 0xFFFFFFFFFFFFFFFEL;
        long classAddress = reader.readLong();
        Object resolvedType = resolverMap.get(new Long(classAddress));
        if (!(resolvedType instanceof TypeImpl)) {
            throw new IOException("Could not resolve classAddress " + classAddress);
        }
        int entriesRead = 2;
        if (resolvedType instanceof ArrayTypeImpl) {
            ArrayTypeImpl type = (ArrayTypeImpl)resolvedType;
            int length = reader.readInt();
            int nrOfComponents = reader.readInt();
            Value[] values = new Value[nrOfComponents];
            for (int i = 0; i < nrOfComponents; ++i) {
                values[i] = ExtendedStackTraceHelper.readValue(type.componentType(), reader);
            }
            ArrayReferenceImpl value = new ArrayReferenceImpl(address, type, isReadOnly, length, values);
            resolverMap.put(new Long(address), value);
            entriesRead = entriesRead + nrOfComponents + 2;
        } else {
            ObjectTypeImpl type = (ObjectTypeImpl)resolvedType;
            int nrOfFields = type.getNrOfFields();
            Value[] values = new Value[nrOfFields];
            for (int i = 0; i < nrOfFields; ++i) {
                values[i] = ExtendedStackTraceHelper.readValue(type.getType(i), reader);
            }
            ObjectReferenceImpl value = new ObjectReferenceImpl(address, type, isReadOnly, values);
            resolverMap.put(new Long(address), value);
            entriesRead += nrOfFields;
        }
        return entriesRead;
    }

    private static void readString(DiagBufReader reader, Map<Long, Object> resolverMap) throws IOException {
        long address = reader.readLong();
        boolean isReadOnly = (address & 1L) == 1L;
        address &= 0xFFFFFFFFFFFFFFFEL;
        long classAddress = reader.readLong();
        Object resolvedType = resolverMap.get(new Long(classAddress));
        if (!(resolvedType instanceof TypeImpl)) {
            throw new IOException("Could not resolve classAdress");
        }
        String content = reader.readString();
        StringReferenceImpl value = new StringReferenceImpl(address, (TypeImpl)resolvedType, isReadOnly, content);
        resolverMap.put(new Long(address), value);
    }

    private static TypeImpl readType(DiagBufReader reader) throws IOException {
        TypeImpl result;
        int nrOfEntries = reader.readNodeStart("Class");
        long address = reader.readLong();
        boolean isShared = (address & 1L) == 1L;
        address &= 0xFFFFFFFFFFFFFFFEL;
        long classLoaderAddress = reader.readLong();
        String className = reader.readString();
        if (className.charAt(0) == '[') {
            char componentType = reader.readString().charAt(0);
            result = new ArrayTypeImpl(address, classLoaderAddress, className, isShared, componentType);
        } else {
            int nrOfStaticFields = reader.readShort();
            String[] staticNames = new String[nrOfStaticFields];
            Value[] staticValues = new Value[nrOfStaticFields];
            for (int i = 0; i < nrOfStaticFields; ++i) {
                String typeAndName = reader.readString();
                char type = typeAndName.charAt(0);
                staticNames[i] = typeAndName.substring(1);
                staticValues[i] = ExtendedStackTraceHelper.readValue(type, reader);
            }
            int nrOfFields = nrOfEntries - 4 - nrOfStaticFields * 2;
            String[] names = new String[nrOfFields];
            char[] types = new char[nrOfFields];
            for (int i = 0; i < nrOfFields; ++i) {
                String typeAndName = reader.readString();
                types[i] = typeAndName.charAt(0);
                names[i] = typeAndName.substring(1);
            }
            result = new ObjectTypeImpl(address, classLoaderAddress, className, isShared, names, types, staticNames, staticValues);
        }
        reader.readNodeEnd("Class");
        return result;
    }

    private static Value readReferenceValue(DiagBufReader reader) throws IOException {
        long address = reader.readLong();
        if (address == 0L) {
            return null;
        }
        if (address == 1L) {
            return NonNullValueImpl.getNonNullValue();
        }
        return new AddressValueImpl(address);
    }

    private static Value readValue(char type, DiagBufReader reader) throws IOException {
        switch (type) {
            case 'Z': {
                return new BooleanValueImpl(reader.readBoolean());
            }
            case 'B': {
                return new ByteValueImpl((byte)reader.readShort());
            }
            case 'C': {
                return new CharValueImpl((char)reader.readShort());
            }
            case 'S': {
                return new ShortValueImpl(reader.readShort());
            }
            case 'I': {
                return new IntValueImpl(reader.readInt());
            }
            case 'J': {
                return new LongValueImpl(reader.readLong());
            }
            case 'F': {
                return new FloatValueImpl(reader.readFloat());
            }
            case 'D': {
                return new DoubleValueImpl(reader.readDouble());
            }
            case 'L': {
                return ExtendedStackTraceHelper.readReferenceValue(reader);
            }
            case 'U': {
                reader.readBoolean();
                return UnknownValueImpl.getUnknownValue();
            }
        }
        throw new IOException("Unknown type '" + type + "'");
    }
}

